/*
 * Decompiled with CFR 0.152.
 */
package com.remainsoftware.common.ssl;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.security.NoSuchProviderException;
import java.security.cert.CertPath;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.cryptopro.CryptoProObjectIdentifiers;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.RSASSAPSSparams;
import org.bouncycastle.asn1.teletrust.TeleTrusTObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.CRLDistPoint;
import org.bouncycastle.asn1.x509.DistributionPoint;
import org.bouncycastle.asn1.x509.X509Extensions;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.jce.ECNamedCurveTable;
import org.bouncycastle.jce.PKCS10CertificationRequest;
import org.bouncycastle.jce.provider.X509CertificateObject;
import org.bouncycastle.util.Selector;
import org.bouncycastle.util.Store;
import org.bouncycastle.util.Strings;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.x509.NoSuchStoreException;
import org.bouncycastle.x509.X509CertStoreSelector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class X509Util {
    private static final Logger logger = LoggerFactory.getLogger(X509Util.class);
    private static Hashtable<String, ASN1ObjectIdentifier> algorithms = new Hashtable();
    private static Hashtable<String, RSASSAPSSparams> params = new Hashtable();
    private static Set<ASN1ObjectIdentifier> noParams = new HashSet<ASN1ObjectIdentifier>();
    public static final String BEGIN_CERT = "-----BEGIN CERTIFICATE-----";
    public static final String END_CERT = "-----END CERTIFICATE-----";
    public static final int CERT_LINE_LENGTH = 64;
    public static final String BEGIN_CERT_REQ = "-----BEGIN CERTIFICATE REQUEST-----";
    public static final String END_CERT_REQ = "-----END CERTIFICATE REQUEST-----";
    public static final int CERT_REQ_LINE_LENGTH = 76;
    static char[] hexChar;

    static {
        algorithms.put("MD2WITHRSAENCRYPTION", PKCSObjectIdentifiers.md2WithRSAEncryption);
        algorithms.put("MD2WITHRSA", PKCSObjectIdentifiers.md2WithRSAEncryption);
        algorithms.put("MD5WITHRSAENCRYPTION", PKCSObjectIdentifiers.md5WithRSAEncryption);
        algorithms.put("MD5WITHRSA", PKCSObjectIdentifiers.md5WithRSAEncryption);
        algorithms.put("SHA1WITHRSAENCRYPTION", PKCSObjectIdentifiers.sha1WithRSAEncryption);
        algorithms.put("SHA1WITHRSA", PKCSObjectIdentifiers.sha1WithRSAEncryption);
        algorithms.put("SHA224WITHRSAENCRYPTION", PKCSObjectIdentifiers.sha224WithRSAEncryption);
        algorithms.put("SHA224WITHRSA", PKCSObjectIdentifiers.sha224WithRSAEncryption);
        algorithms.put("SHA256WITHRSAENCRYPTION", PKCSObjectIdentifiers.sha256WithRSAEncryption);
        algorithms.put("SHA256WITHRSA", PKCSObjectIdentifiers.sha256WithRSAEncryption);
        algorithms.put("SHA384WITHRSAENCRYPTION", PKCSObjectIdentifiers.sha384WithRSAEncryption);
        algorithms.put("SHA384WITHRSA", PKCSObjectIdentifiers.sha384WithRSAEncryption);
        algorithms.put("SHA512WITHRSAENCRYPTION", PKCSObjectIdentifiers.sha512WithRSAEncryption);
        algorithms.put("SHA512WITHRSA", PKCSObjectIdentifiers.sha512WithRSAEncryption);
        algorithms.put("SHA1WITHRSAANDMGF1", PKCSObjectIdentifiers.id_RSASSA_PSS);
        algorithms.put("SHA224WITHRSAANDMGF1", PKCSObjectIdentifiers.id_RSASSA_PSS);
        algorithms.put("SHA256WITHRSAANDMGF1", PKCSObjectIdentifiers.id_RSASSA_PSS);
        algorithms.put("SHA384WITHRSAANDMGF1", PKCSObjectIdentifiers.id_RSASSA_PSS);
        algorithms.put("SHA512WITHRSAANDMGF1", PKCSObjectIdentifiers.id_RSASSA_PSS);
        algorithms.put("RIPEMD160WITHRSAENCRYPTION", TeleTrusTObjectIdentifiers.rsaSignatureWithripemd160);
        algorithms.put("RIPEMD160WITHRSA", TeleTrusTObjectIdentifiers.rsaSignatureWithripemd160);
        algorithms.put("RIPEMD128WITHRSAENCRYPTION", TeleTrusTObjectIdentifiers.rsaSignatureWithripemd128);
        algorithms.put("RIPEMD128WITHRSA", TeleTrusTObjectIdentifiers.rsaSignatureWithripemd128);
        algorithms.put("RIPEMD256WITHRSAENCRYPTION", TeleTrusTObjectIdentifiers.rsaSignatureWithripemd256);
        algorithms.put("RIPEMD256WITHRSA", TeleTrusTObjectIdentifiers.rsaSignatureWithripemd256);
        algorithms.put("SHA1WITHDSA", X9ObjectIdentifiers.id_dsa_with_sha1);
        algorithms.put("DSAWITHSHA1", X9ObjectIdentifiers.id_dsa_with_sha1);
        algorithms.put("SHA224WITHDSA", NISTObjectIdentifiers.dsa_with_sha224);
        algorithms.put("SHA256WITHDSA", NISTObjectIdentifiers.dsa_with_sha256);
        algorithms.put("SHA1WITHECDSA", X9ObjectIdentifiers.ecdsa_with_SHA1);
        algorithms.put("ECDSAWITHSHA1", X9ObjectIdentifiers.ecdsa_with_SHA1);
        algorithms.put("SHA224WITHECDSA", X9ObjectIdentifiers.ecdsa_with_SHA224);
        algorithms.put("SHA256WITHECDSA", X9ObjectIdentifiers.ecdsa_with_SHA256);
        algorithms.put("SHA384WITHECDSA", X9ObjectIdentifiers.ecdsa_with_SHA384);
        algorithms.put("SHA512WITHECDSA", X9ObjectIdentifiers.ecdsa_with_SHA512);
        algorithms.put("GOST3411WITHGOST3410", CryptoProObjectIdentifiers.gostR3411_94_with_gostR3410_94);
        algorithms.put("GOST3411WITHGOST3410-94", CryptoProObjectIdentifiers.gostR3411_94_with_gostR3410_94);
        algorithms.put("GOST3411WITHECGOST3410", CryptoProObjectIdentifiers.gostR3411_94_with_gostR3410_2001);
        algorithms.put("GOST3411WITHECGOST3410-2001", CryptoProObjectIdentifiers.gostR3411_94_with_gostR3410_2001);
        algorithms.put("GOST3411WITHGOST3410-2001", CryptoProObjectIdentifiers.gostR3411_94_with_gostR3410_2001);
        noParams.add(X9ObjectIdentifiers.ecdsa_with_SHA1);
        noParams.add(X9ObjectIdentifiers.ecdsa_with_SHA224);
        noParams.add(X9ObjectIdentifiers.ecdsa_with_SHA256);
        noParams.add(X9ObjectIdentifiers.ecdsa_with_SHA384);
        noParams.add(X9ObjectIdentifiers.ecdsa_with_SHA512);
        noParams.add(X9ObjectIdentifiers.id_dsa_with_sha1);
        noParams.add(NISTObjectIdentifiers.dsa_with_sha224);
        noParams.add(NISTObjectIdentifiers.dsa_with_sha256);
        noParams.add(CryptoProObjectIdentifiers.gostR3411_94_with_gostR3410_94);
        noParams.add(CryptoProObjectIdentifiers.gostR3411_94_with_gostR3410_2001);
        AlgorithmIdentifier sha1AlgId = new AlgorithmIdentifier(OIWObjectIdentifiers.idSHA1, (ASN1Encodable)DERNull.INSTANCE);
        params.put("SHA1WITHRSAANDMGF1", X509Util.creatPSSParams(sha1AlgId, 20));
        AlgorithmIdentifier sha224AlgId = new AlgorithmIdentifier(NISTObjectIdentifiers.id_sha224, (ASN1Encodable)DERNull.INSTANCE);
        params.put("SHA224WITHRSAANDMGF1", X509Util.creatPSSParams(sha224AlgId, 28));
        AlgorithmIdentifier sha256AlgId = new AlgorithmIdentifier(NISTObjectIdentifiers.id_sha256, (ASN1Encodable)DERNull.INSTANCE);
        params.put("SHA256WITHRSAANDMGF1", X509Util.creatPSSParams(sha256AlgId, 32));
        AlgorithmIdentifier sha384AlgId = new AlgorithmIdentifier(NISTObjectIdentifiers.id_sha384, (ASN1Encodable)DERNull.INSTANCE);
        params.put("SHA384WITHRSAANDMGF1", X509Util.creatPSSParams(sha384AlgId, 48));
        AlgorithmIdentifier sha512AlgId = new AlgorithmIdentifier(NISTObjectIdentifiers.id_sha512, (ASN1Encodable)DERNull.INSTANCE);
        params.put("SHA512WITHRSAANDMGF1", X509Util.creatPSSParams(sha512AlgId, 64));
        hexChar = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    }

    private static RSASSAPSSparams creatPSSParams(AlgorithmIdentifier hashAlgId, int saltSize) {
        return new RSASSAPSSparams(hashAlgId, new AlgorithmIdentifier(PKCSObjectIdentifiers.id_mgf1, (ASN1Encodable)hashAlgId), new ASN1Integer((long)saltSize), new ASN1Integer(1L));
    }

    static ASN1ObjectIdentifier getAlgorithmOID(String algorithmName) {
        if (algorithms.containsKey(algorithmName = Strings.toUpperCase((String)algorithmName))) {
            return algorithms.get(algorithmName);
        }
        return new ASN1ObjectIdentifier(algorithmName);
    }

    static AlgorithmIdentifier getSigAlgID(ASN1ObjectIdentifier sigOid, String algorithmName) {
        if (noParams.contains(sigOid)) {
            return new AlgorithmIdentifier(sigOid);
        }
        if (params.containsKey(algorithmName = Strings.toUpperCase((String)algorithmName))) {
            return new AlgorithmIdentifier(sigOid, (ASN1Encodable)params.get(algorithmName));
        }
        return new AlgorithmIdentifier(sigOid, (ASN1Encodable)DERNull.INSTANCE);
    }

    public static Iterator<String> getAlgNames() {
        Enumeration<String> e = algorithms.keys();
        ArrayList<String> l = new ArrayList<String>();
        while (e.hasMoreElements()) {
            l.add(e.nextElement());
        }
        return l.iterator();
    }

    public static String[] getECSpecsNames() {
        Enumeration e = ECNamedCurveTable.getNames();
        ArrayList<String> l = new ArrayList<String>();
        while (e.hasMoreElements()) {
            l.add((String)e.nextElement());
        }
        return l.toArray(new String[0]);
    }

    public static ASN1Primitive getExtensionValue(X509Certificate cert, String oid) throws IOException {
        byte[] bytes = cert.getExtensionValue(oid);
        if (bytes == null) {
            return null;
        }
        ASN1InputStream aIn = new ASN1InputStream((InputStream)new ByteArrayInputStream(bytes));
        ASN1OctetString octs = (ASN1OctetString)aIn.readObject();
        aIn = new ASN1InputStream((InputStream)new ByteArrayInputStream(octs.getOctets()));
        return aIn.readObject();
    }

    private static String getStringFromGeneralNames(ASN1Primitive names) {
        ASN1Sequence namesSequence = ASN1Sequence.getInstance((ASN1TaggedObject)((ASN1TaggedObject)names), (boolean)false);
        if (namesSequence.size() == 0) {
            return null;
        }
        DERTaggedObject taggedObject = (DERTaggedObject)namesSequence.getObjectAt(0);
        return new String(ASN1OctetString.getInstance((ASN1TaggedObject)taggedObject, (boolean)false).getOctets());
    }

    public static DistributionPoint[] getCrlDistributionPoint(X509Certificate certificate) throws CertificateParsingException {
        try {
            ASN1Primitive obj = X509Util.getExtensionValue(certificate, X509Extensions.CRLDistributionPoints.getId());
            if (obj != null) {
                CRLDistPoint crldp = CRLDistPoint.getInstance((Object)obj);
                DistributionPoint[] alldp = crldp.getDistributionPoints();
                return alldp;
            }
        }
        catch (Exception e) {
            logger.error("Error parsing CrlDistributionPoint", (Throwable)e);
            throw new CertificateParsingException(e.toString());
        }
        return null;
    }

    public static X509Certificate[] convertCertChaintoX509(Certificate[] certChain) {
        if (certChain == null) {
            return null;
        }
        X509Certificate[] tempX509CertificateChain = new X509Certificate[certChain.length];
        int i = 0;
        while (i < certChain.length) {
            if (certChain[i] instanceof X509Certificate) {
                tempX509CertificateChain[i] = (X509Certificate)certChain[i];
            }
            ++i;
        }
        return tempX509CertificateChain;
    }

    public static String getCertBase64Encoded(X509Certificate cert) {
        try {
            String sTmp = new String(Base64.encode((byte[])cert.getEncoded()));
            String sEncoded = "-----BEGIN CERTIFICATE-----\r\n";
            int iCnt = 0;
            while (iCnt < sTmp.length()) {
                int iLineLength = iCnt + 64 > sTmp.length() ? sTmp.length() - iCnt : 64;
                sEncoded = String.valueOf(sEncoded) + sTmp.substring(iCnt, iCnt + iLineLength) + "\r\n";
                iCnt += 64;
            }
            sEncoded = String.valueOf(sEncoded) + END_CERT + "\r\n";
            return sEncoded;
        }
        catch (CertificateException e) {
            logger.debug(e.getLocalizedMessage(), (Throwable)e);
            return null;
        }
    }

    public static Collection<X509Certificate> getCertsFromPKCS7(String p7bfilename) throws IOException, CertificateException, CMSException, NoSuchProviderException, NoSuchStoreException {
        logger.info("Importing certificates from PKCS7 file " + p7bfilename);
        byte[] p7bcontent = X509Util.readFile(p7bfilename);
        CMSSignedData data = new CMSSignedData(p7bcontent);
        Store store = data.getCertificates();
        X509CertStoreSelector selector = new X509CertStoreSelector();
        selector.setBasicConstraints(-2);
        Collection certificates = store.getMatches((Selector)selector);
        Integer size = certificates.size();
        Iterator it = certificates.iterator();
        logger.debug("Number of final certificates in the store: " + size);
        while (it.hasNext()) {
            X509Certificate certificate = (X509Certificate)it.next();
            logger.info("Found certificate: " + certificate.getSubjectDN().toString() + ", serial:" + certificate.getSerialNumber());
        }
        return certificates;
    }

    private static byte[] readFile(String fileName) throws IOException {
        File file_to_sign = new File(fileName);
        byte[] buffer = new byte[(int)file_to_sign.length()];
        DataInputStream in = new DataInputStream(new FileInputStream(file_to_sign));
        in.readFully(buffer);
        in.close();
        return buffer;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Collection<X509Certificate> getCertsFromPEM(String certFile) throws IOException, CertificateException {
        logger.info("Importing certificates from PEM file " + certFile);
        Collection<X509Certificate> certs = null;
        try (FileInputStream inStrm = null;){
            try {
                inStrm = new FileInputStream(certFile);
                certs = X509Util.getCertsFromPEM(inStrm);
                return certs;
            }
            catch (IOException e) {
                logger.debug("error while parsing " + certFile + " : " + e.getLocalizedMessage(), (Throwable)e);
                if (inStrm == null) return certs;
                ((InputStream)inStrm).close();
                return certs;
            }
            catch (CertificateException e) {
                logger.debug("error while parsing certificate in " + certFile + " : " + e.getLocalizedMessage(), (Throwable)e);
                if (inStrm == null) return certs;
                ((InputStream)inStrm).close();
                return certs;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public static Collection<X509Certificate> getCertsFromPEM(InputStream certstream) throws IOException, CertificateException {
        ret = new ArrayList<X509Certificate>();
        bufRdr = null;
        ostr = null;
        opstr = null;
        try {
            bufRdr = new BufferedReader(new InputStreamReader(certstream));
            while (bufRdr.ready()) {
                ostr = new ByteArrayOutputStream();
                opstr = new PrintStream(ostr);
                while ((temp = bufRdr.readLine()) != null && !temp.equals("-----BEGIN CERTIFICATE-----")) {
                }
                if (temp != null) ** GOTO lbl15
                throw new IOException("Error in " + certstream.toString() + ", missing " + "-----BEGIN CERTIFICATE-----" + " boundary");
lbl-1000:
                // 1 sources

                {
                    opstr.print(temp);
lbl15:
                    // 2 sources

                    ** while ((temp = bufRdr.readLine()) != null && !temp.equals((Object)"-----END CERTIFICATE-----"))
                }
lbl16:
                // 1 sources

                if (temp == null) {
                    throw new IOException("Error in " + certstream.toString() + ", missing " + "-----END CERTIFICATE-----" + " boundary");
                }
                opstr.close();
                certbuf = Base64.decode((byte[])ostr.toByteArray());
                ostr.close();
                cf = X509Util.getCertificateFactory();
                x509cert = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(certbuf));
                ret.add(x509cert);
            }
        }
        finally {
            if (bufRdr != null) {
                bufRdr.close();
            }
            if (opstr != null) {
                opstr.close();
            }
            if (ostr != null) {
                ostr.close();
            }
        }
        return ret;
    }

    /*
     * Unable to fully structure code
     */
    public static PKCS10CertificationRequest getCSRFromPEM(String csrFile) throws IOException, CertificateException {
        X509Util.logger.info("Loading certificate signing request from PEM file " + csrFile);
        bufRdr = null;
        ostr = null;
        opstr = null;
        pkcs10 = null;
        try {
            inStrm = new FileInputStream(csrFile);
            bufRdr = new BufferedReader(new InputStreamReader(inStrm));
            while (bufRdr.ready()) {
                ostr = new ByteArrayOutputStream();
                opstr = new PrintStream(ostr);
                while ((temp = bufRdr.readLine()) != null && !temp.equals("-----BEGIN CERTIFICATE REQUEST-----")) {
                }
                if (temp.equals("-----BEGIN CERTIFICATE REQUEST-----")) ** GOTO lbl17
                throw new IOException("Error in " + csrFile + ", missing " + "-----BEGIN CERTIFICATE REQUEST-----" + " boundary");
lbl-1000:
                // 1 sources

                {
                    opstr.print(temp);
lbl17:
                    // 2 sources

                    ** while ((temp = bufRdr.readLine()) != null && !temp.equals((Object)"-----END CERTIFICATE REQUEST-----"))
                }
lbl18:
                // 1 sources

                if (!temp.equals("-----END CERTIFICATE REQUEST-----")) {
                    throw new IOException("Error in " + csrFile + ", missing " + "-----END CERTIFICATE REQUEST-----" + " boundary");
                }
                opstr.close();
                certbuf = Base64.decode((byte[])ostr.toByteArray());
                ostr.close();
                pkcs10 = new PKCS10CertificationRequest(certbuf);
            }
        }
        finally {
            if (bufRdr != null) {
                bufRdr.close();
            }
            if (opstr != null) {
                opstr.close();
            }
        }
        return pkcs10;
    }

    public static byte[] getCertEncodedPkcs7(X509Certificate cert) {
        return X509Util.getCertsEncodedPkcs7(new X509Certificate[]{cert});
    }

    public static byte[] getCertsEncodedPkcs7(X509Certificate[] certs) {
        try {
            ArrayList<X509Certificate> alCerts = new ArrayList<X509Certificate>();
            X509Certificate[] x509CertificateArray = certs;
            int n = certs.length;
            int n2 = 0;
            while (n2 < n) {
                X509Certificate cert = x509CertificateArray[n2];
                alCerts.add(cert);
                ++n2;
            }
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            CertPath cp = cf.generateCertPath(alCerts);
            return cp.getEncoded("PKCS7");
        }
        catch (CertificateException e) {
            logger.error("getCertsEncodedPkcs7 error :", (Throwable)e);
            return null;
        }
    }

    public static CertificateFactory getCertificateFactory() {
        try {
            return CertificateFactory.getInstance("X.509", "BC");
        }
        catch (NoSuchProviderException e) {
            logger.debug("error while getting BC Certificate Factory : " + e.getLocalizedMessage(), (Throwable)e);
        }
        catch (CertificateException e) {
            logger.debug("error while getting BC Certificate Factory : " + e.getLocalizedMessage(), (Throwable)e);
        }
        return null;
    }

    public static String toHexString(byte[] b) {
        StringBuffer sb = new StringBuffer(b.length * 2);
        byte[] byArray = b;
        int n = b.length;
        int n2 = 0;
        while (n2 < n) {
            byte element = byArray[n2];
            sb.append(hexChar[(element & 0xF0) >>> 4]);
            sb.append(hexChar[element & 0xF]);
            ++n2;
        }
        return sb.toString();
    }

    public static byte[] fromHexString(String s) {
        int stringLength = s.length();
        if ((stringLength & 1) != 0) {
            throw new IllegalArgumentException("fromHexString requires an even number of hex characters");
        }
        byte[] b = new byte[stringLength / 2];
        int i = 0;
        int j = 0;
        while (i < stringLength) {
            int high = X509Util.charToNibble(s.charAt(i));
            int low = X509Util.charToNibble(s.charAt(i + 1));
            b[j] = (byte)(high << 4 | low);
            i += 2;
            ++j;
        }
        return b;
    }

    public static X509Certificate getBCCertificate(X509Certificate cert) {
        if (cert != null && !(cert instanceof X509CertificateObject)) {
            try {
                ByteArrayInputStream bais = new ByteArrayInputStream(cert.getEncoded());
                cert = (X509Certificate)X509Util.getCertificateFactory().generateCertificate(bais);
            }
            catch (CertificateEncodingException e) {
                logger.error("Certificate conversion to Bouncy Castle Object error", (Throwable)e);
            }
            catch (CertificateException e) {
                logger.error("Certificate conversion to Bouncy Castle Object error", (Throwable)e);
            }
            catch (Exception e) {
                logger.error("Certificate conversion to Bouncy Castle Object error", (Throwable)e);
            }
        }
        return cert;
    }

    private static int charToNibble(char c) {
        if ('0' <= c && c <= '9') {
            return c - 48;
        }
        if ('a' <= c && c <= 'f') {
            return c - 97 + 10;
        }
        if ('A' <= c && c <= 'F') {
            return c - 65 + 10;
        }
        throw new IllegalArgumentException("Invalid hex character: " + c);
    }

    public static X509CRL loadCRLFromDP(DistributionPoint dp) {
        logger.info("CRL download from CDP not implemented yet.");
        return null;
    }

    public static boolean isValidCertificateForEncryption(X509Certificate certificate) {
        try {
            certificate.checkValidity();
            if (X509Util.isValidKeyUsage(certificate, 2)) {
                return true;
            }
        }
        catch (CertificateExpiredException certificateExpiredException) {
            logger.warn("try to use an expired certificate for encryption");
        }
        catch (CertificateNotYetValidException certificateNotYetValidException) {
            logger.warn("try to use a not yet valid certificate for encryption");
        }
        return false;
    }

    public static boolean isValidCertificateForSignature(X509Certificate certificate) {
        block4: {
            certificate.checkValidity();
            if (!X509Util.isValidKeyUsage(certificate, 0) || !X509Util.isValidKeyUsage(certificate, 1)) break block4;
            return true;
        }
        try {
            logger.warn("a signature certificate must have digital signature and non repudiation key usage");
            return false;
        }
        catch (CertificateExpiredException certificateExpiredException) {
            logger.warn("try to use an expired certificate for signature");
        }
        catch (CertificateNotYetValidException certificateNotYetValidException) {
            logger.warn("try to use a not yet valid certificate for encryption");
        }
        return false;
    }

    private static boolean isValidKeyUsage(X509Certificate certificate, int keyusage) {
        if (keyusage >= 0 && keyusage <= 8 && certificate.getKeyUsage() != null) {
            boolean[] ku = certificate.getKeyUsage();
            return ku[keyusage];
        }
        return false;
    }
}

