/*
 * Decompiled with CFR 0.152.
 */
package com.remainsoftware.common.ssl;

import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.remainsoftware.common.ssl.RsaSignAndVerifyText;
import com.remainsoftware.common.util.StringUtils;
import com.remainsoftware.common.util.Validate;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.util.Base64;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.ArrayUtils;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.PEMWriter;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SshKeyUtils {
    private static final Logger logger = LoggerFactory.getLogger(SshKeyUtils.class);
    private static final String END_RSA_PRIVATE_KEY = "-----END RSA PRIVATE KEY-----";
    private static final String BEGIN_RSA_PRIVATE_KEY = "-----BEGIN RSA PRIVATE KEY-----";
    private static final String ECDSA = "ecdsa";
    private static final String DSA = "dsa";
    private static final String RSA = "rsa";
    private static final String SSH_RSA = "ssh-rsa";
    private static final String US_ASCII = "US-ASCII";
    private static final String FILE_IS_EMPTY = "key file is empty";
    private static final String MISSING_KEY_TYPE = "missing key type";
    private static final String UNSUPPORTED_KEY_TYPE = "unsupported key type: ";
    private static final String UNSUPPORTED_VERSION_DESC = "unsupported key version";
    private static final String KEY_EXCESS_DATA_DESC = "processing key reveals excess data, possible padding issue";
    private static final String INVALID_KEYTYPE_DESC = "invalid key type, reason = %s";
    private static final String INVALID_LENGTH_DESC = "invalid key length";
    private static final String UNEXPECTED_TAG_DESC = "unexpected tag";
    private static final String INVALID_KEY_SIZE_DESC = "invalid key size provided for %s algorithm, key size = %d";
    private static final String INVALID_KEY_ALGO_DESC = "invalid key algorithm provided: %s algorithm, key size = %d";
    private static final String FAILED_TO_READ_PUBLIC_KEY_FROM_FILE = "failed to read public key from file: %s, reason = %s";
    private static final String FAILED_TO_READ_PRIVATE_KEY_FROM_FILE = "failed to read private key from file: %s, reason = %s";
    private static final String FILE_DOES_NOT_EXIST = "file does not exist";
    private static final int VALUE_LENGTH = 4;
    private static final byte[] INITIAL_PREFIX;
    private static final Pattern SSH_RSA_PATTERN;
    private static final int DEFAULT_RSA_KEYSIZE = 3072;

    static {
        byte[] byArray = new byte[11];
        byArray[3] = 7;
        byArray[4] = 115;
        byArray[5] = 115;
        byArray[6] = 104;
        byArray[7] = 45;
        byArray[8] = 114;
        byArray[9] = 115;
        byArray[10] = 97;
        INITIAL_PREFIX = byArray;
        SSH_RSA_PATTERN = Pattern.compile("ssh-rsa[\\s]+([A-Za-z0-9/+]+=*)[\\s]+.*");
    }

    private SshKeyUtils() {
    }

    public static com.jcraft.jsch.KeyPair createSshRsaKeyFiles(String keyFileName, File keysPath, String comment, int keySize) throws IllegalArgumentException, IOException, JSchException {
        Validate.isNotNull((Object)keysPath);
        if (StringUtils.isEmpty((String)keyFileName)) {
            keyFileName = "id_rsa";
        }
        File keyFile = new File(keysPath, keyFileName);
        return SshKeyUtils.createSshRsaKeyFiles(keyFile, comment, keySize);
    }

    public static com.jcraft.jsch.KeyPair createSshRsaKeyFiles(File keyFile, String comment, int keySize) throws IllegalArgumentException, IOException, JSchException {
        Validate.isNotNull((Object)keyFile);
        return SshKeyUtils.createKeyPairAndPersist(RSA, keySize, keyFile, comment, "");
    }

    public static com.jcraft.jsch.KeyPair loadKeyPairFromSshRsaKeyFiles(File prvKeyFile, File pubKeyFile) throws IllegalArgumentException, JSchException {
        Validate.isNotNull((Object)prvKeyFile);
        JSch jsch = new JSch();
        return com.jcraft.jsch.KeyPair.load((JSch)jsch, (String)prvKeyFile.getAbsolutePath(), (String)(pubKeyFile != null ? pubKeyFile.getAbsolutePath() : null));
    }

    public static com.jcraft.jsch.KeyPair createKeyPairAndPersist(String algorithm, int keySize, File keyFile, String comment, String passPhrase) throws IllegalArgumentException, IOException, JSchException {
        Validate.isNotEmpty((String)algorithm);
        Validate.isNotNull((Object)keyFile);
        int type = 0;
        if (algorithm.equals(DSA)) {
            type = 1;
            if (keySize != 1024) {
                throw new IllegalArgumentException(String.format(INVALID_KEY_SIZE_DESC, algorithm, keySize));
            }
        } else if (algorithm.equals(ECDSA)) {
            type = 3;
            if (keySize != 256 && keySize != 384 && keySize != 512) {
                throw new IllegalArgumentException(String.format(INVALID_KEY_SIZE_DESC, algorithm, keySize));
            }
        } else if (algorithm.equals(RSA)) {
            type = 2;
            if (keySize != 1024 && keySize != 2048 && keySize != 3072 && keySize != 4096) {
                throw new IllegalArgumentException(String.format(INVALID_KEY_SIZE_DESC, algorithm, keySize));
            }
        } else {
            throw new IllegalArgumentException(String.format(INVALID_KEY_ALGO_DESC, algorithm, keySize));
        }
        JSch jsch = new JSch();
        logger.info(String.format("creating key-pair [type: %s, size: %d, prv-key-file: %s]", SshKeyUtils.getJSchAlgDesc(type), keySize, keyFile));
        com.jcraft.jsch.KeyPair keyPair = com.jcraft.jsch.KeyPair.genKeyPair((JSch)jsch, (int)type, (int)keySize);
        String outFile = keyFile.getAbsolutePath();
        if (StringUtils.isEmpty((String)passPhrase)) {
            keyPair.writePrivateKey(outFile);
        } else {
            keyPair.writePrivateKey(outFile, passPhrase.getBytes());
        }
        if (!StringUtils.isEmpty((String)comment)) {
            keyPair.setPublicKeyComment(comment);
        }
        keyPair.writePublicKey(String.valueOf(outFile) + ".pub", comment == null ? "" : comment);
        keyPair.dispose();
        return keyPair;
    }

    private static Object getJSchAlgDesc(int type) {
        if (type == 1) {
            return DSA.toUpperCase();
        }
        if (type == 2) {
            return RSA.toUpperCase();
        }
        if (type == 3) {
            return ECDSA.toUpperCase();
        }
        return "UKNOWN";
    }

    public static RSAPublicKey parseSSHPublicKey(String key) throws InvalidKeyException {
        Validate.isNotEmpty((String)key);
        Matcher matcher = SSH_RSA_PATTERN.matcher(key.trim());
        if (!matcher.matches()) {
            throw new InvalidKeyException("Key format is invalid for SSH RSA.");
        }
        String keyStr = matcher.group(1);
        ByteArrayInputStream is = new ByteArrayInputStream(org.apache.commons.codec.binary.Base64.decodeBase64((String)keyStr));
        byte[] prefix = new byte[INITIAL_PREFIX.length];
        try {
            if (INITIAL_PREFIX.length != is.read(prefix) || !ArrayUtils.isEquals((Object)INITIAL_PREFIX, (Object)prefix)) {
                throw new InvalidKeyException("Initial [ssh-rsa] key prefix missing.");
            }
            BigInteger exponent = SshKeyUtils.getValue(is);
            BigInteger modulus = SshKeyUtils.getValue(is);
            return (RSAPublicKey)KeyFactory.getInstance("RSA").generatePublic(new RSAPublicKeySpec(modulus, exponent));
        }
        catch (IOException | NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new InvalidKeyException(String.format("Failed to create RSA public key from SSH-RSA key string, reason = %s", StringUtils.extractMessage((Exception)e)), e);
        }
    }

    public static KeyPair converSshRsaToJavaKeyPair(InputStream pubKey, InputStream prvKey) throws IOException, GeneralSecurityException {
        Validate.isNotNull((Object)pubKey);
        Validate.isNotNull((Object)prvKey);
        KeyFactory f = KeyFactory.getInstance(RSA);
        RSAPublicKeySpec pubKeySpec = SshKeyUtils.transformToRsaPublicKeySpec(SshKeyUtils.readAllBase64Bytes(pubKey));
        RSAPrivateCrtKeySpec prvKeySpec = SshKeyUtils.decodeRSAPrivatePKCS1(SshKeyUtils.readAllBase64Bytes(prvKey));
        return new KeyPair(f.generatePublic(pubKeySpec), f.generatePrivate(prvKeySpec));
    }

    public static boolean isSshRsaPublicKey(String pk) {
        Validate.isNotEmpty((String)pk);
        String[] fields = pk.split(" ");
        return fields.length >= 2 && fields[0].equals(SSH_RSA);
    }

    public static boolean isValidSshRsaPublicKey(String pkString) {
        try {
            SshKeyUtils.getRsaPublicKeyFromOpenSshRsaPublicKey(pkString.getBytes());
            return true;
        }
        catch (Exception e) {
            logger.warn(String.format("failed to validate SSH-RSA public key: %s..., msg = %s", StringUtils.truncate((String)pkString, (int)20), StringUtils.extractMessage((Exception)e)));
            return false;
        }
    }

    public static String getOpenSshRsaPublicKeyString(String pkString) {
        Validate.isNotEmpty((String)pkString);
        String[] fields = pkString.split(" ");
        if (fields.length < 2 || !fields[0].equals(SSH_RSA)) {
            return null;
        }
        return fields[1];
    }

    public static RSAPublicKey getRsaPublicKeyFromOpenSshRsaPublicKey(byte[] pkString) throws IllegalArgumentException, InvalidKeySpecException, NoSuchAlgorithmException {
        Validate.isNotNull((Object)pkString);
        String[] fields = new String(pkString, StandardCharsets.US_ASCII).split(" ");
        if (fields.length < 2) {
            throw new IllegalArgumentException(String.format(INVALID_KEYTYPE_DESC, MISSING_KEY_TYPE));
        }
        if (!fields[0].equals(SSH_RSA)) {
            throw new IllegalArgumentException(String.format(INVALID_KEYTYPE_DESC, UNSUPPORTED_KEY_TYPE + fields[0]));
        }
        byte[] decoded = Base64.getDecoder().decode(fields[1]);
        return SshKeyUtils.transformToRsaPublicKey(decoded);
    }

    public static PublicKey getPublicKeyFromOpenSshRsaPublicKey(byte[] pkString) throws IllegalArgumentException, InvalidKeySpecException, NoSuchAlgorithmException {
        Validate.isNotNull((Object)pkString);
        String[] fields = new String(pkString, StandardCharsets.US_ASCII).split(" ");
        if (fields.length < 2) {
            throw new IllegalArgumentException(String.format(INVALID_KEYTYPE_DESC, MISSING_KEY_TYPE));
        }
        if (!fields[0].equals(SSH_RSA)) {
            throw new IllegalArgumentException(String.format(INVALID_KEYTYPE_DESC, UNSUPPORTED_KEY_TYPE + fields[0]));
        }
        byte[] decoded = Base64.getDecoder().decode(fields[1]);
        return SshKeyUtils.transformToPublicKey(decoded);
    }

    public static RSAPublicKey transformToRsaPublicKey(byte[] decodedPk) throws IllegalArgumentException, InvalidKeySpecException, NoSuchAlgorithmException {
        Validate.isNotNull((Object)decodedPk);
        ByteBuffer input = ByteBuffer.wrap(decodedPk);
        String type = SshKeyUtils.string(input);
        if (!SSH_RSA.equals(type)) {
            throw new IllegalArgumentException(String.format(INVALID_KEYTYPE_DESC, UNSUPPORTED_KEY_TYPE + type));
        }
        BigInteger exp = SshKeyUtils.sshint(input);
        BigInteger mod = SshKeyUtils.sshint(input);
        if (input.hasRemaining()) {
            throw new IllegalArgumentException(KEY_EXCESS_DATA_DESC);
        }
        return (RSAPublicKey)KeyFactory.getInstance(RSA).generatePublic(new RSAPublicKeySpec(mod, exp));
    }

    public static PublicKey transformToPublicKey(byte[] decodedPk) throws IllegalArgumentException, InvalidKeySpecException, NoSuchAlgorithmException {
        Validate.isNotNull((Object)decodedPk);
        ByteBuffer input = ByteBuffer.wrap(decodedPk);
        String type = SshKeyUtils.string(input);
        if (!SSH_RSA.equals(type)) {
            throw new IllegalArgumentException(String.format(INVALID_KEYTYPE_DESC, UNSUPPORTED_KEY_TYPE + type));
        }
        RSAPublicKeySpec pubKeySpec = SshKeyUtils.transformToRsaPublicKeySpec(decodedPk);
        KeyFactory f = KeyFactory.getInstance(RSA);
        return f.generatePublic(pubKeySpec);
    }

    public static RSAPublicKeySpec getSshRsaPublicKeySpec(String pkString) throws IllegalArgumentException {
        Validate.isNotNull((Object)pkString);
        String[] fields = new String(pkString.getBytes(), StandardCharsets.US_ASCII).split(" ");
        if (fields.length < 2) {
            throw new IllegalArgumentException(String.format(INVALID_KEYTYPE_DESC, MISSING_KEY_TYPE));
        }
        if (!fields[0].equals(SSH_RSA)) {
            throw new IllegalArgumentException(String.format(INVALID_KEYTYPE_DESC, UNSUPPORTED_KEY_TYPE + fields[0]));
        }
        byte[] std = Base64.getDecoder().decode(fields[1]);
        return SshKeyUtils.transformToRsaPublicKeySpec(std);
    }

    public static RSAPublicKeySpec transformToRsaPublicKeySpec(byte[] decodedPk) throws IllegalArgumentException {
        Validate.isNotNull((Object)decodedPk);
        ByteBuffer input = ByteBuffer.wrap(decodedPk);
        String type = SshKeyUtils.string(input);
        if (!SSH_RSA.equals(type)) {
            throw new IllegalArgumentException(String.format(INVALID_KEYTYPE_DESC, UNSUPPORTED_KEY_TYPE + type));
        }
        BigInteger exp = SshKeyUtils.sshint(input);
        BigInteger mod = SshKeyUtils.sshint(input);
        if (input.hasRemaining()) {
            throw new IllegalArgumentException(KEY_EXCESS_DATA_DESC);
        }
        return new RSAPublicKeySpec(mod, exp);
    }

    public static PublicKey getPublicKeyFromSshRsaPublicKey(String sshRsaPublicKey) throws NoSuchAlgorithmException, InvalidKeySpecException {
        RSAPublicKeySpec pubKeySpec = SshKeyUtils.getSshRsaPublicKeySpec(sshRsaPublicKey);
        KeyFactory f = KeyFactory.getInstance(RSA);
        return f.generatePublic(pubKeySpec);
    }

    /*
     * Loose catch block
     */
    public static PrivateKey getPrivateKeyFromRsaPrivateKey(File prvKeyFile) throws IOException {
        Validate.isNotNull((Object)prvKeyFile, (String)"private key file must be set");
        if (!prvKeyFile.exists()) {
            throw new IOException(String.format(FAILED_TO_READ_PRIVATE_KEY_FROM_FILE, prvKeyFile.getAbsolutePath(), FILE_DOES_NOT_EXIST));
        }
        Throwable throwable = null;
        Object var2_3 = null;
        try (BufferedReader br = new BufferedReader(new FileReader(prvKeyFile));){
            PrivateKey privateKey;
            PEMParser pp;
            Throwable throwable2;
            block21: {
                if (Security.getProvider("BC") == null) {
                    Security.addProvider((Provider)new BouncyCastleProvider());
                }
                throwable2 = null;
                Object var5_8 = null;
                pp = new PEMParser((Reader)br);
                PEMKeyPair pemKeyPair = (PEMKeyPair)pp.readObject();
                KeyPair kp = new JcaPEMKeyConverter().getKeyPair(pemKeyPair);
                privateKey = kp.getPrivate();
                if (pp == null) break block21;
                pp.close();
            }
            return privateKey;
            {
                catch (Throwable throwable3) {
                    try {
                        if (pp != null) {
                            pp.close();
                        }
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        if (throwable2 == null) {
                            throwable2 = throwable4;
                        } else if (throwable2 != throwable4) {
                            throwable2.addSuppressed(throwable4);
                        }
                        throw throwable2;
                    }
                }
            }
        }
        catch (Throwable throwable5) {
            if (throwable == null) {
                throwable = throwable5;
            } else if (throwable != throwable5) {
                throwable.addSuppressed(throwable5);
            }
            throw throwable;
        }
    }

    public static RSAPrivateCrtKeySpec decodeRSAPrivatePKCS1(byte[] decodedPk) throws IllegalArgumentException {
        Validate.isNotNull((Object)decodedPk, (String)"bytes to decode must be set");
        ByteBuffer input = ByteBuffer.wrap(decodedPk);
        if (SshKeyUtils.der(input, 48) != input.remaining()) {
            throw new IllegalArgumentException(KEY_EXCESS_DATA_DESC);
        }
        if (!BigInteger.ZERO.equals(SshKeyUtils.derint(input))) {
            throw new IllegalArgumentException(UNSUPPORTED_VERSION_DESC);
        }
        BigInteger n = SshKeyUtils.derint(input);
        BigInteger e = SshKeyUtils.derint(input);
        BigInteger d = SshKeyUtils.derint(input);
        BigInteger p = SshKeyUtils.derint(input);
        BigInteger q = SshKeyUtils.derint(input);
        BigInteger ep = SshKeyUtils.derint(input);
        BigInteger eq = SshKeyUtils.derint(input);
        BigInteger c = SshKeyUtils.derint(input);
        return new RSAPrivateCrtKeySpec(n, e, d, p, q, ep, eq, c);
    }

    public static RSAPublicKey getRsaPublicKey(File pubKeyFile) throws IOException, NoSuchAlgorithmException, InvalidKeySpecException {
        Validate.isNotNull((Object)pubKeyFile, (String)"public key file must be set");
        String publicKey = SshKeyUtils.getPublicKeyStringFromFile(pubKeyFile);
        RSAPublicKeySpec rsaPublicKeySpec = SshKeyUtils.getSshRsaPublicKeySpec(publicKey);
        return (RSAPublicKey)KeyFactory.getInstance(RSA).generatePublic(rsaPublicKeySpec);
    }

    public static String getPublicKeyStringFromFile(File pubKeyFile) throws IOException {
        Validate.isNotNull((Object)pubKeyFile, (String)"public key file must be set");
        if (!pubKeyFile.exists()) {
            throw new IOException(String.format(FAILED_TO_READ_PUBLIC_KEY_FROM_FILE, pubKeyFile.getAbsolutePath(), FILE_DOES_NOT_EXIST));
        }
        String contents = null;
        try {
            contents = FileUtils.readFileToString((File)pubKeyFile);
        }
        catch (IOException e) {
            throw new IOException(String.format(FAILED_TO_READ_PUBLIC_KEY_FROM_FILE, pubKeyFile.getAbsolutePath(), StringUtils.extractMessage((Exception)e)));
        }
        contents = contents.trim();
        if (StringUtils.isEmpty((String)contents)) {
            throw new IOException(String.format(FAILED_TO_READ_PUBLIC_KEY_FROM_FILE, pubKeyFile.getAbsolutePath(), FILE_IS_EMPTY));
        }
        return contents;
    }

    public static String getPrivateKeyFromFile(File prvKeyFile) throws IOException {
        if (!prvKeyFile.exists()) {
            throw new IOException(String.format(FAILED_TO_READ_PRIVATE_KEY_FROM_FILE, prvKeyFile.getAbsolutePath(), FILE_DOES_NOT_EXIST));
        }
        String contents = null;
        try {
            contents = FileUtils.readFileToString((File)prvKeyFile);
        }
        catch (IOException e) {
            throw new IOException(String.format(FAILED_TO_READ_PRIVATE_KEY_FROM_FILE, prvKeyFile.getAbsolutePath(), StringUtils.extractMessage((Exception)e)));
        }
        contents = contents.trim();
        if (StringUtils.isEmpty((String)contents)) {
            throw new IOException(String.format(FAILED_TO_READ_PRIVATE_KEY_FROM_FILE, prvKeyFile.getAbsolutePath(), FILE_IS_EMPTY));
        }
        return contents;
    }

    private static String string(ByteBuffer buf) {
        return new String(SshKeyUtils.lenval(buf), Charset.forName(US_ASCII));
    }

    private static BigInteger sshint(ByteBuffer buf) {
        return new BigInteger(1, SshKeyUtils.lenval(buf));
    }

    private static byte[] lenval(ByteBuffer buf) {
        byte[] copy = new byte[buf.getInt()];
        buf.get(copy);
        return copy;
    }

    private static BigInteger derint(ByteBuffer input) {
        int len = SshKeyUtils.der(input, 2);
        byte[] value = new byte[len];
        input.get(value);
        return new BigInteger(1, value);
    }

    private static int der(ByteBuffer input, int exp) {
        int tag = input.get() & 0xFF;
        if (tag != exp) {
            throw new IllegalArgumentException(UNEXPECTED_TAG_DESC);
        }
        int n = input.get() & 0xFF;
        if (n < 128) {
            return n;
        }
        if ((n &= 0x7F) < 1 || n > 2) {
            throw new IllegalArgumentException(INVALID_LENGTH_DESC);
        }
        int len = 0;
        while (n-- > 0) {
            len <<= 8;
            len |= input.get() & 0xFF;
        }
        return len;
    }

    private static byte[] readAllBase64Bytes(InputStream input) throws IOException {
        String line;
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        BufferedReader r = new BufferedReader(new InputStreamReader(input, StandardCharsets.US_ASCII));
        Base64.Decoder decoder = Base64.getDecoder();
        while ((line = r.readLine()) != null) {
            if (line.startsWith("-----")) continue;
            output.write(decoder.decode(line));
        }
        return output.toByteArray();
    }

    private static BigInteger getValue(InputStream inputStream) throws IOException {
        byte[] valueArray;
        Validate.isNotNull((Object)inputStream);
        byte[] lenBuff = new byte[4];
        if (4 != inputStream.read(lenBuff)) {
            throw new InvalidParameterException("Unable to read key value length");
        }
        int len = ByteBuffer.wrap(lenBuff).getInt();
        if (len != inputStream.read(valueArray = new byte[len])) {
            throw new InvalidParameterException("Unable to read key value");
        }
        return new BigInteger(valueArray);
    }

    public static String getJschRsaPublicKey(File privateKeyFile) throws JSchException, IOException {
        com.jcraft.jsch.KeyPair keyPair = com.jcraft.jsch.KeyPair.load((JSch)SshKeyUtils.getJSch(), (String)privateKeyFile.getAbsolutePath());
        if (keyPair.getKeyType() != 2 || keyPair.isEncrypted()) {
            return null;
        }
        Throwable throwable = null;
        Object var3_4 = null;
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            keyPair.writePublicKey((OutputStream)out, keyPair.getPublicKeyComment());
            return out.toString();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static String getJschRsaPrivateKey(File privateKeyFile) throws JSchException, IOException {
        com.jcraft.jsch.KeyPair keyPair = com.jcraft.jsch.KeyPair.load((JSch)SshKeyUtils.getJSch(), (String)privateKeyFile.getAbsolutePath());
        if (keyPair.getKeyType() != 2 || keyPair.isEncrypted()) {
            return null;
        }
        Throwable throwable = null;
        Object var3_4 = null;
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            keyPair.writePrivateKey((OutputStream)out);
            return out.toString();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static JSch getJSch() {
        return new JSch();
    }

    public static String convertPrivateKeyToJschPrivateKey(PrivateKey privateKey) throws IOException {
        StringWriter stringWriter = new StringWriter();
        PEMWriter pemWriter = new PEMWriter((Writer)stringWriter);
        pemWriter.writeObject((Object)privateKey);
        pemWriter.close();
        byte[] privateKeyPEM = stringWriter.toString().getBytes();
        return privateKeyPEM.toString();
    }

    static byte[] readKeyFile(File keyFile) throws IOException {
        return FileUtils.readFileToByteArray((File)keyFile);
    }

    public static void main(String[] args) throws Exception {
        File prvKeyFile = new File(System.getProperty("java.io.tmpdir"), "rsa_id");
        if (!prvKeyFile.exists()) {
            prvKeyFile.createNewFile();
        }
        String keyPass = "oms@localhost:45052";
        SshKeyUtils.createKeyPairAndPersist(RSA, 3072, prvKeyFile, keyPass, null);
        if (prvKeyFile.exists()) {
            SshKeyUtils.getJschRsaPrivateKey(prvKeyFile);
            String jschRsaPublicKey = SshKeyUtils.getJschRsaPublicKey(prvKeyFile);
            PublicKey publicKey = SshKeyUtils.getPublicKeyFromSshRsaPublicKey(jschRsaPublicKey);
            PrivateKey privateKey = SshKeyUtils.getPrivateKeyFromRsaPrivateKey(prvKeyFile);
            keyPass = new String(keyPass.getBytes(), StandardCharsets.UTF_8);
            System.out.println("Text to be encrypted: " + keyPass);
            byte[] cipherText = RsaSignAndVerifyText.rsaEncrypt(keyPass.getBytes(StandardCharsets.UTF_8), privateKey);
            String decipherEnc = Base64.getEncoder().encodeToString(cipherText);
            byte[] decipherDec = Base64.getDecoder().decode(decipherEnc);
            String decryptedText = RsaSignAndVerifyText.rsaDecrypt(decipherDec, publicKey, StandardCharsets.UTF_8);
            System.out.println("Decrypted text: " + decryptedText);
        }
    }
}

