/*
 * Decompiled with CFR 0.152.
 */
package com.remainsoftware.common.ssl;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyManagementException;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.CertPathParameters;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.Collection;
import javax.net.ssl.CertPathTrustManagerParameters;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSLUtils {
    private static final Logger logger = LoggerFactory.getLogger(SSLUtils.class);
    private static final TrustManager[] trustAllCerts = new TrustManager[]{new TrustAllTrustManager()};

    public static void disableSSLHostnameVerification() {
        HttpsURLConnection.setDefaultHostnameVerifier(new VerifyAllHostnameVerifier());
    }

    public static TrustManager[] getTrustAllCertsTrustManagers() {
        return (TrustManager[])trustAllCerts.clone();
    }

    public static SSLSocketFactory getSSLSocketFactory(String protocol, String[] sslEnabledProtocols, String[] sslCipherSuites, SecureRandom random, TrustManager[] tms, KeyManager[] kms) throws NoSuchAlgorithmException, KeyManagementException {
        SSLContext sc = SSLContext.getInstance(protocol);
        sc.init(kms, tms, random);
        SSLSocketFactory sf = sc.getSocketFactory();
        if (sslEnabledProtocols != null || sslCipherSuites != null) {
            sf = new CustomSSLSocketFactory(sf, sslEnabledProtocols, sslCipherSuites);
        }
        return sf;
    }

    protected static TrustManager[] getTrustManagers(String trustStoreFilename, String trustStorePassword, String trustStoreType, String trustStoreProvider, String trustStoreAlgorithm, Integer maxCertificatePathLength, String crlFilename) throws IOException, KeyStoreException, NoSuchProviderException, NoSuchAlgorithmException, CertificateException, InvalidAlgorithmParameterException, CRLException {
        KeyStore trustStore = SSLUtils.getStore(trustStoreFilename, trustStorePassword, trustStoreType, trustStoreProvider);
        if (trustStoreAlgorithm == null) {
            trustStoreAlgorithm = TrustManagerFactory.getDefaultAlgorithm();
        }
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(trustStoreAlgorithm);
        if (crlFilename == null) {
            tmf.init(trustStore);
        } else {
            CertPathParameters params = SSLUtils.getParameters(trustStoreAlgorithm, crlFilename, maxCertificatePathLength, trustStore);
            CertPathTrustManagerParameters mfp = new CertPathTrustManagerParameters(params);
            tmf.init(mfp);
        }
        return tmf.getTrustManagers();
    }

    protected static CertPathParameters getParameters(String algorithm, String crlFilename, Integer maxCertificateChainLength, KeyStore trustStore) throws KeyStoreException, InvalidAlgorithmParameterException, CRLException, CertificateException, IOException, NoSuchAlgorithmException {
        PKIXBuilderParameters xparams;
        PKIXBuilderParameters params = null;
        if ("PKIX".equalsIgnoreCase(algorithm)) {
            xparams = new PKIXBuilderParameters(trustStore, (CertSelector)new X509CertSelector());
            Collection<? extends CRL> crls = SSLUtils.getCRLs(crlFilename);
            CollectionCertStoreParameters csp = new CollectionCertStoreParameters(crls);
            CertStore store = CertStore.getInstance("Collection", csp);
            xparams.addCertStore(store);
            xparams.setRevocationEnabled(true);
            if (maxCertificateChainLength != null) {
                xparams.setMaxPathLength(maxCertificateChainLength);
            }
        } else {
            throw new CRLException("CRLs not supported for type: " + algorithm);
        }
        params = xparams;
        return params;
    }

    public static Collection<? extends CRL> getCRLs(String crlFilename) throws IOException, CRLException, CertificateException {
        File crlFile = new File(crlFilename);
        Collection<? extends CRL> crls = null;
        InputStream is = null;
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            is = new FileInputStream(crlFile);
            crls = cf.generateCRLs(is);
        }
        catch (Throwable throwable) {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (is != null) {
            try {
                is.close();
            }
            catch (IOException iOException) {}
        }
        return crls;
    }

    public static KeyStore getStore(String storeFilename, String storePassword, String storeType, String storeProvider) throws IOException, KeyStoreException, NoSuchProviderException, CertificateException, NoSuchAlgorithmException {
        KeyStore keyStore;
        block8: {
            KeyStore ks = null;
            InputStream in = null;
            try {
                ks = storeProvider == null ? KeyStore.getInstance(storeType) : KeyStore.getInstance(storeType, storeProvider);
                in = new FileInputStream(storeFilename);
                char[] storePass = null;
                if (storePassword != null && !"".equals(storePassword)) {
                    storePass = storePassword.toCharArray();
                }
                ks.load(in, storePass);
                keyStore = ks;
                if (in == null) break block8;
            }
            catch (Throwable throwable) {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
        return keyStore;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static synchronized Certificate[] getCertificatesFromSocket(String host, String port) throws Exception {
        Certificate[] certificateArray;
        TrustManager[] trustCerts = new TrustManager[]{new DefaultTrustManager(){}};
        Socket sslSocket = null;
        try {
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, trustCerts, new SecureRandom());
            SSLSocketFactory sslSocketFactory = sslContext.getSocketFactory();
            sslSocket = (SSLSocket)sslSocketFactory.createSocket(host, (int)Integer.valueOf(port));
            ((SSLSocket)sslSocket).startHandshake();
            certificateArray = ((SSLSocket)sslSocket).getSession().getPeerCertificates();
            if (sslSocket == null) return certificateArray;
        }
        catch (Exception e) {
            try {
                throw new Exception(String.format("Could not get certificate from secure socket to %s:%s", host, port), e);
            }
            catch (Throwable throwable) {
                if (sslSocket == null) throw throwable;
                try {
                    sslSocket.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
        }
        try {
            sslSocket.close();
            return certificateArray;
        }
        catch (IOException iOException) {}
        return certificateArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static X509Certificate convertFileToX509Certificate(File pemFile) throws Exception {
        X509Certificate x509Certificate;
        FileInputStream is = null;
        try {
            is = new FileInputStream(pemFile);
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            x509Certificate = (X509Certificate)cf.generateCertificate(is);
            if (is == null) return x509Certificate;
        }
        catch (Exception e) {
            try {
                throw new Exception(String.format("Failed to convert file '%s' to X509 certificate.", pemFile != null ? pemFile : "null"), e);
            }
            catch (Throwable throwable) {
                if (is == null) throw throwable;
                try {
                    ((InputStream)is).close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
        }
        try {
            ((InputStream)is).close();
            return x509Certificate;
        }
        catch (IOException iOException) {}
        return x509Certificate;
    }

    public static KeyStore loadKeyStore(String keystoreFile, String keystorePassword) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("Load keystore '%s' file with '%s' password", keystoreFile, keystorePassword));
        }
        KeyStore keystore = null;
        try {
            Throwable throwable = null;
            Object var4_9 = null;
            try (FileInputStream fis = new FileInputStream(new File(keystoreFile));){
                keystore = KeyStore.getInstance("JKS");
                keystore.load(fis, keystorePassword.toCharArray());
                return keystore;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e2) {
            if (logger.isDebugEnabled()) {
                logger.debug(String.format("Error loading JKS keystore '%s' file with '%s' password. Maybe its type is not JKS: %s", keystoreFile, keystorePassword, e2));
            }
            try {
                Throwable e2 = null;
                Object var4_11 = null;
                try (FileInputStream fis = new FileInputStream(new File(keystoreFile));){
                    keystore = KeyStore.getInstance("PKCS12");
                    keystore.load(fis, keystorePassword.toCharArray());
                    return keystore;
                }
                catch (Throwable throwable) {
                    if (e2 == null) {
                        e2 = throwable;
                    } else if (e2 != throwable) {
                        e2.addSuppressed(throwable);
                    }
                    throw e2;
                }
            }
            catch (Exception e3) {
                if (logger.isDebugEnabled()) {
                    logger.debug(String.format("Error loading PKCS12 keystore '%s' file with '%s' password. Maybe its type is not PKCS12: %s", keystoreFile, keystorePassword, e3));
                }
                throw new Exception(String.format("Error loading keystore '%s' file with '%s' password", keystoreFile, keystorePassword));
            }
        }
    }

    public static KeyPair loadKeyPairFromKeyStore(String keystoreFile, String keystorePassword, String publicKeyAlias) throws Exception {
        KeyStore keystore = SSLUtils.loadKeyStore(keystoreFile, keystorePassword);
        PublicKey publicKey = SSLUtils.loadPublicKeyFromKeyStore(keystore, publicKeyAlias);
        PrivateKey privateKey = SSLUtils.loadPrivateKeyFromKeyStore(keystore, keystorePassword, publicKeyAlias);
        return new KeyPair(publicKey, privateKey);
    }

    public static PublicKey loadPublicKeyFromKeyStore(KeyStore keystore, String publicKeyAlias) throws Exception {
        Certificate certificate;
        try {
            certificate = keystore.getCertificate(publicKeyAlias);
        }
        catch (KeyStoreException e) {
            throw new Exception(String.format("Error loading public key for alias '%s'", publicKeyAlias), e);
        }
        if (certificate == null) {
            throw new Exception(String.format("Error loading public key for alias '%s': Given alias does not exist or does not contain a certificate.", publicKeyAlias));
        }
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("Loaded public key for alias '%s'", publicKeyAlias));
        }
        return certificate.getPublicKey();
    }

    public static PrivateKey loadPrivateKeyFromKeyStore(KeyStore keystore, String keystorePassword, String publicKeyAlias) throws Exception {
        PrivateKey privateKey = null;
        try {
            privateKey = (PrivateKey)keystore.getKey(publicKeyAlias, keystorePassword.toCharArray());
        }
        catch (Exception e) {
            throw new Exception(String.format("Error loading private key for alias '%s'", publicKeyAlias), e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("Loaded private key for alias '%s'", publicKeyAlias));
        }
        return privateKey;
    }

    public static class CustomSSLSocketFactory
    extends SSLSocketFactory {
        private final String[] fSslEnabledProtocols;
        private final String[] fSslCipherSuites;
        private final SSLSocketFactory fBbase;

        public CustomSSLSocketFactory(SSLSocketFactory base, String[] sslEnabledProtocols, String[] sslCipherSuites) {
            this.fBbase = base;
            this.fSslEnabledProtocols = sslEnabledProtocols == null ? null : (String[])sslEnabledProtocols.clone();
            this.fSslCipherSuites = sslCipherSuites == null || sslCipherSuites.length == 0 ? base.getDefaultCipherSuites() : (1 == sslCipherSuites.length && "ALL".equalsIgnoreCase(sslCipherSuites[0]) ? base.getSupportedCipherSuites() : (String[])sslCipherSuites.clone());
        }

        @Override
        public String[] getDefaultCipherSuites() {
            return this.fBbase.getDefaultCipherSuites();
        }

        @Override
        public String[] getSupportedCipherSuites() {
            return this.fBbase.getSupportedCipherSuites();
        }

        private SSLSocket customize(Socket s) {
            SSLSocket socket = (SSLSocket)s;
            if (this.fSslEnabledProtocols != null) {
                socket.setEnabledProtocols(this.fSslEnabledProtocols);
            }
            socket.setEnabledCipherSuites(this.fSslCipherSuites);
            return socket;
        }

        @Override
        public Socket createSocket(Socket s, String host, int port, boolean autoClose) throws IOException {
            return this.customize(this.fBbase.createSocket(s, host, port, autoClose));
        }

        @Override
        public Socket createSocket(String host, int port) throws IOException {
            return this.customize(this.fBbase.createSocket(host, port));
        }

        @Override
        public Socket createSocket(InetAddress host, int port) throws IOException {
            return this.customize(this.fBbase.createSocket(host, port));
        }

        @Override
        public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException {
            return this.customize(this.fBbase.createSocket(host, port, localHost, localPort));
        }

        @Override
        public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
            return this.customize(this.fBbase.createSocket(address, port, localAddress, localPort));
        }
    }

    public static class DefaultHostnameVerifier
    implements HostnameVerifier {
        @Override
        public boolean verify(String hostname, SSLSession session) {
            return true;
        }
    }

    public static class DefaultTrustManager
    implements X509TrustManager {
        private static final X509Certificate[] acceptedIssuers = new X509Certificate[0];

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return acceptedIssuers;
        }
    }

    protected static class TrustAllTrustManager
    implements X509TrustManager {
        private static final X509Certificate[] EMPTY = new X509Certificate[0];

        protected TrustAllTrustManager() {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return EMPTY;
        }

        @Override
        public void checkClientTrusted(X509Certificate[] certs, String authType) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] certs, String authType) {
        }

        public boolean equals(Object o) {
            return o.getClass().equals(this.getClass());
        }
    }

    protected static class VerifyAllHostnameVerifier
    implements HostnameVerifier {
        protected VerifyAllHostnameVerifier() {
        }

        @Override
        public boolean verify(String hostname, SSLSession session) {
            return true;
        }
    }
}

