/*
 * Decompiled with CFR 0.152.
 */
package com.remainsoftware.common.ssl;

import com.remainsoftware.common.ssl.PemFile;
import com.remainsoftware.common.ssl.SSLUtils;
import com.remainsoftware.common.ssl.SshKeyUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Writer;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.KeyManagementException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.ECParameterSpec;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.TreeMap;
import javax.net.ssl.HandshakeCompletedEvent;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.provider.JCEECPublicKey;
import org.bouncycastle.jce.provider.JDKDSAPublicKey;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemObjectGenerator;
import org.bouncycastle.util.io.pem.PemWriter;

public class SSLTest {
    private static boolean debug = false;
    static final char[] hexChars;

    static {
        if (Security.getProvider("BC") == null) {
            System.out.println("BouncyCastle; adding security provider to the JVM");
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
        hexChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', 'a', 'b', 'c', 'd', 'e', 'f'};
    }

    public static void main(String[] args) {
        try {
            SSLTest._main(args);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void usage() {
        System.out.println("Usage: java " + SSLTest.class + " [opts] host[:port]");
        System.out.println();
        System.out.println("-sslprotocol                 Sets the SSL/TLS protocol to be used (e.g. SSL, TLS, SSLv3, TLSv1.2, etc.)");
        System.out.println("-enabledprotocols protocols  Sets individual SSL/TLS ptotocols that should be enabled");
        System.out.println("-ciphers cipherspec          A comma-separated list of SSL/TLS ciphers");
        System.out.println("-cipherFilter filter         A regular expression containing cipher suite patterns which should be REMOVED from the acceptable list (e.g. '(NULL|anon|RC4)')");
        System.out.println("-connectonly                 Don't scan; only connect a single time");
        System.out.println("-keystore                    Sets the key store for connections (for TLS client certificates)");
        System.out.println("-keystoretype type           Sets the type for the key store");
        System.out.println("-keystorepassword pass       Sets the password for the key store");
        System.out.println("-keystoreprovider provider   Sets the crypto provider for the key store");
        System.out.println("-truststore                  Sets the trust store for connections");
        System.out.println("-truststoretype type         Sets the type for the trust store");
        System.out.println("-truststorepassword pass     Sets the password for the trust store");
        System.out.println("-truststorealgorithm alg     Sets the algorithm for the trust store");
        System.out.println("-truststoreprovider provider Sets the crypto provider for the trust store");
        System.out.println("-crlfilename                 Sets the CRL filename to use for the trust store");
        System.out.println("-check-certificate           Checks certificate trust (default: true)");
        System.out.println("-no-check-certificate        Ignores certificate errors (default: false)");
        System.out.println("-verify-hostname             Verifies certificate hostname (default: false)");
        System.out.println("-no-verify-hostname          Ignores hostname mismatches (default: true)");
        System.out.println("-showcerts                   Show server's certificate chain information");
        System.out.println("-showsslerrors               Show SSL/TLS error details");
        System.out.println("-showhandshakeerrors         Show SSL/TLS handshake error details");
        System.out.println("-showerrors                  Show all connection error details");
        System.out.println("-showrejects                 Show protocols/ciphers which weren't successful");
        System.out.println("-savecerts filename          Save chain of certificates with the provided base file name (no extension)");
        System.out.println("-createkeys keyspath         Create and save a RSA key pair to provided path -> id_rsa/id_rsa.pub and exit");
        System.out.println("-debug                       Show detailed SSL/TLS handshake info");
        System.out.println();
        System.out.println("-client-info                 Show this client's capabilities and exit");
        System.out.println("-h -help --help              Shows this help message");
    }

    /*
     * Exception decompiling
     */
    private static void _main(String[] args) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    static void hadShakeCompleted(HandshakeCompletedEvent evt) {
        System.err.println("\n======== COMPLETED HANDSHAKE EVENT INFO, SESSION = " + evt.getSession());
        System.err.println("\tHANDSHAKE THREADNAME: " + Thread.currentThread().getName());
        SSLSocket socket1 = evt.getSocket();
        System.err.println("\tparameters = " + socket1.getSSLParameters());
        System.err.println(Arrays.asList(socket1.getSSLParameters().getProtocols()));
        System.err.println(Arrays.asList(socket1.getSSLParameters().getCipherSuites()));
        System.err.println("\tconstraints=" + socket1.getSSLParameters().getAlgorithmConstraints());
        System.err.println("\tendpoint id algorithm = " + socket1.getSSLParameters().getEndpointIdentificationAlgorithm());
        System.err.println("\tserver names=" + socket1.getSSLParameters().getServerNames());
        try {
            System.err.println("\tprincipal = " + evt.getPeerPrincipal());
            Certificate[] certificateArray = evt.getSession().getPeerCertificates();
            int n = certificateArray.length;
            int n2 = 0;
            while (n2 < n) {
                Certificate cert = certificateArray[n2];
                if ("X.509".equals(cert.getType())) {
                    X509Certificate x509cert = (X509Certificate)cert;
                    System.out.println("\ncertificate subject = " + x509cert.getSubjectDN());
                    if (x509cert.getSigAlgParams() != null) {
                        System.out.println("\tparameters: " + Arrays.asList(new byte[][]{x509cert.getSigAlgParams()}));
                    }
                } else {
                    System.out.println("\tUnrecognized certificate type: " + cert.getType());
                }
                PublicKey pk = cert.getPublicKey();
                String keyInfo = SSLTest.getPublicKeyAlgInfo(pk);
                System.out.println("\tPK algorithm: " + keyInfo);
                System.out.println("\tImplementing PK class: " + pk.getClass());
                ++n2;
            }
        }
        catch (SSLPeerUnverifiedException e) {
            e.printStackTrace();
        }
        System.err.println("\n======== END HANDSHAKE EVENT INFO ========\n");
    }

    public static String getPublicKeyAlgInfo(PublicKey pk) {
        int keysize = 0;
        String algorithm = pk.getAlgorithm();
        String format = pk.getFormat();
        String encoding = "";
        if (pk instanceof RSAPublicKey) {
            RSAPublicKey rsaPk = (RSAPublicKey)pk;
            keysize = (rsaPk.getModulus().toByteArray().length - 1) * 8;
            encoding = String.valueOf(encoding) + Arrays.asList(new byte[][]{rsaPk.getEncoded()});
        }
        if (pk instanceof JCEECPublicKey) {
            algorithm = "ECDSA";
            JCEECPublicKey ecPk = (JCEECPublicKey)pk;
            keysize = ecPk.getQ().getXCoord().getFieldSize();
            encoding = String.valueOf(encoding) + Arrays.asList(new byte[][]{ecPk.getEncoded()});
        }
        if (pk instanceof JDKDSAPublicKey) {
            JDKDSAPublicKey dsaPk = (JDKDSAPublicKey)pk;
            keysize = dsaPk.getY().bitLength();
            encoding = String.valueOf(encoding) + Arrays.asList(new byte[][]{dsaPk.getEncoded()});
        }
        return String.valueOf(algorithm) + ", size = " + (keysize == 0 ? "unknown" : String.valueOf(keysize) + "bits") + ", format = " + format + ", encoding = " + (encoding.isEmpty() ? "unkown" : encoding);
    }

    public static void listCurves(PrintStream out) {
        Provider[] ecProviders = Security.getProviders("AlgorithmParameters.EC");
        if (ecProviders != null) {
            Provider[] providerArray = ecProviders;
            int n = ecProviders.length;
            int n2 = 0;
            while (n2 < n) {
                Provider provider = providerArray[n2];
                out.println("Provider: " + provider);
                String list = provider.getService("AlgorithmParameters", "EC").getAttribute("SupportedCurves");
                TreeMap<String, String> sorted = new TreeMap<String, String>();
                String[] stringArray = list.split("\\|");
                int n3 = stringArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    String curve = stringArray[n4];
                    sorted.put(curve.toLowerCase(), curve);
                    ++n4;
                }
                for (String curve : sorted.values()) {
                    out.println(curve);
                }
                ++n2;
            }
        }
    }

    private static SSLSocket createSSLSocket(InetSocketAddress address, String host, int port, int readTimeout, int connectTimeout, SSLSocketFactory sf) throws IOException {
        Socket sock = new Socket();
        sock.setSoTimeout(readTimeout);
        sock.connect(address, connectTimeout);
        return (SSLSocket)sf.createSocket(sock, host, port, true);
    }

    private static String[] getJVMSupportedCipherSuites(String protocol, SecureRandom rand) throws NoSuchAlgorithmException, KeyManagementException {
        SSLContext sc = SSLContext.getInstance(protocol);
        sc.init(null, null, rand);
        return sc.getSocketFactory().getSupportedCipherSuites();
    }

    private static String[] getJVMDefaultCipherSuites(String protocol, SecureRandom rand) throws NoSuchAlgorithmException, KeyManagementException {
        SSLContext sc = SSLContext.getInstance(protocol);
        sc.init(null, null, rand);
        return sc.getSocketFactory().getDefaultCipherSuites();
    }

    static boolean checkTrust(X509Certificate[] chain, TrustManager[] trustManagers) {
        if (trustManagers == null) {
            return false;
        }
        if (1 == trustManagers.length && trustManagers[0] instanceof SSLUtils.TrustAllTrustManager) {
            System.out.println("NOTE: Certificate chain will be trusted because all certificates are trusted");
        }
        TrustManager[] trustManagerArray = trustManagers;
        int n = trustManagers.length;
        int n2 = 0;
        while (n2 < n) {
            TrustManager tm = trustManagerArray[n2];
            if (tm instanceof X509TrustManager) {
                try {
                    ((X509TrustManager)tm).checkServerTrusted(chain, "RSA");
                    return true;
                }
                catch (CertificateException certificateException) {
                    return false;
                }
            }
            ++n2;
        }
        return false;
    }

    public static boolean isSelfSigned(X509Certificate cert) {
        try {
            PublicKey key = cert.getPublicKey();
            cert.verify(key);
            return true;
        }
        catch (SignatureException signatureException) {
            return false;
        }
        catch (InvalidKeyException invalidKeyException) {
            return false;
        }
        catch (CertificateException e) {
            System.out.println("\texception occurred while checking for self-signed certificate, message = " + e.getMessage());
            return false;
        }
        catch (NoSuchAlgorithmException e) {
            System.out.println("\texception occurred while checking for self-signed certificate, message = " + e.getMessage());
            return false;
        }
        catch (NoSuchProviderException e) {
            System.out.println("\texception occurred while checking for self-signed certificate, message = " + e.getMessage());
            return false;
        }
    }

    static void dumpCertificate(X509Certificate cert) throws GeneralSecurityException {
        System.out.print("\tSubject: ");
        System.out.println(cert.getSubjectDN());
        Collection<List<?>> altNames = cert.getSubjectAlternativeNames();
        if (altNames != null && !altNames.isEmpty()) {
            System.out.print("\tSubject Alternative Names (SANs): ");
            boolean needsComma = false;
            for (List<?> sanList : altNames) {
                if (sanList == null || sanList.isEmpty() || sanList.size() <= 1) continue;
                if (needsComma) {
                    System.out.print(", ");
                } else {
                    needsComma = true;
                }
                Object thing = sanList.get(1);
                if (thing instanceof String) {
                    System.out.print(thing);
                    continue;
                }
                System.out.print("[binary]");
            }
            System.out.println();
        }
        System.out.print("\tIssuer: ");
        System.out.println(cert.getIssuerDN());
        System.out.print("\tSignature Algorithm: ");
        System.out.println(cert.getSigAlgName());
        System.out.print("\tSHA-256 Fingerprint: ");
        MessageDigest md = MessageDigest.getInstance("SHA-256");
        byte[] sig = md.digest(cert.getEncoded());
        System.out.println(SSLTest.toHexString(sig, ":"));
        System.out.println("\tValid from " + cert.getNotBefore() + " until " + cert.getNotAfter());
        Date now = new Date();
        System.out.println("\tCurrently valid: " + (cert.getNotBefore().before(now) && cert.getNotAfter().after(now)));
        System.out.println("\tSelf-signed: " + SSLTest.isSelfSigned(cert));
    }

    static String getCertificateType(X509Certificate cert) {
        PublicKey pubKey = cert.getPublicKey();
        if (pubKey instanceof RSAPublicKey) {
            return String.valueOf(((RSAPublicKey)pubKey).getModulus().bitLength()) + "-bit RSA";
        }
        if (pubKey instanceof ECPublicKey) {
            ECParameterSpec params = ((ECPublicKey)pubKey).getParams();
            if (params != null) {
                return String.valueOf(params.getOrder().bitLength()) + "-bit Elliptic-curve";
            }
            return "Unknown strength Elliptic-curve";
        }
        if (pubKey instanceof DSAPublicKey) {
            DSAParams params = ((DSAPublicKey)pubKey).getParams();
            if (params != null) {
                return String.valueOf(params.getP().bitLength()) + "-bit DSA";
            }
            return String.valueOf(((DSAPublicKey)pubKey).getY().bitLength()) + "-bit DSA";
        }
        return "Other X.509 key, class=" + pubKey.getClass().getName();
    }

    static boolean writePemFile(X509Certificate x509Cert, String fileName) {
        try {
            PemFile pemFile = new PemFile(x509Cert, "CERTIFICATE");
            pemFile.write(fileName);
            return true;
        }
        catch (Exception e) {
            System.out.println("exception occurred while saving certificate (PEM format): '" + fileName + "', reason = " + e.getMessage());
            e.printStackTrace();
            return false;
        }
    }

    static void createSshKeyFiles(String keysType, String keysPath) {
        try {
            String type = keysType;
            File keysFile = new File(keysPath, "id_" + type);
            SshKeyUtils.createKeyPairAndPersist(type, 2048, keysFile, "Remain SSH", "");
            System.out.println("created SSH key files:" + keysFile.getAbsolutePath());
        }
        catch (Exception e) {
            System.err.println("exception occured on create of SSH key files: message = " + e.getMessage());
            e.printStackTrace();
        }
    }

    static void createBouncyCastleKeyFiles(String keysPath) {
        Security.addProvider((Provider)new BouncyCastleProvider());
        try {
            KeyPair keyPair = SSLTest.generateBouncyCastleRSAKeyPair(1024);
            PrivateKey priv = keyPair.getPrivate();
            PublicKey pub = keyPair.getPublic();
            File privKeyFile = new File(keysPath, "id_rsa");
            PemObject pemObject = new PemObject("RSA PRIVATE KEY", priv.getEncoded());
            try (PemWriter pemWriter = new PemWriter((Writer)new OutputStreamWriter(new FileOutputStream(privKeyFile)));){
                pemWriter.writeObject((PemObjectGenerator)pemObject);
                System.out.println("created private RSA key file:" + privKeyFile.getAbsolutePath());
            }
            File pubKeyFile = new File(keysPath, "id_rsa.pub");
            pemObject = new PemObject("RSA PUBLIC KEY", pub.getEncoded());
            pemWriter = new PemWriter((Writer)new OutputStreamWriter(new FileOutputStream(pubKeyFile)));
            try {
                pemWriter.writeObject((PemObjectGenerator)pemObject);
                System.out.println("created public RSA key file:" + pubKeyFile.getAbsolutePath());
            }
            finally {
                pemWriter.close();
            }
        }
        catch (Exception e) {
            System.err.println("exception occured on create of RSA key files: message = " + e.getMessage());
            e.printStackTrace();
        }
    }

    private static KeyPair generateBouncyCastleRSAKeyPair(int keySize) throws NoSuchAlgorithmException, NoSuchProviderException {
        KeyPairGenerator generator = KeyPairGenerator.getInstance("RSA", "BC");
        generator.initialize(keySize);
        KeyPair keyPair = generator.generateKeyPair();
        return keyPair;
    }

    static String toHexString(byte[] bytes, String separator) {
        StringBuilder sb = new StringBuilder(bytes.length * 2);
        boolean first = true;
        byte[] byArray = bytes;
        int n = bytes.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            if (first) {
                first = false;
            } else if (separator != null) {
                sb.append(separator);
            }
            sb.append(hexChars[b >> 4 & 0xF]).append(hexChars[b & 0xF]);
            ++n2;
        }
        return sb.toString();
    }

    static void doSSLv2() {
    }

    private static /* synthetic */ void lambda$0(HandshakeCompletedEvent evt) {
    }
}

