/*
 * Decompiled with CFR 0.152.
 */
package com.remainsoftware.common.ssl;

import com.remainsoftware.common.util.Validate;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.util.Base64;

public class JreKeyGenPem {
    private static Base64.Encoder encoder = Base64.getEncoder();

    public static void createKeys(String algo, int keySize, String outFile) throws Exception {
        Validate.isNotEmpty((String)algo);
        Validate.isPositive((int)keySize);
        Validate.isNotEmpty((String)outFile);
        KeyPairGenerator kpg = KeyPairGenerator.getInstance(algo);
        kpg.initialize(keySize);
        KeyPair kp = kpg.generateKeyPair();
        try (FileWriter out = null;){
            out = new FileWriter(outFile);
            out.write("-----BEGIN RSA PRIVATE KEY-----\n");
            JreKeyGenPem.writeBase64(out, kp.getPrivate());
            out.write("-----END RSA PRIVATE KEY-----\n");
            if (outFile != null) {
                ((Writer)out).close();
                out = new FileWriter(String.valueOf(outFile) + ".pub");
            }
            out.write("-----BEGIN RSA PUBLIC KEY-----\n");
            JreKeyGenPem.writeBase64(out, kp.getPublic());
            out.write("-----END RSA PUBLIC KEY-----\n");
        }
    }

    private static void writeBase64(Writer out, Key key) throws IOException {
        byte[] buf = key.getEncoded();
        out.write(encoder.encodeToString(buf));
        out.write("\n");
    }
}

