/*
 * Decompiled with CFR 0.152.
 */
package com.remainsoftware.common.ssl;

import com.google.common.net.InternetDomainName;
import com.ibm.misc.BASE64Encoder;
import com.myjavatools.lib.Strings;
import com.remainsoftware.common.ssl.DomainNameValidator;
import com.remainsoftware.common.ssl.KeyStoreInfo;
import com.remainsoftware.common.ssl.PemFile;
import com.remainsoftware.common.util.CommonConstants;
import com.remainsoftware.common.util.FileUtils;
import com.remainsoftware.common.util.GravityReply;
import com.remainsoftware.common.util.GravitySeverity;
import com.remainsoftware.common.util.NetUtils;
import com.remainsoftware.common.util.StringUtils;
import com.remainsoftware.common.util.Validate;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Field;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyManagementException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.PKIXParameters;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.crypto.Cipher;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.x500.AttributeTypeAndValue;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x500.style.IETFUtils;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.X509Extensions;
import org.bouncycastle.asn1.x509.X509Name;
import org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import org.bouncycastle.jce.X509Principal;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.provider.JCEECPublicKey;
import org.bouncycastle.jce.provider.JDKDSAPublicKey;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.x509.X509V3CertificateGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertificateUtils {
    private static final String IBM_JSSE2_OVERRIDE_DEFAULT_PROTOCOL = "com.ibm.jsse2.overrideDefaultProtocol";
    private static final String IBM_JSSE2_OVERRIDE_DEFAULT_TLS = "com.ibm.jsse2.overrideDefaultTLS";
    private static final String JDK_TLS_CLIENT_PROTOCOLS = "jdk.tls.client.protocols";
    private static final String HTTPS_PROTOCOLS = "https.protocols";
    public static final String O_REMAIN = "Remain";
    public static final String OU_REMAIN_SOFTWARE = "Remain Software";
    public static final String SSL = "SSL";
    public static final String SSL_LC = "ssl";
    public static final String TLS_LC = "tls";
    public static final String TLS = "TLS";
    public static final String TLSv1 = "TLSv1";
    public static final String TLSv11 = "TLSv1.1";
    public static final String TLSv12 = "TLSv1.2";
    public static final String TLSv13 = "TLSv1.3";
    public static final String DEFAULT_TLS_PROTOCOL = "TLSv1.2";
    public static final String SSL_TLSv2 = "SSL_TLSv2";
    public static final String PRV_EXTENSION = ".prv";
    public static final String PUB_EXTENSION = ".pub";
    public static final String PEM_EXTENSION = ".pem";
    public static final String CRT_EXTENSION = ".crt";
    public static final String CER_EXTENSION = ".cer";
    public static final String DER_EXTENSION = ".der";
    public static final String[] X509CERT_WILDCARD_EXTENSIONS = new String[]{"*.pem", "*.crt", "*.cer", "*.der", "*" + ".pem".toUpperCase(), "*" + ".crt".toUpperCase(), "*" + ".cer".toUpperCase(), "*" + ".der".toUpperCase()};
    public static final String JKS_PROVIDER_NAME = "JKS";
    public static final String PKCS12_PROVIDER_NAME = "PKCS12";
    public static final String JKS_EXTENSION = ".jks";
    public static final String P12_EXTENSION = ".p12";
    public static final String PFX_EXTENSION = ".pfx";
    public static final String JKS_LC = "jks";
    public static final String P12_LC = "p12";
    public static final String PFX_LC = "pfx";
    public static final String[] TRUSTSTORE_WILDCARD_EXTENSIONS = new String[]{"*.jks", "*.p12", "*.pfx", ".jks".toUpperCase(), "*" + ".p12".toUpperCase(), "*" + ".pfx".toUpperCase()};
    public static final String PEM_CERTIFICATE = "CERTIFICATE";
    public static final String PEM_PRIVATE_KEY = "PRIVATE KEY";
    public static final String PEM_PUBLIC_KEY = "PUBLIC KEY";
    public static final Integer SESSION_TRUSTED_HOST = 0;
    public static final Integer CERTIFICATE_TRUSTED_HOST = 1;
    public static final String LIB_SECURITY_CACERTS = "/lib/security/cacerts";
    public static final String CERTIFICATES_SUBDIR_NAME = "certificates";
    public static final String DEFAULT_CERTIFICATES_PATH = ".remain/certificates";
    public static final String PROPERTY_CERTIFICATES_PATH = "ssl.certificates.path";
    public static final String SSL_ADDITIONAL_TRUST_STORE = "ssl.trust.store";
    public static final String SSL_HOSTNAME_MISMATCH = "SSL hostname mismatch";
    public static final String CERTIFICATE_ERROR = "Certificate error;";
    public static final String HTTPS_HOSTNAME_WRONG = "HTTPS hostname wrong";
    public static final String VALIDATION_FAILED_FOR_CERTIFICATE = "Certificate error; validation failed for SSL certificate";
    public static final String HOST_CERTIFICATE_REJECTED = "Certificate error; host SSL certificate rejected";
    public static final String FAILED_PROCESSING_HOST_CERTIFICATE = "Certificate error; failed processing host SSL certificate";
    public static final String PROPERTY_SSL_TRUSTED_HOSTS = "ssl.trusted.hosts";
    public static final String SSL_DEFAULT_PROTOCOL_VERSION = "ssl.default.protocol.version";
    public static final String SSL_ALLOW_WEAK_CERT_KEY_LENGTHS = "ssl.allow.weak.certificate.key.lengths";
    public static final String SSL_ALLOW_EXPIRED_CERTIFICATE = "ssl.allow.expired.certificate";
    public static final String SSL_ALLOW_WEAK_PROTOCOLS = "ssl.allow.weak.protocols";
    private static final int SUBALTNAME_OTHERNAME = 0;
    private static final int SUBALTNAME_RFC822NAME = 1;
    private static final int SUBALTNAME_DNSNAME = 2;
    private static final int SUBALTNAME_X400ADDRESS = 3;
    private static final int SUBALTNAME_DIRECTORYNAME = 4;
    private static final int SUBALTNAME_EDIPARTYNAME = 5;
    private static final int SUBALTNAME_URI = 6;
    private static final int SUBALTNAME_IPADDRESS = 7;
    private static final int SUBALTNAME_REGISTREDID = 8;
    public static final String[] sslAllProtocols = new String[]{"SSLv2Hello", "SSLv3", "TLSv1", "TLSv1.1", "TLSv1.2", "TLSv1.3"};
    public static final List<String> allSslProtocolsList = Arrays.asList(sslAllProtocols);
    public static final String[] sslWeakProtocols = new String[]{"SSLv2Hello", "SSLv3", "TLSv1"};
    public static final List<String> sslWeakProtocolsList = Arrays.asList(sslWeakProtocols);
    public static final String[] defaultSupportedSslProtocols = new String[]{"TLSv1.1", "TLSv1.2", "TLSv1.2"};
    public static final List<String> defaultSupportedProtocolsList = Arrays.asList(defaultSupportedSslProtocols);
    public static String defaultSupportedSslProtocolsString = String.join((CharSequence)",", defaultSupportedSslProtocols);
    public static final String[] allTlsProtocols = new String[]{"TLSv1", "TLSv1.1", "TLSv1.2", "TLSv1.3"};
    public static final List<String> allTlsProtocolsList = Arrays.asList(allTlsProtocols);
    public static final String[] sslWeakCiphers = new String[]{"SSL_RSA_EXPORT_WITH_RC4_40_MD5", "SSL_RSA_EXPORT_WITH_DES40_CBC_SHA", "SSL_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA", "SSL_RSA_WITH_DES_CBC_SHA", "SSL_DHE_RSA_WITH_DES_CBC_SHA", "TLS_DHE_RSA_WITH_AES_128_CBC_SHA", "SSL_DHE_RSA_WITH_3DES_EDE_CBC_SHA", "TLS_DHE_RSA_WITH_AES_256_CBC_SHA", "TLS_DHE_RSA_WITH_AES_128_CBC_SHA256", ".*NULL.*", ".*RC4.*", ".*MD5.*", ".*DES.*", ".*DSS.*"};
    public static final String[] jsseDefaultDisabledCiphers = new String[]{"TLS_DH_anon_WITH_AES_256_CBC_SHA256", "TLS_ECDH_anon_WITH_AES_256_CBC_SHA", "TLS_DH_anon_WITH_AES_256_CBC_SHA", "TLS_DH_anon_WITH_AES_128_CBC_SHA256", "TLS_ECDH_anon_WITH_AES_128_CBC_SHA", "TLS_DH_anon_WITH_AES_128_CBC_SHA", "TLS_ECDH_anon_WITH_RC4_128_SHA", "SSL_DH_anon_WITH_RC4_128_MD5", "TLS_ECDH_anon_WITH_3DES_EDE_CBC_SHA", "SSL_DH_anon_WITH_3DES_EDE_CBC_SHA", "TLS_RSA_WITH_NULL_SHA256", "TLS_ECDHE_ECDSA_WITH_NULL_SHA", "TLS_ECDHE_RSA_WITH_NULL_SHA", "SSL_RSA_WITH_NULL_SHA", "TLS_ECDH_ECDSA_WITH_NULL_SHA", "TLS_ECDH_RSA_WITH_NULL_SHA", "TLS_ECDH_anon_WITH_NULL_SHA", "SSL_RSA_WITH_NULL_MD5", "SSL_RSA_WITH_DES_CBC_SHA", "SSL_DHE_RSA_WITH_DES_CBC_SHA", "SSL_DHE_DSS_WITH_DES_CBC_SHA", "SSL_RSA_EXPORT_WITH_RC4_40_MD5", "SSL_DH_anon_EXPORT_WITH_RC4_40_MD5", "SSL_RSA_EXPORT_WITH_DES40_CBC_SHA", "SSL_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA", "SSL_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA", "SSL_DH_anon_EXPORT_WITH_DES40_CBC_SHA", "TLS_DHE_DSS_WITH_AES_128_CBC_SHA", "TLS_KRB5_WITH_RC4_128_SHA", "TLS_KRB5_WITH_RC4_128_MD5", "TLS_KRB5_WITH_3DES_EDE_CBC_SHA", "TLS_KRB5_WITH_3DES_EDE_CBC_MD5", "TLS_KRB5_WITH_DES_CBC_SHA", "TLS_KRB5_WITH_DES_CBC_MD5", "TLS_KRB5_EXPORT_WITH_RC4_40_SHA", "TLS_KRB5_EXPORT_WITH_RC4_40_MD5", "TLS_KRB5_EXPORT_WITH_DES_CBC_40_SHA", "TLS_KRB5_EXPORT_WITH_DES_CBC_40_MD5"};
    public static final int LEASE_PERIOD_YEAR_IN_DAYS = 365;
    public static final String REMAINSOFTWARE_COM = "remainsoftware.com";
    public static final String REMAIN_NL = "remain.nl";
    private static final Logger logger = LoggerFactory.getLogger(CertificateUtils.class);
    private static final int RSA_2048_KEY_LENGTH = 2048;
    private static final int DEFAULT_RSA_KEY_LENGTH = 2048;
    private static final int MINIMUM_ASYMMETRIC_KEY_LENGTH = 2048;
    private static Map<String, Integer> trustedHosts = new HashMap<String, Integer>();
    private static Map<String, X509Certificate> trustedHostsCertificate = new HashMap<String, X509Certificate>();
    private static X509Certificate lastProcessedCertificate = null;
    private static boolean isSetupRemainSslOverride = false;
    private static String DEFAULT_SSL_CONTEXT_PROTOCOL = null;
    private static Object DEFAULT_SSL_CONTEXT_PROTOCOL_SYNC = new Object();
    private static boolean isProcessSslSettingsDone = false;
    private static boolean isNonNullConfigSslProtocolProvided = false;
    private static Map<String, File> certificateFiles = new HashMap<String, File>();
    private static final String componentUUID = "f2dsfb1d-9e7a-4c9f-984e-ee5sdfa68d60";

    static {
        Security.setProperty("crypto.policy", "unlimited");
        try {
            logger.info(String.format("Cipher; AES max allowed key length: %d", Cipher.getMaxAllowedKeyLength("AES")));
            logger.info(String.format("Cipher; RSA max allowed key length: %d", Cipher.getMaxAllowedKeyLength("RSA")));
        }
        catch (Exception e) {
            logger.error(StringUtils.extractMessage((Exception)e), (Throwable)e);
        }
        CertificateUtils.addBCProvider();
    }

    private CertificateUtils() {
    }

    public static void addBCProvider() {
        if (Security.getProvider("BC") == null) {
            logger.info("BouncyCastle; adding security provider to the JVM runtime");
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void processSslSettings(String sslProtocol) {
        Object object = DEFAULT_SSL_CONTEXT_PROTOCOL_SYNC;
        synchronized (object) {
            String msg = "processSslSettings; ssl-protocols: '" + (sslProtocol == null ? "*notset" : sslProtocol) + "'";
            logger.info(msg);
            if (!isNonNullConfigSslProtocolProvided && !StringUtils.isEmpty((String)sslProtocol)) {
                isProcessSslSettingsDone = false;
            }
            if (!isProcessSslSettingsDone) {
                isProcessSslSettingsDone = true;
                String javaHttpsTlsProtocols = System.getProperty(HTTPS_PROTOCOLS);
                String jdkTlsProtocols = System.getProperty(JDK_TLS_CLIENT_PROTOCOLS);
                String ibmOverrideDefaultTls = System.getProperty(IBM_JSSE2_OVERRIDE_DEFAULT_TLS);
                String propertySSLProtocol = System.getProperty(SSL_DEFAULT_PROTOCOL_VERSION);
                String configSslProtocol = sslProtocol = sslProtocol == null ? "" : sslProtocol;
                if (StringUtils.isEmpty((String)configSslProtocol)) {
                    configSslProtocol = defaultSupportedSslProtocolsString;
                } else {
                    if (sslProtocol.equals(SSL_TLSv2)) {
                        configSslProtocol = String.join((CharSequence)",", allTlsProtocols);
                    }
                    isNonNullConfigSslProtocolProvided = true;
                }
                configSslProtocol = configSslProtocol.replace(" ", "");
                if (StringUtils.isEmpty((String)propertySSLProtocol)) {
                    propertySSLProtocol = configSslProtocol;
                    System.setProperty(SSL_DEFAULT_PROTOCOL_VERSION, propertySSLProtocol);
                    msg = "set java property: ssl.default.protocol.version=" + propertySSLProtocol;
                    logger.info(msg);
                }
                if (StringUtils.isEmpty((String)jdkTlsProtocols)) {
                    jdkTlsProtocols = configSslProtocol;
                    System.setProperty(JDK_TLS_CLIENT_PROTOCOLS, jdkTlsProtocols);
                    logger.info(String.format("override set for TLS protocol on java property: %s=%s", JDK_TLS_CLIENT_PROTOCOLS, jdkTlsProtocols));
                    if (StringUtils.isEmpty((String)javaHttpsTlsProtocols)) {
                        javaHttpsTlsProtocols = configSslProtocol;
                        System.setProperty(HTTPS_PROTOCOLS, javaHttpsTlsProtocols);
                        msg = "override set for TLS protocol on java property: https.protocols=" + javaHttpsTlsProtocols;
                        logger.info(msg);
                    }
                } else {
                    jdkTlsProtocols = jdkTlsProtocols.replace(" ", "");
                    msg = "java property: jdk.tls.client.protocols=" + jdkTlsProtocols;
                    logger.info(msg);
                    if (StringUtils.isEmpty((String)javaHttpsTlsProtocols)) {
                        System.setProperty(HTTPS_PROTOCOLS, jdkTlsProtocols);
                    }
                }
                if (sslProtocol != null && sslProtocol.equals(SSL_TLSv2)) {
                    System.setProperty(IBM_JSSE2_OVERRIDE_DEFAULT_PROTOCOL, sslProtocol);
                    logger.info(String.format("override set for TLS protocol on java property: %s=%s", IBM_JSSE2_OVERRIDE_DEFAULT_PROTOCOL, sslProtocol));
                } else {
                    String highestTlsProt = CertificateUtils.getLastInListTlsProtocol(jdkTlsProtocols, JDK_TLS_CLIENT_PROTOCOLS);
                    if (StringUtils.isEmpty((String)ibmOverrideDefaultTls) && highestTlsProt != null && defaultSupportedProtocolsList.contains(highestTlsProt)) {
                        System.setProperty(IBM_JSSE2_OVERRIDE_DEFAULT_TLS, "true");
                        msg = "override set for TLS protocol on java property: com.ibm.jsse2.overrideDefaultTLS=true";
                        logger.info(msg);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getDefaultSSLContextProtocol() {
        Object object = DEFAULT_SSL_CONTEXT_PROTOCOL_SYNC;
        synchronized (object) {
            if (DEFAULT_SSL_CONTEXT_PROTOCOL == null) {
                String sslProtocol = CertificateUtils.getLastInListTlsProtocol(System.getProperty(SSL_DEFAULT_PROTOCOL_VERSION), SSL_DEFAULT_PROTOCOL_VERSION);
                if (StringUtils.isEmpty((String)sslProtocol)) {
                    sslProtocol = CertificateUtils.getLastInListTlsProtocol(System.getProperty(JDK_TLS_CLIENT_PROTOCOLS), JDK_TLS_CLIENT_PROTOCOLS);
                    if (StringUtils.isEmpty((String)sslProtocol)) {
                        sslProtocol = "TLSv1.2";
                    } else if (!allSslProtocolsList.contains(sslProtocol)) {
                        logger.warn(String.format("failed validation for provided SSL/TLS protocol: '%s', check the following configuration property: %s=%s', action = returning value %s", sslProtocol, SSL_DEFAULT_PROTOCOL_VERSION, sslProtocol, "TLSv1.2"));
                        sslProtocol = "TLSv1.2";
                    }
                } else if (!allSslProtocolsList.contains(sslProtocol)) {
                    logger.warn(String.format("failed validation for provided SSL/TLS protocol: '%s', check the following configuration property: %s=%s', action = returning value %s", sslProtocol, JDK_TLS_CLIENT_PROTOCOLS, sslProtocol, "TLSv1.2"));
                    sslProtocol = "TLSv1.2";
                }
                DEFAULT_SSL_CONTEXT_PROTOCOL = sslProtocol;
                logger.info(String.format("default SSL Context protocol set to: '%s'", sslProtocol));
            }
            return DEFAULT_SSL_CONTEXT_PROTOCOL;
        }
    }

    public static String[] getSupportedSSLProtocols() {
        String sslProtocols = System.getProperty(SSL_DEFAULT_PROTOCOL_VERSION);
        if (StringUtils.isEmpty((String)sslProtocols) && StringUtils.isEmpty((String)(sslProtocols = System.getProperty(JDK_TLS_CLIENT_PROTOCOLS)))) {
            return defaultSupportedSslProtocols;
        }
        sslProtocols = sslProtocols.replace(" ", "");
        return sslProtocols.trim().split(",");
    }

    private static String getLastInListTlsProtocol(String tlsProtocols, String listName) {
        if (!StringUtils.isEmpty((String)tlsProtocols)) {
            String[] protocols = tlsProtocols.split(",");
            String tlsProt = protocols[protocols.length - 1].trim();
            if (allTlsProtocolsList.contains(tlsProt)) {
                logger.debug(String.format("determined TLS protocol: '%s' as last in the list (%s): '%s'", tlsProt, listName, tlsProtocols));
                return tlsProt;
            }
            logger.warn(String.format("failed validation for the TLS protocol: '%s in the list (%s): '%s'", tlsProt, listName, tlsProtocols));
        }
        return null;
    }

    public static String getValidatedAppSSLContextProtocol(String sslProtocol, String fromProperty, boolean allowWeak) {
        if (StringUtils.isEmpty((String)sslProtocol)) {
            return CertificateUtils.getDefaultdAppSSLContextProtocol();
        }
        if (StringUtils.isEmpty((String)fromProperty)) {
            fromProperty = "*notset";
        }
        if (!allowWeak && (sslProtocol.equals(SSL) || sslWeakProtocolsList.contains(sslProtocol))) {
            logger.warn(String.format("failed validation for provided SSL/TLS protocol: '%s, rejected as too weak (configuration/property: %s=%s), action = returning value %s", sslProtocol, fromProperty, sslProtocol, CertificateUtils.getDefaultdAppSSLContextProtocol()));
            sslProtocol = CertificateUtils.getDefaultdAppSSLContextProtocol();
        } else if (!(sslProtocol.equals(SSL) || sslProtocol.equals(TLS) || allSslProtocolsList.contains(sslProtocol))) {
            logger.warn(String.format("failed validation for provided SSL Context protocol: '%s, not a known protocol, check the following configuration/property: %s=%s, action = returning value %s", sslProtocol, fromProperty, sslProtocol, CertificateUtils.getDefaultdAppSSLContextProtocol()));
            sslProtocol = CertificateUtils.getDefaultdAppSSLContextProtocol();
        }
        return sslProtocol;
    }

    public static String getDefaultdAppSSLContextProtocol() {
        return TLS;
    }

    public static KeyPair createRSA2048SHA1KeyPair() {
        try {
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
            SecureRandom random = SecureRandom.getInstance("SHA1PRNG");
            keyPairGenerator.initialize(2048, random);
            KeyPair keyPair = keyPairGenerator.generateKeyPair();
            return keyPair;
        }
        catch (Throwable e) {
            logger.error("exception occurred while creating RSA key pair, message = " + e.getMessage(), e);
            return null;
        }
    }

    public static KeyPair createRSA2048RNDStrongKeyPair() {
        try {
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
            SecureRandom random = SecureRandom.getInstanceStrong();
            keyPairGenerator.initialize(2048, random);
            KeyPair keyPair = keyPairGenerator.generateKeyPair();
            return keyPair;
        }
        catch (Throwable e) {
            logger.error("exception occurred while creating RSA key pair, message = " + e.getMessage(), e);
            return null;
        }
    }

    public static boolean saveKey(Key key, File file) {
        Validate.isNotNull((Object)key, (String)"key must be set");
        Validate.isNotNull((Object)file, (String)"file-name must be set");
        return CertificateUtils.saveKey(key, file.getAbsolutePath());
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean saveKey(Key key, String fileName) {
        Validate.isNotNull((Object)key, (String)"key must be set");
        Validate.isNotEmpty((String)fileName, (String)"file-name must be set");
        File saveFile = new File(fileName);
        File parentPath = saveFile.getParentFile();
        if (parentPath != null && !parentPath.exists()) {
            parentPath.mkdirs();
        }
        FileOutputStream os = null;
        byte[] encoded = key.getEncoded();
        os = new FileOutputStream(saveFile);
        os.write(encoded);
        os.flush();
        if (os == null) return true;
        try {
            os.close();
            return true;
        }
        catch (IOException iOException) {}
        return true;
        catch (Exception e) {
            try {
                logger.error("exception occurred while saving key to file: '" + fileName + "', message = " + e.getMessage(), (Throwable)e);
                if (os == null) return false;
            }
            catch (Throwable throwable) {
                if (os == null) throw throwable;
                try {
                    os.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                os.close();
                return false;
            }
            catch (IOException iOException) {}
            return false;
        }
    }

    public static X509Certificate createSelfSignedCertificate(String commonName, String organization, String organizationalUnit, String country, KeyPair keyPair, int daysValid, String subjectAltName) {
        Validate.isNotEmpty((String)commonName, (String)"common-name must be set");
        Validate.isNotNull((Object)keyPair, (String)"key-pair must be set");
        Validate.isPositive((int)daysValid, (String)"days-valid must be > 0");
        if (daysValid > 7300) {
            daysValid = 7300;
        }
        try {
            X509V3CertificateGenerator v3CertGen = new X509V3CertificateGenerator();
            v3CertGen.setSerialNumber(BigInteger.valueOf(System.nanoTime()).shiftLeft(4).add(BigInteger.valueOf((long)Math.rint(Math.random() * 1000.0))));
            if (StringUtils.isEmpty((String)organization)) {
                organization = "";
            }
            if (StringUtils.isEmpty((String)organizationalUnit)) {
                organizationalUnit = "";
            }
            if (StringUtils.isEmpty((String)country)) {
                country = "";
            }
            v3CertGen.setIssuerDN((X509Name)new X509Principal("CN=" + commonName + ", O=" + organization + ", OU=" + organizationalUnit + ", L=, ST=, C=" + country));
            Calendar start = Calendar.getInstance();
            start.add(5, -1);
            v3CertGen.setNotBefore(start.getTime());
            Calendar retire = Calendar.getInstance();
            retire.add(5, daysValid);
            v3CertGen.setNotAfter(retire.getTime());
            v3CertGen.setSubjectDN((X509Name)new X509Principal("CN=" + commonName + ", O=" + organization + ", OU=" + organizationalUnit + ", L=None, C=None"));
            if (!StringUtils.isEmpty((String)subjectAltName)) {
                GeneralNames sans = null;
                sans = NetUtils.isIPAddress((String)subjectAltName) ? new GeneralNames(new GeneralName(7, subjectAltName)) : new GeneralNames(new GeneralName(2, subjectAltName));
                v3CertGen.addExtension(X509Extensions.SubjectAlternativeName, false, (ASN1Encodable)sans);
            }
            v3CertGen.setPublicKey(keyPair.getPublic());
            v3CertGen.setSignatureAlgorithm("SHA256withRSAEncryption");
            X509Certificate pKCertificate = v3CertGen.generate(keyPair.getPrivate());
            pKCertificate.verify(pKCertificate.getPublicKey());
            return pKCertificate;
        }
        catch (Exception e) {
            logger.error("exception occurred while creating or validating X509 certificate, message = " + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean createJavaKeyStore(X509Certificate pKCertificate, KeyPair keyPair, String keyAlias, File keyStoreFilePath, String keyStorePassword) {
        Validate.isNotNull((Object)pKCertificate, (String)"X509Certificate must be set");
        Validate.isNotNull((Object)keyPair, (String)"key-pair must be set");
        Validate.isNotEmpty((String)keyAlias, (String)"key-alias must be set");
        Validate.isNotNull((Object)keyStoreFilePath, (String)"keystore-file-path must be set");
        Validate.isNotNull((Object)keyStorePassword, (String)"keystore-password must be set");
        FileOutputStream os = null;
        KeyStore privateKS = KeyStore.getInstance(JKS_PROVIDER_NAME);
        privateKS.load(null, keyStorePassword.toCharArray());
        privateKS.setKeyEntry(keyAlias, keyPair.getPrivate(), keyStorePassword.toCharArray(), new Certificate[]{pKCertificate});
        os = new FileOutputStream(keyStoreFilePath);
        privateKS.store(os, keyStorePassword.toCharArray());
        os.flush();
        if (os == null) return true;
        try {
            os.close();
            return true;
        }
        catch (IOException iOException) {}
        return true;
        catch (Exception e) {
            try {
                logger.error("exception occurred while creating or saving the java keystore (" + keyStoreFilePath.getAbsolutePath() + "), message = " + StringUtils.extractMessage((Exception)e), (Throwable)e);
                if (os == null) return false;
            }
            catch (Throwable throwable) {
                if (os == null) throw throwable;
                try {
                    os.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                os.close();
                return false;
            }
            catch (IOException iOException) {}
            return false;
        }
    }

    public static X509Certificate createX509CertificateFromFile(File file) throws Exception {
        X509Certificate x509Certificate;
        block7: {
            Validate.isNotNull((Object)file, (String)"file must be set");
            FileInputStream is = null;
            try {
                X509Certificate x509Cert;
                CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
                is = new FileInputStream(file);
                x509Certificate = x509Cert = (X509Certificate)certFactory.generateCertificate(is);
                if (is == null) break block7;
            }
            catch (Throwable throwable) {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            try {
                is.close();
            }
            catch (IOException iOException) {}
        }
        return x509Certificate;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static X509Certificate createCertificateFromPemFile(File fileName) {
        PEMParser reader;
        block12: {
            Validate.isNotNull((Object)fileName, (String)"file-name must be set");
            reader = null;
            reader = new PEMParser((Reader)new FileReader(fileName));
            Object pemObject = reader.readObject();
            if (!(pemObject instanceof X509Certificate)) break block12;
            X509Certificate x509Certificate = (X509Certificate)pemObject;
            if (reader == null) return x509Certificate;
            try {
                reader.close();
                return x509Certificate;
            }
            catch (IOException iOException) {}
            return x509Certificate;
            catch (Exception e) {
                try {
                    logger.error("exception occurred while reading certificate from file (PEM): '" + fileName + "', message = " + StringUtils.extractMessage((Exception)e), (Throwable)e);
                    if (reader == null) return null;
                }
                catch (Throwable throwable) {
                    if (reader == null) throw throwable;
                    try {
                        reader.close();
                        throw throwable;
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    reader.close();
                    return null;
                }
                catch (IOException iOException) {}
                return null;
            }
        }
        if (reader == null) return null;
        try {
            reader.close();
            return null;
        }
        catch (IOException iOException) {}
        return null;
    }

    public static KeyStoreInfo createRemainServerKeyStore(File jksFile, String jksPassword, String hostName, int days) {
        Validate.isNotEmpty((String)jksPassword, (String)"keystore-password must be set");
        Validate.isNotEmpty((String)hostName, (String)"host-name must be set");
        Validate.isPositive((int)days, (String)"years must be >= 1");
        KeyPair keyPair = CertificateUtils.createRSA2048SHA1KeyPair();
        X509Certificate x509Cert = CertificateUtils.createSelfSignedCertificate(hostName, O_REMAIN, OU_REMAIN_SOFTWARE, "NL", keyPair, days, hostName);
        if (x509Cert != null) {
            CertificateUtils.writePemFile(x509Cert, PEM_CERTIFICATE, new File(jksFile.getParentFile(), String.valueOf(hostName) + CRT_EXTENSION).getAbsolutePath());
            if (CertificateUtils.createJavaKeyStore(x509Cert, keyPair, hostName, jksFile, jksPassword)) {
                KeyStoreInfo keyStoreInfo = new KeyStoreInfo(jksFile, jksPassword);
                keyStoreInfo.setAlias(hostName);
                keyStoreInfo.setType(JKS_PROVIDER_NAME);
                return keyStoreInfo;
            }
        }
        return null;
    }

    public static boolean writeDerCertificate(X509Certificate pKCertificate, File certFilePath) {
        Validate.isNotNull((Object)pKCertificate, (String)"X509Certificate must be set");
        Validate.isNotNull((Object)certFilePath, (String)"certificate-file-path must be set");
        return CertificateUtils.writeDerCertificate(pKCertificate, certFilePath.getAbsolutePath());
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean writeDerCertificate(X509Certificate x509Cert, String fileName) {
        Validate.isNotNull((Object)x509Cert, (String)"X509Certificate must be set");
        Validate.isNotEmpty((String)fileName, (String)"certificate-file-path must be set");
        File saveFile = new File(fileName);
        File parentPath = saveFile.getParentFile();
        if (parentPath != null && !parentPath.exists()) {
            parentPath.mkdirs();
        }
        FileOutputStream fos = null;
        fos = new FileOutputStream(new File(fileName));
        fos.write(x509Cert.getEncoded());
        fos.flush();
        if (fos == null) return true;
        try {
            fos.close();
            return true;
        }
        catch (IOException iOException) {}
        return true;
        catch (Exception e) {
            try {
                logger.error("exception occurred while saving X509 certificate to file: '" + fileName + "', message = " + e.getMessage(), (Throwable)e);
                if (fos == null) return false;
            }
            catch (Throwable throwable) {
                if (fos == null) throw throwable;
                try {
                    fos.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                fos.close();
                return false;
            }
            catch (IOException iOException) {}
            return false;
        }
    }

    public static boolean writePemFile(X509Certificate x509Cert, String description, String fileName) {
        Validate.isNotNull((Object)x509Cert, (String)"X509Certificate must be set");
        Validate.isNotEmpty((String)fileName, (String)"file-name must be set");
        try {
            PemFile pemFile = new PemFile(x509Cert, description);
            pemFile.write(fileName);
            return true;
        }
        catch (Exception e) {
            logger.error("exception occurred while saving certificate (PEM format): '" + fileName + "', reason = " + StringUtils.extractMessage((Exception)e), (Throwable)e);
            return false;
        }
    }

    public static void writePemFile(Key key, String description, String fileName) throws IOException {
        Validate.isNotNull((Object)key, (String)"key from KeyPair must be set");
        Validate.isNotEmpty((String)fileName, (String)"file-name must be set");
        PemFile pemFile = new PemFile(key, description == null ? "" : description);
        pemFile.write(fileName);
    }

    public static X509Certificate[] getKeyStoreCertificates(KeyStore keyStore) throws KeyStoreException {
        Validate.isNotNull((Object)keyStore, (String)"KeyStore must be set");
        ArrayList<X509Certificate> x509Certs = new ArrayList<X509Certificate>(keyStore.size());
        Enumeration<String> alias = keyStore.aliases();
        while (alias.hasMoreElements()) {
            x509Certs.add((X509Certificate)keyStore.getCertificate(alias.nextElement()));
        }
        return x509Certs.toArray(new X509Certificate[x509Certs.size()]);
    }

    public static boolean isExpiredCertificate(X509Certificate x509Cert) {
        Validate.isNotNull((Object)x509Cert, (String)"X509Certificate must be set");
        return new Date().after(x509Cert.getNotAfter());
    }

    public static boolean isTooEarlyCertificate(X509Certificate x509Cert) {
        Validate.isNotNull((Object)x509Cert, (String)"X509Certificate must be set");
        return new Date().before(x509Cert.getNotBefore());
    }

    public static boolean isSelfSigned(X509Certificate cert) {
        try {
            PublicKey key = cert.getPublicKey();
            cert.verify(key);
            return true;
        }
        catch (SignatureException signatureException) {
            return false;
        }
        catch (InvalidKeyException invalidKeyException) {
            return false;
        }
        catch (CertificateException e) {
            logger.error("exception occurred while checking for self-signed certificate, message = " + StringUtils.extractMessage((Exception)e), (Throwable)e);
            return false;
        }
        catch (NoSuchAlgorithmException e) {
            logger.error("exception occurred while checking for self-signed certificate, message = " + StringUtils.extractMessage((Exception)e), (Throwable)e);
            return false;
        }
        catch (NoSuchProviderException e) {
            logger.error("exception occurred while checking for self-signed certificate, message = " + StringUtils.extractMessage((Exception)e), (Throwable)e);
            return false;
        }
    }

    public static String getCertificateIssuerDN(X509Certificate x509Cert) {
        Validate.isNotNull((Object)x509Cert, (String)"X509Certificate must be set");
        String issuerDn = "";
        Principal principal = x509Cert.getIssuerDN();
        if (principal != null) {
            issuerDn = principal.getName();
        }
        return issuerDn;
    }

    public static String getHostForCertificateManagegement(X509Certificate x509Cert, String hostName) {
        String[] hostNames;
        String certHostName = DomainNameValidator.findDnsMatch(x509Cert, hostName);
        if (certHostName == null && (hostNames = CertificateUtils.getCertificateHostNames(x509Cert)).length != 0) {
            certHostName = hostNames[0];
        }
        return certHostName;
    }

    public static String[] getCertificateHostNames(X509Certificate x509Cert) {
        String[] hostNames;
        Validate.isNotNull((Object)x509Cert, (String)"X509Certificate must be set");
        boolean isInValidCnHostName = false;
        ArrayList<String> certHosts = new ArrayList<String>();
        String cnName = CertificateUtils.getFirstCommonNameFromSubject(x509Cert);
        if (!StringUtils.isEmpty((String)cnName) && CertificateUtils.isValidCertificateHostName(cnName)) {
            certHosts.add(cnName);
        } else {
            isInValidCnHostName = true;
        }
        String[] stringArray = hostNames = CertificateUtils.getDnsNamesFromSubjectAltName(x509Cert);
        int n = hostNames.length;
        int n2 = 0;
        while (n2 < n) {
            String certHost = stringArray[n2];
            if (!StringUtils.isEmpty((String)certHost) && !certHosts.contains(certHost)) {
                certHosts.add(certHost);
            }
            ++n2;
        }
        if (certHosts.isEmpty()) {
            if (isInValidCnHostName) {
                logger.warn(String.format("Certificate with Subject Common Name: '%s', cannot be used to verify a server, reason = Subject Common Name or SAN needs to contain a valid host name or ip-address", cnName));
            } else {
                logger.warn("For the purpose of pinning, the certificate does not contain a valid Subject Common Name or Subject Alternative name, it cannot be used to verify a server, reason = Subject CN or SAN needs to contain a valid host name or ip-address");
            }
        }
        return certHosts.toArray(new String[certHosts.size()]);
    }

    private static boolean isValidCertificateHostName(String hostName) {
        if (hostName == null) {
            return false;
        }
        if ((hostName = hostName.trim()).startsWith("*.")) {
            int loc = hostName.indexOf(46);
            if (hostName.length() > loc + 1) {
                hostName = hostName.substring(loc + 1);
            }
        } else if (hostName.startsWith("{")) {
            int loc = hostName.indexOf(125);
            if (hostName.length() > loc + 2) {
                hostName = hostName.substring(loc + 2);
            }
        }
        return NetUtils.isIPAddress((String)hostName) || InternetDomainName.isValid((String)hostName);
    }

    public static String getCertificateHostNameForHostIpAddresss(X509Certificate x509Cert, String hostName) {
        String host;
        Validate.isNotNull((Object)x509Cert, (String)"X509Certificate must be set");
        Validate.isNotEmpty((String)hostName, (String)"host name must be set");
        if (!StringUtils.isEmpty((String)hostName) && NetUtils.isIPAddress((String)hostName) && !StringUtils.isEmpty((String)(host = CertificateUtils.getIpAddressFromSubjectAltName(x509Cert)))) {
            return host;
        }
        return "";
    }

    public static String getCertificateHostName(X509Certificate x509Cert) {
        Validate.isNotNull((Object)x509Cert, (String)"X509Certificate must be set");
        String[] hostNames = CertificateUtils.getDnsNamesFromSubjectAltName(x509Cert);
        if (hostNames.length != 0) {
            return hostNames[0];
        }
        return CertificateUtils.getFirstCommonNameFromSubject(x509Cert);
    }

    public static String getFirstCommonNameFromSubject(X509Certificate x509Cert) {
        Validate.isNotNull((Object)x509Cert, (String)"X509Certificate must be set");
        try {
            AttributeTypeAndValue attrib;
            RDN[] rdnCns;
            X500Name x500name = new JcaX509CertificateHolder(x509Cert).getSubject();
            if (x500name != null && (rdnCns = x500name.getRDNs(BCStyle.CN)) != null && rdnCns.length > 0 && (attrib = rdnCns[0].getFirst()) != null) {
                return IETFUtils.valueToString((ASN1Encodable)attrib.getValue());
            }
        }
        catch (Exception e) {
            logger.error(String.format("failed to extract the CN (common-name) from certificate subject (certificate: %s), reason = %s", x509Cert, StringUtils.extractMessage((Exception)e)));
        }
        return "";
    }

    public static String[] getDnsNamesFromSubjectAltName(X509Certificate x509Cert) {
        Validate.isNotNull((Object)x509Cert, (String)"X509Certificate must be set");
        ArrayList<String> dnsNames = new ArrayList<String>();
        try {
            if (x509Cert.getSubjectAlternativeNames() != null) {
                for (List<?> next : x509Cert.getSubjectAlternativeNames()) {
                    String dnsName;
                    int OID = (Integer)next.get(0);
                    if (OID != 2 || StringUtils.isEmpty((String)(dnsName = (String)next.get(1)))) continue;
                    dnsNames.add(dnsName);
                }
            }
        }
        catch (Exception e) {
            logger.error(String.format("failed to extract the dns-name from certificate subject alternative name (certificate: %s), reason = %s", x509Cert, StringUtils.extractMessage((Exception)e)));
        }
        return dnsNames.toArray(new String[dnsNames.size()]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getIpAddressFromSubjectAltName(X509Certificate x509Cert) {
        Validate.isNotNull((Object)x509Cert, (String)"X509Certificate must be set");
        try {
            List<?> next;
            int OID;
            if (x509Cert.getSubjectAlternativeNames() == null) return null;
            Iterator<List<?>> iter = x509Cert.getSubjectAlternativeNames().iterator();
            do {
                if (iter.hasNext()) continue;
                return null;
            } while ((OID = ((Integer)(next = iter.next()).get(0)).intValue()) != 7);
            String ipAddress = (String)next.get(1);
            if (StringUtils.isEmpty((String)ipAddress)) return null;
            return ipAddress;
        }
        catch (Exception e) {
            logger.error(String.format("failed to extract the ip-address from certificate subject alternative name (certificate: %s), reason = %s", x509Cert, StringUtils.extractMessage((Exception)e)));
        }
        return null;
    }

    public static Date getCertificateExpirationDate(X509Certificate x509Cert) {
        Validate.isNotNull((Object)x509Cert, (String)"X509Certificate must be set");
        return x509Cert.getNotAfter();
    }

    public static String getCertificateFingerprint(X509Certificate x509Cert) {
        Validate.isNotNull((Object)x509Cert, (String)"X509Certificate must be set");
        try {
            MessageDigest sha1 = MessageDigest.getInstance("SHA1");
            sha1.update(x509Cert.getEncoded());
            return StringUtils.byteArray2Hex((byte[])sha1.digest());
        }
        catch (Exception e) {
            logger.error(String.format("failed to create the fingerprint for certificate: %s, reason = %s", x509Cert, StringUtils.extractMessage((Exception)e)));
            return null;
        }
    }

    public static int getMinimumAsymmetricKeyLength(String pkAlgorithm) {
        if (StringUtils.isEmpty((String)pkAlgorithm)) {
            return 2048;
        }
        return 2048;
    }

    public static int getPublicKeyLength(PublicKey publicKey) {
        Validate.isNotNull((Object)publicKey, (String)"PublicKey must be set");
        int keysize = 0;
        if (publicKey instanceof RSAPublicKey) {
            RSAPublicKey rsapk = (RSAPublicKey)publicKey;
            keysize = (rsapk.getModulus().toByteArray().length - 1) * 8;
        } else if (publicKey instanceof DSAPublicKey) {
            JDKDSAPublicKey dsapubkey = (JDKDSAPublicKey)publicKey;
            keysize = dsapubkey.getY().bitLength();
        } else if (publicKey instanceof JCEECPublicKey) {
            JCEECPublicKey ecpubkey = (JCEECPublicKey)publicKey;
            keysize = ecpubkey.getQ().getXCoord().getFieldSize();
        }
        return keysize;
    }

    public static int getCertificatePublicKeyLength(X509Certificate x509Cert) {
        Validate.isNotNull((Object)x509Cert, (String)"X509Certificate must be set");
        return CertificateUtils.getPublicKeyLength(x509Cert.getPublicKey());
    }

    public static String getCertificateSignatureAlgorithmName(X509Certificate x509Cert) {
        Validate.isNotNull((Object)x509Cert, (String)"X509Certificate must be set");
        return x509Cert.getSigAlgName();
    }

    public static String getPublicKeyAlgorithmName(PublicKey publicKey) {
        Validate.isNotNull((Object)publicKey, (String)"PublicKey must be set");
        String algorithm = publicKey.getAlgorithm();
        if (publicKey instanceof JCEECPublicKey) {
            algorithm = "ECDSA";
        }
        return algorithm;
    }

    public static String getPublicKeyFormat(PublicKey publicKey) {
        String format = "";
        if (publicKey instanceof RSAPublicKey) {
            RSAPublicKey rsaPublicKey = (RSAPublicKey)publicKey;
            format = rsaPublicKey.getFormat();
        } else if (publicKey instanceof DSAPublicKey) {
            DSAPublicKey dsaPublicKey = (DSAPublicKey)publicKey;
            format = dsaPublicKey.getFormat();
        } else if (publicKey instanceof JCEECPublicKey) {
            JCEECPublicKey ecPublicKey = (JCEECPublicKey)publicKey;
            format = ecPublicKey.getFormat();
        }
        return format;
    }

    /*
     * Exception decompiling
     */
    public static X509Certificate getJavaKeyStoreCertificate(File keyStoreFile, String password, String certAlias) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 11[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static KeyStore loadKeyStore(File keyStoreFile, String password) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        KeyStore keyStore;
        Validate.isNotNull((Object)keyStoreFile, (String)"key-store file must be set");
        Validate.isNotEmpty((String)password, (String)"key-store password must be set");
        KeyStore keyStore2 = KeyStore.getInstance(JKS_PROVIDER_NAME);
        FileInputStream is = null;
        try {
            is = new FileInputStream(keyStoreFile);
            keyStore2.load(is, password.toCharArray());
            keyStore = keyStore2;
        }
        catch (Throwable throwable) {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            if (is != null) {
                is.close();
            }
        }
        catch (IOException iOException) {}
        return keyStore;
    }

    public static KeyStore loadJavaCaCertsKeyStore() throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        KeyStore keyStore;
        block7: {
            String filename = String.valueOf(System.getProperty("java.home")) + LIB_SECURITY_CACERTS.replace('/', File.separatorChar);
            FileInputStream is = null;
            try {
                is = new FileInputStream(filename);
                KeyStore keystore = KeyStore.getInstance(KeyStore.getDefaultType());
                String password = "changeit";
                keystore.load(is, password.toCharArray());
                keyStore = keystore;
                if (is == null) break block7;
            }
            catch (Throwable throwable) {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            try {
                is.close();
            }
            catch (IOException iOException) {}
        }
        return keyStore;
    }

    public static TrustManagerFactory createX509TrustmanagerFactory(KeyStore keyStore) throws NoSuchAlgorithmException, KeyStoreException {
        TrustManagerFactory trustMgrFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustMgrFactory.init(keyStore);
        return trustMgrFactory;
    }

    public static String x509ToBase64PEMString(X509Certificate x509Cert) throws CertificateEncodingException {
        Validate.isNotNull((Object)x509Cert, (String)"x509-cert must be set");
        StringBuilder sb = new StringBuilder();
        BASE64Encoder encoder = new BASE64Encoder();
        sb.append("-----BEGIN CERTIFICATE-----").append("\n");
        sb.append(encoder.encode(x509Cert.getEncoded()));
        sb.append("\n").append("-----END CERTIFICATE-----").append("\n");
        return sb.toString();
    }

    public static String publicKeyToBase64PEMString(KeyPair keyPair) {
        Validate.isNotNull((Object)keyPair, (String)"key-pair must be set");
        byte[] encodedKey = keyPair.getPublic().getEncoded();
        if (encodedKey == null) {
            encodedKey = new byte[]{};
        }
        StringBuilder sb = new StringBuilder();
        BASE64Encoder encoder = new BASE64Encoder();
        sb.append("-----BEGIN PUBLIC KEY-----").append("\n");
        sb.append(encoder.encode(encodedKey));
        sb.append("\n").append("-----END PUBLIC KEY-----").append("\n");
        return sb.toString();
    }

    public static String privateKeyToBase64PEMString(KeyPair keyPair) {
        Validate.isNotNull((Object)keyPair, (String)"key-pair must be set");
        byte[] encodedKey = keyPair.getPrivate().getEncoded();
        if (encodedKey == null) {
            encodedKey = new byte[]{};
        }
        StringBuilder sb = new StringBuilder();
        BASE64Encoder encoder = new BASE64Encoder();
        sb.append("-----BEGIN PRIVATE KEY-----").append("\n");
        sb.append(encoder.encode(encodedKey));
        sb.append("\n").append("-----END PRIVATE KEY-----").append("\n");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addSessionTrustedHost(String hostName) {
        if (!StringUtils.isEmpty((String)hostName)) {
            Map<String, Integer> map = trustedHosts;
            synchronized (map) {
                trustedHosts.put(hostName, SESSION_TRUSTED_HOST);
                logger.info(String.format("added session trusted host: '%s'", hostName));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addCertificateTrustedHost(String hostName, X509Certificate x509Cert) {
        if (!StringUtils.isEmpty((String)hostName)) {
            Map<String, Integer> map = trustedHosts;
            synchronized (map) {
                trustedHosts.put(hostName, CERTIFICATE_TRUSTED_HOST);
                trustedHostsCertificate.put(hostName, x509Cert);
            }
        }
    }

    public static String[] addCertificateTrustedHostFromFile(File certFile) throws Exception {
        String[] hostNames;
        X509Certificate x509Cert = CertificateUtils.createX509CertificateFromFile(certFile);
        FileUtils.copyFile((File)certFile, (File)new File(CertificateUtils.getRemainCertificatesPath(), certFile.getName()), (boolean)true);
        String[] stringArray = hostNames = CertificateUtils.getCertificateHostNames(x509Cert);
        int n = hostNames.length;
        int n2 = 0;
        while (n2 < n) {
            String hostName = stringArray[n2];
            CertificateUtils.addCertificateTrustedHost(hostName, x509Cert);
            ++n2;
        }
        return hostNames;
    }

    public static void addLocalHostAsSessionTrusted(String hostName) {
        if (!CertificateUtils.isCertificateTrustedHost("localhost")) {
            CertificateUtils.addSessionTrustedHost("localhost");
        }
        if (!CertificateUtils.isCertificateTrustedHost("127.0.0.1")) {
            CertificateUtils.addSessionTrustedHost("127.0.0.1");
        }
        if (!CertificateUtils.isCertificateTrustedHost("::1")) {
            CertificateUtils.addSessionTrustedHost("::1");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static X509Certificate getTrustedHostCertificate(String hostName) {
        if (!StringUtils.isEmpty((String)hostName)) {
            Map<String, Integer> map = trustedHosts;
            synchronized (map) {
                return trustedHostsCertificate.get(hostName);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, X509Certificate> getTrustedHostsWithCertificates() {
        Map<String, Integer> map = trustedHosts;
        synchronized (map) {
            return new HashMap<String, X509Certificate>(trustedHostsCertificate);
        }
    }

    public static void setLastProcessedCertificate(X509Certificate x509Cert) {
        lastProcessedCertificate = x509Cert;
    }

    public static X509Certificate getLastProcessedCertificate() {
        return lastProcessedCertificate;
    }

    public static void removeTrustedHost(String hostName) {
        CertificateUtils.removeTrustedHost(hostName, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean removeTrustedHost(String hostName, boolean deleteCertificate) {
        boolean isSucces = true;
        if (!StringUtils.isEmpty((String)hostName)) {
            Map<String, Integer> map = trustedHosts;
            synchronized (map) {
                String trustedHost = CertificateUtils.getTrustedHost(hostName);
                if (trustedHost != null) {
                    trustedHosts.remove(trustedHost);
                    if (deleteCertificate) {
                        isSucces = CertificateUtils.deleteCertificateFile(hostName);
                    }
                    trustedHostsCertificate.remove(trustedHost);
                }
            }
        }
        return isSucces;
    }

    private static boolean deleteCertificateFile(String hostName) {
        File certFile = certificateFiles.get(hostName);
        if (certFile != null && certFile.exists()) {
            return certFile.delete();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getTrustedHost(String hostName) {
        if (!StringUtils.isEmpty((String)hostName)) {
            Map<String, Integer> map = trustedHosts;
            synchronized (map) {
                for (String trustedHost : trustedHosts.keySet()) {
                    if (!StringUtils.isEqualIgnoreCase((String)hostName, (String)trustedHost)) continue;
                    return trustedHost;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] getTrustedHosts() {
        ArrayList<String> hosts = new ArrayList<String>();
        Map<String, Integer> map = trustedHosts;
        synchronized (map) {
            for (String trustedHost : trustedHosts.keySet()) {
                hosts.add(trustedHost);
            }
        }
        return hosts.toArray(new String[hosts.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isCertificateTrustedHost(String hostName) {
        if (!StringUtils.isEmpty((String)hostName)) {
            Map<String, Integer> map = trustedHosts;
            synchronized (map) {
                for (String trustedHost : trustedHosts.keySet()) {
                    if (!hostName.contains("*")) {
                        if (!StringUtils.simpleMatchFilter((String)hostName, (String)trustedHost, (boolean)false)) continue;
                        return trustedHosts.get(trustedHost) == CERTIFICATE_TRUSTED_HOST;
                    }
                    if (!StringUtils.simpleMatchFilter((String)trustedHost, (String)hostName, (boolean)false)) continue;
                    return trustedHosts.get(trustedHost) == CERTIFICATE_TRUSTED_HOST;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] getCertificateTrustedHosts() {
        ArrayList<String> hosts = new ArrayList<String>();
        Map<String, Integer> map = trustedHosts;
        synchronized (map) {
            for (String trustedHost : trustedHosts.keySet()) {
                if (trustedHosts.get(trustedHost) != CERTIFICATE_TRUSTED_HOST) continue;
                hosts.add(trustedHost);
            }
        }
        return hosts.toArray(new String[hosts.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isSessionTrustedHost(String hostName) {
        if (StringUtils.isEmpty((String)hostName)) return false;
        Map<String, Integer> map = trustedHosts;
        synchronized (map) {
            String trustedHost;
            Iterator<String> iterator = trustedHosts.keySet().iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    return false;
                }
                trustedHost = iterator.next();
                if (hostName.equals(trustedHost)) {
                    return true;
                }
                if (!hostName.contains("*")) {
                    if (!StringUtils.simpleMatchFilter((String)hostName, (String)trustedHost, (boolean)false)) continue;
                    if (trustedHosts.get(trustedHost) != SESSION_TRUSTED_HOST) return false;
                    return true;
                }
                if (StringUtils.simpleMatchFilter((String)trustedHost, (String)hostName, (boolean)false)) break;
            }
            if (trustedHosts.get(trustedHost) != SESSION_TRUSTED_HOST) return false;
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] getSessionTrustedHosts() {
        ArrayList<String> hosts = new ArrayList<String>();
        Map<String, Integer> map = trustedHosts;
        synchronized (map) {
            for (String trustedHost : trustedHosts.keySet()) {
                if (trustedHosts.get(trustedHost) != SESSION_TRUSTED_HOST) continue;
                hosts.add(trustedHost);
            }
        }
        return hosts.toArray(new String[hosts.size()]);
    }

    public static String replaceWildWithPound(String hostName) {
        return hostName.replaceAll("\\*", "#");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isTrustedHost(String hostName) {
        if (StringUtils.isEmpty((String)hostName)) return false;
        Map<String, Integer> map = trustedHosts;
        synchronized (map) {
            String trustedHost;
            Iterator<String> iterator = trustedHosts.keySet().iterator();
            do {
                if (!iterator.hasNext()) {
                    return false;
                }
                trustedHost = iterator.next();
                if (trustedHost.equals(hostName)) {
                    return true;
                }
                if (!StringUtils.simpleMatchFilter((String)hostName, (String)trustedHost, (boolean)false)) continue;
                return true;
            } while (!hostName.contains("*") || !StringUtils.simpleMatchFilter((String)trustedHost, (String)hostName, (boolean)false));
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final void loadTrustedHosts(String userCertPath, File instCertPath) {
        Validate.isNotEmpty((String)userCertPath, (String)"certificates path must be set");
        Map<String, Integer> map = trustedHosts;
        synchronized (map) {
            trustedHosts.clear();
            CertificateUtils.addTrustedHosts(System.getProperty(PROPERTY_SSL_TRUSTED_HOSTS));
            if (instCertPath != null && instCertPath.exists()) {
                CertificateUtils.addTrustedHostsFromNewerCertificates(new File(userCertPath), instCertPath);
            } else {
                logger.warn("skipped processing trusted hosts from installation certificates directory, reason = certificates directory not found");
            }
            CertificateUtils.addTrustedHostsFromCertificatesPath(userCertPath);
        }
    }

    private static void addTrustedHostsFromNewerCertificates(File userCertPath, File instCertPath) {
        String[] certFileNames;
        logger.info(String.format("check and process trusted host certificates in directory: %s", instCertPath.getAbsolutePath()));
        String[] stringArray = certFileNames = CertificateUtils.getCertificatesFromPath(instCertPath);
        int n = certFileNames.length;
        int n2 = 0;
        while (n2 < n) {
            String certFileName = stringArray[n2];
            File instCertFile = new File(instCertPath, certFileName);
            File userCertFile = new File(userCertPath, certFileName);
            if (!userCertFile.exists()) {
                CertificateUtils.addTrustedCertificate(instCertFile);
            }
            ++n2;
        }
    }

    private static String[] getCertificatesFromPath(File certPath) {
        String[] certFileNames = certPath.list((dir, name) -> name.endsWith(PEM_EXTENSION) || name.endsWith(CRT_EXTENSION) || name.endsWith(CER_EXTENSION) || name.endsWith(DER_EXTENSION));
        return certFileNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void addTrustedHostsFromCertificatesPath(String certificatesPath) {
        Map<String, Integer> map = trustedHosts;
        synchronized (map) {
            logger.info(String.format("processing trusted host certificates in directory: %s", certificatesPath));
            if (!StringUtils.isEmpty((String)certificatesPath)) {
                String[] fileNames;
                File certPathFile = new File(certificatesPath);
                if (!certPathFile.exists()) {
                    certPathFile.mkdirs();
                }
                if ((fileNames = CertificateUtils.getCertificatesFromPath(certPathFile)) == null || fileNames.length == 0) {
                    return;
                }
                String[] stringArray = fileNames;
                int n = fileNames.length;
                int n2 = 0;
                while (n2 < n) {
                    String fileName = stringArray[n2];
                    CertificateUtils.addTrustedCertificate(new File(certPathFile, fileName));
                    ++n2;
                }
            }
        }
    }

    private static void addTrustedCertificate(File certFile) {
        X509Certificate x509Cert = null;
        try {
            x509Cert = CertificateUtils.createX509CertificateFromFile(certFile);
        }
        catch (Exception e) {
            logger.error(String.format("failed to load trusted host from certificate file: %s, reason = %s", certFile.getAbsolutePath(), StringUtils.extractMessage((Exception)e)), (Throwable)e);
            return;
        }
        Object[] hostNames = CertificateUtils.getCertificateHostNames(x509Cert);
        if (hostNames.length == 0) {
            logger.warn(String.format("skipped processing of certificate file: %s (CN = %s), reason = certificate does not contain any valid DNS/host name", certFile.getAbsolutePath(), CertificateUtils.getFirstCommonNameFromSubject(x509Cert)));
            return;
        }
        logger.info(String.format("processing certificate with host(s): [%s] from certificate file: %s", Strings.join((CharSequence)", ", (Object[])hostNames), certFile.getAbsolutePath()));
        if (CertificateUtils.isExpiredCertificate(x509Cert)) {
            logger.warn(String.format("certificate with host(s): [%s] expired on %s (certificate file: %s)", Strings.join((CharSequence)", ", (Object[])hostNames), x509Cert.getNotAfter().toString(), certFile.getAbsolutePath()));
        }
        Object[] objectArray = hostNames;
        int n = hostNames.length;
        int n2 = 0;
        while (n2 < n) {
            Object hostName = objectArray[n2];
            if (!StringUtils.isEmpty((String)hostName)) {
                Integer trustType = trustedHosts.get(hostName);
                if (trustType == null || trustType != SESSION_TRUSTED_HOST) {
                    CertificateUtils.addCertificateTrustedHost((String)hostName, x509Cert);
                    certificateFiles.put((String)hostName, certFile);
                    boolean isLocalAddress = NetUtils.isLocalAddress((String)hostName);
                    if (isLocalAddress) {
                        CertificateUtils.addLocalHostAsSessionTrusted((String)hostName);
                    }
                    logger.info(String.format("added certificate trusted host: '%s', local-address = %s, self-signed = %s, expiration date: %s", hostName, Boolean.toString(isLocalAddress), Boolean.toString(CertificateUtils.isSelfSigned(x509Cert)), x509Cert.getNotAfter().toString()));
                } else {
                    logger.warn(String.format("skipped add of certificate trusted host: '%s', host is already a trusted host", hostName));
                }
            } else {
                logger.warn(String.format("skipped load of trusted host from certificate file: '%s', empty or invalid host name: '%s'", certFile.getAbsolutePath(), hostName));
            }
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addTrustedHosts(String hosts) {
        Map<String, Integer> map = trustedHosts;
        synchronized (map) {
            if (!StringUtils.isEmpty((String)hosts)) {
                String[] split;
                String[] stringArray = split = hosts.split(",");
                int n = split.length;
                int n2 = 0;
                while (n2 < n) {
                    String host = stringArray[n2];
                    String hostName = host.trim();
                    if (!"".equals(hostName)) {
                        CertificateUtils.addSessionTrustedHost(hostName);
                    }
                    ++n2;
                }
            }
        }
    }

    public static X509Certificate convert(javax.security.cert.X509Certificate x509Cert) {
        Validate.isNotNull((Object)x509Cert, (String)"X509 Certificate must be set");
        try {
            byte[] encoded = x509Cert.getEncoded();
            ByteArrayInputStream bis = new ByteArrayInputStream(encoded);
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            return (X509Certificate)cf.generateCertificate(bis);
        }
        catch (Exception e) {
            logger.error("exception occured while converting a certificate (javax to java security): " + x509Cert.toString() + ", message = " + StringUtils.extractMessage((Exception)e), (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setupHttpsSslExceptionOverride() throws NoSuchAlgorithmException, KeyManagementException {
        Map<String, Integer> map = trustedHosts;
        synchronized (map) {
            if (isSetupRemainSslOverride) {
                return;
            }
            System.setProperty("jsse.enableSNIExtension", "false");
            TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                @Override
                public void checkClientTrusted(X509Certificate[] x509Certs, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] x509Certs, String authType) {
                    X509Certificate x509Cert = x509Certs[0];
                    CertificateUtils.setLastProcessedCertificate(x509Cert);
                    if (DomainNameValidator.findDnsMatch(x509Cert, CertificateUtils.REMAIN_NL) != null || DomainNameValidator.findDnsMatch(x509Cert, CertificateUtils.REMAINSOFTWARE_COM) != null) {
                        return;
                    }
                }
            }};
            SSLContext sc = SSLContext.getInstance(TLS);
            sc.init(null, trustAllCerts, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
            HttpsURLConnection.setDefaultHostnameVerifier((hostName, session) -> true);
            isSetupRemainSslOverride = true;
        }
    }

    public static javax.security.cert.X509Certificate convert(X509Certificate x509Cert) {
        Validate.isNotNull((Object)x509Cert, (String)"X509 Certificate must be set");
        try {
            byte[] encoded = x509Cert.getEncoded();
            return javax.security.cert.X509Certificate.getInstance(encoded);
        }
        catch (Exception e) {
            logger.error("exception occured while converting a certificate (from java to javax security): " + x509Cert.toString() + ", message = " + StringUtils.extractMessage((Exception)e), (Throwable)e);
            return null;
        }
    }

    private static KeyStore createJavaKeyStore(String certFileName, String keyFileName) throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException, InvalidKeySpecException, FileNotFoundException {
        KeyStore ks = KeyStore.getInstance(JKS_PROVIDER_NAME);
        FileInputStream fis = new FileInputStream(certFileName);
        BufferedInputStream bis = new BufferedInputStream(fis);
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        Certificate cert = null;
        try {
            while (bis.available() > 0) {
                cert = cf.generateCertificate(bis);
            }
        }
        catch (Throwable throwable) {
            try {
                if (bis != null) {
                    bis.close();
                } else if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            if (bis != null) {
                bis.close();
            } else if (fis != null) {
                fis.close();
            }
        }
        catch (IOException iOException) {}
        ks.load(null, null);
        ks.setKeyEntry("keyentry,", CertificateUtils.createPrivateKey(keyFileName), componentUUID.toCharArray(), new Certificate[]{cert});
        return ks;
    }

    private static PrivateKey createPrivateKey(String keyFileName) throws IOException, NoSuchAlgorithmException, InvalidKeySpecException, FileNotFoundException {
        StringBuilder sb = new StringBuilder();
        FileInputStream fis = new FileInputStream(keyFileName);
        InputStreamReader isr = new InputStreamReader(fis);
        BufferedReader br = new BufferedReader(isr);
        try {
            String line;
            while ((line = br.readLine()) != null) {
                sb.append(line);
            }
        }
        catch (Throwable throwable) {
            try {
                if (br != null) {
                    br.close();
                } else if (isr != null) {
                    isr.close();
                }
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            if (br != null) {
                br.close();
            } else if (isr != null) {
                isr.close();
            }
        }
        catch (IOException iOException) {}
        String pemString = sb.toString();
        pemString = pemString.replace("-----BEGIN PRIVATE KEY-----", "");
        pemString = pemString.replace("-----END PRIVATE KEY-----", "");
        byte[] encoded = Base64.decode((String)pemString);
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(encoded);
        KeyFactory kf = KeyFactory.getInstance("RSA");
        PrivateKey privateKey = kf.generatePrivate(keySpec);
        return privateKey;
    }

    public static void dumpJREKeyStoreCACertificates() {
        try {
            KeyStore keyStore = CertificateUtils.getJREKeyStore();
            if (keyStore != null) {
                X509Certificate[] trustedCerts = CertificateUtils.getKeyStoreCertificates(keyStore);
                int ix = 0;
                while (ix < trustedCerts.length) {
                    boolean selfSigned = CertificateUtils.isSelfSigned(trustedCerts[ix]);
                    logger.info("Key-store cert[" + ix + "]: [ " + trustedCerts[ix].getSubjectX500Principal().getName() + ", self-signed = " + selfSigned + " ]");
                    ++ix;
                }
            }
        }
        catch (Exception e) {
            logger.info("failed to list key-store certificates, message = " + StringUtils.extractMessage((Exception)e));
        }
    }

    public static KeyStore getJREKeyStore() {
        String fileName = String.valueOf(System.getProperty("java.home")) + LIB_SECURITY_CACERTS.replace('/', File.separatorChar);
        return CertificateUtils.getKeyStore(fileName);
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static KeyStore getKeyStore(String fileName) {
        Validate.isNotEmpty((String)fileName, (String)"Key-store file nam emust be set");
        FileInputStream is = null;
        is = new FileInputStream(fileName);
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        char[] password = "changeit".toCharArray();
        keyStore.load(is, password);
        KeyStore keyStore2 = keyStore;
        if (is == null) return keyStore2;
        try {
            is.close();
            return keyStore2;
        }
        catch (IOException iOException) {}
        return keyStore2;
        catch (Exception e) {
            try {
                logger.error("Exception occurred while loading java runtime certificate key store, message = " + e.getMessage(), (Throwable)e);
                if (is == null) return null;
            }
            catch (Throwable throwable) {
                if (is == null) throw throwable;
                try {
                    is.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                is.close();
                return null;
            }
            catch (IOException iOException) {}
            return null;
        }
    }

    public static GravityReply testHttpConnection(String serverUrl) {
        URL url = null;
        HttpURLConnection httpConn = null;
        GravityReply reply = new GravityReply();
        try {
            try {
                url = new URL(serverUrl);
                httpConn = NetUtils.openHttpConnection((URL)url);
                CertificateUtils.getResponseCode(httpConn);
            }
            catch (Exception e) {
                block14: {
                    logger.warn(String.format("test connection failed for URL: %s, reason = %s, cause = %s", serverUrl, StringUtils.extractMessage((Exception)e), StringUtils.extractCauseMessage((Exception)e)));
                    if (e instanceof SSLHandshakeException && e.getCause() instanceof CertificateException) {
                        reply.setSeverity(GravitySeverity.WARNING);
                        reply.setAdditionalInfo(HOST_CERTIFICATE_REJECTED);
                        reply.setMessage(e.getCause().getMessage());
                        GravityReply gravityReply = reply;
                        if (httpConn != null) {
                            httpConn.disconnect();
                        }
                        return gravityReply;
                    }
                    if (!(e instanceof IOException) || e.getMessage() == null || !e.getMessage().startsWith(HTTPS_HOSTNAME_WRONG)) break block14;
                    reply.setSeverity(GravitySeverity.WARNING);
                    reply.setAdditionalInfo(SSL_HOSTNAME_MISMATCH);
                    reply.setMessage(e.getMessage());
                    GravityReply gravityReply = reply;
                    if (httpConn != null) {
                        httpConn.disconnect();
                    }
                    return gravityReply;
                }
                reply.setSeverity(GravitySeverity.ERROR);
                String message = StringUtils.extractMessage((Exception)e);
                if (StringUtils.isEmpty((String)message)) {
                    message = StringUtils.extractCompoundMessage((Exception)e);
                }
                reply.setMessage(message);
                reply.setException(e);
                if (httpConn != null) {
                    httpConn.disconnect();
                }
            }
        }
        finally {
            if (httpConn != null) {
                httpConn.disconnect();
            }
        }
        return reply;
    }

    public static boolean isAllowExpiredCertificate() {
        return Boolean.getBoolean(SSL_ALLOW_EXPIRED_CERTIFICATE);
    }

    public static boolean isAllowWeakCertificateKeyLength() {
        return Boolean.getBoolean(SSL_ALLOW_WEAK_CERT_KEY_LENGTHS);
    }

    private static int getResponseCode(URLConnection urlConnection) throws IOException {
        int status = 200;
        if (urlConnection instanceof HttpURLConnection) {
            status = ((HttpURLConnection)urlConnection).getResponseCode();
        }
        return status;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void readJRETrustedCACert(String certName) {
        Certificate sapcert;
        char[] password;
        KeyStore keystore;
        FileInputStream is;
        block14: {
            String filename = String.valueOf(System.getProperty("java.home")) + LIB_SECURITY_CACERTS.replace('/', File.separatorChar);
            is = null;
            is = new FileInputStream(filename);
            keystore = KeyStore.getInstance(KeyStore.getDefaultType());
            password = "changeit".toCharArray();
            keystore.load(is, password);
            new PKIXParameters(keystore);
            sapcert = keystore.getCertificate(certName);
            if (sapcert != null) break block14;
            logger.warn("Failed to find certificate '" + certName + "' in key-store file: '" + filename + "'");
            if (is == null) return;
            try {
                is.close();
                return;
            }
            catch (IOException iOException) {}
            return;
        }
        try {
            try {
                PublicKey sapcertKey = sapcert.getPublicKey();
                System.out.println(sapcertKey);
                Enumeration<String> aliases = keystore.aliases();
                while (aliases.hasMoreElements()) {
                    String alias = aliases.nextElement();
                    System.out.println("alias certificates :" + alias);
                    if (!keystore.isKeyEntry(alias)) continue;
                    keystore.getKey(alias, password);
                }
            }
            catch (Exception e) {
                logger.error("Exception occurred while reading trusted java key store certificate '" + certName + "', message = " + e.getMessage(), (Throwable)e);
                if (is == null) return;
                try {
                    is.close();
                    return;
                }
                catch (IOException iOException) {}
                return;
            }
        }
        catch (Throwable throwable) {
            if (is == null) throw throwable;
            try {
                is.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        if (is == null) return;
        try {
            is.close();
            return;
        }
        catch (IOException iOException) {}
    }

    public static boolean allowUnsafeServerCertChange(Exception exception) {
        if (exception.getCause() instanceof SSLHandshakeException) {
            logger.debug("server https certificate has been altered");
            try {
                Class<?> c = Class.forName("sun.security.ssl.ClientHandshaker");
                Field allowUnsafeServerCertChangeField = c.getDeclaredField("allowUnsafeServerCertChange");
                allowUnsafeServerCertChangeField.setAccessible(true);
                Field modifiersField = Field.class.getDeclaredField("modifiers");
                modifiersField.setAccessible(true);
                modifiersField.setInt(allowUnsafeServerCertChangeField, allowUnsafeServerCertChangeField.getModifiers() & 0xFFFFFFEF);
                allowUnsafeServerCertChangeField.set(null, true);
                logger.debug("client has been updated to support runtime SSL certificate changes (re-negotiation).");
                return true;
            }
            catch (Exception ex) {
                logger.debug("client cannot be updated to support SSL certificate changes (re-negotiation), reason = " + StringUtils.extractMessage((Exception)ex), (Throwable)ex);
            }
        }
        return false;
    }

    public static Path resolvePath(String certificatePath) throws Exception {
        if (certificatePath.startsWith("file:")) {
            try {
                logger.info("using file resolver for certificate path: {}", (Object)certificatePath);
                Path path = Paths.get(new URL(certificatePath).toURI());
                if (!Files.exists(path, new LinkOption[0])) {
                    throw new FileNotFoundException();
                }
                return path;
            }
            catch (Exception e) {
                throw new Exception("failed to resolve certificate path: '" + certificatePath + "', reason = " + e.getMessage(), e);
            }
        }
        return new File(certificatePath).toPath();
    }

    public static File getRemainCertificatesPath() {
        File certPathDir;
        String certPath = System.getProperty(PROPERTY_CERTIFICATES_PATH);
        if (StringUtils.isEmpty((String)certPath)) {
            certPath = StringUtils.addPath((String)CommonConstants.getUserHome(), (String)DEFAULT_CERTIFICATES_PATH);
            System.setProperty(PROPERTY_CERTIFICATES_PATH, certPath);
        }
        if (!(certPathDir = new File(certPath)).exists()) {
            certPathDir.mkdirs();
        }
        return certPathDir;
    }
}

