/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.ui.util;

import com.ibm.as400.ui.framework.java.MessageLog;
import com.ibm.as400.ui.util.ClCommonLayout;
import com.ibm.as400.ui.util.ClElem;
import com.ibm.as400.ui.util.ClList;
import com.ibm.as400.ui.util.ClListKeyListener;
import com.ibm.as400.ui.util.ClNode;
import com.ibm.as400.ui.util.ClPanel;
import com.ibm.as400.ui.util.ClPanelFocusListener;
import com.ibm.as400.ui.util.ClParm;
import com.ibm.as400.ui.util.ClParseException;
import com.ibm.as400.ui.util.ClQual;
import com.ibm.as400.ui.util.ClSyntax;
import com.ibm.as400.ui.util.ClValues;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyListener;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

class ClQualListPanel
extends ClPanel
implements ActionListener,
ItemListener,
ListSelectionListener,
DocumentListener {
    private JButton m_add;
    private JButton m_remove;
    private JButton m_moveup;
    private JButton m_movedown;
    private ClList m_list;
    private Vector m_listData;
    private ClValues m_sngValues = null;
    private JScrollPane m_scrollList;
    private int m_max;
    private int m_length;
    private String m_dft;
    private Enumeration m_children;
    private Vector m_qualNames;
    private boolean m_bVisible;
    private ClCommonLayout m_parent;

    ClQualListPanel(ClPanel clPanel, Enumeration enumeration, ClCommonLayout clCommonLayout) throws ClParseException {
        this.m_parent = clCommonLayout;
        this.m_children = enumeration;
        this.m_max = clCommonLayout.getMax();
        this.m_dft = clCommonLayout.getDft();
        this.m_length = clCommonLayout.getTotalLength();
        this.m_bVisible = true;
        this.m_qualNames = new Vector(3);
        this.m_listData = new Vector();
        this.setLayout(new GridBagLayout());
        this.layoutPanel(clPanel, enumeration);
    }

    void layoutPanel(ClPanel clPanel, Enumeration enumeration) throws ClParseException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        ClNode clNode = null;
        ClValues clValues = null;
        this.m_qualNames.removeAllElements();
        this.m_listData.removeAllElements();
        if (this.m_max > 1) {
            if (m_addString == null) {
                m_addString = ClPanel.loadString("IDS_LIST_ADD");
            }
            if (m_removeString == null) {
                m_removeString = ClPanel.loadString("IDS_LIST_REMOVE");
            }
            if (m_moveupString == null) {
                m_moveupString = ClPanel.loadString("IDS_LIST_MOVEUP");
            }
            if (m_movedownString == null) {
                m_movedownString = ClPanel.loadString("IDS_LIST_MOVEDOWN");
            }
            this.m_add = new JButton(m_addString);
            this.m_remove = new JButton(m_removeString);
            this.m_moveup = new JButton(m_moveupString);
            this.m_movedown = new JButton(m_movedownString);
            this.m_add.setFont(ClPanel.m_scaledFont);
            this.m_remove.setFont(ClPanel.m_scaledFont);
            this.m_moveup.setFont(ClPanel.m_scaledFont);
            this.m_movedown.setFont(ClPanel.m_scaledFont);
            this.m_add.setActionCommand("Add");
            this.m_remove.setActionCommand("Remove");
            this.m_moveup.setActionCommand("MoveUp");
            this.m_movedown.setActionCommand("MoveDown");
            object4 = this.m_add.getPreferredSize();
            object3 = this.m_remove.getPreferredSize();
            object2 = this.m_moveup.getPreferredSize();
            object = this.m_movedown.getPreferredSize();
            if (((Dimension)object3).width > ((Dimension)object4).width) {
                ((Dimension)object4).width = ((Dimension)object3).width;
            }
            if (((Dimension)object).width > ((Dimension)object2).width) {
                ((Dimension)object2).width = ((Dimension)object).width;
            }
            if (((Dimension)object2).width > ((Dimension)object4).width) {
                ((Dimension)object4).width = ((Dimension)object2).width;
            }
            if (((Dimension)object3).height > ((Dimension)object4).height) {
                ((Dimension)object4).height = ((Dimension)object3).height;
            }
            if (((Dimension)object).height > ((Dimension)object2).height) {
                ((Dimension)object2).height = ((Dimension)object).height;
            }
            if (((Dimension)object2).height > ((Dimension)object4).height) {
                ((Dimension)object4).height = ((Dimension)object2).height;
            }
            this.m_add.setPreferredSize((Dimension)object4);
            this.m_remove.setPreferredSize((Dimension)object4);
            this.m_moveup.setPreferredSize((Dimension)object4);
            this.m_movedown.setPreferredSize((Dimension)object4);
            this.m_add.addActionListener(this);
            this.m_remove.addActionListener(this);
            this.m_moveup.addActionListener(this);
            this.m_movedown.addActionListener(this);
        }
        object4 = new ClListKeyListener(this);
        if (enumeration.hasMoreElements()) {
            clNode = (ClNode)enumeration.nextElement();
            if (clNode instanceof ClValues && (clValues = (ClValues)clNode).getNodeType() == 8) {
                object3 = this.m_parent.m_sngValues;
                if (object3 != null) {
                    object2 = ((ClNode)object3).getChildren();
                    while (object2.hasMoreElements()) {
                        object = (ClNode)object2.nextElement();
                        if (object == null) continue;
                        clValues.addChild((ClNode)object);
                    }
                }
                this.m_sngValues = clValues;
            }
            if (clValues == null) {
                clValues = this.m_sngValues = this.m_parent.m_sngValues;
            }
            if (enumeration.hasMoreElements() || clValues == null) {
                while (!(clNode instanceof ClQual)) {
                    clNode = (ClNode)enumeration.nextElement();
                }
                if (clNode instanceof ClQual) {
                    int n = 0;
                    if (this.m_max > 1 && !enumeration.hasMoreElements()) {
                        n = 2;
                    }
                    object2 = ((ClQual)clNode).getChildren();
                    while (object2.hasMoreElements()) {
                        object = (ClNode)object2.nextElement();
                        if (!(object instanceof ClValues)) continue;
                        if (clValues == null) {
                            clValues = (ClValues)object;
                            continue;
                        }
                        Enumeration enumeration2 = ((ClValues)object).getChildren();
                        while (enumeration2.hasMoreElements()) {
                            clValues.addChild((ClNode)enumeration2.nextElement());
                        }
                    }
                    ((ClQual)clNode).layoutPanel(clPanel, clValues, this.m_dft, n);
                    ((ClQual)clNode).addKeyListener((KeyListener)object4);
                    ((ClQual)clNode).addItemListener(this);
                    ((ClQual)clNode).addDocumentListener(this);
                    this.m_qualNames.addElement(clNode);
                    if (this.m_max > 1 && !enumeration.hasMoreElements()) {
                        this.addAddButton(clPanel);
                    }
                }
                while (enumeration.hasMoreElements()) {
                    clNode = (ClNode)enumeration.nextElement();
                    if (clNode instanceof ClQual) {
                        int n = 0;
                        if (this.m_max > 1 && !enumeration.hasMoreElements()) {
                            n = 2;
                        }
                        ((ClQual)clNode).layoutPanel(clPanel, n);
                        ((ClQual)clNode).addKeyListener((KeyListener)object4);
                        this.m_qualNames.addElement(clNode);
                        if (this.m_max <= 1 || enumeration.hasMoreElements()) continue;
                        this.addAddButton(clPanel);
                        continue;
                    }
                    MessageLog.logError((Object)"CP: unexpected node in Qual.");
                }
            } else {
                MessageLog.logError((Object)"CP: No Qual in PARM");
            }
        } else {
            MessageLog.logError((Object)"CP: No Qual in PARM");
        }
        if (this.m_max > 1) {
            this.setLayout(new GridBagLayout());
            this.m_listData = new Vector();
            this.m_list = new ClList(this.m_listData);
            this.m_list.setVisibleRowCount(4);
            this.m_list.addKeyListener((KeyListener)object4);
            this.m_scrollList = new JScrollPane();
            this.m_scrollList.getViewport().add(this.m_list);
            if (clNode != null && clNode instanceof ClQual) {
                JTextField jTextField = new JTextField(ClPanel.getColumns(10));
                jTextField.setFont(ClPanel.m_scaledFont);
                object2 = this.m_scrollList.getPreferredSize();
                ((Dimension)object2).width = jTextField.getPreferredSize().width;
                this.m_scrollList.setPreferredSize((Dimension)object2);
            }
            ClPanelFocusListener clPanelFocusListener = new ClPanelFocusListener();
            this.m_add.addFocusListener(clPanelFocusListener);
            this.m_remove.addFocusListener(clPanelFocusListener);
            this.m_moveup.addFocusListener(clPanelFocusListener);
            this.m_movedown.addFocusListener(clPanelFocusListener);
            this.m_list.addFocusListener(clPanelFocusListener);
            this.m_list.addListSelectionListener(this);
            int n = 2;
            object = new GridBagConstraints();
            ((GridBagConstraints)object).anchor = 17;
            ((GridBagConstraints)object).gridwidth = n;
            ((GridBagConstraints)object).gridheight = 3;
            ((GridBagConstraints)object).weightx = 0.0;
            ((GridBagConstraints)object).weighty = 0.0;
            ((GridBagConstraints)object).gridx = -1;
            ((GridBagConstraints)object).gridy = -1;
            ((GridBagConstraints)object).fill = 1;
            ((GridBagConstraints)object).insets = new Insets(3, 7, 0, 0);
            this.add((Component)this.m_scrollList, object);
            this.addRemoveButton(this);
            object = new GridBagConstraints();
            ((GridBagConstraints)object).anchor = 17;
            ((GridBagConstraints)object).gridwidth = 0;
            ((GridBagConstraints)object).gridheight = 1;
            ((GridBagConstraints)object).weightx = 0.0;
            ((GridBagConstraints)object).weighty = 0.0;
            ((GridBagConstraints)object).gridx = -1;
            ((GridBagConstraints)object).gridy = -1;
            ((GridBagConstraints)object).fill = 0;
            ((GridBagConstraints)object).insets = new Insets(3, 7, 0, 7);
            this.add((Component)this.m_moveup, object);
            object = new GridBagConstraints();
            ((GridBagConstraints)object).anchor = 17;
            ((GridBagConstraints)object).gridwidth = 0;
            ((GridBagConstraints)object).gridheight = 1;
            ((GridBagConstraints)object).weightx = 0.0;
            ((GridBagConstraints)object).weighty = 0.0;
            ((GridBagConstraints)object).gridx = -1;
            ((GridBagConstraints)object).gridy = -1;
            ((GridBagConstraints)object).fill = 0;
            ((GridBagConstraints)object).insets = new Insets(3, 7, 0, 7);
            this.add((Component)this.m_movedown, object);
            this.m_remove.setEnabled(false);
            this.m_list.setEnabled(false);
        }
        this.setStartingValues(this.m_parent.getStartingValue());
        this.validateControls();
    }

    void setStartingValues(String string) throws ClParseException {
        if (string == null) {
            return;
        }
        if (this.m_parent.getMax() > 1) {
            this.setStartingListValues(string);
            return;
        }
        this.parseStartingQualValues(string);
        this.validateControls();
        this.m_parent.setStartingValue(this.getCLString());
    }

    void parseStartingQualValues(String string) throws ClParseException {
        Object object;
        int n;
        Vector<String> vector = new Vector<String>(3);
        while (string != null && !string.equals("")) {
            string = string.trim();
            n = -1;
            if (string.startsWith("\"")) {
                n = string.indexOf("\"", 1);
                if (n == -1) {
                    this.m_parent.getPanel().displayAS400Message(18, (Object)string);
                    MessageLog.logError((Object)("CP: unmatched quote: " + string));
                }
                vector.addElement(string.substring(0, n + 1));
                string = string.substring(n + 1);
                continue;
            }
            if (string.startsWith("/")) {
                string = string.substring(1);
                continue;
            }
            n = string.indexOf("/");
            if (n == -1) {
                vector.addElement(string);
                string = null;
                continue;
            }
            vector.addElement(string.substring(0, n));
            string = string.substring(n + 1);
        }
        n = this.m_qualNames.size();
        for (int i = 0; i < n; ++i) {
            object = this.m_qualNames.elementAt(i);
            if (!(object instanceof ClQual)) continue;
            if (vector.size() == 0) break;
            String string2 = (String)vector.lastElement();
            if (string2.length() > 0 && string2.charAt(0) != '*' && ClSyntax.stripQuotes(string2, false).length() > ((ClQual)object).getLen1() && ((ClQual)object).getType() != 1 && ((ClQual)object).getType() != 12 && (string2.length() <= 1 || string2.charAt(0) != 'x' && string2.charAt(0) != 'X' || string2.charAt(1) != '\'') && (string2.length() <= 1 || string2.charAt(0) != '$' && string2.charAt(0) != '&')) {
                ClNode clNode = (ClQual)object;
                while (!(clNode instanceof ClParm)) {
                    clNode = clNode.getParent();
                }
                this.m_parent.getPanel().displayAS400Message(74, (Object)((ClParm)clNode).getKwd(), (Object)("'" + string2 + "'"), (Object)new Integer(((ClQual)object).getLen1()));
                throw new ClParseException();
            }
            ((ClQual)object).setText(string2);
            vector.removeElementAt(vector.size() - 1);
        }
        if (vector.size() != 0) {
            ClNode clNode = this.m_parent;
            while (!(clNode instanceof ClParm)) {
                clNode = clNode.getParent();
            }
            object = ((ClParm)clNode).getKwd();
            this.m_parent.getPanel().displayAS400Message(45, object);
            throw new ClParseException();
        }
    }

    void setStartingListValues(String string) throws ClParseException {
        if (string == null || this.m_max <= 1) {
            return;
        }
        this.blankControls();
        while (string != null && !string.equals("")) {
            String string2;
            int n;
            string = string.trim();
            int n2 = string.indexOf(" ");
            String string3 = null;
            if (n2 == -1) {
                string3 = string;
                string = "";
            } else {
                string3 = string.substring(0, n2);
                string = string.substring(n2 + 1, string.length());
            }
            Vector<String> vector = new Vector<String>(3);
            for (String string4 = string3; string4 != null && !string4.equals(""); string4 = string4.substring(n2 + 1, string4.length())) {
                n2 = (string4 = string4.trim()).indexOf("/");
                if (n2 == -1) {
                    vector.addElement(string4);
                    break;
                }
                String string5 = string4.substring(0, n2);
                vector.addElement(string5);
            }
            int n3 = this.m_qualNames.size();
            for (n = 0; n < n3; ++n) {
                Object e = this.m_qualNames.elementAt(n);
                if (!(e instanceof ClQual)) continue;
                if (vector.size() == 0) break;
                string2 = (String)vector.lastElement();
                if (string2.length() > 0 && string2.charAt(0) != '*' && ClSyntax.stripQuotes(string2, false).length() > ((ClQual)e).getLen1() && ((ClQual)e).getType() != 1 && ((ClQual)e).getType() != 12 && (string2.length() <= 1 || string2.charAt(0) != 'x' && string2.charAt(0) != 'X' || string2.charAt(1) != '\'') && (string2.length() <= 1 || string2.charAt(0) != '$' && string2.charAt(0) != '&')) {
                    ClNode clNode = (ClQual)e;
                    while (!(clNode instanceof ClParm)) {
                        clNode = clNode.getParent();
                    }
                    this.m_parent.getPanel().displayAS400Message(74, (Object)((ClParm)clNode).getKwd(), (Object)("'" + string2 + "'"), (Object)new Integer(((ClQual)e).getLen1()));
                    throw new ClParseException();
                }
                vector.removeElementAt(vector.size() - 1);
            }
            this.parseStartingQualValues(string3);
            string3 = this.getQualifiedName();
            n = 0;
            n3 = this.m_qualNames.size();
            for (int i = 0; i < n3; ++i) {
                string2 = this.m_qualNames.elementAt(i);
                if (!(string2 instanceof ClQual)) continue;
                if (i == 0 && this.isSingleValue(((ClQual)((Object)string2)).getText())) {
                    if (string.equals("") && this.m_listData.size() == 0) {
                        n = 1;
                    } else {
                        ClNode clNode = this.m_parent;
                        while (!(clNode instanceof ClParm)) {
                            clNode = clNode.getParent();
                        }
                        this.m_parent.getPanel().displayAS400Message(94, (Object)((ClParm)clNode).getKwd(), (Object)((ClQual)((Object)string2)).getText());
                        throw new ClParseException();
                    }
                }
                if (((ClQual)((Object)string2)).getText().equals("") || ((ClQual)((Object)string2)).verify(0, true, true)) continue;
                throw new ClParseException();
            }
            if (n != 0) continue;
            this.m_listData.addElement(string3);
            if (this.m_listData.size() > this.m_parent.getMax()) {
                ClNode clNode = this.m_parent;
                while (!(clNode instanceof ClParm)) {
                    clNode = clNode.getParent();
                }
                this.m_parent.getPanel().displayAS400Message(46, (Object)((ClParm)clNode).getKwd(), (Object)"");
                throw new ClParseException();
            }
            this.blankControls(false);
        }
        this.m_list.setListData(this.m_listData);
        this.m_scrollList.revalidate();
        this.m_scrollList.repaint();
        this.m_parent.setStartingValue(this.getCLString());
    }

    int getLongestLabelWidth() {
        int n = 0;
        int n2 = this.m_qualNames.size();
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            Object e = this.m_qualNames.elementAt(i);
            if (e instanceof ClQual) {
                n3 = ((ClQual)e).getLongestLabelWidth() + 21;
                if (n3 <= n) continue;
                n = n3;
                continue;
            }
            MessageLog.logError((Object)"CP: Object not ClQual type");
        }
        return n;
    }

    boolean verify() {
        return this.verify(true);
    }

    boolean verify(int n) {
        if (n > 0) {
            return this.verify(false);
        }
        return this.verify(true);
    }

    boolean verify(boolean bl) {
        Object object;
        int n;
        if (!this.m_bVisible) {
            return true;
        }
        int n2 = this.m_qualNames.size();
        boolean bl2 = false;
        for (n = 0; n < n2; ++n) {
            object = this.m_qualNames.elementAt(n);
            if (object instanceof ClQual) {
                if (((ClQual)object).getText().equals("")) continue;
                if (!((ClQual)object).verify(0, this.m_bVisible, true)) {
                    return false;
                }
                if (n != 0) continue;
                bl2 = true;
                continue;
            }
            MessageLog.logError((Object)"CP: Object not ClQual type");
        }
        if (bl) {
            n = this.m_listData.size();
            if (bl2) {
                ++n;
            }
            if (n < this.m_parent.getMin()) {
                object = this.m_parent;
                while (!(object instanceof ClParm)) {
                    object = ((ClNode)object).getParent();
                }
                this.m_parent.getPanel().displayAS400Message(71, (Object)((ClParm)object).getKwd());
                this.assignFocus();
                return false;
            }
            object = this.getQualifiedName();
        }
        return true;
    }

    String getCLString() {
        String string = "";
        int n = this.m_listData.size();
        string = this.getQualifiedName();
        String string2 = this.getDefaultQualifiedName();
        if (string2.equals(string)) {
            if (!(this.m_parent instanceof ClElem)) {
                string = "";
            } else {
                String string3 = ((ClQual)this.m_qualNames.elementAt(0)).getText();
                if (string3.equals(((ClElem)this.m_parent).getDft())) {
                    string = "";
                }
            }
        }
        int n2 = this.m_qualNames.size();
        String string4 = null;
        for (int i = 0; i < n2; ++i) {
            Object e = this.m_qualNames.elementAt(i);
            if (!(e instanceof ClQual)) continue;
            string4 = ((ClQual)e).getText();
            break;
        }
        if (this.isSingleValue(string4)) {
            return string4;
        }
        String string5 = "";
        for (int i = 0; i < n; ++i) {
            string5 = string5 + this.m_listData.elementAt(i) + " ";
        }
        string = string5 + string;
        return string.trim();
    }

    String getCompareValue() {
        int n;
        int n2;
        String string;
        String string2 = null;
        int n3 = this.m_listData.size();
        string2 = this.getQualifiedName();
        string2 = string2.trim();
        if (n3 != 0 && !this.isSingleValue(string2)) {
            string2 = (String)this.m_listData.firstElement();
        }
        if ((string = this.getDefaultQualifiedName().toUpperCase(Locale.ENGLISH)).equals(string2)) {
            return "";
        }
        if (string2 != null && (n2 = string2.indexOf(47)) != -1 && (n = (string2 = string2.substring(n2 + 1, string2.length())).indexOf(47)) != -1) {
            string2 = string2.substring(n + 1, string2.length());
        }
        return string2;
    }

    protected String getQualifiedName() {
        String string = "";
        int n = this.m_qualNames.size() - 1;
        boolean bl = false;
        for (int i = n; i >= 0; --i) {
            Object e = this.m_qualNames.elementAt(i);
            if (e instanceof ClQual) {
                String string2 = ((ClQual)e).getText();
                String string3 = ((ClQual)e).getDft();
                if (string3 == null) {
                    string3 = "";
                }
                if (!string2.equals(string3) || bl) {
                    if (bl && !string.equals("")) {
                        string = string + "/";
                    }
                    if (string2.equals("") && bl) {
                        string2 = this.isSingleValue(((ClQual)e).getDft()) && i == 0 ? "*N" : ((ClQual)e).getDft();
                    }
                    if (string2 == null) {
                        string2 = "*N";
                    }
                    if (!ClSyntax.quoted(string2 = string2.trim())) {
                        string2 = string2.toUpperCase(Locale.ENGLISH);
                    }
                    string = string + string2;
                    if (!string2.equals("")) {
                        bl = true;
                    }
                }
                if (i != 0) continue;
                if (string.equals("")) {
                    return string2;
                }
                if (!string.equals("*N")) continue;
                return "";
            }
            MessageLog.logError((Object)"CP: Object not ClQual type");
        }
        return string;
    }

    protected String getDefaultQualifiedName() {
        int n;
        String string = "";
        String string2 = null;
        for (int i = n = this.m_qualNames.size() - 1; i >= 0; --i) {
            Object e = this.m_qualNames.elementAt(i);
            if (e instanceof ClQual) {
                if (i != n && !string.equals("")) {
                    string = string + "/";
                }
                if ((string2 = ((ClQual)e).getDft()) != null) {
                    string = string + string2;
                    continue;
                }
                if (i == n || string.equals("")) continue;
                string = string + "*N";
                continue;
            }
            MessageLog.logError((Object)"CP: Object not ClQual type");
        }
        return string;
    }

    public void setVisible(boolean bl) {
        int n;
        this.m_bVisible = bl;
        for (int i = n = this.m_qualNames.size() - 1; i >= 0; --i) {
            Object e = this.m_qualNames.elementAt(i);
            if (e instanceof ClQual) {
                ((ClQual)e).setVisible(bl);
                continue;
            }
            MessageLog.logError((Object)"CP: Object not ClQual type");
        }
        if (this.m_add != null) {
            this.m_add.setVisible(bl);
            this.m_remove.setVisible(bl);
            this.m_scrollList.setVisible(bl);
            this.m_moveup.setVisible(bl);
            this.m_movedown.setVisible(bl);
        }
    }

    void blankControls() {
        this.blankControls(true);
    }

    void blankControls(boolean bl) {
        int n;
        for (int i = n = this.m_qualNames.size() - 1; i >= 0; --i) {
            Object e = this.m_qualNames.elementAt(i);
            if (e instanceof ClQual) {
                ((ClQual)e).blankControls();
                continue;
            }
            MessageLog.logError((Object)"CP: Object not ClQual type");
        }
        if (this.m_list != null && bl) {
            this.m_listData.removeAllElements();
            this.m_list.setListData(this.m_listData);
            this.m_scrollList.revalidate();
            this.m_scrollList.repaint();
        }
        this.validateControls();
    }

    void refresh() {
        this.blankControls();
        int n = this.m_qualNames.size();
        for (int i = 0; i < n; ++i) {
            Object e = this.m_qualNames.elementAt(i);
            if (e instanceof ClQual) {
                ((ClQual)e).refresh();
                continue;
            }
            MessageLog.logError((Object)"CP: Object not ClQual type");
        }
    }

    public void changedUpdate(DocumentEvent documentEvent) {
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.documentChanged();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.documentChanged();
    }

    public void documentChanged() {
        class Me
        implements Runnable {
            Me() {
            }

            public void run() {
                ClQualListPanel.this.validateControls();
            }
        }
        SwingUtilities.invokeLater(new Me());
    }

    void assignFocus() {
        int n = this.m_qualNames.size();
        if (n > 0) {
            ((ClQual)this.m_qualNames.firstElement()).assignFocus();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("Add")) {
            if (this.m_add == null || !this.m_add.isEnabled()) {
                return;
            }
            if (!this.verify(false)) {
                return;
            }
            String string2 = this.getQualifiedName();
            if (string2 != null && !string2.equals("")) {
                this.blankControls(false);
                int n = this.m_list.getSelectedIndex();
                if (this.m_listData.size() == 0 || n == -1) {
                    this.m_listData.addElement(string2);
                } else {
                    this.m_listData.insertElementAt(string2, n + 1);
                }
                this.m_list.setListData(this.m_listData);
                if (this.m_listData.size() == 1 || n == -1) {
                    this.m_list.setSelectedIndex(this.m_listData.size() - 1);
                } else {
                    this.m_list.setSelectedIndex(n + 1);
                }
                this.m_list.ensureIndexIsVisible(this.m_list.getSelectedIndex());
                this.m_scrollList.revalidate();
                this.m_scrollList.repaint();
                this.validateControls();
            }
            this.assignFocus();
        } else if (string.equals("Remove")) {
            int n = this.m_listData.size();
            ListSelectionModel listSelectionModel = this.m_list.getSelectionModel();
            int n2 = listSelectionModel.getMaxSelectionIndex();
            if (n2 == -1) {
                return;
            }
            ++n2;
            for (int i = n; i >= 0; --i) {
                if (!listSelectionModel.isSelectedIndex(i)) continue;
                --n2;
                this.m_listData.removeElementAt(i);
            }
            this.m_list.setListData(this.m_listData);
            n = this.m_listData.size();
            if (n2 >= n) {
                n2 = n - 1;
            }
            if (n2 >= 0) {
                this.m_list.setSelectedIndex(n2);
                this.m_list.ensureIndexIsVisible(this.m_list.getSelectedIndex());
            }
            this.m_scrollList.revalidate();
            this.m_scrollList.repaint();
            this.validateControls();
            this.m_remove.requestFocus();
        } else if (string.equals("MoveUp")) {
            int n = this.m_list.getSelectedIndex();
            if (n == -1 || n == 0) {
                return;
            }
            Object e = this.m_listData.elementAt(n);
            this.m_listData.removeElementAt(n);
            this.m_listData.insertElementAt(e, n - 1);
            this.m_list.setListData(this.m_listData);
            this.m_list.setSelectedIndex(n - 1);
            this.m_list.ensureIndexIsVisible(this.m_list.getSelectedIndex());
            this.m_scrollList.revalidate();
            this.m_scrollList.repaint();
            this.validateControls();
            this.m_moveup.requestFocus();
        } else if (string.equals("MoveDown")) {
            int n = this.m_list.getSelectedIndex();
            if (n == -1 || n == this.m_listData.size() - 1) {
                return;
            }
            Object e = this.m_listData.elementAt(n);
            this.m_listData.removeElementAt(n);
            this.m_listData.insertElementAt(e, n + 1);
            this.m_list.setListData(this.m_listData);
            this.m_list.setSelectedIndex(n + 1);
            this.m_list.ensureIndexIsVisible(this.m_list.getSelectedIndex());
            this.m_scrollList.revalidate();
            this.m_scrollList.repaint();
            this.validateControls();
            this.m_movedown.requestFocus();
        }
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        if (bl) {
            this.validateControls();
        } else {
            int n = this.m_qualNames.size();
            for (int i = 0; i < n; ++i) {
                ((ClQual)this.m_qualNames.elementAt(i)).setEnabled(false);
            }
            if (this.m_list != null) {
                this.m_add.setEnabled(false);
                this.m_moveup.setEnabled(false);
                this.m_movedown.setEnabled(false);
                this.m_remove.setEnabled(false);
                this.m_list.setEnabled(false);
            }
        }
    }

    void validateControls() {
        if (!this.isEnabled()) {
            return;
        }
        boolean bl = true;
        if (this.m_listData.size() >= this.m_max) {
            bl = false;
        }
        if (this.m_add != null) {
            this.m_add.setEnabled(bl);
        }
        int n = this.m_qualNames.size();
        for (int i = 0; i < n; ++i) {
            ((ClQual)this.m_qualNames.elementAt(i)).setEnabled(bl);
        }
        if (this.m_list != null && this.m_list.getSelectedIndex() != -1) {
            if (this.m_list.getSelectedIndex() != 0) {
                this.m_moveup.setEnabled(this.m_listData.size() > 1);
            } else {
                this.m_moveup.setEnabled(false);
            }
            if (this.m_list.getSelectedIndex() != this.m_listData.size() - 1) {
                this.m_movedown.setEnabled(this.m_listData.size() > 1);
            } else {
                this.m_movedown.setEnabled(false);
            }
            if (this.m_listData.size() > 0) {
                this.m_remove.setEnabled(true);
            }
        } else if (this.m_list != null) {
            this.m_moveup.setEnabled(false);
            this.m_movedown.setEnabled(false);
            this.m_remove.setEnabled(false);
        }
        if (this.m_list != null) {
            this.m_list.setEnabled(true);
        }
        n = this.m_qualNames.size();
        String string = null;
        for (int i = 0; i < n; ++i) {
            Object e = this.m_qualNames.elementAt(i);
            if (!(e instanceof ClQual)) continue;
            boolean bl2 = true;
            bl2 = this.m_listData.size() == 0;
            string = ((ClQual)e).getText(bl2);
            break;
        }
        if (string.equals("") && this.m_add != null) {
            this.m_add.setEnabled(false);
        }
        this.checkSingleValues(string);
    }

    void checkSingleValues(String string) {
        if (this.m_sngValues == null) {
            return;
        }
        if (this.isSingleValue(string)) {
            if (this.m_list != null) {
                this.m_list.setEnabled(false);
                this.m_add.setEnabled(false);
                this.m_remove.setEnabled(false);
                this.m_moveup.setEnabled(false);
                this.m_movedown.setEnabled(false);
            }
            int n = this.m_qualNames.size();
            for (int i = 1; i < n; ++i) {
                ((ClQual)this.m_qualNames.elementAt(i)).setEnabled(false);
            }
        } else if (this.m_listData.size() > 0 && this.m_list != null) {
            this.m_list.setEnabled(true);
        }
    }

    boolean isSingleValue(String string) {
        if (this.m_sngValues == null) {
            return false;
        }
        Vector vector = this.m_sngValues.getStrings();
        if (string != null) {
            string = string.toUpperCase(Locale.ENGLISH);
            string = string.trim();
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                if (!string.equals(vector.elementAt(i)) || !this.m_sngValues.isOriginalParentSingleValue(i)) continue;
                return true;
            }
        }
        return false;
    }

    public void addKeyListener(KeyListener keyListener) {
        int n = this.m_qualNames.size();
        for (int i = 0; i < n; ++i) {
            ((ClQual)this.m_qualNames.elementAt(i)).addKeyListener(keyListener);
        }
    }

    void addDocumentListener(DocumentListener documentListener) {
        int n = 0;
        int n2 = this.m_qualNames.size();
        if (n < n2) {
            ((ClQual)this.m_qualNames.elementAt(n)).addDocumentListener(documentListener);
        }
    }

    void addItemListener(ItemListener itemListener) {
        int n = 0;
        int n2 = this.m_qualNames.size();
        if (n < n2) {
            ((ClQual)this.m_qualNames.elementAt(n)).addItemListener(itemListener);
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.validateControls();
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.validateControls();
    }

    void addAddButton(ClPanel clPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 16;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 7, 0, 7);
        clPanel.add((Component)this.m_add, gridBagConstraints);
    }

    void addRemoveButton(ClPanel clPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(3, 7, 0, 7);
        clPanel.add((Component)this.m_remove, gridBagConstraints);
    }

    boolean canUserAdd() {
        if (this.m_add == null) {
            return false;
        }
        return this.m_add.isEnabled();
    }

    private static String getCopyright() {
        return "(C)Copyright IBM Corp. 1998, 1999";
    }
}

