/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.widgets;

import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.inject.Inject;
import miworkplace.ui.jobs.JobStatusControl;
import miworkplace.ui.widgets.EditorPositionControl;
import miworkplace.ui.widgets.FileAccessModeControl;
import miworkplace.ui.widgets.FixedTypeFieldName;
import miworkplace.ui.widgets.StatusBarOverwriteControl;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.UISynchronize;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.osgi.service.log.LogService;

public class StatusBar {
    @Inject
    private LogService logger;
    @Inject
    private UISynchronize sync;
    @Inject
    private IEventBroker eventBroker;
    private EditorPositionControl editorPosition;
    private FixedTypeFieldName fieldName;
    private StatusBarOverwriteControl overwriteMode;

    @PostConstruct
    public void createControls(Composite parent, IEclipseContext context) {
        Composite root = new Composite(parent, 0);
        GridLayout layout = new GridLayout(5, false);
        layout.horizontalSpacing = 1;
        root.setLayout((Layout)layout);
        int tst = 0;
        this.fieldName = new FixedTypeFieldName(root, 0x4000 | tst).setEventBroker(this.eventBroker);
        this.fieldName.setLayoutData(GridDataFactory.fillDefaults().grab(true, false).hint(150, -1).create());
        this.overwriteMode = new StatusBarOverwriteControl(root, 0x1000000 | tst).setEventBroker(this.eventBroker);
        this.overwriteMode.setLayoutData(GridDataFactory.fillDefaults().grab(true, false).hint(75, -1).create());
        this.editorPosition = new EditorPositionControl(root, 0x1000000 | tst).setEventBroker(this.eventBroker);
        this.editorPosition.setLayoutData(GridDataFactory.fillDefaults().grab(true, false).hint(75, -1).create());
        FileAccessModeControl fileAccessMode = new FileAccessModeControl(root, 0x1000000 | tst).setEventBroker(this.eventBroker);
        fileAccessMode.setLayoutData(GridDataFactory.fillDefaults().grab(true, false).hint(80, 0xFFFFFFFF | tst).create());
        IEclipseContext subContext = context.createChild();
        subContext.set(Composite.class, (Object)root);
        JobStatusControl jobStatusControl = (JobStatusControl)ContextInjectionFactory.make(JobStatusControl.class, (IEclipseContext)subContext);
        jobStatusControl.setLayoutData(GridDataFactory.fillDefaults().align(0x1000008, 0x1000000).create());
    }

    @PreDestroy
    public void dispose() {
        if (this.editorPosition != null && !this.editorPosition.getControl().isDisposed()) {
            this.editorPosition.dispose();
        }
        if (this.overwriteMode != null && !this.overwriteMode.getControl().isDisposed()) {
            this.overwriteMode.dispose();
        }
    }
}

