/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.widgets;

import java.util.LinkedList;
import java.util.Queue;
import miworkplace.ui.widgets.GifCLabel;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.e4.ui.di.UISynchronize;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.osgi.service.log.LogService;

public class ProgressControl
implements IJobChangeListener {
    private Queue<String> queue = new LinkedList<String>();
    private GifCLabel label;
    private LogService logger;
    private UISynchronize uiSync;

    public ProgressControl(Composite parent, int style) {
        this.label = new GifCLabel(parent, style);
        this.label.setVisible(false);
        this.label.setGifImage(this.getClass().getResourceAsStream("/icons/progress.gif"));
        Job.getJobManager().addJobChangeListener((IJobChangeListener)this);
    }

    public void dispose() {
        Job.getJobManager().removeJobChangeListener((IJobChangeListener)this);
    }

    public void done(IJobChangeEvent event) {
        if (event.getJob().isSystem()) {
            return;
        }
        this.logger.log(4, "Event job change (done): " + event.getJob().getName());
        this.queue.remove(event.getJob().getName());
        this.updateUi();
    }

    public void running(IJobChangeEvent event) {
        if (event.getJob().isSystem()) {
            return;
        }
        this.logger.log(4, "Event job change (start): " + event.getJob().getName());
        this.queue.add(event.getJob().getName());
        this.updateUi();
    }

    public void scheduled(IJobChangeEvent event) {
    }

    public void sleeping(IJobChangeEvent event) {
    }

    public void aboutToRun(IJobChangeEvent event) {
    }

    public void awake(IJobChangeEvent event) {
    }

    public void setLayoutData(Object data) {
        this.label.setLayoutData(data);
    }

    public Control getControl() {
        return this.label;
    }

    public void updateUi() {
        this.logger.log(4, "Task queue size " + this.queue.size());
        if (this.getControl().isDisposed() || this.getControl().getDisplay().isDisposed()) {
            return;
        }
        this.getUiSync().syncExec(new Runnable(){

            @Override
            public void run() {
                if (ProgressControl.this.queue.isEmpty()) {
                    ProgressControl.this.label.setVisible(false);
                } else {
                    if (ProgressControl.this.label.isDisposed()) {
                        return;
                    }
                    ProgressControl.this.label.setVisible(true);
                    ProgressControl.this.label.setText(ProgressControl.this.queue.peek());
                    ProgressControl.this.logger.log(4, "Showing task: " + ProgressControl.this.queue.peek());
                }
            }
        });
    }

    public UISynchronize getUiSync() {
        return this.uiSync;
    }

    public void setUiSync(UISynchronize uiSync) {
        this.uiSync = uiSync;
    }

    public LogService getLogger() {
        return this.logger;
    }

    public void setLogger(LogService logger) {
        this.logger = logger;
    }
}

