/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.widgets;

import miworkplace.ui.api.IEditor;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class FileAccessModeControl
implements EventHandler {
    private CLabel label;

    public FileAccessModeControl(Composite parent, int style) {
        this.label = new CLabel(parent, style);
    }

    public FileAccessModeControl setEventBroker(IEventBroker eventBroker) {
        eventBroker.subscribe("miworkplace/ui/editor/closed", (EventHandler)this);
        eventBroker.subscribe("miworkplace/ui/editor/focus/gained", (EventHandler)this);
        eventBroker.subscribe("miworkplace/ui/editor/focus/lost", (EventHandler)this);
        return this;
    }

    public void setLayoutData(Object data) {
        this.label.setLayoutData(data);
    }

    public void dispose() {
    }

    public Control getControl() {
        return this.label;
    }

    public void handleEvent(Event event) {
        if (event.getTopic().equals("miworkplace/ui/editor/focus/gained")) {
            IEditor editor = (IEditor)event.getProperty("org.eclipse.e4.data");
            this.updateLabel(editor.isReadOnly() ? Mode.Readonly : Mode.Editable);
        } else if (event.getTopic().equals("miworkplace/ui/editor/focus/lost")) {
            this.clearLabel();
        } else if (event.getTopic().equals("miworkplace/ui/editor/closed")) {
            this.clearLabel();
        }
    }

    private void clearLabel() {
        if (!this.label.isDisposed()) {
            this.label.setText("");
        }
    }

    private void updateLabel(Mode mode) {
        if (!this.label.isDisposed()) {
            this.label.setText(mode.description());
        }
    }

    private static enum Mode {
        Editable("Editable"),
        Readonly("Read only");

        private final String description;

        private Mode(String description) {
            this.description = description;
        }

        String description() {
            return this.description;
        }
    }
}

