/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.util;

import jakarta.inject.Inject;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Scanner;
import miworkplace.common.debug.Debug;
import miworkplace.common.debug.Option;
import miworkplace.i18n.Messages;
import miworkplace.ui.Constants;
import miworkplace.ui.api.WorkspaceUtil;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.extensions.Preference;
import org.eclipse.e4.ui.di.UISynchronize;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.osgi.framework.Version;

public class VersionChecker
extends Job {
    private static final String VERSION_URL = "https://miworkplace.com/version.txt?cacheFrom=now";
    @Inject
    private UISynchronize uiSync;
    private Debug logger = Debug.getInstance();
    @Inject
    private IEclipseContext fContext;
    @Inject
    @Preference(nodePath="miworkplace.application")
    private IEclipsePreferences applicationPreferences;

    public VersionChecker() {
        super(Messages.ui_version_title);
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            HttpURLConnection connection;
            Object proxy;
            if (this.applicationPreferences.getBoolean("miworkplace.ui.general.network.http.proxy", false)) {
                proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(this.applicationPreferences.get("miworkplace.ui.general.network.http.proxy.host", "localhost"), this.applicationPreferences.getInt("miworkplace.ui.general.network.http.proxy.port", 3128)));
                connection = (HttpURLConnection)new URL(VERSION_URL).openConnection((Proxy)proxy);
            } else {
                connection = (HttpURLConnection)new URL(VERSION_URL).openConnection();
            }
            connection.setDefaultUseCaches(false);
            connection.setUseCaches(false);
            connection.setRequestProperty("Cache-Control", "no-cache");
            try {
                proxy = null;
                Object var4_7 = null;
                try (Scanner scanner = new Scanner(connection.getInputStream());){
                    Version webVersion = new Version(scanner.nextLine());
                    int rc = this.compare(webVersion, Constants.VERSION);
                    if (rc > 0) {
                        this.uiSync.asyncExec(() -> {
                            int button = MessageDialog.open((int)2, (Shell)Display.getCurrent().getActiveShell(), (String)Messages.ui_version_title, (String)String.format(Messages.ui_version_check, webVersion.toString()), (int)0x10000000, (String[])new String[]{Messages.ui_version_updte, Messages.ui_version_later, Messages.ui_what_is_new});
                            if (button == 0) {
                                WorkspaceUtil.runCommand("org.eclipse.equinox.p2.ui.sdk.update", this.fContext);
                            }
                            if (button == 2) {
                                Program.launch((String)"https://remainsoftware.com/docs/miworkplace/help/index.jsp#topic/miworkplace.help/manuals/html/MiWorkplace/NaN/NaN.html");
                                this.run(monitor);
                            }
                        });
                    }
                }
                catch (Throwable throwable) {
                    if (proxy == null) {
                        proxy = throwable;
                    } else if (proxy != throwable) {
                        ((Throwable)proxy).addSuppressed(throwable);
                    }
                    throw proxy;
                }
            }
            catch (Exception e) {
                this.logger.error("Could not compare versions.", (Throwable)e);
            }
        }
        catch (Exception e) {
            this.logger.error("Could establish connection to miworkplace.com", (Throwable)e);
        }
        return Status.OK_STATUS;
    }

    private int compare(Version webVersion, Version currentVersion) {
        this.logger.debug((Option)miworkplace.ui.debug.Option.lifeCycle, MessageFormat.format("Version compare: {0} - {1}", webVersion, currentVersion));
        if (webVersion.equals((Object)currentVersion)) {
            return 0;
        }
        if (webVersion.getMajor() > currentVersion.getMajor()) {
            return 1;
        }
        if (webVersion.getMajor() < currentVersion.getMajor()) {
            return 0;
        }
        if (webVersion.getMinor() > currentVersion.getMinor()) {
            return 1;
        }
        if (webVersion.getMinor() < currentVersion.getMinor()) {
            return 0;
        }
        if (webVersion.getMicro() > currentVersion.getMicro()) {
            return 1;
        }
        return 0;
    }
}

