/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.util;

import com.ibm.as400.access.QSYSObjectPathName;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import miworkplace.common.ObjectNotFoundException;
import miworkplace.common.debug.Debug;
import miworkplace.common.debug.Option;
import miworkplace.common.model.IRemoteObject;
import miworkplace.common.model.IWorkspaceStore;
import miworkplace.common.model.SourceMember;
import miworkplace.connection.api.IConnectionUtilities;
import miworkplace.i18n.Messages;
import miworkplace.notifications.Notifier;
import miworkplace.services.api.IObjectPropertiesStore;
import miworkplace.services.api.ObjectProperty;
import miworkplace.ui.Constants;
import miworkplace.ui.api.WorkspaceUtil;
import miworkplace.ui.explorer.MemberDescription;
import miworkplace.ui.explorer.MemberList;
import org.apache.commons.codec.binary.Hex;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.UISynchronize;

public class MemberLoader
extends Job {
    private Debug logger = Debug.getInstance();
    @Inject
    private UISynchronize sync;
    @Inject
    private IEclipseContext context;
    @Inject
    private IConnectionUtilities connUtil;
    @Inject
    private IEventBroker eventBroker;
    @Inject
    private IWorkspaceStore workspaceStore;
    @Inject
    private IObjectPropertiesStore objectPropertiesStore;
    @Inject
    @Named(value="miworkplace.ui.file")
    @Optional
    private IRemoteObject file;
    private Long sourceId = -1L;

    public MemberLoader() {
        super(Messages.ui_mbrloader_job_title);
        this.setPriority(20);
    }

    public IStatus run(IProgressMonitor monitor) {
        this.logger.traceEntry((Option)miworkplace.ui.debug.Option.loading, new Object[]{monitor});
        IStatus status = this.doRun(monitor);
        this.logger.traceExit((Option)miworkplace.ui.debug.Option.loading, (Object)status);
        return status;
    }

    private IStatus doRun(IProgressMonitor pMonitor) {
        try {
            List<IRemoteObject> members = this.loadMembers(this.getFile());
            List storedMembers = this.workspaceStore.getMembers(this.getFile());
            for (IRemoteObject member : storedMembers) {
                this.workspaceStore.remove(member);
            }
            for (IRemoteObject member : members) {
                this.workspaceStore.add(member);
            }
            this.file.setChildrenLoaded(true);
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("org.eclipse.e4.data", members);
            map.put("viewerId", this.getSourceId());
            map.put("connection", this.getFile().getConnection().getName());
            map.put("path", this.getFile().getPath());
            this.eventBroker.post("miworkplace/ui/loader/member/loaded", map);
            return new Status(0, Constants.PLUGIN_ID, String.format(Messages.ui_mbrloader_job_success, this.getFile().getName()));
        }
        catch (ObjectNotFoundException onfe) {
            this.sync.asyncExec(new Runnable(){

                @Override
                public void run() {
                    MemberLoader.this.logger.error("Error loading member list of " + MemberLoader.this.getFile().getName(), (Throwable)onfe);
                    Notifier.warn((String)Messages.ui_mbrloader_notify_title, (String)onfe.getMessage());
                }
            });
            return new Status(2, Constants.PLUGIN_ID, onfe.getMessage());
        }
        catch (Exception e) {
            this.logger.error("Error loading member list of " + this.getFile().getName(), (Throwable)e);
            return new Status(4, Constants.PLUGIN_ID, String.format(Messages.ui_mbrloader_job_error, this.getFile().getName()), (Throwable)e);
        }
    }

    public List<IRemoteObject> loadMembers(IRemoteObject file) throws Exception {
        try {
            this.logger.debug((Option)miworkplace.ui.debug.Option.loading, MessageFormat.format("start: Load members of {0}", file == null ? "null" : file.getName()));
            if (!this.connUtil.doesObjectExist(file.getConnection(), file.getPath())) {
                throw new ObjectNotFoundException(String.format(Messages.ui_mbrloader_notfound, file.getName()));
            }
            ArrayList<IRemoteObject> members = new ArrayList<IRemoteObject>(100);
            MemberList memberList = new MemberList(file.getConnection().getSystem(), new QSYSObjectPathName(file.getPath()));
            memberList.addAttribute(8);
            memberList.refresh();
            MemberDescription[] memberDescriptions = memberList.getMemberDescriptions();
            this.logger.debug((Option)miworkplace.ui.debug.Option.loading, "Adding members to MiWorkplace Store.");
            MemberDescription[] memberDescriptionArray = memberDescriptions;
            int n = memberDescriptions.length;
            int n2 = 0;
            while (n2 < n) {
                MemberDescription desc = memberDescriptionArray[n2];
                Date createDate = (Date)desc.getValue(1);
                Date changeDate = (Date)desc.getValue(6);
                String createDateHex = Hex.encodeHexString((byte[])String.valueOf(createDate.getTime()).getBytes());
                String changeDateHex = Hex.encodeHexString((byte[])String.valueOf(changeDate.getTime()).getBytes());
                IFile memberFile = WorkspaceUtil.buildMemberFile(file, desc.getValue(7).toString());
                SourceMember member = new SourceMember(file.getConnection(), (IResource)memberFile, null);
                String sourceType = desc.getValue(10).toString();
                member.setSourceType(sourceType);
                member.setRawCreationDate(createDateHex);
                member.setRawChangeDate(changeDateHex);
                members.add((IRemoteObject)member);
                HashMap<ObjectProperty, Object> properties = new HashMap<ObjectProperty, Object>();
                properties.put(ObjectProperty.name, desc.getValue(7).toString());
                properties.put(ObjectProperty.rawcreationdate, createDateHex);
                properties.put(ObjectProperty.rawchangedate, changeDateHex);
                properties.put(ObjectProperty.creationdate, createDate);
                properties.put(ObjectProperty.changedate, changeDate);
                properties.put(ObjectProperty.sourcefile, file.getName());
                properties.put(ObjectProperty.sourcetype, sourceType);
                String description = desc.getValue(8).toString();
                properties.put(ObjectProperty.textdescription, description);
                if (!(this.objectPropertiesStore.get((IRemoteObject)member) != null && sourceType.equals(this.objectPropertiesStore.get((IRemoteObject)member).get(ObjectProperty.sourcetype)) && description.equals(this.objectPropertiesStore.get((IRemoteObject)member).get(ObjectProperty.textdescription)) && changeDateHex.equals(this.objectPropertiesStore.get((IRemoteObject)member).get(ObjectProperty.rawchangedate)))) {
                    this.logger.debug((Option)miworkplace.ui.debug.Option.loading, "Adding member " + member.getPath());
                    properties.put(ObjectProperty.notloaded, Boolean.TRUE);
                    this.objectPropertiesStore.put((IRemoteObject)member, properties);
                }
                ++n2;
            }
            this.logger.debug((Option)miworkplace.ui.debug.Option.loading, MessageFormat.format("end  : Load members of {0}. {1} entries found...", file == null ? "null" : file.getName(), members.size()));
            return members;
        }
        catch (Exception e) {
            this.logger.debug((Option)miworkplace.ui.debug.Option.loading, MessageFormat.format("ERROR  : Load members of {0}. Message {1}...", file == null ? "null" : file.getName(), e.getMessage()));
            throw e;
        }
    }

    public IRemoteObject getFile() {
        return this.file;
    }

    public void setFile(IRemoteObject file) {
        this.file = file;
    }

    public Long getSourceId() {
        return this.sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }

    public boolean belongsTo(Object family) {
        return this.file.getConnection().getName().equals(family);
    }
}

