/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.util;

import com.ibm.as400.access.ObjectDescription;
import com.ibm.as400.access.ObjectList;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import miworkplace.common.debug.Debug;
import miworkplace.common.debug.Option;
import miworkplace.common.model.IConnection;
import miworkplace.common.model.IWorkspaceStore;
import miworkplace.connection.api.IConnectionUtilities;
import miworkplace.i18n.Messages;
import miworkplace.notifications.Notifier;
import miworkplace.ui.Constants;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.services.events.IEventBroker;

public class LibraryLoader
extends Job {
    @Inject
    private IConnectionUtilities connUtil;
    @Inject
    private IEventBroker eventBroker;
    @Inject
    private IWorkspaceStore workspaceStore;
    @Inject
    @Optional
    private IConnection connection;
    @Inject
    @Named(value="miworkplace.ui.library")
    @Optional
    private String libraryName;
    private Debug logger = Debug.getInstance();
    private Long sourceId = -1L;

    public LibraryLoader() {
        super(Messages.ui_libloader_job_title);
        this.setPriority(20);
    }

    public IStatus run(IProgressMonitor monitor) {
        this.logger.traceEntry((Option)miworkplace.ui.debug.Option.loading, new Object[]{monitor});
        IStatus status = this.doRun(monitor);
        this.logger.traceExit((Option)miworkplace.ui.debug.Option.loading, (Object)status);
        return status;
    }

    private IStatus doRun(IProgressMonitor monitor) {
        if (this.getConnection().isConnected()) {
            monitor.beginTask(Messages.ui_libloader_task, -1);
            List<String> libraries = this.assembleLibraries(this.getConnection());
            this.workspaceStore.addLibraries(this.connection, libraries);
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("org.eclipse.e4.data", libraries);
            map.put("viewerId", this.getSourceId());
            map.put("connection", this.connection.getName());
            this.eventBroker.post("miworkplace/ui/loader/libraries/loaded", map);
            return new Status(0, Constants.PLUGIN_ID, String.format(Messages.ui_libloader_success, this.getConnection().getName()));
        }
        return new Status(4, Constants.PLUGIN_ID, Messages.ui_libloader_error);
    }

    private List<String> assembleLibraries(IConnection connection) {
        LinkedList<String> libraries = new LinkedList<String>();
        if (this.libraryName != null) {
            libraries.add(this.libraryName);
        } else if (connection.showAllLibraries()) {
            ObjectList objectList = new ObjectList(connection.getSystem(), "QSYS", "*ALL", "*LIB");
            try {
                Enumeration objectDescriptions = objectList.getObjects();
                while (objectDescriptions.hasMoreElements()) {
                    ObjectDescription objectDescription = (ObjectDescription)objectDescriptions.nextElement();
                    libraries.add(objectDescription.getName());
                }
            }
            catch (Exception e) {
                this.logger.error("Could not load list of all libraries from system.", (Throwable)e);
                Notifier.error((String)Messages.ui_libloader_notify_title, (String)Messages.ui_libloader_notify_error);
            }
        } else {
            if (connection.showLibraryList()) {
                List libraryList = this.connUtil.getLibraryList(connection);
                libraries.addAll(libraryList);
            }
            for (String lib : connection.getListedLibraries()) {
                if (libraries.contains(lib)) continue;
                libraries.add(lib);
            }
        }
        return libraries;
    }

    public IConnection getConnection() {
        return this.connection;
    }

    public void setConnection(IConnection connection) {
        this.connection = connection;
    }

    public Long getSourceId() {
        return this.sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }

    public boolean belongsTo(Object family) {
        return this.connection.getName().equals(family);
    }
}

