/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;

public final class JavaUtils {
    private JavaUtils() {
    }

    public static <T> T adapt(Object adapter, Class<T> adapterType) {
        Object value;
        if (adapterType.isInstance(adapter)) {
            return (T)adapter;
        }
        if (adapter instanceof IAdaptable) {
            Object value2;
            IAdaptable adaptable = (IAdaptable)adapter;
            if (adapterType != null && (value2 = adaptable.getAdapter(adapterType)) != null && adapterType.isInstance(value2)) {
                return (T)value2;
            }
        } else if (adapter != null && (value = Platform.getAdapterManager().loadAdapter(adapter, adapterType.getName())) != null && adapterType.isInstance(value)) {
            return (T)value;
        }
        return null;
    }

    public static <T> List<T> filter(Iterator<?> it, Class<T> expectedClass) {
        ArrayList<T> items = new ArrayList<T>();
        while (it.hasNext()) {
            Object next = it.next();
            T adapted = JavaUtils.adapt(next, expectedClass);
            if (adapted == null) continue;
            items.add(adapted);
        }
        return items;
    }

    public static int compare(Object o1, Object o2) {
        if (o1 == null && o2 == null) {
            return 0;
        }
        if (o1 != null && o2 == null) {
            return 1;
        }
        if (o1 == null && o2 != null) {
            return -1;
        }
        if (o1 instanceof Comparable) {
            Comparable c1 = (Comparable)o1;
            return c1.compareTo(o2);
        }
        if (o2 instanceof Comparable) {
            Comparable c2 = (Comparable)o2;
            return -c2.compareTo(o1);
        }
        return o1.toString().compareTo(o2.toString());
    }

    public static <T> Comparator<T> comparator() {
        return new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                return JavaUtils.compare(o1, o2);
            }
        };
    }

    public static List<String> normalizeSeparatedList(String pInput, boolean toUpper, boolean toLower) {
        if (toUpper) {
            return Arrays.asList(pInput.trim().toUpperCase().replaceAll(",", " ").trim().split(" ")).stream().filter(s -> !s.trim().isEmpty()).collect(Collectors.toList());
        }
        if (toLower) {
            return Arrays.asList(pInput.trim().toLowerCase().replaceAll(",", " ").trim().split(" ")).stream().filter(s -> !s.trim().isEmpty()).collect(Collectors.toList());
        }
        return Arrays.asList(pInput.trim().replaceAll(",", " ").trim().split(" ")).stream().filter(s -> !s.trim().isEmpty()).collect(Collectors.toList());
    }
}

