/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.useraction;

import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.StaxDriver;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import miworkplace.common.debug.Debug;
import miworkplace.common.debug.Option;
import miworkplace.extra.xstream.XStream;
import miworkplace.i18n.Messages;
import miworkplace.notifications.Notifier;
import miworkplace.ui.Constants;
import miworkplace.ui.useraction.IUserActionStore;
import miworkplace.ui.useraction.UserAction;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

public class UserActionStore
implements IUserActionStore {
    private static final String UTF_8 = "UTF-8";
    private static Debug logger = Debug.getInstance();
    private File file;

    public void activate() {
        Bundle bundle = Platform.getBundle((String)Constants.PLUGIN_ID);
        IPath bundleStateLocation = Platform.getStateLocation((Bundle)bundle);
        this.file = bundleStateLocation.append("useractions.xml").toFile();
    }

    private List<UserAction> load() {
        if (!this.file.exists()) {
            return new ArrayList<UserAction>();
        }
        XStream xstream = new XStream((HierarchicalStreamDriver)this.createSerializationDriverInstance());
        xstream.setClassLoader(this.getClass().getClassLoader());
        InputStreamReader reader = null;
        try {
            reader = new InputStreamReader((InputStream)new FileInputStream(this.file), UTF_8);
        }
        catch (Exception e) {
            logger.error((Option)miworkplace.ui.debug.Option.userActions, "Could not read user actions file " + this.file.getAbsolutePath(), (Throwable)e);
        }
        if (reader != null) {
            try {
                return (List)xstream.fromXML((Reader)reader);
            }
            catch (Exception e) {
                logger.error((Option)miworkplace.ui.debug.Option.userActions, "Could not read user actions file " + this.file.getAbsolutePath(), (Throwable)e);
                Notifier.error((String)Messages.ui_useraction_read_error_title, (String)Messages.ui_useraction_read_error);
            }
        }
        return new ArrayList<UserAction>();
    }

    private void persist(List<UserAction> actions) {
        try {
            this.file.createNewFile();
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(this.file), UTF_8);
            XStream xstream = new XStream((HierarchicalStreamDriver)this.createSerializationDriverInstance());
            xstream.setClassLoader(this.getClass().getClassLoader());
            xstream.toXML(actions, (Writer)writer);
            writer.close();
        }
        catch (Exception e) {
            logger.error((Option)miworkplace.ui.debug.Option.userActions, "Could not write user actions to " + this.file.getAbsolutePath(), (Throwable)e);
        }
    }

    @Override
    public List<UserAction> list() {
        return this.load();
    }

    @Override
    public void add(UserAction userAction) {
        List<UserAction> userActions = this.load();
        userActions.add(userAction);
        this.persist(userActions);
    }

    @Override
    public void save(List<UserAction> userActions) {
        this.persist(userActions);
    }

    @Override
    public void delete(UserAction userAction) {
        List<UserAction> actions = this.load();
        actions.remove(userAction);
        this.persist(actions);
    }

    private StaxDriver createSerializationDriverInstance() {
        return new StaxDriver();
    }
}

