/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.useraction;

import java.util.ArrayList;
import java.util.List;
import miworkplace.i18n.Messages;
import miworkplace.services.api.IActiveConnectionService;
import miworkplace.ui.themes.Colors;
import miworkplace.ui.useraction.UserAction;
import miworkplace.ui.util.Prompter;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;

public class UserActionDialog
extends TitleAreaDialog {
    private UserAction userAction;
    private Text txtName;
    private Text txtDescription;
    private Button checkBatch;
    private SourceViewer commandViewer;
    private List<UserAction> availableUserActions;
    private final boolean editMode;
    private Button fPrompt;
    private Button fValidForAll;
    private Button fValidForLibraries;
    private Button fValidForObjects;
    private Button fValidForMembers;
    private Button fValidForIFS;

    public UserActionDialog(Shell shell, UserAction userAction, List<UserAction> availableUserActions) {
        super(shell);
        this.userAction = userAction;
        this.availableUserActions = availableUserActions;
        this.editMode = userAction.getName() != null;
    }

    protected Point getInitialSize() {
        return new Point(500, 500);
    }

    protected Control createDialogArea(Composite parent) {
        if (this.userAction.getName() == null) {
            this.setTitle(Messages.ui_useraction_dialog_new_title);
            this.setMessage(Messages.ui_useraction_dialog_new_msg);
            parent.getShell().setText(Messages.ui_useraction_dialog_new_title);
        } else {
            this.setTitle(Messages.ui_useraction_dialog_edit_title);
            this.setMessage(String.format(Messages.ui_useraction_dialog_edit_msg, this.userAction.getName()));
            parent.getShell().setText(Messages.ui_useraction_dialog_edit_title);
        }
        this.setTitleImage(new Image((Device)this.getShell().getDisplay(), ((Object)((Object)this)).getClass().getResourceAsStream("/icons/useraction-wizard.png")));
        Composite p = (Composite)super.createDialogArea(parent);
        Composite controls = this.buildControls(p);
        this.initializeControls();
        return controls;
    }

    private void initializeControls() {
        this.commandViewer.setDocument((IDocument)new Document());
        if (this.userAction.getName() != null) {
            this.txtName.setText(this.userAction.getName());
            this.txtDescription.setText(this.userAction.getDescription());
            this.checkBatch.setSelection(this.userAction.isBatch());
            this.fPrompt.setSelection(this.userAction.isPrompt());
            this.fValidForAll.setSelection(this.userAction.isValidForAll());
            this.fValidForIFS.setSelection(this.userAction.isValidForIFS());
            this.fValidForLibraries.setSelection(this.userAction.isValidForLibrary());
            this.fValidForMembers.setSelection(this.userAction.isValidForMember());
            this.fValidForObjects.setSelection(this.userAction.isValidForObject());
            this.commandViewer.getDocument().set(this.userAction.getCommand());
        }
    }

    private Composite buildControls(Composite parent) {
        parent.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite controls = new Composite(parent, 0);
        controls.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.horizontalSpacing = 10;
        controls.setLayout((Layout)gridLayout);
        Label lblName = new Label(controls, 0);
        lblName.setText(Messages.ui_useraction_dialog_form_name);
        this.txtName = new Text(controls, 2048);
        GridData gridData = new GridData(4, 4, true, false);
        this.txtName.setLayoutData((Object)gridData);
        Label lblDescription = new Label(controls, 0);
        lblDescription.setText(Messages.ui_useraction_dialog_form_desc);
        this.txtDescription = new Text(controls, 2048);
        this.txtDescription.setLayoutData((Object)new GridData(4, 4, true, false));
        Label lblBatch = new Label(controls, 0);
        lblBatch.setText(Messages.ui_useraction_dialog_form_batch);
        this.checkBatch = new Button(controls, 32);
        Label lblPrompt = new Label(controls, 0);
        lblPrompt.setText(Messages.UserActionDialog_ui_prompt);
        this.fPrompt = new Button(controls, 32);
        new Label(controls, 0);
        Group group = new Group(controls, 0);
        group.setLayoutData((Object)new GridData(4, 4, true, false));
        group.setLayout((Layout)new GridLayout(5, false));
        group.setText(Messages.useraction_dialog_validfor);
        this.fValidForAll = new Button((Composite)group, 32);
        this.fValidForAll.setText(Messages.useraction_dialog_All);
        this.fValidForAll.addListener(13, e -> {
            if (this.fValidForAll.getSelection()) {
                this.fValidForLibraries.setSelection(true);
                this.fValidForObjects.setSelection(true);
                this.fValidForMembers.setSelection(true);
                this.fValidForIFS.setSelection(true);
            }
        });
        this.fValidForLibraries = new Button((Composite)group, 32);
        this.fValidForLibraries.setText(Messages.useraction_dialog_Libraries);
        this.fValidForLibraries.addListener(13, e -> {
            if (!((Button)e.widget).getSelection()) {
                this.fValidForAll.setSelection(false);
            }
        });
        this.fValidForObjects = new Button((Composite)group, 32);
        this.fValidForObjects.setText(Messages.useraction_dialog_Objects);
        this.fValidForObjects.addListener(13, e -> {
            if (!((Button)e.widget).getSelection()) {
                this.fValidForAll.setSelection(false);
            }
        });
        this.fValidForMembers = new Button((Composite)group, 32);
        this.fValidForMembers.setText(Messages.useraction_dialog_members);
        this.fValidForMembers.addListener(13, e -> {
            if (!((Button)e.widget).getSelection()) {
                this.fValidForAll.setSelection(false);
            }
        });
        this.fValidForIFS = new Button((Composite)group, 32);
        this.fValidForIFS.setText(Messages.useraction_dialog_IFS);
        this.fValidForIFS.addListener(13, e -> {
            if (!((Button)e.widget).getSelection()) {
                this.fValidForAll.setSelection(false);
            }
        });
        Label lblCommand = new Label(controls, 0);
        lblCommand.setText(Messages.ui_useraction_dialog_form_cmd);
        lblCommand.setLayoutData((Object)new GridData(16384, 128, false, false, 1, 1));
        this.commandViewer = this.buildViewer(controls);
        this.commandViewer.getTextWidget().setLayoutData((Object)new GridData(4, 4, true, true));
        this.commandViewer.getTextWidget().addListener(2, event -> {
            if (event.keyCode == 0x100000D) {
                BundleContext context = FrameworkUtil.getBundle(((Object)((Object)this)).getClass()).getBundleContext();
                ServiceReference reference = context.getServiceReference(IActiveConnectionService.class);
                IActiveConnectionService service = (IActiveConnectionService)context.getService(reference);
                context.ungetService(reference);
                String prompt = Prompter.prompt(service.getLastUsedActiveConnection(), this.commandViewer.getTextWidget().getText());
                if (prompt != null) {
                    this.commandViewer.getTextWidget().setText(prompt);
                }
            }
        });
        ControlDecoration controlDecoration = new ControlDecoration((Control)this.commandViewer.getTextWidget(), 16512);
        controlDecoration.setDescriptionText(Messages.UserActionDialog_ctrlspace_f4);
        Image image = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_CONTENT_PROPOSAL").getImage();
        controlDecoration.setImage(image);
        controlDecoration.show();
        return controls;
    }

    private SourceViewer buildViewer(Composite parent) {
        final SourceViewer viewer = new SourceViewer(parent, null, 2624);
        viewer.getTextWidget().setFont(JFaceResources.getTextFont());
        SourceViewerConfiguration configuration = new SourceViewerConfiguration(){

            public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
                ContentAssistant ca = new ContentAssistant();
                ca.setContentAssistProcessor((IContentAssistProcessor)new VariableProcessor(), "__dftl_partition_content_type");
                ca.setInformationControlCreator(new IInformationControlCreator(){

                    public IInformationControl createInformationControl(Shell parent) {
                        DefaultInformationControl informationControl = new DefaultInformationControl(parent);
                        return informationControl;
                    }
                });
                ca.setProposalSelectorForeground(Colors.instance().get(Colors.ColorDefinition.DefaultFont));
                ca.setProposalSelectorBackground(Colors.instance().get(Colors.ColorDefinition.DefaultBackground));
                return ca;
            }
        };
        viewer.configure(configuration);
        viewer.appendVerifyKeyListener(new VerifyKeyListener(){

            public void verifyKey(VerifyEvent event) {
                if (event.stateMask == 262144 && event.character == ' ') {
                    if (viewer.canDoOperation(13)) {
                        viewer.doOperation(13);
                    }
                    event.doit = false;
                }
            }
        });
        return viewer;
    }

    protected boolean isResizable() {
        return true;
    }

    protected void okPressed() {
        if (this.isValid()) {
            this.applyValues();
            super.okPressed();
        }
    }

    private void applyValues() {
        this.userAction.setName(this.txtName.getText());
        this.userAction.setDescription(this.txtDescription.getText());
        this.userAction.setBatch(this.checkBatch.getSelection());
        this.userAction.setPrompt(this.fPrompt.getSelection());
        this.userAction.setValidForAll(this.fValidForAll.getSelection());
        this.userAction.setValidForLibrary(this.fValidForLibraries.getSelection());
        this.userAction.setValidForObject(this.fValidForObjects.getSelection());
        this.userAction.setValidForMember(this.fValidForMembers.getSelection());
        this.userAction.setValidForIFS(this.fValidForIFS.getSelection());
        this.userAction.setCommand(this.commandViewer.getDocument().get());
    }

    private boolean isValid() {
        if (StringUtils.isBlank((CharSequence)this.txtName.getText())) {
            this.setErrorMessage(Messages.ui_useraction_dialog_error_name);
            return false;
        }
        if (StringUtils.isBlank((CharSequence)this.commandViewer.getTextWidget().getText())) {
            this.setErrorMessage(Messages.ui_useraction_dialog_error_cmd);
            return false;
        }
        if (!this.editMode) {
            for (UserAction availableUserAction : this.availableUserActions) {
                if (!this.txtName.getText().equals(availableUserAction.getName())) continue;
                this.setErrorMessage(Messages.ui_useraction_dialog_error_exist);
                return false;
            }
        }
        this.setErrorMessage(null);
        return true;
    }

    class RemoteExplorerVariableProposal
    implements ICompletionProposal,
    ICompletionProposalExtension {
        private String value;
        private String description;
        private int offset;

        public RemoteExplorerVariableProposal(String value, String description) {
            this.value = value;
            this.description = description;
        }

        public void apply(IDocument document) {
        }

        public Point getSelection(IDocument document) {
            return new Point(this.offset + this.value.length(), 0);
        }

        public String getAdditionalProposalInfo() {
            return this.description;
        }

        public String getDisplayString() {
            return this.value;
        }

        public Image getImage() {
            return null;
        }

        public IContextInformation getContextInformation() {
            return null;
        }

        public void apply(IDocument document, char trigger, int offset) {
            try {
                document.replace(offset, 0, this.value);
                this.offset = offset;
            }
            catch (BadLocationException badLocationException) {}
        }

        public boolean isValidFor(IDocument document, int offset) {
            return true;
        }

        public char[] getTriggerCharacters() {
            return null;
        }

        public int getContextInformationPosition() {
            return -1;
        }
    }

    class VariableProcessor
    implements IContentAssistProcessor {
        private List<ICompletionProposal> availableProposals = new ArrayList<ICompletionProposal>();

        public VariableProcessor() {
            this.availableProposals.add(new RemoteExplorerVariableProposal("${connection}", Messages.ui_useraction_dialog_ca_conn));
            this.availableProposals.add(new RemoteExplorerVariableProposal("${library}", Messages.ui_useraction_dialog_ca_library));
            this.availableProposals.add(new RemoteExplorerVariableProposal("${object}", Messages.ui_useraction_dialog_ca_object));
            this.availableProposals.add(new RemoteExplorerVariableProposal("${member}", Messages.ui_useraction_dialog_ca_member));
            this.availableProposals.add(new RemoteExplorerVariableProposal("${ifspath}", Messages.ui_useraction_dialog_ca_path));
            this.availableProposals.add(new RemoteExplorerVariableProposal("${type}", Messages.ui_useraction_dialog_ca_type));
            this.availableProposals.add(new RemoteExplorerVariableProposal("${attribute}", Messages.ui_useraction_dialog_ca_attr));
            this.availableProposals.add(new RemoteExplorerVariableProposal("${user}", Messages.ui_useraction_dialog_ca_user));
            this.availableProposals.add(new RemoteExplorerVariableProposal("${streamfile}", Messages.ui_useraction_dialog_ca_stmf));
            this.availableProposals.add(new RemoteExplorerVariableProposal("${basename}", Messages.ui_useraction_dialog_ca_basename));
        }

        public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
            return this.availableProposals.toArray(new ICompletionProposal[this.availableProposals.size()]);
        }

        public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
            return null;
        }

        public char[] getCompletionProposalAutoActivationCharacters() {
            return null;
        }

        public char[] getContextInformationAutoActivationCharacters() {
            return null;
        }

        public String getErrorMessage() {
            return null;
        }

        public IContextInformationValidator getContextInformationValidator() {
            return null;
        }
    }
}

