/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.pref;

import java.util.List;
import miworkplace.i18n.Messages;
import miworkplace.notifications.Notifier;
import miworkplace.ui.pref.api.PreferencePage;
import miworkplace.ui.useraction.IUserActionStore;
import miworkplace.ui.useraction.UserAction;
import miworkplace.ui.useraction.UserActionDialog;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;

class UserActionPreferencePage
extends PreferencePage {
    private final String title = Messages.ui_pref_useraction_name;
    private IUserActionStore userActionStore;
    private ListViewer viewer;
    private List<UserAction> userActions;
    private Button remove;
    private Button edit;

    public UserActionPreferencePage(Composite parent, IUserActionStore userActionStore) {
        super(parent, 0);
        this.userActionStore = userActionStore;
        this.setLayout((Layout)new FillLayout());
        this.userActions = userActionStore.list();
        this.init((Composite)this);
    }

    private void init(Composite parent) {
        FormToolkit toolkit = new FormToolkit(parent.getDisplay());
        Form form = toolkit.createForm(parent);
        FormLayout layout = new FormLayout();
        layout.marginHeight = 20;
        layout.marginWidth = 25;
        form.getBody().setLayout((Layout)layout);
        form.setText(this.title);
        FormData layoutData = new FormData();
        layoutData.top = new FormAttachment(0);
        layoutData.left = new FormAttachment(0);
        layoutData.right = new FormAttachment(75);
        layoutData.bottom = new FormAttachment(100);
        this.viewer = new ListViewer(form.getBody(), 2816);
        this.viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.getControl().setData("FormWidgetFactory.drawBorder", (Object)"textBorder");
        this.viewer.getControl().setLayoutData((Object)layoutData);
        this.viewer.setSorter(new ViewerSorter());
        this.viewer.setInput(this.userActions);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (event.getSelection().isEmpty()) {
                    UserActionPreferencePage.this.edit.setEnabled(false);
                    UserActionPreferencePage.this.remove.setEnabled(false);
                } else {
                    UserActionPreferencePage.this.edit.setEnabled(true);
                    UserActionPreferencePage.this.remove.setEnabled(true);
                }
            }
        });
        layoutData = new FormData();
        layoutData.top = new FormAttachment(0);
        layoutData.left = new FormAttachment((Control)this.viewer.getList(), 15);
        layoutData.right = new FormAttachment(100);
        layoutData.bottom = new FormAttachment(100);
        Composite buttonSection = toolkit.createComposite(form.getBody());
        buttonSection.setLayout((Layout)new FormLayout());
        buttonSection.setLayoutData((Object)layoutData);
        this.fillButtonSection(buttonSection, toolkit);
    }

    private void fillButtonSection(Composite detailSection, FormToolkit toolkit) {
        FormData layoutData = new FormData();
        layoutData.left = new FormAttachment(0);
        layoutData.right = new FormAttachment(100);
        Button add = toolkit.createButton(detailSection, Messages.common_add, 8);
        add.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UserAction userAction = new UserAction();
                UserActionDialog dialog = new UserActionDialog(UserActionPreferencePage.this.getShell(), userAction, UserActionPreferencePage.this.userActions);
                dialog.setBlockOnOpen(true);
                if (dialog.open() == 0) {
                    UserActionPreferencePage.this.userActions.add(userAction);
                    UserActionPreferencePage.this.viewer.refresh();
                }
            }
        });
        add.setLayoutData((Object)layoutData);
        layoutData = new FormData();
        layoutData.top = new FormAttachment((Control)add, 5);
        layoutData.left = new FormAttachment(0);
        layoutData.right = new FormAttachment(100);
        this.edit = toolkit.createButton(detailSection, Messages.common_edit, 8);
        this.edit.setEnabled(false);
        this.edit.setLayoutData((Object)layoutData);
        this.edit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)UserActionPreferencePage.this.viewer.getSelection();
                if (selection == null || selection.isEmpty()) {
                    return;
                }
                UserAction userAction = (UserAction)selection.getFirstElement();
                UserActionDialog dialog = new UserActionDialog(UserActionPreferencePage.this.getShell(), userAction, UserActionPreferencePage.this.userActions);
                dialog.setBlockOnOpen(true);
                if (dialog.open() == 0) {
                    UserActionPreferencePage.this.viewer.refresh();
                }
            }
        });
        layoutData = new FormData();
        layoutData.top = new FormAttachment((Control)this.edit, 5);
        layoutData.left = new FormAttachment(0);
        layoutData.right = new FormAttachment(100);
        this.remove = toolkit.createButton(detailSection, Messages.common_remove, 8);
        this.remove.setEnabled(false);
        this.remove.setLayoutData((Object)layoutData);
        this.remove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)UserActionPreferencePage.this.viewer.getSelection();
                if (selection == null || selection.isEmpty()) {
                    return;
                }
                List selectedUserActions = selection.toList();
                UserActionPreferencePage.this.userActions.removeAll(selectedUserActions);
                UserActionPreferencePage.this.viewer.refresh();
            }
        });
    }

    public boolean isValid() {
        return true;
    }

    public void save(IEclipsePreferences preferences) {
        try {
            this.userActionStore.save(this.userActions);
        }
        catch (Exception e) {
            Notifier.error((String)Messages.ui_pref_useraction_error_title, (String)String.format(Messages.ui_pref_useraction_error, e.getMessage()));
        }
    }
}

