/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.message;

import java.util.ArrayList;
import java.util.HashMap;
import miworkplace.common.model.IConnection;
import miworkplace.i18n.Messages;
import miworkplace.ui.Constants;
import miworkplace.ui.message.JobLogMessage;
import miworkplace.ui.message.MessagesLoader;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.osgi.service.log.LogService;

public class UpdateMessagesJob
extends Job {
    private IConnection connection;
    private com.ibm.as400.access.Job job;
    private IEventBroker eventBroker;
    private LogService logger;
    private byte[] lastMessageKey;

    public UpdateMessagesJob(IConnection connection, com.ibm.as400.access.Job job, IEventBroker eventBroker, LogService logger, byte[] lastMessageKey) {
        super(String.format(Messages.ui_message_update_title, job.toString()));
        this.connection = connection;
        this.job = job;
        this.eventBroker = eventBroker;
        this.logger = logger;
        this.lastMessageKey = lastMessageKey;
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            ArrayList<JobLogMessage> messages = new ArrayList<JobLogMessage>();
            MessagesLoader messagesLoader = new MessagesLoader(messages, this.connection, this.job, this.lastMessageKey);
            messagesLoader.run();
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("job", this.job.toString());
            data.put("connection", this.connection.getName());
            data.put("messages", messages);
            this.eventBroker.send("miworkplace/ui/jobs/messages/retrieved", data);
            return Status.OK_STATUS;
        }
        catch (Exception e) {
            this.logger.log(1, "Could not get messages for job " + this.job.toString());
            return new Status(4, Constants.PLUGIN_ID, e.getMessage(), (Throwable)e);
        }
    }

    public boolean belongsTo(Object family) {
        return this.connection.getName().equals(family);
    }
}

