/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.message;

import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.List;
import miworkplace.common.model.IConnection;
import miworkplace.connection.api.IConnectionManager;
import miworkplace.i18n.Messages;
import miworkplace.notifications.Notifier;
import miworkplace.services.api.IActiveConnectionService;
import miworkplace.ui.Constants;
import miworkplace.ui.api.ModelUtil;
import miworkplace.ui.jobs.JobToolTipTextComposer;
import miworkplace.ui.message.JobLogMessage;
import miworkplace.ui.message.MessageView;
import miworkplace.ui.message.MessagesLoader;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.e4.core.di.extensions.Preference;
import org.eclipse.e4.ui.di.UISynchronize;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;

public class ShowMessageViewJob
extends Job {
    @Inject
    private UISynchronize sync;
    @Inject
    protected IActiveConnectionService activeConnService;
    @Inject
    protected IConnectionManager connectionManager;
    @Inject
    protected EPartService partService;
    @Inject
    protected EModelService modelService;
    @Inject
    protected MApplication application;
    @Inject
    @Preference(nodePath="miworkplace.application")
    private IEclipsePreferences applicationPreferences;
    private IConnection connection;
    private com.ibm.as400.access.Job job;
    private byte[] lastMessageKey;

    public ShowMessageViewJob(IConnection connection, com.ibm.as400.access.Job job, byte[] lastMessageKey) {
        super(String.format(Messages.ui_message_show_title, job.toString()));
        this.setPriority(20);
        this.connection = connection;
        this.job = job;
        this.lastMessageKey = lastMessageKey;
    }

    protected IStatus run(IProgressMonitor monitor) {
        final ArrayList<JobLogMessage> messages = new ArrayList<JobLogMessage>();
        MessagesLoader messagesLoader = new MessagesLoader(messages, this.connection, this.job, this.lastMessageKey);
        try {
            messagesLoader.run();
            final MPart part = this.composePart(this.connection, this.job, this.partService, messages);
            this.sync.syncExec(new Runnable(){

                @Override
                public void run() {
                    MPartStack editorPartStack = ModelUtil.getSharedPartstack(ShowMessageViewJob.this.modelService, ShowMessageViewJob.this.application);
                    if (editorPartStack != null) {
                        editorPartStack.getChildren().add(part);
                    }
                    ShowMessageViewJob.this.partService.showPart(part, EPartService.PartState.ACTIVATE);
                    MessageView view = (MessageView)part.getObject();
                    view.setJob(ShowMessageViewJob.this.job);
                    view.setConnection(ShowMessageViewJob.this.connection);
                    view.addMessages(messages);
                    if (ShowMessageViewJob.this.applicationPreferences.getBoolean("miworkplace.ui.jobs.start", false)) {
                        view.startRetriever();
                    }
                }
            });
            return Status.OK_STATUS;
        }
        catch (Exception e) {
            this.sync.syncExec(new Runnable(){

                @Override
                public void run() {
                    Notifier.error((String)Messages.ui_message_load_error_title, (String)String.format(Messages.ui_message_load_error, ShowMessageViewJob.this.job.toString()));
                }
            });
            return new Status(4, Constants.PLUGIN_ID, String.format(Messages.ui_message_load_error, this.job.toString()), (Throwable)e);
        }
    }

    private MPart composePart(IConnection connection, com.ibm.as400.access.Job job, EPartService partService, List<JobLogMessage> messages) {
        String uri = this.composeInputUri(connection, job);
        String editorPartDescriptorId = "miworkplace.ui.partdescriptor.message";
        String contributionUri = "bundleclass://miworkplace.ui/miworkplace.ui.message.MessageView";
        MPart part = partService.createPart(editorPartDescriptorId);
        part.getProperties().put("miworkplace.editor.connection", connection.getName());
        part.getProperties().put("miworkplace.editor.inputUri", uri);
        part.getProperties().put("miworkplace.view.temporary", Boolean.TRUE.toString());
        part.setLabel(job.toString());
        part.setTooltip(JobToolTipTextComposer.createToolTipText(connection, job));
        part.setContributionURI(contributionUri);
        part.getTags().add("removeOnHide");
        return part;
    }

    protected MPart getPart(IConnection connection, com.ibm.as400.access.Job job, EPartService partService) {
        String inputUri = this.composeInputUri(connection, job);
        Collection parts = partService.getParts();
        for (MPart part : parts) {
            if (!part.getProperties().containsKey("miworkplace.editor.inputUri") || !((String)part.getProperties().get("miworkplace.editor.inputUri")).equals(inputUri) || part.getObject() == null || !(part.getObject() instanceof MessageView)) continue;
            return part;
        }
        return null;
    }

    protected String encode(String s) {
        return Base64.getEncoder().encodeToString(s.getBytes());
    }

    private String composeInputUri(IConnection connection, com.ibm.as400.access.Job job) {
        return "job://" + this.encode(connection.getName()) + "/" + job.toString();
    }

    public boolean belongsTo(Object family) {
        return this.connection.getName().equals(family);
    }
}

