/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.message;

import com.ibm.as400.access.Job;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.inject.Inject;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import miworkplace.common.model.IConnection;
import miworkplace.i18n.Messages;
import miworkplace.ui.message.JobLogMessage;
import miworkplace.ui.message.MessageComparator;
import miworkplace.ui.message.MessageRetrievalInfoProvider;
import miworkplace.ui.message.MessageRetrieverThread;
import miworkplace.ui.themes.Colors;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.di.extensions.Preference;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.tools.services.IResourcePool;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;
import org.osgi.service.event.Event;
import org.osgi.service.log.LogService;

public class MessageView
implements MessageRetrievalInfoProvider {
    public static final String VIEW_ID = "miworkplace.ui.partdescriptor.message";
    @Inject
    private IEventBroker eventBroker;
    @Inject
    private LogService logger;
    @Inject
    private IResourcePool imagePool;
    @Inject
    private IEclipseContext context;
    @Inject
    @Preference(nodePath="miworkplace.application")
    private IEclipsePreferences applicationPreferences;
    @Inject
    MPart part;
    @Inject
    EPartService partService;
    @Inject
    ESelectionService selectionService;
    private boolean fInListener = false;
    private List<JobLogMessage> messages = new ArrayList<JobLogMessage>();
    private MessageViewFilter filter = new MessageViewFilter();
    private TableViewer viewer;
    private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private MessageComparator sorter = new MessageComparator();
    private Job job;
    private IConnection connection;
    private Combo id;
    private Combo type;
    private Combo severity;
    private Combo from;
    private Combo fFilterText;
    private MessageRetrieverThread retrieverThread;
    private Table ftable;
    private Composite filterPanel;

    @PostConstruct
    public void postConstruct(Composite parent) {
        parent.setLayout((Layout)new GridLayout());
        this.filterPanel = new Composite(parent, 0);
        this.buildFilter(this.filterPanel);
        Composite tvComposite = new Composite(parent, 0);
        TableColumnLayout layout = new TableColumnLayout();
        tvComposite.setLayout((Layout)layout);
        this.viewer = new TableViewer(tvComposite, 66306);
        this.composeTable(layout);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setInput(this.messages);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                MessageView.this.selectionService.setSelection((Object)event.getSelection());
            }
        });
        this.viewer.setComparator((ViewerComparator)this.sorter);
        this.viewer.setFilters(new ViewerFilter[]{this.filter});
        this.viewer.addDoubleClickListener(pEvent -> {
            MPart mPart = this.partService.showPart("miworkplace.ui.message.details", EPartService.PartState.VISIBLE);
        });
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.filterPanel);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)tvComposite);
    }

    @PreDestroy
    public void preDestroy() {
        this.stopRetriever();
    }

    private void buildFilter(Composite parent) {
        SelectionAdapter selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MessageView.this.updateFilter();
            }
        };
        this.filterPanel.setLayout((Layout)new GridLayout(4, true));
        Label labelId = new Label(parent, 0);
        labelId.setText(Messages.ui_message_filter_id);
        Label labelType = new Label(parent, 0);
        labelType.setText(Messages.ui_message_filter_type);
        Label labelSeverity = new Label(parent, 0);
        labelSeverity.setText(Messages.ui_message_filter_severity);
        Label labelFrom = new Label(parent, 0);
        labelFrom.setText(Messages.ui_message_filter_from);
        this.id = new Combo(parent, 8);
        this.id.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.id.addSelectionListener((SelectionListener)selectionListener);
        this.type = new Combo(parent, 8);
        this.type.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.type.addSelectionListener((SelectionListener)selectionListener);
        this.severity = new Combo(parent, 8);
        this.severity.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.severity.addSelectionListener((SelectionListener)selectionListener);
        this.from = new Combo(parent, 8);
        this.from.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.from.addSelectionListener((SelectionListener)selectionListener);
        Composite composite = new Composite(this.filterPanel, 0);
        composite.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 4, 1));
        GridLayout gl_composite = new GridLayout(3, false);
        gl_composite.verticalSpacing = 0;
        gl_composite.marginWidth = 0;
        gl_composite.marginHeight = 0;
        composite.setLayout((Layout)gl_composite);
        Label labelText = new Label(composite, 0);
        labelText.setText(Messages.ui_message_filter_text);
        this.fFilterText = new Combo(composite, 2048);
        this.fFilterText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.fFilterText.setSize(137, 21);
        this.fFilterText.addListener(13, e -> {
            if (this.fInListener) {
                return;
            }
            this.fInListener = true;
            this.updateFilter();
            this.fInListener = false;
        });
        this.fFilterText.addListener(1, e -> {
            if (this.fInListener) {
                return;
            }
            this.fInListener = true;
            if (e.keyCode == 13) {
                this.updateFilter();
            }
            this.fInListener = false;
        });
        ToolBar toolBar = new ToolBar(composite, 0x820000);
        toolBar.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        ToolItem apply = new ToolItem(toolBar, 0);
        ToolItem clear = new ToolItem(toolBar, 0);
        apply.setImage(this.imagePool.getImageUnchecked("IMAGE_OK_24"));
        apply.addSelectionListener((SelectionListener)selectionListener);
        apply.setToolTipText(Messages.ui_message_filter_apply);
        clear.setImage(this.imagePool.getImageUnchecked("IMAGE_CLEAR_24"));
        clear.setToolTipText(Messages.ui_message_filter_clear);
        clear.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MessageView.this.id.deselectAll();
                MessageView.this.type.deselectAll();
                MessageView.this.severity.deselectAll();
                MessageView.this.from.deselectAll();
                MessageView.this.fFilterText.setText("");
                MessageView.this.updateFilter();
            }
        });
    }

    private void composeTable(TableColumnLayout pLayout) {
        Table table = this.viewer.getTable();
        TableViewerColumn tableColumn1 = new TableViewerColumn(this.viewer, 16384);
        TableColumn col1 = tableColumn1.getColumn();
        col1.setText(Messages.ui_message_table_col1);
        pLayout.setColumnData((Widget)col1, (ColumnLayoutData)new ColumnWeightData(3));
        col1.addSelectionListener((SelectionListener)new ColumnSelectionAdapter(this.viewer, 1));
        tableColumn1.setLabelProvider((CellLabelProvider)new MessagesColumnLabelProvider(0));
        TableViewerColumn tableColumn2 = new TableViewerColumn(this.viewer, 16384);
        TableColumn col2 = tableColumn2.getColumn();
        col2.setText(Messages.ui_message_table_col2);
        pLayout.setColumnData((Widget)col2, (ColumnLayoutData)new ColumnWeightData(2));
        col2.addSelectionListener((SelectionListener)new ColumnSelectionAdapter(this.viewer, 2));
        tableColumn2.setLabelProvider((CellLabelProvider)new MessagesColumnLabelProvider(1));
        TableViewerColumn tableColumn3 = new TableViewerColumn(this.viewer, 16384);
        TableColumn col3 = tableColumn3.getColumn();
        col3.setText(Messages.ui_message_table_col3);
        pLayout.setColumnData((Widget)col3, (ColumnLayoutData)new ColumnWeightData(2));
        col3.addSelectionListener((SelectionListener)new ColumnSelectionAdapter(this.viewer, 3));
        tableColumn3.setLabelProvider((CellLabelProvider)new MessagesColumnLabelProvider(2));
        TableViewerColumn tableColumn4 = new TableViewerColumn(this.viewer, 16384);
        TableColumn col4 = tableColumn4.getColumn();
        col4.setText(Messages.ui_message_table_col4);
        pLayout.setColumnData((Widget)col4, (ColumnLayoutData)new ColumnWeightData(2));
        col4.addSelectionListener((SelectionListener)new ColumnSelectionAdapter(this.viewer, 4));
        tableColumn4.setLabelProvider((CellLabelProvider)new MessagesColumnLabelProvider(3));
        TableViewerColumn tableColumn5 = new TableViewerColumn(this.viewer, 16384);
        TableColumn col5 = tableColumn5.getColumn();
        col5.setText(Messages.ui_message_table_col5);
        pLayout.setColumnData((Widget)col5, (ColumnLayoutData)new ColumnWeightData(10));
        col5.addSelectionListener((SelectionListener)new ColumnSelectionAdapter(this.viewer, 5));
        tableColumn5.setLabelProvider((CellLabelProvider)new MessagesColumnLabelProvider(4));
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        this.viewer.setComparator((ViewerComparator)this.sorter);
    }

    @Override
    public byte[] getLastMessageKey() {
        if (this.messages.isEmpty()) {
            return null;
        }
        return this.messages.get(this.messages.size() - 1).getKey();
    }

    public void setJob(Job job) {
        this.job = job;
    }

    @Override
    public Job getJob() {
        return this.job;
    }

    public void setConnection(IConnection connection) {
        this.connection = connection;
    }

    @Override
    public IConnection getConnection() {
        return this.connection;
    }

    public void addMessages(List<JobLogMessage> messages) {
        this.messages.addAll(messages);
        this.updateFilterControls(messages);
        this.viewer.refresh();
    }

    public void startRetriever() {
        this.logger.log(3, "Starting message retriever thread for " + this.job.toString());
        if (this.retrieverThread == null) {
            IEclipseContext subcontext = this.context.createChild();
            subcontext.set(IConnection.class, (Object)this.connection);
            subcontext.set(Job.class, (Object)this.job);
            subcontext.set(MessageRetrievalInfoProvider.class, (Object)this);
            subcontext.set("retrieval.interval", (Object)this.applicationPreferences.getInt("miworkplace.ui.jobs.interval", 10));
            this.retrieverThread = (MessageRetrieverThread)ContextInjectionFactory.make(MessageRetrieverThread.class, (IEclipseContext)subcontext);
        }
        if (!this.retrieverThread.isAlive()) {
            this.retrieverThread.start();
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("connection", this.getConnection().getName());
            data.put("job", this.getJob().toString());
            this.eventBroker.send("miworkplace/ui/message/thread/start", data);
        }
    }

    public void stopRetriever() {
        if (this.job != null) {
            this.logger.log(3, "Ending message retriever thread for " + this.job.toString());
        }
        if (this.retrieverThread != null && this.retrieverThread.isAlive()) {
            this.retrieverThread.end();
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("connection", this.getConnection().getName());
            data.put("job", this.getJob().toString());
            this.eventBroker.send("miworkplace/ui/message/thread/stop", data);
            this.retrieverThread = null;
        }
    }

    public boolean isRetrieving() {
        return this.retrieverThread != null && this.retrieverThread.isAlive();
    }

    private void updateFilterControls(List<JobLogMessage> messages) {
        for (JobLogMessage message : messages) {
            if (message.id != null && this.id.indexOf(message.id) == -1) {
                this.id.add(message.id);
            }
            if (message.type != null && this.type.indexOf(message.type) == -1) {
                this.type.add(message.type);
            }
            if (message.severity != null && this.severity.indexOf(message.severity.toString()) == -1) {
                this.severity.add(message.severity.toString());
            }
            if (message.fromProgram != null && this.from.indexOf(message.fromProgram) == -1) {
                this.from.add(message.fromProgram);
            }
            if (message.fromModule == null || this.from.indexOf(message.fromModule) != -1) continue;
            this.from.add(message.fromModule);
        }
    }

    private void updateFilter() {
        this.filter.setId(this.id.getSelectionIndex() == -1 ? null : this.id.getText());
        this.filter.setType(this.type.getSelectionIndex() == -1 ? null : this.type.getText());
        this.filter.setSeverity(this.severity.getSelectionIndex() == -1 ? null : this.severity.getText());
        this.filter.setFrom(this.from.getSelectionIndex() == -1 ? null : this.from.getText());
        this.filter.setText(this.fFilterText.getText());
        this.viewer.setFilters(new ViewerFilter[]{this.filter});
        this.updateFilterCombo();
    }

    private void updateFilterCombo() {
        String text = this.fFilterText.getText();
        if (!text.trim().isEmpty()) {
            int i = 0;
            while (i < this.fFilterText.getItemCount()) {
                if (this.fFilterText.getItem(i).equals(text)) {
                    this.fFilterText.remove(i);
                }
                ++i;
            }
            this.fFilterText.add(text, 0);
            this.fFilterText.setText(text);
        }
    }

    @Inject
    @Optional
    public void notifiedMessagesRetrieved(@UIEventTopic(value="miworkplace/ui/jobs/messages/retrieved") Event event) {
        String connectionName = event.getProperty("connection").toString();
        String jobToString = event.getProperty("job").toString();
        if (this.connection.getName().equals(connectionName) && this.job.toString().equals(jobToString)) {
            List<JobLogMessage> messages = (List<JobLogMessage>)event.getProperty("messages");
            this.messages.addAll((Collection<JobLogMessage>)(messages.isEmpty() ? messages : messages.subList(1, messages.size())));
            this.updateFilterControls(messages);
            this.viewer.refresh();
        }
    }

    class ColumnSelectionAdapter
    extends SelectionAdapter {
        private final TableViewer viewer;
        private final int sortCriteria;

        public ColumnSelectionAdapter(TableViewer viewer, int sortCriteria) {
            this.viewer = viewer;
            this.sortCriteria = sortCriteria;
        }

        public void widgetSelected(SelectionEvent e) {
            if (this.viewer.getComparator() instanceof MessageComparator) {
                if (MessageView.this.sorter.getCriteria() == this.sortCriteria) {
                    MessageView.this.sorter.setCriteria(this.sortCriteria).setSortDirection(!MessageView.this.sorter.isSortDescending());
                } else {
                    MessageView.this.sorter.setCriteria(this.sortCriteria).setSortDirection(false);
                }
                this.viewer.refresh();
            }
        }
    }

    class MessageViewFilter
    extends ViewerFilter {
        private String id;
        private String type;
        private String severity;
        private String from;
        private String fFilterText;

        MessageViewFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            JobLogMessage message = (JobLogMessage)element;
            if (this.id != null && !StringUtils.defaultString((String)message.id).equals(this.id)) {
                return false;
            }
            if (this.type != null && !StringUtils.defaultString((String)message.type).equals(this.type)) {
                return false;
            }
            if (this.severity != null && message.severity != null && !message.severity.toString().equals(this.severity)) {
                return false;
            }
            if (this.from != null && !StringUtils.defaultString((String)message.fromProgram).equals(this.from) && !StringUtils.defaultString((String)message.fromModule).equals(this.from)) {
                return false;
            }
            return !StringUtils.isNotEmpty((CharSequence)this.fFilterText) || StringUtils.defaultString((String)message.message).toLowerCase().contains(this.fFilterText);
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getSeverity() {
            return this.severity;
        }

        public void setSeverity(String severity) {
            this.severity = severity;
        }

        public String getFrom() {
            return this.from;
        }

        public void setFrom(String from) {
            this.from = from;
        }

        public String getText() {
            return this.fFilterText;
        }

        public void setText(String text) {
            this.fFilterText = text.toLowerCase();
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }
    }

    class MessagesColumnLabelProvider
    extends ColumnLabelProvider {
        private int index;

        public MessagesColumnLabelProvider(int index) {
            this.index = index;
        }

        public String getText(Object element) {
            JobLogMessage message = (JobLogMessage)element;
            switch (this.index) {
                case 0: {
                    return message.date == null ? "" : MessageView.this.dateFormat.format(message.date.getTime());
                }
                case 1: {
                    return message.id;
                }
                case 2: {
                    return message.type;
                }
                case 3: {
                    return message.severity.toString();
                }
                case 4: {
                    return message.message;
                }
            }
            return "";
        }

        public Color getForeground(Object element) {
            JobLogMessage message = (JobLogMessage)element;
            if (message.severity >= 40) {
                return Colors.instance().get(Colors.ColorDefinition.Alert);
            }
            return super.getForeground(element);
        }
    }
}

