/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.jobs;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import miworkplace.i18n.Messages;
import miworkplace.notifications.Notifier;
import miworkplace.services.api.IActiveConnectionService;
import miworkplace.ui.api.IJobFilterService;
import miworkplace.ui.jobs.JobFilterDialog;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.swt.widgets.Shell;

public class ShowJobFilterDialogHandler {
    @Inject
    private IActiveConnectionService activeConnService;
    @Inject
    IJobFilterService fFilterService;

    @Execute
    public void execute(@Named(value="activeShell") Shell shell, IEclipseContext context) {
        if (this.activeConnService.getLastUsedActiveConnection() == null) {
            Notifier.info((String)Messages.ui_jobs_filter, (String)Messages.common_noactiveconnavailable);
        } else {
            JobFilterDialog dialog = (JobFilterDialog)((Object)ContextInjectionFactory.make(JobFilterDialog.class, (IEclipseContext)context));
            if (dialog.open() == 0) {
                this.fFilterService.refresh(dialog.getFilter());
            }
        }
    }
}

