/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.jobs;

import com.ibm.as400.access.Job;
import com.ibm.as400.access.QSYSObjectPathName;
import java.text.DateFormat;
import miworkplace.common.model.IConnection;
import miworkplace.i18n.Messages;
import org.apache.commons.lang3.StringUtils;

public class JobToolTipTextComposer {
    private static DateFormat localeDateFormat = DateFormat.getDateTimeInstance();

    public static String createToolTipText(IConnection connection, Job job) {
        try {
            if (job.getStatus().equals("*ACTIVE")) {
                StringBuilder sb = new StringBuilder();
                sb.append(connection.getName() + ":" + job.toString() + " : ");
                if (StringUtils.isNotEmpty((CharSequence)job.getSubsystem())) {
                    sb.append("\n" + String.format(Messages.ui_jobs_ttt_run, JobToolTipTextComposer.retrieveSubsystem(job)));
                }
                if (StringUtils.isNotEmpty((CharSequence)job.getStringValue(1004))) {
                    if (job.getJobActiveDate() != null) {
                        sb.append("\n" + String.format(Messages.ui_jobs_ttt_started_1, JobToolTipTextComposer.retrieveJobQueue(job), localeDateFormat.format(job.getJobActiveDate())));
                    } else {
                        sb.append("\n" + String.format(Messages.ui_jobs_ttt_started_2, JobToolTipTextComposer.retrieveJobQueue(job)));
                    }
                } else if (job.getJobActiveDate() != null) {
                    sb.append("\n" + String.format(Messages.ui_jobs_ttt_started_3, localeDateFormat.format(job.getJobActiveDate())));
                }
                return sb.toString();
            }
            if (job.getStatus().equals("*OUTQ")) {
                StringBuilder sb = new StringBuilder();
                sb.append(connection.getName() + ":" + job.toString());
                if (StringUtils.isNotEmpty((CharSequence)job.getSubsystem())) {
                    sb.append("\n" + String.format(Messages.ui_jobs_ttt_ran, JobToolTipTextComposer.retrieveSubsystem(job)));
                }
                if (StringUtils.isNotEmpty((CharSequence)job.getStringValue(1004))) {
                    if (job.getJobActiveDate() != null) {
                        sb.append("\n");
                        sb.append(String.format(Messages.ui_jobs_ttt_entered_1, JobToolTipTextComposer.retrieveJobQueue(job), localeDateFormat.format(job.getJobEnterSystemDate())));
                    } else {
                        sb.append("\n");
                        sb.append(String.format(Messages.ui_jobs_ttt_entered_2, JobToolTipTextComposer.retrieveJobQueue(job)));
                    }
                } else if (job.getJobEnterSystemDate() != null) {
                    sb.append("\n");
                    sb.append(String.format(Messages.ui_jobs_ttt_entered_3, localeDateFormat.format(job.getJobEnterSystemDate())));
                }
                if (job.getJobEndedDate() != null) {
                    sb.append("\n");
                    sb.append(String.format(Messages.ui_jobs_ttt_ended, localeDateFormat.format(job.getJobEndedDate())));
                }
                return sb.toString();
            }
            if (job.getStatus().equals("*JOBQ")) {
                return connection.getName() + ":" + job.toString() + " : \n" + String.format(Messages.ui_jobs_ttt_entered_1, JobToolTipTextComposer.retrieveJobQueue(job), localeDateFormat.format(job.getJobEnterSystemDate()));
            }
            return connection.getName() + ":" + job.toString();
        }
        catch (Exception exception) {
            return connection.getName() + ":" + job.toString();
        }
    }

    private static String retrieveSubsystem(Job job) throws Exception {
        QSYSObjectPathName path = new QSYSObjectPathName(job.getSubsystem());
        return path.getObjectName().trim();
    }

    private static String retrieveJobQueue(Job job) throws Exception {
        String value = job.getStringValue(1004);
        if (value.length() > 10) {
            return value.substring(0, 10).trim();
        }
        return value.trim();
    }
}

