/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.handler;

import jakarta.inject.Inject;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import miworkplace.common.model.IConnection;
import miworkplace.connection.api.IConnectionManager;
import miworkplace.i18n.Messages;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.extensions.Preference;
import org.eclipse.e4.core.services.log.Logger;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.workbench.IWorkbench;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.e4.ui.workbench.modeling.IWindowCloseHandler;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class WindowCloseHandler
implements IWindowCloseHandler {
    @Inject
    @Preference(nodePath="miworkplace.application")
    private IEclipsePreferences applicationPreferences;
    @Inject
    private IConnectionManager connectionManager;
    @Inject
    private Logger logger;
    @Inject
    private EPartService partService;
    @Inject
    private MApplication application;
    @Inject
    private IWorkbench workbench;
    QualifiedName keepAliveQualifier = new QualifiedName("miworkplace://miworkplace.services.alive", "function");

    public boolean close(MWindow window) {
        this.logger.debug("Closing application");
        boolean promptOnExit = this.applicationPreferences.getBoolean("miworkplace.ui.general.promptonexit", true);
        if (promptOnExit) {
            if (MessageDialog.openConfirm((Shell)Display.getCurrent().getActiveShell(), (String)Messages.ui_handler_close_exit_title, (String)Messages.ui_handler_close_exit_prompt)) {
                return this.close(this.workbench, Display.getCurrent().getActiveShell());
            }
            return false;
        }
        return this.close(this.workbench, Display.getCurrent().getActiveShell());
    }

    private boolean close(IWorkbench workbench, Shell shell) {
        this.logger.debug("Closing application");
        IEclipseContext activeChild = this.application.getContext().getActiveChild();
        if (this.arePartsDirty()) {
            MessageDialog dialog = new MessageDialog(shell, Messages.ui_handler_close_save_title, null, Messages.ui_handler_close_save_prompt, 3, new String[]{Messages.common_ignore, Messages.common_cancel}, 1);
            int result = dialog.open();
            if (activeChild != null) {
                activeChild.setParent(this.application.getContext());
                activeChild.activateBranch();
            }
            if (result != 0) {
                return false;
            }
        }
        Collection openParts = this.partService.getParts();
        for (MPart part : openParts) {
            if (part.getProperties().containsKey("miworkplace.editor")) {
                this.partService.hidePart(part, true);
                continue;
            }
            if (!part.getProperties().containsKey("miworkplace.view.temporary")) continue;
            this.partService.hidePart(part, true);
        }
        for (IConnection connection : this.connectionManager.list()) {
            if (!connection.isConnected()) continue;
            this.cancelKeepAliveJob(connection);
            try {
                connection.disconnect();
            }
            catch (Exception e) {
                this.logger.error("Could not disconnect connection " + connection.getName() + ". Cause: " + e.getMessage(), (Object)e);
            }
        }
        LinkedList<Job> jobs = new LinkedList<Job>();
        for (IConnection connection : this.connectionManager.list()) {
            jobs.addAll(Arrays.asList(Job.getJobManager().find((Object)connection.getName())));
        }
        boolean running = true;
        int maxWait = 10;
        while (running) {
            running = false;
            for (Job job : jobs) {
                if (job.getState() != 4 && job.getState() != 2 || "keep.alive".equals(job.getProperty(this.keepAliveQualifier))) continue;
                running = true;
                job.cancel();
                this.logger.debug("Job " + job.getName() + " still running...");
            }
            if (!running || --maxWait == 0) break;
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return true;
    }

    private void cancelKeepAliveJob(IConnection connection) {
        Job[] jobs;
        this.logger.debug("Canceling keep alive jobs for " + connection.getName());
        Job[] jobArray = jobs = Job.getJobManager().find((Object)connection.getName());
        int n = jobs.length;
        int n2 = 0;
        while (n2 < n) {
            Job job = jobArray[n2];
            Object property = job.getProperty(this.keepAliveQualifier);
            if ("keep.alive".equals(property)) {
                job.cancel();
                job.getThread().interrupt();
                break;
            }
            ++n2;
        }
    }

    public boolean arePartsDirty() {
        if (this.partService != null) {
            return !this.partService.getDirtyParts().isEmpty();
        }
        return false;
    }
}

