/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.handler;

import jakarta.inject.Inject;
import java.util.HashMap;
import miworkplace.common.model.IConnection;
import miworkplace.connection.api.IConnectionManager;
import miworkplace.i18n.Messages;
import miworkplace.notifications.Notifier;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.commands.EHandlerService;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuItem;
import org.osgi.service.log.LogService;

public class OpenRecentlyEditedHandler {
    private static final String OPEN_MEMBER_COMMAND_ID = "miworkplace.ui.command.openSourceMember";
    private static final String OPEN_STREAM_FILE_ID = "miworkplace.ui.command.ifs.open";
    private static final String OPEN_CONNECTION_ID = "miworkplace.ui.command.openConnection";
    @Inject
    private LogService logger;
    @Inject
    private ECommandService commandService;
    @Inject
    private EHandlerService handlerService;
    @Inject
    private IConnectionManager connManager;

    @Execute
    public void execute(@Optional MMenuItem menuItem) {
        String connectionName = menuItem.getTransientData().get("connection").toString();
        String path = menuItem.getTransientData().get("path").toString();
        IConnection connection = this.connManager.get(connectionName);
        if (connection == null) {
            Notifier.error((String)"", (String)Messages.ui_recently_noconn);
            return;
        }
        if (!connection.isConnected()) {
            this.openLoginDialog(connectionName);
        }
        if (!connection.isConnected()) {
            return;
        }
        this.openResource(connectionName, path);
    }

    private void openResource(String connectionName, String path) {
        String commandId = path.toUpperCase().startsWith("/QSYS.LIB/") ? OPEN_MEMBER_COMMAND_ID : OPEN_STREAM_FILE_ID;
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("miworkplace.ui.editor.command.parameter.connection", connectionName);
        parameters.put("miworkplace.ui.editor.command.parameter.selection", path);
        ParameterizedCommand command = this.commandService.createCommand(commandId, parameters);
        if (!command.getCommand().isDefined()) {
            this.logger.log(1, "Command " + commandId + " is not available. Could not open member " + path + ".");
            return;
        }
        if (!this.handlerService.canExecute(command)) {
            this.logger.log(1, "Open Member Handler cannot execute for member " + path + ".");
        } else {
            this.handlerService.executeHandler(command);
        }
    }

    private void openLoginDialog(String connectionName) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("miworkplace.ui.command.openConnection.parameter.connection", connectionName);
        ParameterizedCommand command = this.commandService.createCommand(OPEN_CONNECTION_ID, parameters);
        this.handlerService.executeHandler(command);
    }
}

