/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.explorer.wizard;

import java.util.LinkedList;
import java.util.List;
import miworkplace.common.listener.NumericVerifyListener;
import miworkplace.common.model.IConnection;
import miworkplace.common.model.IRemoteObject;
import miworkplace.common.model.IWorkspaceStore;
import miworkplace.connection.api.IConnectionManager;
import miworkplace.i18n.Messages;
import miworkplace.notifications.Notifier;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class SourceFileWizardPage
extends WizardPage {
    private Text txtFileName = null;
    private Combo cmbLibraryName = null;
    private Combo cmbConnection = null;
    private Text txtDescription = null;
    private Text txtSourceLength = null;
    private IWorkspaceStore workspaceStore;
    private IConnectionManager connectionManager;
    private String[] connectionNames;
    private IConnection connection;
    private IRemoteObject library;

    public SourceFileWizardPage(IWorkspaceStore workspaceStore, IConnectionManager connectionManager, IConnection connection, IRemoteObject library) {
        super(Messages.ui_wizard_srcf_title);
        this.workspaceStore = workspaceStore;
        this.connectionManager = connectionManager;
        this.connection = connection;
        this.library = library;
        this.setTitle(Messages.ui_wizard_srcf_title);
        this.setDescription(Messages.ui_wizard_srcf_desc);
        LinkedList<String> names = new LinkedList<String>();
        for (IConnection conn : connectionManager.list()) {
            if (!conn.isConnected()) continue;
            names.add(conn.getName());
        }
        this.connectionNames = names.toArray(new String[names.size()]);
    }

    public void createControl(Composite parent) {
        Composite controls = new Composite(parent, 0);
        FormLayout parentLayout = new FormLayout();
        parentLayout.marginHeight = 15;
        parentLayout.marginWidth = 15;
        controls.setLayout((Layout)parentLayout);
        FormData formData = new FormData();
        Label lblConnection = new Label(controls, 0);
        lblConnection.setText(Messages.ui_wizard_srcf_conn);
        lblConnection.setLayoutData((Object)formData);
        lblConnection.pack();
        formData = new FormData();
        formData.left = new FormAttachment((Control)lblConnection, 50);
        formData.bottom = new FormAttachment((Control)lblConnection, 0, 0x1000000);
        this.cmbConnection = new Combo(controls, 8);
        this.cmbConnection.setLayoutData((Object)formData);
        this.cmbConnection.setItems(this.connectionNames);
        this.cmbConnection.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IConnection connection = SourceFileWizardPage.this.connectionManager.get(SourceFileWizardPage.this.cmbConnection.getText());
                SourceFileWizardPage.this.updateLibrariesSelection(connection);
            }
        });
        this.cmbConnection.pack();
        formData = new FormData();
        formData.top = new FormAttachment((Control)lblConnection, 25);
        Label lblLibraryName = new Label(controls, 0);
        lblLibraryName.setText(Messages.ui_wizard_srcf_lib);
        lblLibraryName.setLayoutData((Object)formData);
        lblLibraryName.pack();
        formData = new FormData();
        formData.left = new FormAttachment((Control)this.cmbConnection, 0, 16384);
        formData.right = new FormAttachment(100, 0);
        formData.bottom = new FormAttachment((Control)lblLibraryName, 0, 0x1000000);
        this.cmbLibraryName = new Combo(controls, 8);
        this.cmbLibraryName.setLayoutData((Object)formData);
        this.cmbLibraryName.pack();
        formData = new FormData();
        formData.top = new FormAttachment((Control)lblLibraryName, 25);
        Label lblSourceFileName = new Label(controls, 0);
        lblSourceFileName.setText(Messages.ui_wizard_srcf_name);
        lblSourceFileName.setLayoutData((Object)formData);
        lblSourceFileName.pack();
        formData = new FormData();
        formData.left = new FormAttachment((Control)this.cmbConnection, 0, 16384);
        formData.bottom = new FormAttachment((Control)lblSourceFileName, 0, 0x1000000);
        formData.right = new FormAttachment(100, 0);
        this.txtFileName = new Text(controls, 2048);
        this.txtFileName.setLayoutData((Object)formData);
        this.txtFileName.setTextLimit(10);
        this.txtFileName.pack();
        formData = new FormData();
        formData.top = new FormAttachment((Control)lblSourceFileName, 25);
        Label lblSourceFileLength = new Label(controls, 0);
        lblSourceFileLength.setText(Messages.ui_wizard_srcf_length);
        lblSourceFileLength.setLayoutData((Object)formData);
        lblSourceFileLength.pack();
        formData = new FormData();
        formData.left = new FormAttachment((Control)this.cmbConnection, 0, 16384);
        formData.bottom = new FormAttachment((Control)lblSourceFileLength, 0, 0x1000000);
        formData.right = new FormAttachment(100, 0);
        this.txtSourceLength = new Text(controls, 2048);
        this.txtSourceLength.setLayoutData((Object)formData);
        this.txtSourceLength.setText("112");
        this.txtSourceLength.addVerifyListener((VerifyListener)new NumericVerifyListener());
        this.txtSourceLength.pack();
        formData = new FormData();
        formData.top = new FormAttachment((Control)lblSourceFileLength, 25);
        Label lblDescription = new Label(controls, 0);
        lblDescription.setText(Messages.ui_wizard_srcf_description);
        lblDescription.setLayoutData((Object)formData);
        lblDescription.pack();
        formData = new FormData();
        formData.left = new FormAttachment((Control)this.cmbConnection, 0, 16384);
        formData.bottom = new FormAttachment((Control)lblDescription, 0, 0x1000000);
        formData.right = new FormAttachment(100, 0);
        this.txtDescription = new Text(controls, 2048);
        this.txtDescription.setLayoutData((Object)formData);
        this.txtDescription.setTextLimit(50);
        this.txtDescription.pack();
        this.setControl((Control)controls);
        if (this.connection != null && this.connection.isConnected()) {
            this.cmbConnection.select(this.cmbConnection.indexOf(this.connection.getName()));
            this.updateLibrariesSelection(this.connection);
            if (this.library != null) {
                this.cmbLibraryName.select(this.cmbLibraryName.indexOf(this.library.getName()));
            }
        }
    }

    private void updateLibrariesSelection(IConnection connection) {
        List libraries = this.workspaceStore.getLibraries(connection);
        if (libraries != null) {
            String[] libraryNames = new String[libraries.size()];
            int i = 0;
            while (i < libraries.size()) {
                libraryNames[i] = ((IRemoteObject)libraries.get(i)).getName();
                ++i;
            }
            this.cmbLibraryName.setItems(libraryNames);
            this.cmbLibraryName.select(0);
        } else {
            this.cmbLibraryName.removeAll();
        }
    }

    public String getConnectionName() {
        return this.cmbConnection.getText();
    }

    public String getLibraryName() {
        return this.cmbLibraryName.getText();
    }

    public String getSourceFileName() {
        return this.txtFileName.getText().toUpperCase();
    }

    public String getDescriptionText() {
        return this.txtDescription.getText();
    }

    public int getSourceLength() {
        int length = 112;
        try {
            length = Integer.parseInt(this.txtSourceLength.getText());
        }
        catch (Exception exception) {
            Notifier.warn((String)Messages.ui_wizard_srcf_title, (String)Messages.ui_wizard_srcf_error_len);
        }
        return length;
    }
}

