/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.explorer.handler;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.HashMap;
import miworkplace.common.model.IConnection;
import miworkplace.common.model.IRemoteObject;
import miworkplace.connection.api.IConnectionManager;
import miworkplace.i18n.Messages;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.swt.widgets.Shell;

public class RemoveLibraryHandler {
    @Inject
    private IEventBroker eventAdmin;
    @Inject
    private IConnectionManager connectionManager;

    @CanExecute
    public boolean canExecute(@Named(value="org.eclipse.ui.selection") ITreeSelection selection) {
        Object firstElement;
        if (selection.size() == 1 && (firstElement = selection.getFirstElement()) instanceof IRemoteObject) {
            IRemoteObject object = (IRemoteObject)firstElement;
            if (object.getConnection().showAllLibraries()) {
                return false;
            }
            return ((IRemoteObject)firstElement).getType() == IRemoteObject.Type.library;
        }
        return false;
    }

    @Execute
    public void execute(@Named(value="activeShell") Shell shell, @Named(value="org.eclipse.ui.selection") ITreeSelection selection) {
        IRemoteObject library = (IRemoteObject)selection.getFirstElement();
        IConnection connection = library.getConnection();
        MessageDialog dialog = new MessageDialog(shell, Messages.common_dialog_confirm, null, String.format(Messages.ui_handler_remove_library_prompt, library.getName()), 3, new String[]{Messages.common_yes, Messages.common_no}, 0);
        if (dialog.open() == 0) {
            connection.removeListedLibrary(library.getName());
            this.connectionManager.update(connection);
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("org.eclipse.e4.data", connection);
            map.put("library", library);
            this.eventAdmin.post("miworkplace/connection/listed/removed", map);
        }
    }
}

