/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.explorer.handler;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import miworkplace.common.debug.Debug;
import miworkplace.common.debug.Option;
import miworkplace.common.model.IConnection;
import miworkplace.common.model.IRemoteObject;
import miworkplace.common.model.IWorkspaceStore;
import miworkplace.common.model.SourceMember;
import miworkplace.ui.api.ConnectionRule;
import miworkplace.ui.explorer.RemoteExplorer;
import miworkplace.ui.util.LibraryLoader;
import miworkplace.ui.util.MemberLoader;
import miworkplace.ui.util.ObjectLoader;
import org.eclipse.core.commands.contexts.ContextManager;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jface.bindings.BindingManager;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.TreePath;

public class RefreshHandler {
    private Debug logger = Debug.getInstance();
    @Inject
    private IEclipseContext context;
    @Inject
    private IWorkspaceStore workspaceStore;

    @CanExecute
    public boolean canExecute(@Named(value="org.eclipse.ui.selection") ITreeSelection selection, BindingManager manager, ContextManager contextManager) {
        if (selection == null) {
            return false;
        }
        return !selection.isEmpty();
    }

    @Execute
    public void execute(@Named(value="org.eclipse.ui.selection") ITreeSelection selection, EPartService partService) {
        RemoteExplorer explorer = (RemoteExplorer)partService.findPart("miworkplace.ui.explorer").getObject();
        long sourceId = explorer.getSourceId();
        TreePath[] paths = selection.getPaths();
        this.logger.info((Option)miworkplace.ui.debug.Option.loading, MessageFormat.format("Refreshing {0}", Arrays.asList(paths).toString()));
        TreePath[] treePathArray = paths;
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            TreePath path = treePathArray[n2];
            Object lastSegment = path.getLastSegment();
            if (lastSegment instanceof IConnection && ((IConnection)lastSegment).isConnected()) {
                this.loadLibraries(sourceId, lastSegment);
            } else if (lastSegment instanceof SourceMember) {
                SourceMember member = (SourceMember)lastSegment;
                member.setChildrenLoaded(false);
                this.loadMembers(sourceId, (IRemoteObject)this.workspaceStore.getSourceFile(member.getConnection(), member));
            } else if (lastSegment instanceof IRemoteObject) {
                IRemoteObject remoteObject = (IRemoteObject)lastSegment;
                remoteObject.setChildrenLoaded(false);
                switch (remoteObject.getType()) {
                    case library: {
                        this.loadObjects(sourceId, remoteObject);
                        break;
                    }
                    case file: {
                        if (remoteObject.getAttribute() != IRemoteObject.Attribute.sourcefile) break;
                        this.loadMembers(sourceId, remoteObject);
                    }
                }
            }
            ++n2;
        }
    }

    private List<IRemoteObject> getLoadedChildren(Object object) {
        IRemoteObject remoteObject;
        LinkedList<IRemoteObject> objects = new LinkedList<IRemoteObject>();
        if (object instanceof IConnection) {
            List libraries = this.workspaceStore.getLibraries((IConnection)object);
            objects.addAll(libraries);
            for (IRemoteObject library : libraries) {
                objects.addAll(this.getLoadedChildren(library));
            }
        } else if (!(object instanceof SourceMember) && object instanceof IRemoteObject && (remoteObject = (IRemoteObject)object).getType() == IRemoteObject.Type.library) {
            List subobjects = this.workspaceStore.getObjects(remoteObject);
            for (IRemoteObject ro : subobjects) {
                if (ro.getAttribute() != IRemoteObject.Attribute.sourcefile) continue;
                objects.add(ro);
            }
        }
        for (IRemoteObject ro : new LinkedList(objects)) {
            if (ro.areChildrenLoaded()) continue;
            objects.remove(ro);
        }
        return objects;
    }

    private void load(long sourceId, List<IRemoteObject> visibleObjects) {
        for (IRemoteObject remoteObject : visibleObjects) {
            this.logger.info((Option)miworkplace.ui.debug.Option.loading, "Loading " + remoteObject.getName());
            if (remoteObject.getType() == IRemoteObject.Type.library) {
                this.loadObjects(sourceId, remoteObject);
                continue;
            }
            if (remoteObject.getType() != IRemoteObject.Type.file || remoteObject.getAttribute() != IRemoteObject.Attribute.sourcefile) continue;
            this.loadMembers(sourceId, remoteObject);
        }
    }

    private void loadObjects(long sourceId, IRemoteObject library) {
        ObjectLoader loader = (ObjectLoader)((Object)ContextInjectionFactory.make(ObjectLoader.class, (IEclipseContext)this.context));
        loader.setLibrary(library);
        loader.setSourceId(sourceId);
        loader.setRule(new ConnectionRule(library.getConnection().getName()));
        loader.schedule();
    }

    private void loadMembers(long sourceId, IRemoteObject file) {
        MemberLoader memberLoader = (MemberLoader)((Object)ContextInjectionFactory.make(MemberLoader.class, (IEclipseContext)this.context));
        memberLoader.setFile(file);
        memberLoader.setSourceId(sourceId);
        memberLoader.setRule(new ConnectionRule(file.getConnection().getName()));
        memberLoader.schedule();
    }

    private void loadLibraries(long sourceId, Object lastSegment) {
        LibraryLoader loader = (LibraryLoader)((Object)ContextInjectionFactory.make(LibraryLoader.class, (IEclipseContext)this.context));
        loader.setConnection((IConnection)lastSegment);
        loader.setSourceId(sourceId);
        loader.schedule();
    }
}

