/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.explorer.handler;

import com.ibm.as400.access.QSYSObjectPathName;
import jakarta.inject.Inject;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import miworkplace.common.debug.Debug;
import miworkplace.common.model.IConnection;
import miworkplace.common.model.IRemoteObject;
import miworkplace.common.model.IWorkspaceStore;
import miworkplace.common.model.QSYSObject;
import miworkplace.common.validator.ObjectNameValidator;
import miworkplace.connection.api.IConnectionManager;
import miworkplace.connection.api.IConnectionUtilities;
import miworkplace.i18n.Messages;
import miworkplace.notifications.Notifier;
import miworkplace.services.util.ObjectHelper;
import miworkplace.ui.api.ConnectionRule;
import miworkplace.ui.api.WorkspaceUtil;
import miworkplace.ui.explorer.CopySelection;
import miworkplace.ui.util.ObjectLoader;
import org.eclipse.core.resources.IResource;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;

public class PasteObjectHandler {
    private final String TITLE = Messages.ui_handler_paste_obj_title;
    @Inject
    private IEventBroker eventBroker;
    private Debug logger = Debug.getInstance();
    @Inject
    private IEclipseContext context;
    @Inject
    private IConnectionManager connectionManager;
    @Inject
    private IConnectionUtilities connUtil;
    @Inject
    private IWorkspaceStore workspaceStore;

    public void paste(Shell shell, ESelectionService selectionService, CopySelection copySelection) {
        IConnection connection = this.connectionManager.get(copySelection.getConnectionName());
        Object selection = selectionService.getSelection();
        if (selection == null || ((ISelection)selection).isEmpty()) {
            Notifier.error((String)this.TITLE, (String)Messages.ui_handler_paste_obj_nodest);
            return;
        }
        IStructuredSelection ss = (IStructuredSelection)selection;
        Object element = ss.getFirstElement();
        IRemoteObject destLibrary = (IRemoteObject)element;
        QSYSObjectPathName destLibraryPath = new QSYSObjectPathName(destLibrary.getPath());
        if (!destLibrary.getConnection().getName().equals(connection.getName())) {
            Notifier.error((String)this.TITLE, (String)Messages.ui_handler_paste_obj_copynotsupported);
            return;
        }
        if (!destLibrary.areChildrenLoaded()) {
            ObjectLoader loader = (ObjectLoader)((Object)ContextInjectionFactory.make(ObjectLoader.class, (IEclipseContext)this.context));
            loader.setLibrary(destLibrary);
            loader.setRule(new ConnectionRule(connection.getName()));
            loader.schedule();
        }
        QSYSObjectPathName workPath = new QSYSObjectPathName(destLibrary.getName(), "DUMMY", "*FILE");
        for (String ifsPath : copySelection.getValues()) {
            try {
                QSYSObjectPathName name = new QSYSObjectPathName(ifsPath);
                String destFileName = name.getObjectName();
                if (name.getLibraryName().equals(destLibraryPath.getObjectName())) {
                    Notifier.warn((String)Messages.ui_handler_paste_obj_title, (String)Messages.ui_handler_paste_obj_samelib);
                    return;
                }
                workPath.setObjectName(name.getObjectName());
                workPath.setObjectType(name.getObjectType());
                IRemoteObject remoteObject = this.workspaceStore.get(connection, workPath.getPath());
                if (remoteObject != null) {
                    MessageDialog dialog = new MessageDialog(shell, Messages.ui_handler_paste_obj_conflict_title, null, String.format(Messages.ui_handler_paste_obj_conflict_prompt, workPath.getObjectName()), 3, new String[]{Messages.common_rename, Messages.common_overwrite, Messages.common_skip}, 0);
                    int retVal = dialog.open();
                    if (retVal == 0) {
                        List objects = this.workspaceStore.getObjects(remoteObject);
                        List<String> objectNames = this.convertToNames(objects);
                        InputDialog inputDialog = new InputDialog(shell, Messages.ui_handler_paste_obj_conflict_title, String.format(Messages.ui_handler_paste_obj_conflict_newname, workPath.getObjectName()), workPath.getObjectName(), (IInputValidator)new ObjectNameValidator(objectNames));
                        boolean running = true;
                        while (running) {
                            if (inputDialog.open() == 0) {
                                String newName = inputDialog.getValue();
                                QSYSObjectPathName path = new QSYSObjectPathName(destLibrary.getName(), newName, name.getObjectType());
                                if (this.workspaceStore.get(connection, path.getPath()) != null) continue;
                                destFileName = newName.toUpperCase();
                                running = false;
                                continue;
                            }
                            running = false;
                        }
                    } else if (retVal == 2) continue;
                }
                QSYSObjectPathName destPath = new QSYSObjectPathName(destLibrary.getName(), destFileName, name.getObjectType());
                this.connUtil.copySourceFile(connection, ifsPath, destPath.getPath());
                Notifier.info((String)this.TITLE, (String)String.format(Messages.ui_handler_paste_obj_success, destPath.getObjectName(), destPath.getLibraryName()));
                this.notifyOthers(connection, destPath.getLibraryName(), destFileName, ifsPath);
            }
            catch (Exception e) {
                this.logger.error(MessageFormat.format("Could not copy {0} into {1}.", ifsPath, workPath.getPath()), (Throwable)e);
                Notifier.error((String)this.TITLE, (String)String.format(Messages.ui_handler_paste_obj_error, ifsPath, workPath.getPath()));
            }
        }
    }

    private void notifyOthers(IConnection connection, String libraryName, String fileName, String fromIfsPath) {
        IRemoteObject library = this.workspaceStore.getLibrary(connection, libraryName);
        IResource file = WorkspaceUtil.buildObjectResource(library, fileName, IRemoteObject.Type.file);
        IRemoteObject destFile = QSYSObject.create((IConnection)connection, (IResource)file, (IRemoteObject.Type)IRemoteObject.Type.file, (String)"*FILE", (IRemoteObject.Attribute)IRemoteObject.Attribute.datafile, (String)"PF");
        if (destFile.getType() == IRemoteObject.Type.file) {
            try {
                if (ObjectHelper.isSourceFile((IRemoteObject)destFile)) {
                    destFile = QSYSObject.create((IConnection)connection, (IResource)file, (IRemoteObject.Type)IRemoteObject.Type.file, (String)"*FILE", (IRemoteObject.Attribute)IRemoteObject.Attribute.sourcefile, (String)"PF");
                    destFile.setAttribute(IRemoteObject.Attribute.sourcefile);
                } else {
                    destFile.setAttribute(IRemoteObject.Attribute.datafile);
                }
            }
            catch (Exception e) {
                this.logger.error("Error determining file type on copied objects.", (Throwable)e);
                destFile.setAttribute(IRemoteObject.Attribute.datafile);
            }
        }
        this.workspaceStore.add(destFile);
        IRemoteObject sourceFile = this.workspaceStore.get(connection, fromIfsPath);
        HashMap<String, IRemoteObject> map = new HashMap<String, IRemoteObject>();
        map.put("org.eclipse.e4.data", destFile);
        map.put("miworkplace.ui.source", sourceFile);
        this.eventBroker.post("miworkplace/object/created", map);
    }

    private List<String> convertToNames(List<IRemoteObject> objects) {
        ArrayList<String> names = new ArrayList<String>();
        for (IRemoteObject object : objects) {
            names.add(object.getName());
        }
        return names;
    }
}

