/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.explorer.handler;

import com.ibm.as400.access.IFSFile;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.IOException;
import miworkplace.common.model.IRemoteObject;
import miworkplace.common.model.IWorkspaceStore;
import miworkplace.common.model.StreamFile;
import miworkplace.connection.api.IConnectionUtilities;
import miworkplace.i18n.Messages;
import miworkplace.notifications.Notifier;
import miworkplace.ui.api.WorkspaceUtil;
import miworkplace.ui.explorer.CopySelection;
import org.eclipse.core.resources.IResource;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.swt.widgets.Shell;
import org.osgi.service.log.LogService;

public class PasteIfsHandler {
    private final String NOTIFICATION_TITLE = Messages.ui_handler_paste_ifs_title;
    @Inject
    private IEventBroker eventBroker;
    @Inject
    private LogService logger;
    @Inject
    private IWorkspaceStore workspaceStore;
    @Inject
    private IConnectionUtilities connUtil;

    @CanExecute
    public boolean canExecute(@Named(value="org.eclipse.ui.selection") ITreeSelection selection, @Named(value="e4ActivePart") MPart part, CopySelection copySelection) {
        if (copySelection == null) {
            return false;
        }
        if (copySelection.getValues() == null) {
            return false;
        }
        if (copySelection.getValues().isEmpty()) {
            return false;
        }
        if (copySelection.getType() != IRemoteObject.Type.streamfile) {
            return false;
        }
        if (selection == null) {
            return false;
        }
        if (selection.isEmpty()) {
            return false;
        }
        return selection.getFirstElement() instanceof StreamFile;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Execute
    public void execute(@Named(value="org.eclipse.ui.selection") ITreeSelection selection, @Named(value="activeShell") Shell shell, CopySelection copySelection) {
        StreamFile file = (StreamFile)selection.getFirstElement();
        StreamFile destDirectory = file.isDirectory() ? file : (StreamFile)this.workspaceStore.getParentFile((IRemoteObject)file);
        IFSFile destIfsFile = new IFSFile(destDirectory.getConnection().getSystem(), destDirectory.getPath());
        try {
            if (!destIfsFile.exists()) {
                Notifier.error((String)this.NOTIFICATION_TITLE, (String)String.format(Messages.ui_handler_paste_ifs_nodest, destDirectory.getPath()));
                return;
            }
        }
        catch (IOException e) {
            this.logger.log(1, "Could not determine if the destination folder " + destDirectory.getPath() + " exists.", (Throwable)e);
            Notifier.error((String)this.NOTIFICATION_TITLE, (String)String.format(Messages.ui_handler_paste_ifs_checkexist, destDirectory.getPath()));
            return;
        }
        if (!copySelection.getConnectionName().equals(destDirectory.getConnection().getName())) {
            this.logger.log(1, "Copying between different machines is not supported.");
            Notifier.error((String)this.NOTIFICATION_TITLE, (String)Messages.ui_handler_paste_ifs_copynotsupported);
            return;
        }
        int successfulCopies = 0;
        boolean replaceAll = false;
        boolean aborted = false;
        block10: for (String ifsPath : copySelection.getValues()) {
            IFSFile sourceFile;
            block20: {
                sourceFile = new IFSFile(destDirectory.getConnection().getSystem(), ifsPath);
                if (destDirectory.getPath().equals(sourceFile.getParent())) {
                    this.logger.log(1, "Could not copy " + ifsPath + " to " + destDirectory.getPath() + ". Source path must not equal the destination path.");
                    Notifier.error((String)this.NOTIFICATION_TITLE, (String)Messages.ui_handler_paste_ifs_equal);
                    continue;
                }
                try {
                    boolean replace;
                    boolean exist = this.doesDestinationExist(sourceFile, destIfsFile);
                    boolean bl = replace = replaceAll;
                    if (exist && !replaceAll) {
                        MessageDialog dialog = new MessageDialog(shell, Messages.common_dialog_confirm, null, String.format(Messages.ui_handler_paste_ifs_confirm_prompt, sourceFile.getName()), 5, new String[]{Messages.common_yes_all, Messages.common_yes, Messages.common_no, Messages.common_cancel}, 2);
                        int buttonIndex = dialog.open();
                        switch (buttonIndex) {
                            case 0: {
                                replaceAll = true;
                                replace = true;
                                break;
                            }
                            case 1: {
                                replace = true;
                                break;
                            }
                            case 2: {
                                replace = false;
                                break;
                            }
                            case 3: {
                                aborted = true;
                                break block10;
                            }
                        }
                    }
                    if (exist && !replace) continue;
                    if (sourceFile.isFile()) {
                        sourceFile.copyTo(destIfsFile.getAbsolutePath());
                        ++successfulCopies;
                        break block20;
                    }
                    if (sourceFile.isDirectory()) {
                        if (exist && replace) {
                            this.connUtil.deleteStreamFile(destDirectory.getConnection(), destIfsFile.getAbsolutePath() + "/" + sourceFile.getName());
                        }
                        sourceFile.copyTo(destIfsFile.getAbsolutePath() + "/" + sourceFile.getName());
                        ++successfulCopies;
                    } else {
                        Notifier.error((String)this.NOTIFICATION_TITLE, (String)String.format(Messages.ui_handler_paste_ifs_wrongtype, ifsPath));
                    }
                }
                catch (Exception e) {
                    this.logger.log(1, "Could not copy " + ifsPath + " to " + destDirectory.getPath() + ". Error: " + e.getMessage());
                    Notifier.error((String)this.NOTIFICATION_TITLE, (String)String.format(Messages.ui_handler_paste_ifs_error, ifsPath, destDirectory.getPath()));
                }
            }
            StreamFile streamFile = this.addToWorkspace(destDirectory, sourceFile);
            if (streamFile == null) continue;
            this.eventBroker.post("miworkplace/streamfile/created", (Object)streamFile);
        }
        if (aborted) {
            Notifier.info((String)this.NOTIFICATION_TITLE, (String)Messages.ui_handler_paste_ifs_aborted);
            return;
        }
        if (successfulCopies <= 0) return;
        Notifier.info((String)this.NOTIFICATION_TITLE, (String)String.format(Messages.ui_handler_paste_ifs_success, successfulCopies, copySelection.getValues().size()));
    }

    private StreamFile addToWorkspace(StreamFile destDirectory, IFSFile sourceFile) {
        try {
            IResource resource = WorkspaceUtil.buildStreamFileResource(destDirectory.getConnection(), destDirectory.getPath() + "/" + sourceFile.getName(), sourceFile.isDirectory());
            StreamFile streamFile = new StreamFile(destDirectory.getConnection(), resource, IRemoteObject.Type.streamfile, sourceFile.isDirectory());
            this.workspaceStore.add((IRemoteObject)streamFile);
            return streamFile;
        }
        catch (Exception e) {
            this.logger.log(1, "Could not add " + sourceFile.getPath() + " to workspace.", (Throwable)e);
            return null;
        }
    }

    private boolean doesDestinationExist(IFSFile sourceFile, IFSFile destDirectory) throws Exception {
        return new IFSFile(sourceFile.getSystem(), destDirectory.getPath() + "/" + sourceFile.getName()).exists();
    }
}

