/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.explorer.handler;

import com.ibm.as400.access.QSYSObjectPathName;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.beans.PropertyVetoException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import miworkplace.common.model.IConnection;
import miworkplace.common.model.IRemoteObject;
import miworkplace.common.model.IWorkspaceStore;
import miworkplace.common.model.SourceMember;
import miworkplace.common.validator.ObjectPathValidator;
import miworkplace.connection.api.IConnectionUtilities;
import miworkplace.i18n.Messages;
import miworkplace.notifications.Notifier;
import miworkplace.ui.api.WorkspaceUtil;
import miworkplace.ui.widgets.RemoteCheckingInputDialog;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.swt.widgets.Shell;
import org.osgi.service.log.LogService;

public class MoveMemberHandler {
    @Inject
    private IEventBroker eventBroker;
    @Inject
    private LogService logger;
    @Inject
    private IConnectionUtilities connUtil;
    @Inject
    private IWorkspaceStore workspaceStore;

    @Execute
    public void execute(@Named(value="activeShell") Shell shell, @Named(value="org.eclipse.ui.selection") ITreeSelection selection) {
        if (selection == null || selection.isEmpty()) {
            return;
        }
        List<SourceMember> members = this.getSelectedMembers(selection);
        if (members.isEmpty()) {
            return;
        }
        IConnection connection = members.get(0).getConnection();
        List<String> negativePathList = this.buildNegativePathList(members);
        String destination = null;
        String sourceFileLibrary = this.getSourceLibraryName(members.get(0));
        RemoteCheckingInputDialog dialog = new RemoteCheckingInputDialog(connection, this.connUtil, sourceFileLibrary, shell, Messages.ui_handler_movembr_title, Messages.ui_handler_movembr_prompt, negativePathList.get(0), (IInputValidator)new ObjectPathValidator(negativePathList));
        if (dialog.open() != 0) {
            return;
        }
        destination = dialog.getValue();
        this.move(shell, members, connection, destination);
    }

    public void move(Shell shell, List<SourceMember> members, IConnection connection, String destination) {
        for (SourceMember member : members) {
            try {
                QSYSObjectPathName destPath = this.buildDestinationMemberPath(member, destination);
                if (this.doesMemberInDestinationExist(member, destPath)) {
                    MessageDialog dialog2 = new MessageDialog(shell, Messages.common_dialog_confirm, null, String.format(Messages.ui_handler_movembr_confirm_prompt, member.getName(), destPath.getObjectName()), 3, new String[]{Messages.common_replace, Messages.common_cancel}, 0);
                    if (dialog2.open() != 0) continue;
                    this.connUtil.deleteSourceMember(connection, destPath.getPath());
                }
                this.connUtil.copyMember(connection, member.getPath(), destPath.getPath());
                this.connUtil.deleteSourceMember(connection, member.getPath());
                QSYSObjectPathName sourceFilePath = new QSYSObjectPathName(destPath.getLibraryName(), destPath.getObjectName(), "FILE");
                IRemoteObject sourceFile = this.workspaceStore.get(connection, sourceFilePath.getPath());
                IFile file = WorkspaceUtil.buildMemberFile(sourceFile, destPath.getMemberName());
                SourceMember newMember = new SourceMember(connection, (IResource)file, null);
                newMember.setSourceType(member.getSourceType());
                this.workspaceStore.remove((IRemoteObject)member);
                this.workspaceStore.add((IRemoteObject)newMember);
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("old.member", member);
                map.put("new.member", newMember);
                map.put("new.member.path", destPath.getPath());
                map.put("dest.source.file.path", sourceFilePath.getPath());
                map.put("connection", connection.getName());
                this.eventBroker.post("miworkplace/member/moved", map);
                Notifier.info((String)Messages.ui_handler_movembr_title, (String)String.format(Messages.ui_handler_movembr_success, member.getName(), destPath.getObjectName()));
            }
            catch (Exception e) {
                this.logger.log(1, "Could not move member " + member.getName() + " to " + destination + ".", (Throwable)e);
                Notifier.error((String)Messages.ui_handler_movembr_title, (String)String.format(Messages.ui_handler_movembr_error, member.getName(), destination));
            }
        }
    }

    private String getSourceLibraryName(SourceMember sourceMember) {
        QSYSObjectPathName path = new QSYSObjectPathName(sourceMember.getPath());
        return path.getLibraryName();
    }

    private List<String> buildNegativePathList(List<SourceMember> members) {
        LinkedList<String> negativePathList = new LinkedList<String>();
        for (SourceMember member : members) {
            String qsysPath;
            QSYSObjectPathName path = new QSYSObjectPathName(member.getPath());
            if (!negativePathList.contains(path.getObjectName())) {
                negativePathList.add(path.getObjectName());
            }
            if (negativePathList.contains(qsysPath = path.getLibraryName() + "/" + path.getObjectName())) continue;
            negativePathList.add(qsysPath);
        }
        return negativePathList;
    }

    private List<SourceMember> getSelectedMembers(ITreeSelection selection) {
        LinkedList<SourceMember> members = new LinkedList<SourceMember>();
        for (Object next : selection) {
            if (!(next instanceof SourceMember)) continue;
            members.add((SourceMember)next);
        }
        return members;
    }

    private boolean doesMemberInDestinationExist(SourceMember member, QSYSObjectPathName destPath) {
        QSYSObjectPathName destMemberPath = new QSYSObjectPathName(member.getPath());
        try {
            destMemberPath.setLibraryName(destPath.getLibraryName());
            destMemberPath.setObjectName(destPath.getObjectName());
        }
        catch (PropertyVetoException e) {
            throw new RuntimeException("Error during move member, checking member in destination source file.", e);
        }
        return this.connUtil.doesMemberExist(member.getConnection(), destMemberPath.getPath());
    }

    private QSYSObjectPathName buildDestinationMemberPath(SourceMember sourceMember, String destination) {
        QSYSObjectPathName memberPath = new QSYSObjectPathName(sourceMember.getPath());
        String[] parts = destination.split("/");
        try {
            if (parts.length == 1) {
                memberPath.setObjectName(parts[0]);
            } else {
                memberPath.setLibraryName(parts[0]);
                memberPath.setObjectName(parts[1]);
            }
        }
        catch (PropertyVetoException e) {
            throw new RuntimeException("Error during move member, building destination member path.", e);
        }
        return memberPath;
    }
}

