/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.explorer.handler;

import com.ibm.as400.access.QSYSObjectPathName;
import com.ibm.as400.access.Record;
import com.ibm.as400.access.RecordFormat;
import com.ibm.as400.access.SequentialFile;
import jakarta.inject.Inject;
import java.io.File;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import miworkplace.common.model.IConnection;
import miworkplace.common.model.IRemoteObject;
import miworkplace.connection.api.IConnectionUtilities;
import miworkplace.i18n.Messages;
import miworkplace.notifications.Notifier;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.CharUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.e4.core.di.extensions.Preference;
import org.eclipse.e4.ui.di.UISynchronize;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.osgi.service.log.LogService;

public class ImportToSourceFileRunner
implements IRunnableWithProgress {
    @Inject
    private UISynchronize uiSync;
    @Inject
    private LogService logger;
    @Inject
    private IConnectionUtilities connUtil;
    @Inject
    @Preference(nodePath="miworkplace.application")
    IEclipsePreferences applicationPreferences;
    private final IRemoteObject remoteObject;
    private final File file;
    private double lineNumberIncrementation = 1.0;

    public ImportToSourceFileRunner(IRemoteObject remoteObject, File file) {
        this.remoteObject = remoteObject;
        this.file = file;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        final AtomicInteger counter = new AtomicInteger(0);
        this.lineNumberIncrementation = this.getLineNumberIncrementation(this.applicationPreferences);
        ZipFile zipFile = null;
        try {
            try {
                zipFile = new ZipFile(this.file);
                Enumeration<? extends ZipEntry> entries = zipFile.entries();
                while (entries.hasMoreElements()) {
                    final ZipEntry entry = entries.nextElement();
                    if (entry.isDirectory()) continue;
                    monitor.subTask(String.format(Messages.ui_handler_import_srcfile_subtask, entry.getName()));
                    String memberName = this.resolveSourceMemberName(entry.getName());
                    String memberPath = this.buildMemberPath(this.remoteObject, memberName, entry.getName());
                    try {
                        this.importMember(zipFile, entry, this.remoteObject, memberPath);
                        counter.getAndIncrement();
                    }
                    catch (Exception e) {
                        this.logger.log(1, "Could not import " + entry.getName() + ".", (Throwable)e);
                        this.uiSync.asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                Notifier.warn((String)Messages.ui_handler_import_srcfile_title, (String)String.format(Messages.ui_handler_import_srcfile_error, entry.getName()));
                            }
                        });
                    }
                    monitor.worked(1);
                }
                this.uiSync.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        Notifier.info((String)Messages.ui_handler_import_srcfile_title, (String)String.format(Messages.ui_handler_import_srcfile_success, counter.get(), ImportToSourceFileRunner.this.remoteObject.getName()));
                    }
                });
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        finally {
            monitor.done();
            try {
                if (zipFile != null) {
                    zipFile.close();
                }
            }
            catch (Exception e) {
                this.logger.log(1, "Could not close ZIP file " + zipFile.getName() + ".", (Throwable)e);
            }
        }
    }

    private String buildMemberPath(IRemoteObject remoteObject, String memberName, String zipEntryName) {
        String baseName = FilenameUtils.getBaseName((String)memberName);
        String normalizedName = this.normalizeQsysObjectName(baseName);
        String sourceFilePath = this.resolveSourceFilePath(remoteObject, zipEntryName);
        return sourceFilePath + "/" + normalizedName + ".MBR";
    }

    private String normalizeQsysObjectName(String baseName) {
        if (baseName.length() > 10) {
            baseName = baseName.substring(0, 10);
        }
        StringBuilder name = new StringBuilder();
        char[] cArray = baseName.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (CharUtils.isAsciiAlphanumeric((char)c)) {
                name.append(c);
            } else if (c == '#') {
                name.append(c);
            } else if (c == '%') {
                name.append(c);
            } else if (c == '$') {
                name.append(c);
            } else if (c == '\u00a7') {
                name.append(c);
            } else if (c == '_') {
                name.append(c);
            } else {
                name.append('_');
            }
            ++n2;
        }
        return name.toString().toUpperCase();
    }

    private void importMember(ZipFile zipFile, ZipEntry zipEntry, IRemoteObject destRemoteObject, String memberPath) throws Exception {
        IConnection connection = destRemoteObject.getConnection();
        QSYSObjectPathName memberObject = new QSYSObjectPathName(memberPath);
        QSYSObjectPathName sourceFileObject = new QSYSObjectPathName(memberObject.getLibraryName(), memberObject.getObjectName(), "FILE");
        String libraryName = memberObject.getLibraryName();
        String attribute = FilenameUtils.getExtension((String)zipEntry.getName());
        if (!this.connUtil.doesObjectExist(connection, sourceFileObject.getPath())) {
            this.connUtil.createSourceFile(connection, sourceFileObject.getObjectName(), "", sourceFileObject.getLibraryName(), 112);
        }
        if (this.connUtil.doesMemberExist(connection, memberPath)) {
            this.connUtil.clearMember(connection, memberPath);
        } else {
            this.connUtil.createSourceMember(connection, libraryName, sourceFileObject.getObjectName(), memberObject.getMemberName(), attribute, "");
        }
        InputStream in = zipFile.getInputStream(zipEntry);
        List sourceLines = IOUtils.readLines((InputStream)in);
        if (this.isLineNumberOverflowing(sourceLines)) {
            throw new RuntimeException(Messages.ui_handler_import_srcfile_linenumbers);
        }
        if (this.isLineLengthOverflowing(sourceLines)) {
            this.uiSync.asyncExec(new Runnable(){

                @Override
                public void run() {
                    Notifier.warn((String)Messages.ui_handler_import_srcfile_title, (String)Messages.ui_handler_import_srcfile_linelength);
                }
            });
        }
        BigDecimal changeDate = this.getDateAsDecimal(new Date());
        SequentialFile file = new SequentialFile(connection.getSystem(), memberPath);
        try {
            file.setRecordFormat();
        }
        catch (Exception exception) {
            throw new RuntimeException(String.format(Messages.ui_handler_import_srcfile_member_accessable, memberObject.getMemberName()));
        }
        Record[] records = this.sourceToRecordObjects(sourceLines, file.getRecordFormat(), this.lineNumberIncrementation, changeDate);
        try {
            file.open(2, 0, 3);
            file.write(records);
            file.close();
        }
        catch (Exception exception) {
            throw new RuntimeException(String.format(Messages.ui_handler_import_srcfile_member_notwritable, memberObject.getMemberName()));
        }
    }

    private Record[] sourceToRecordObjects(List<String> sourceLines, RecordFormat recordFormat, double lineNumberIncrementation, BigDecimal changeDate) {
        Record[] records = new Record[sourceLines.size()];
        double lineNumber = 0.0;
        int i = 0;
        while (i < sourceLines.size()) {
            records[i] = new Record(recordFormat);
            records[i].setField(0, (Object)new BigDecimal(lineNumber += lineNumberIncrementation).setScale(2, 4));
            records[i].setField(1, (Object)changeDate);
            records[i].setField(2, (Object)sourceLines.get(i));
            ++i;
        }
        return records;
    }

    public BigDecimal getDateAsDecimal(Date date) {
        SimpleDateFormat datfmt = new SimpleDateFormat("yyMMdd");
        return new BigDecimal(datfmt.format(date));
    }

    private boolean isLineLengthOverflowing(List<String> sourceLines) {
        boolean overflowing = false;
        int i = 0;
        while (i < sourceLines.size()) {
            String line = sourceLines.get(i);
            if (line.length() > 100) {
                sourceLines.remove(i);
                sourceLines.add(i, line.substring(0, 100));
                overflowing = true;
            }
            ++i;
        }
        return overflowing;
    }

    private boolean isLineNumberOverflowing(List<String> sourceLines) {
        return (double)sourceLines.size() * this.lineNumberIncrementation > 9999.0;
    }

    private double getLineNumberIncrementation(IEclipsePreferences applicationPreferences) {
        String value = applicationPreferences.get("miworkplace.ui.editor.line.number.incrementation", "1.00");
        double incValue = 1.0;
        try {
            incValue = Double.parseDouble(value);
        }
        catch (NumberFormatException nfe) {
            incValue = 1.0;
            this.logger.log(1, "Could not set the line number incrementation value. Using default 1.00. Value: " + value + ". Error: " + nfe.getMessage());
        }
        return incValue;
    }

    private String resolveSourceMemberName(String name) {
        return FilenameUtils.getName((String)name);
    }

    private String resolveSourceFilePath(IRemoteObject remoteObject, String zipEntryName) {
        if (remoteObject.getType().equals((Object)IRemoteObject.Type.library)) {
            File f = new File(zipEntryName);
            String sourceFileName = f.getParent() == null ? "SOURCES" : this.normalizeQsysObjectName(f.getParentFile().getName());
            return remoteObject.getPath() + "/" + sourceFileName + ".FILE";
        }
        return remoteObject.getPath();
    }
}

