/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.explorer.handler;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import miworkplace.common.model.IRemoteObject;
import miworkplace.common.model.StreamFile;
import miworkplace.i18n.Messages;
import miworkplace.notifications.Notifier;
import miworkplace.services.api.ILockService;
import miworkplace.ui.explorer.handler.ImportToFolderRunner;
import miworkplace.ui.explorer.handler.ImportToSourceFileRunner;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.commands.EHandlerService;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.di.UISynchronize;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.osgi.service.log.LogService;

public class ImportSourceHandler {
    @Inject
    private IEclipseContext context;
    @Inject
    private EHandlerService handlerService;
    @Inject
    private ECommandService commandService;
    @Inject
    private UISynchronize uiSync;
    @Inject
    protected ILockService lockService;
    @Inject
    protected LogService logger;
    private final String REFRESH_DIRECTORY_COMMAND_ID = "miworkplace.ui.command.ifs.refresh";
    private final String REFRESH_SOURCE_FILE_COMMAND_ID = "miworkplace.ui.command.refresh";

    @CanExecute
    public boolean canExecute(@Named(value="org.eclipse.ui.selection") ITreeSelection selection) {
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Execute
    public void execute(@Named(value="org.eclipse.ui.selection") TreeSelection selection, @Named(value="activeShell") Shell shell, MApplication application) {
        if (selection.isEmpty()) {
            return;
        }
        File file = this.getSourceArchiveFile(shell);
        if (file == null) {
            return;
        }
        IEclipseContext activeWindowContext = application.getContext().getActiveChild();
        Object element = selection.getFirstElement();
        if (!(element instanceof IRemoteObject)) return;
        try {
            IRemoteObject object = (IRemoteObject)element;
            if (object instanceof StreamFile) {
                StreamFile folder = (StreamFile)object;
                if (!folder.isDirectory()) throw new Exception(Messages.ui_handler_import_source_nofolder);
                this.importToFolder(shell, file, activeWindowContext, folder);
                return;
            } else if (object.getType().equals((Object)IRemoteObject.Type.file) && object.getAttribute().equals((Object)IRemoteObject.Attribute.sourcefile)) {
                this.importToQsys(shell, file, activeWindowContext, object);
                return;
            } else {
                if (!object.getType().equals((Object)IRemoteObject.Type.library)) return;
                this.importToQsys(shell, file, activeWindowContext, object);
            }
            return;
        }
        catch (Exception e) {
            this.logger.log(1, "Could not import sources.", (Throwable)e);
            this.uiSync.asyncExec(new Runnable(){

                @Override
                public void run() {
                    Notifier.error((String)Messages.ui_handler_import_source_title, (String)Messages.ui_handler_import_source_error);
                }
            });
        }
    }

    private void importToQsys(Shell shell, File file, IEclipseContext activeWindowContext, IRemoteObject object) throws InvocationTargetException, InterruptedException {
        ImportToSourceFileRunner runner = new ImportToSourceFileRunner(object, file);
        ContextInjectionFactory.inject((Object)runner, (IEclipseContext)this.context);
        new ProgressMonitorDialog(shell).run(true, true, (IRunnableWithProgress)runner);
        activeWindowContext.activate();
        ParameterizedCommand command = this.commandService.createCommand("miworkplace.ui.command.refresh", null);
        this.handlerService.executeHandler(command);
    }

    private void importToFolder(Shell shell, File file, IEclipseContext activeWindowContext, StreamFile folder) throws InvocationTargetException, InterruptedException {
        ImportToFolderRunner runner = new ImportToFolderRunner(folder, file);
        ContextInjectionFactory.inject((Object)runner, (IEclipseContext)this.context);
        new ProgressMonitorDialog(shell).run(true, true, (IRunnableWithProgress)runner);
        activeWindowContext.activate();
        ParameterizedCommand command = this.commandService.createCommand("miworkplace.ui.command.ifs.refresh", null);
        this.handlerService.executeHandler(command);
    }

    private File getSourceArchiveFile(Shell shell) {
        FileDialog dialog = new FileDialog(shell, 4096);
        dialog.setFilterExtensions(new String[]{"*.zip"});
        dialog.setFilterNames(new String[]{"Zip Archive"});
        String filename = dialog.open();
        if (filename == null) {
            return null;
        }
        return new File(filename);
    }
}

