/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.explorer.handler;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.HashMap;
import miworkplace.common.model.IConnection;
import miworkplace.common.model.IRemoteObject;
import miworkplace.common.model.StreamFile;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.osgi.service.log.LogService;

public class GoIntoHandler {
    @Inject
    private IEventBroker eventBroker;
    @Inject
    private LogService logger;

    @CanExecute
    public boolean canExecute(@Named(value="org.eclipse.ui.selection") @Optional ITreeSelection selection) {
        Object element;
        if (selection != null && !selection.isEmpty() && (element = selection.getFirstElement()) != null) {
            if (element instanceof IConnection) {
                return ((IConnection)element).isConnected();
            }
            if (element instanceof IRemoteObject) {
                IRemoteObject remoteObject = (IRemoteObject)element;
                if (remoteObject.getType() == IRemoteObject.Type.library) {
                    return true;
                }
                if (remoteObject.getType() == IRemoteObject.Type.file) {
                    return remoteObject.getAttribute() == IRemoteObject.Attribute.sourcefile;
                }
                if (remoteObject.getType() == IRemoteObject.Type.streamfile && ((StreamFile)remoteObject).isDirectory()) {
                    return true;
                }
            }
        }
        return false;
    }

    @Execute
    public void run(@Named(value="org.eclipse.ui.selection") TreeSelection selection) {
        if (selection != null) {
            Object element = selection.getFirstElement();
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("org.eclipse.e4.data", element);
            this.eventBroker.post("miworkplace/ui/explorer/input/change", map);
        }
    }
}

