/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.explorer.handler;

import com.ibm.as400.access.IFSFile;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.IOException;
import miworkplace.common.model.IRemoteObject;
import miworkplace.common.model.IWorkspaceStore;
import miworkplace.common.model.StreamFile;
import miworkplace.i18n.Messages;
import miworkplace.notifications.Notifier;
import miworkplace.ui.api.WorkspaceUtil;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.resources.IResource;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.swt.widgets.Shell;
import org.osgi.service.log.LogService;

public class DirectoryWizardHandler {
    @Inject
    private LogService logger;
    @Inject
    private IEventBroker eventBroker;
    @Inject
    private IWorkspaceStore workspaceStore;

    @Execute
    public void execute(@Named(value="activeShell") Shell shell, @Named(value="org.eclipse.ui.selection") TreeSelection selection) {
        InputDialog dialog = new InputDialog(shell, Messages.ui_handler_dir_wiz_title, Messages.ui_handler_dir_wiz_prompt, null, null);
        if (dialog.open() == 0) {
            String value = dialog.getValue();
            if (StringUtils.isBlank((CharSequence)value)) {
                Notifier.warn((String)Messages.ui_handler_dir_wiz_title, (String)String.format(Messages.ui_handler_dir_wiz_invalid, value));
            } else {
                StreamFile parentFile = (StreamFile)selection.getFirstElement();
                try {
                    if (!parentFile.isDirectory()) {
                        parentFile = (StreamFile)this.workspaceStore.getParentFile((IRemoteObject)parentFile);
                    }
                    String newDirectoryPath = parentFile.getPath() + "/" + value;
                    IFSFile file = new IFSFile(parentFile.getConnection().getSystem(), newDirectoryPath);
                    if (file.exists()) {
                        Notifier.warn((String)Messages.ui_handler_dir_wiz_title, (String)String.format(Messages.ui_handler_dir_wiz_exists, value));
                    } else {
                        boolean created = file.mkdirs();
                        if (created) {
                            IResource resource = WorkspaceUtil.buildStreamFileResource(parentFile.getConnection(), newDirectoryPath, true);
                            StreamFile streamFile = new StreamFile(parentFile.getConnection(), resource, IRemoteObject.Type.streamfile, true);
                            this.workspaceStore.add((IRemoteObject)streamFile);
                            this.eventBroker.post("miworkplace/directory/created", (Object)streamFile);
                            Notifier.info((String)Messages.ui_handler_dir_wiz_title, (String)String.format(Messages.ui_handler_dir_wiz_success, value));
                        } else {
                            Notifier.warn((String)Messages.ui_handler_dir_wiz_title, (String)String.format(Messages.ui_handler_dir_wiz_nosuccess, value));
                        }
                    }
                }
                catch (IOException e) {
                    this.logger.log(1, "Could not create new directory. Error: " + e.getMessage());
                    Notifier.error((String)Messages.ui_handler_dir_wiz_title, (String)Messages.ui_handler_dir_wiz_error);
                }
            }
        }
    }
}

