/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.explorer.handler;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import miworkplace.common.model.IRemoteObject;
import miworkplace.common.model.IWorkspaceStore;
import miworkplace.common.model.StreamFile;
import miworkplace.connection.api.IConnectionUtilities;
import miworkplace.i18n.Messages;
import miworkplace.notifications.Notifier;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.swt.widgets.Shell;
import org.osgi.service.log.LogService;

public class DeleteStreamFileHandler {
    @Inject
    private LogService logger;
    @Inject
    private IConnectionUtilities connUtil;
    @Inject
    private IEventBroker eventBroker;
    @Inject
    private IWorkspaceStore workspaceStore;

    @CanExecute
    public boolean canExecute(@Named(value="org.eclipse.ui.selection") ITreeSelection selection) {
        return selection != null && !selection.isEmpty();
    }

    @Execute
    public void execute(@Named(value="activeShell") Shell shell, @Named(value="org.eclipse.ui.selection") ITreeSelection selection) {
        boolean singleSelection = selection.size() == 1;
        int count = 0;
        String message = this.buildMessage(selection);
        MessageDialog dialog = new MessageDialog(shell, Messages.ui_handler_delete_stmf_title, null, message, 3, new String[]{Messages.common_yes, Messages.common_no}, 0);
        if (dialog.open() == 0) {
            for (Object object : selection) {
                if (!(object instanceof StreamFile)) continue;
                StreamFile file = (StreamFile)object;
                try {
                    this.connUtil.deleteStreamFile(file.getConnection(), file.getPath());
                    ++count;
                    this.workspaceStore.remove((IRemoteObject)file);
                    this.eventBroker.post("miworkplace/streamfile/deleted", (Object)file);
                }
                catch (Exception e) {
                    this.logger.log(1, "Could not delete " + file.getPath(), (Throwable)e);
                    Notifier.error((String)Messages.ui_handler_delete_stmf_notify_title, (String)String.format(Messages.ui_handler_delete_stmf_error, file.getPath()));
                }
            }
            if (singleSelection && count == 1) {
                Notifier.info((String)Messages.ui_handler_delete_stmf_notify_title, (String)Messages.ui_handler_delete_stmf_success_single_1);
            } else if (!singleSelection && count == 1) {
                Notifier.info((String)Messages.ui_handler_delete_stmf_notify_title, (String)Messages.ui_handler_delete_stmf_success_single_2);
            } else if (!singleSelection && count > 1) {
                Notifier.info((String)Messages.ui_handler_delete_stmf_notify_title, (String)String.format(Messages.ui_handler_delete_stmf_success_multi, count));
            }
        }
    }

    private String buildMessage(ITreeSelection selection) {
        if (selection.size() == 1) {
            return String.format(Messages.ui_handler_delete_stmf_prompt_single, selection.getFirstElement());
        }
        return String.format(Messages.ui_handler_delete_stmf_prompt_multi, selection.size());
    }
}

