/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.explorer.handler;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.Map;
import miworkplace.common.model.IRemoteObject;
import miworkplace.common.model.SourceMember;
import miworkplace.connection.api.IConnectionUtilities;
import miworkplace.i18n.Messages;
import miworkplace.notifications.Notifier;
import miworkplace.services.api.IObjectPropertiesStore;
import miworkplace.services.api.ObjectProperty;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.swt.widgets.Shell;
import org.osgi.service.log.LogService;

public class ChangeMemberDescriptionHandler {
    @Inject
    private LogService logger;
    @Inject
    private IEventBroker eventBroker;
    @Inject
    private IConnectionUtilities connUtilFacade;
    @Inject
    private IObjectPropertiesStore propertiesStore;

    @CanExecute
    public boolean canExecute(@Named(value="org.eclipse.ui.selection") @Optional ITreeSelection selection) {
        if (selection == null || selection.isEmpty()) {
            return false;
        }
        Object element = selection.getFirstElement();
        return element != null && element instanceof SourceMember;
    }

    @Execute
    public void execute(@Named(value="activeShell") Shell shell, @Named(value="org.eclipse.ui.selection") ITreeSelection selection) {
        SourceMember member = (SourceMember)selection.getFirstElement();
        this.changeMemberDescription(shell, member);
    }

    private void changeMemberDescription(Shell shell, SourceMember member) {
        InputDialog dialog;
        String oldDescription = "";
        Map properties = this.propertiesStore.get((IRemoteObject)member);
        if (properties != null && properties.get(ObjectProperty.textdescription) != null) {
            oldDescription = properties.get(ObjectProperty.textdescription).toString();
        }
        if ((dialog = new InputDialog(shell, Messages.ui_handler_chgmbrdesc_title, Messages.ui_handler_chgmbrdesc_prompt, oldDescription, new IInputValidator(){

            public String isValid(String newText) {
                if (newText.length() > 50) {
                    return Messages.ui_handler_chgmbrdesc_limit;
                }
                return null;
            }
        })).open() == 0) {
            String newDescription = dialog.getValue().trim();
            if (newDescription.equals(oldDescription)) {
                Notifier.info((String)Messages.ui_handler_chgmbrdesc_title, (String)Messages.ui_handler_chgmbrdesc_error_samevalue);
            } else {
                try {
                    this.connUtilFacade.changeMemberDescription(member.getConnection(), member.getPath(), newDescription);
                    this.eventBroker.post("miworkplace/member/updated", (Object)member);
                }
                catch (Exception e) {
                    this.logger.log(1, "Error changing member description for " + member.getName() + ". Cause: " + e.getMessage());
                    Notifier.error((String)Messages.ui_handler_chgmbrdesc_title, (String)String.format(Messages.ui_handler_chgmbrdesc_error, member.getName()));
                }
            }
        }
    }
}

