/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.explorer.handler;

import com.remainsoftware.common.util.ServiceUtils;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.ArrayList;
import java.util.List;
import miworkplace.common.model.IConnection;
import miworkplace.common.model.IWorkspaceStore;
import miworkplace.connection.api.IConnectionManager;
import miworkplace.i18n.Messages;
import miworkplace.ui.util.JavaUtils;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.swt.widgets.Shell;

public class AddLibraryHandler {
    @Inject
    private IConnectionManager connectionManager;

    @CanExecute
    public boolean canExecute(@Named(value="org.eclipse.ui.selection") ITreeSelection selection) {
        Object firstElement;
        return selection.size() == 1 && (firstElement = selection.getFirstElement()) instanceof IConnection;
    }

    @Execute
    public void execute(@Named(value="activeShell") Shell shell, @Named(value="org.eclipse.ui.selection") ITreeSelection selection) {
        IConnection connection = (IConnection)selection.getFirstElement();
        InputDialog dialog = new InputDialog(shell, Messages.ui_handler_addlib_input_title, Messages.ui_handler_addlib_input_prompt, null, this.getValidator(connection));
        this.addLibrariesToConnection(connection, dialog);
    }

    private void addLibrariesToConnection(IConnection connection, InputDialog dialog) {
        if (dialog.open() == 0) {
            IWorkspaceStore store = (IWorkspaceStore)ServiceUtils.getOSGiService(this.getClass(), IWorkspaceStore.class);
            for (String newLibraryName : JavaUtils.normalizeSeparatedList(dialog.getValue(), true, false)) {
                store.addLibrary(connection, newLibraryName);
                connection.addListedLibrary(newLibraryName);
            }
            this.connectionManager.update(connection);
        }
    }

    private IInputValidator getValidator(IConnection connection) {
        return pInput -> {
            List<String> libs = JavaUtils.normalizeSeparatedList(pInput, true, false);
            if (libs.size() == 0 || libs.size() == 1 && libs.get(0).isEmpty()) {
                return Messages.ui_handler_addlib_input_error_empty;
            }
            ArrayList<String> exists = new ArrayList<String>();
            for (String lib : libs) {
                if (!connection.getListedLibraries().contains(lib)) continue;
                exists.add(lib);
            }
            if (!exists.isEmpty()) {
                return String.format(Messages.ui_handler_addlib_input_error_exist, exists.toString());
            }
            return null;
        };
    }
}

