/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.explorer.filter;

import miworkplace.i18n.Messages;
import miworkplace.ui.explorer.filter.FilterManager;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class NewFilterDialog
extends TitleAreaDialog {
    private FilterManager fFilterManager;
    private Combo fGroupCombo;
    private Text fFilterText;
    private String fFilterName;

    public NewFilterDialog(Shell parentShell) {
        super(parentShell);
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        GridLayout gridLayout = (GridLayout)container.getLayout();
        gridLayout.marginRight = 5;
        gridLayout.marginLeft = 5;
        new Label(container, 0);
        Label fGroupName = new Label(container, 0);
        fGroupName.setText(Messages.NewFilterDialog_fltrGrp);
        this.fGroupCombo = new Combo(container, 2048);
        this.fGroupCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.fGroupCombo.setItems(this.fFilterManager.getFilterGroups().toArray(new String[0]));
        Label lblFiltername = new Label(container, 0);
        lblFiltername.setText(Messages.NewFilterDialog_fltrName);
        this.fFilterText = new Text(container, 2048);
        this.fFilterText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.init();
        this.fFilterText.addModifyListener(e -> this.validateInput());
        this.fFilterText.setFocus();
        return container;
    }

    private void init() {
        this.setTitle(Messages.NewFilterDialog_crt_new_filter);
        this.setMessage(Messages.NewFilterDialog_topinst1 + System.lineSeparator() + Messages.NewFilterDialog_topInst2);
        if (this.fFilterName != null) {
            this.fGroupCombo.setText("");
            this.fFilterText.setText(this.fFilterName);
            String[] split = this.fFilterName.split(" / ");
            if (split.length == 2) {
                this.fGroupCombo.setText(split[0]);
                this.fFilterText.setText(split[1]);
            }
        }
    }

    protected Control createContents(Composite pParent) {
        try {
            Control control = super.createContents(pParent);
            return control;
        }
        finally {
            if (this.fFilterName == null || this.fFilterName.isEmpty()) {
                this.getButton(0).setEnabled(false);
            }
        }
    }

    protected void validateInput() {
        this.makeFilterName();
        this.getButton(0).setEnabled(false);
        if (this.fFilterName.isEmpty()) {
            this.setErrorMessage(Messages.FilterDialog_enter_filternme);
        } else if (this.fFilterManager.getFilter(this.fFilterName) != null) {
            this.setErrorMessage(Messages.FilterDialog_fltr_exists);
        } else {
            this.getButton(0).setEnabled(true);
            this.setErrorMessage(null);
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
    }

    protected void okPressed() {
        this.makeFilterName();
        super.okPressed();
    }

    private void makeFilterName() {
        this.fFilterName = this.fGroupCombo.getText().trim().isEmpty() ? this.fFilterText.getText().trim() : this.fGroupCombo.getText().trim() + " / " + this.fFilterText.getText().trim();
    }

    public NewFilterDialog setFilterName(String pFilterName) {
        this.fFilterName = pFilterName;
        return this;
    }

    public String getFilterName() {
        return this.fFilterName;
    }

    public NewFilterDialog setFilterManager(FilterManager pFilterManager) {
        this.fFilterManager = pFilterManager;
        return this;
    }
}

