/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.explorer.filter;

import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.io.File;
import java.io.FileOutputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Scanner;
import java.util.stream.Collectors;
import miworkplace.common.debug.Debug;
import miworkplace.i18n.Messages;
import miworkplace.ui.Constants;
import miworkplace.ui.explorer.filter.Filter;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.json.JSONArray;

@Creatable
@Singleton
public class FilterManager {
    Debug log = Debug.getInstance();
    public static final String KEY_LAST_SELECTED_FILTER = Filter.class.getName() + ".lastselected";
    @Inject
    IEventBroker eventBroker;

    public List<Filter> getFilters() {
        ArrayList<Filter> result = new ArrayList<Filter>();
        try {
            String[] filters;
            String[] stringArray = filters = InstanceScope.INSTANCE.getNode(Constants.FILTER_NODE).keys();
            int n = filters.length;
            int n2 = 0;
            while (n2 < n) {
                String key = stringArray[n2];
                Filter filter = FilterManager.createFromJSON(InstanceScope.INSTANCE.getNode(Constants.FILTER_NODE).get(key, key));
                if (filter != null) {
                    filter.setManager(this);
                    result.add(filter);
                } else {
                    System.out.println(key);
                }
                ++n2;
            }
        }
        catch (Exception e) {
            Constants.LOG.error(e.getMessage(), (Throwable)e);
        }
        if (result.isEmpty()) {
            return this.getBaseFilters();
        }
        return result;
    }

    public void saveFilters(List<Filter> pFilters) {
        try {
            String[] keys;
            String[] stringArray = keys = InstanceScope.INSTANCE.getNode(Constants.FILTER_NODE).keys();
            int n = keys.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray[n2];
                InstanceScope.INSTANCE.getNode(Constants.FILTER_NODE).remove(string);
                ++n2;
            }
            for (Filter filter : pFilters) {
                String json = this.toJSON(filter);
                if (json == null) continue;
                InstanceScope.INSTANCE.getNode(Constants.FILTER_NODE).put(filter.getName(), json);
            }
            InstanceScope.INSTANCE.getNode(Constants.FILTER_NODE).flush();
        }
        catch (Exception e) {
            Constants.LOG.error(e.getMessage(), (Throwable)e);
        }
    }

    public String toJSON(Filter pFilter) {
        ObjectMapper mapper = new ObjectMapper();
        try {
            return mapper.writeValueAsString((Object)pFilter);
        }
        catch (Exception e) {
            Constants.LOG.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static Filter createFromJSON(String pFilterJSon) {
        ObjectMapper mapper = new ObjectMapper();
        try {
            return (Filter)mapper.readValue(pFilterJSon, Filter.class);
        }
        catch (Exception e) {
            Constants.LOG.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private List<Filter> getBaseFilters() {
        ArrayList<Filter> result = new ArrayList<Filter>();
        Filter filter = new Filter();
        filter.setManager(this);
        filter.setName(Messages.FilterManager_src_files);
        filter.setSelectSourceFiles(true);
        result.add(filter);
        return result;
    }

    public Filter getFilter(String pFilterName) {
        for (Filter filter : this.getFilters()) {
            if (!Objects.equals(filter.getName(), pFilterName)) continue;
            return filter;
        }
        return null;
    }

    public void addFilter(Filter pFilter) {
        List<Filter> filters = this.getFilters();
        if (filters.contains(pFilter)) {
            filters.remove(pFilter);
        }
        filters.add(pFilter);
        this.saveFilters(filters);
    }

    public void exportFilters(Shell shell) {
        FileDialog d = new FileDialog(shell);
        d.setFilterExtensions(new String[]{"*.json"});
        d.setOverwrite(true);
        Object file = d.open();
        if (file != null) {
            if (!((String)file).toLowerCase().endsWith(".json")) {
                file = (String)file + ".json";
            }
            File outFile = new File((String)file);
            try {
                Throwable throwable = null;
                Object var6_8 = null;
                try (FileOutputStream fos = new FileOutputStream(outFile);){
                    JSONArray array = new JSONArray();
                    for (Filter filter : this.getFilters()) {
                        array.put((Object)this.toJSON(filter));
                    }
                    fos.write(array.toString().getBytes());
                    MessageDialog.openConfirm((Shell)shell, (String)Messages.FilterManager_saved_fltrs, (String)MessageFormat.format(Messages.FilterManager_save_cnfrm, this.getFilters().size(), file));
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                this.log.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void importFilters(Shell shell) {
        FileDialog d = new FileDialog(shell);
        d.setFilterExtensions(new String[]{"*.json"});
        d.setOverwrite(false);
        String file = d.open();
        if (file != null) {
            File inFile = new File(file);
            StringBuffer data = new StringBuffer();
            try {
                Throwable throwable = null;
                Object var7_9 = null;
                try (Scanner fis = new Scanner(inFile);){
                    while (fis.hasNextLine()) {
                        data.append(fis.nextLine());
                    }
                    JSONArray array = new JSONArray(data.toString());
                    boolean confirm = MessageDialog.openConfirm((Shell)shell, (String)Messages.FilterManager_rplce_fltrs, (String)MessageFormat.format(Messages.FilterManager_rplce_cnfrm, this.getFilters().size(), array.length()));
                    if (confirm) {
                        this.getFilters().forEach(filter -> this.deleteFilter((Filter)filter));
                        int i = 0;
                        while (i < array.length()) {
                            Filter filter2 = FilterManager.createFromJSON(array.get(i).toString());
                            this.addFilter(filter2);
                            ++i;
                        }
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                this.log.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void deleteFilter(Filter pFilter) {
        List<Filter> filters = this.getFilters();
        if (filters.contains(pFilter)) {
            filters.remove(pFilter);
        }
        this.saveFilters(filters);
    }

    public String[] getFilterNames() {
        List<Filter> filters = this.getFilters();
        Object[] result = new String[filters.size()];
        int i = 0;
        while (i < result.length) {
            result[i] = filters.get(i).getName();
            ++i;
        }
        Arrays.sort(result);
        return result;
    }

    public void notifyListeners() {
        this.eventBroker.post("miworkplace/ui/filter/changed", new Object());
    }

    public List<Filter> getActiveFilters() {
        return this.getFilters().stream().filter(filter -> filter.isActive()).collect(Collectors.toList());
    }

    public List<Filter> getActiveFilters(boolean pIFSFilters) {
        return this.getFilters().stream().filter(filter -> filter.isActive() && filter.isIfs() == pIFSFilters).collect(Collectors.toList());
    }

    public List<String> getFilterGroups() {
        ArrayList<String> result = new ArrayList<String>();
        this.getFilters().forEach(f -> {
            String[] split = f.getName().split(" / ");
            if (split.length == 2 && !result.contains(split[0])) {
                result.add(split[0]);
            }
        });
        result.sort((s1, s2) -> s1.toLowerCase().compareTo(s2.toLowerCase()));
        return result;
    }
}

