/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.explorer;

import jakarta.inject.Inject;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import miworkplace.common.model.Library;
import miworkplace.common.model.QSYSObject;
import miworkplace.common.model.SourceMember;
import miworkplace.common.model.StreamFile;
import miworkplace.i18n.Messages;
import miworkplace.ui.useraction.IUserActionStore;
import miworkplace.ui.useraction.UserAction;
import org.eclipse.e4.ui.di.AboutToShow;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.commands.MCommand;
import org.eclipse.e4.ui.model.application.ui.menu.MDirectMenuItem;
import org.eclipse.e4.ui.model.application.ui.menu.MHandledMenuItem;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuElement;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuFactory;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.jface.viewers.TreeSelection;

public class UserActionMenuContribution {
    private final String USER_ACTION_COMMAND_ID = "miworkplace.ui.command.useraction";
    @Inject
    private IUserActionStore userActionStore;
    @Inject
    private MApplication application;
    @Inject
    private EModelService modelService;

    @AboutToShow
    public void aboutToShow(List<MMenuElement> items, ESelectionService selectionService) {
        List<UserAction> userActions = this.userActionStore.list();
        Collections.sort(userActions, new Comparator<UserAction>(){

            @Override
            public int compare(UserAction ua1, UserAction ua2) {
                return ua1.getName().compareTo(ua2.getName());
            }
        });
        if (userActions.isEmpty()) {
            MDirectMenuItem item = this.createNoUserActionsItem();
            items.add((MMenuElement)item);
        } else {
            TreeSelection selection = (TreeSelection)selectionService.getSelection();
            MCommand command = this.getCommandInstance("miworkplace.ui.command.useraction");
            for (UserAction userAction : userActions) {
                if (!this.isActionValidForSelection(userAction, selection)) continue;
                MHandledMenuItem dynamicItem = (MHandledMenuItem)this.modelService.createModelElement(MHandledMenuItem.class);
                dynamicItem.setLabel(MessageFormat.format("{0} ({1})", userAction.getName(), userAction.getDescription()));
                dynamicItem.setCommand(command);
                dynamicItem.getTransientData().put("useraction", userAction);
                dynamicItem.setTooltip(userAction.getDescription());
                items.add((MMenuElement)dynamicItem);
            }
            if (items.isEmpty()) {
                MDirectMenuItem item = this.createNoUserActionsItem();
                items.add((MMenuElement)item);
            }
        }
    }

    private boolean isActionValidForSelection(UserAction pUserAction, TreeSelection pSelection) {
        if (pUserAction.isValidForAll()) {
            return true;
        }
        for (Object selection : pSelection) {
            if (selection instanceof SourceMember && pUserAction.isValidForMember()) {
                return true;
            }
            if (selection instanceof SourceMember && !pUserAction.isValidForMember()) {
                return false;
            }
            if (selection instanceof Library && pUserAction.isValidForLibrary()) {
                return true;
            }
            if (selection instanceof Library && !pUserAction.isValidForLibrary()) {
                return false;
            }
            if (selection instanceof QSYSObject && pUserAction.isValidForObject()) {
                return true;
            }
            if (!(selection instanceof StreamFile) || !pUserAction.isValidForIFS()) continue;
            return true;
        }
        return false;
    }

    private MDirectMenuItem createNoUserActionsItem() {
        MDirectMenuItem item = MMenuFactory.INSTANCE.createDirectMenuItem();
        item.setLabel(Messages.ui_explorer_nouseraction);
        item.setEnabled(false);
        item.setVisible(true);
        return item;
    }

    private MCommand getCommandInstance(String commandId) {
        List commands = this.application.getCommands();
        for (MCommand command : commands) {
            if (!command.getElementId().equals(commandId)) continue;
            return command;
        }
        return null;
    }
}

