/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.explorer;

import jakarta.inject.Inject;
import java.text.MessageFormat;
import miworkplace.common.model.IConnection;
import miworkplace.common.model.IRemoteObject;
import miworkplace.common.model.SourceMember;
import miworkplace.common.model.StreamFile;
import miworkplace.i18n.Messages;
import miworkplace.services.api.IObjectPropertiesStore;
import miworkplace.ui.api.ICompileResultService;
import miworkplace.ui.compile.CompileResult;
import miworkplace.ui.explorer.filter.FilterManager;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.e4.core.di.extensions.Preference;
import org.eclipse.e4.tools.services.IResourcePool;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

public class RemoteExplorerLabelProvider
extends LabelProvider {
    @Inject
    private IObjectPropertiesStore fPropertiesStore;
    @Inject
    private FilterManager fFilterManager;
    @Inject
    private ICompileResultService fCompileResultService;
    @Inject
    private IResourcePool fImagePool;
    @Inject
    @Preference(nodePath="miworkplace.application/explorer")
    private IEclipsePreferences prefs;

    public String getText(Object obj) {
        if (obj instanceof IConnection) {
            boolean ifs = !this.prefs.get("miworkplace.ui.explorer.viewer.showing", "qsys").equals("qsys");
            IConnection conn = (IConnection)obj;
            if (conn.isConnected()) {
                int filtersActive = this.fFilterManager.getActiveFilters(ifs).size();
                if (filtersActive > 0) {
                    String filters = MessageFormat.format(Messages.ui_explorer_filters_active, filtersActive);
                    return MessageFormat.format("{0} {1}", conn.getName(), filters);
                }
                return conn.getName();
            }
            return MessageFormat.format("{0} {1}", ((IConnection)obj).getName(), Messages.ui_explorer_not_connected);
        }
        if (obj instanceof IFolder) {
            return FilenameUtils.getBaseName((String)((IResource)obj).getName());
        }
        if (obj instanceof SourceMember) {
            SourceMember member = (SourceMember)obj;
            if (StringUtils.isEmpty((CharSequence)member.getSourceType())) {
                return member.getName();
            }
            return String.valueOf(member) + "." + member.getSourceType() + this.getDescription((IRemoteObject)member);
        }
        if (obj instanceof IRemoteObject) {
            IRemoteObject object = (IRemoteObject)obj;
            String description = this.fPropertiesStore.getDescription(object);
            if (object instanceof StreamFile) {
                return object.getName();
            }
            return MessageFormat.format("{0}.{1}{2}", object.getName(), object.getType().abbr(), description.isEmpty() ? "" : " - " + description);
        }
        if (obj instanceof StreamFile) {
            return ((StreamFile)obj).getName();
        }
        return obj.toString();
    }

    private String getDescription(IRemoteObject member) {
        String description = this.fPropertiesStore.getDescription(member);
        return description.isBlank() ? "" : " - " + description;
    }

    public Image getImage(Object obj) {
        if (obj instanceof IConnection) {
            if (((IConnection)obj).isConnected()) {
                if (((IConnection)obj).isSecure()) {
                    return this.fImagePool.getImageUnchecked("IMAGE_SERVER_SSL");
                }
                return this.fImagePool.getImageUnchecked("IMAGE_SERVER");
            }
            return this.fImagePool.getImageUnchecked("IMAGE_SERVER_OFF");
        }
        if (obj instanceof SourceMember) {
            CompileResult cr = this.fCompileResultService.getCompileResult(((SourceMember)obj).getPath());
            if (cr == null || !cr.hasErrors()) {
                return this.fImagePool.getImageUnchecked("IMAGE_TEXT");
            }
            return this.fImagePool.getImageUnchecked("IMAGE_ERROR");
        }
        if (obj instanceof StreamFile) {
            if (((StreamFile)obj).isDirectory()) {
                return this.fImagePool.getImageUnchecked("IMAGE_FOLDER");
            }
            CompileResult cr = this.fCompileResultService.getCompileResult(((StreamFile)obj).getPath());
            if (cr == null || !cr.hasErrors()) {
                return this.fImagePool.getImageUnchecked("IMAGE_TEXT");
            }
            return this.fImagePool.getImageUnchecked("IMAGE_ERROR");
        }
        if (obj instanceof IRemoteObject) {
            IRemoteObject object = (IRemoteObject)obj;
            if (object.getType() == IRemoteObject.Type.library) {
                return this.fImagePool.getImageUnchecked("IMAGE_LIBRARY");
            }
            if (object.getType() == IRemoteObject.Type.file) {
                return this.fImagePool.getImageUnchecked("IMAGE_FILE");
            }
            if (object.getType() == IRemoteObject.Type.program) {
                return this.fImagePool.getImageUnchecked("IMAGE_PROGRAM");
            }
            if (object.getType() == IRemoteObject.Type.serviceprogram) {
                return this.fImagePool.getImageUnchecked("IMAGE_SERVICEPROGRAM");
            }
            if (object.getType() == IRemoteObject.Type.bindingdirectory) {
                return this.fImagePool.getImageUnchecked("IMAGE_DEFAULT");
            }
            if (object.getType() == IRemoteObject.Type.dataarea) {
                return this.fImagePool.getImageUnchecked("IMAGE_DATA_AREA");
            }
            if (object.getType() == IRemoteObject.Type.userspace) {
                return this.fImagePool.getImageUnchecked("IMAGE_USERSPACE");
            }
            if (object.getType() == IRemoteObject.Type.module) {
                return this.fImagePool.getImageUnchecked("IMAGE_MODULE");
            }
        } else if (obj instanceof String) {
            return this.fImagePool.getImageUnchecked("IMAGE_REFRESH");
        }
        return this.fImagePool.getImageUnchecked("IMAGE_DEFAULT");
    }
}

