/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.explorer;

import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.LinkedList;
import java.util.stream.Collectors;
import miworkplace.common.debug.Debug;
import miworkplace.common.debug.Option;
import miworkplace.common.model.IConnection;
import miworkplace.common.model.IRemoteObject;
import miworkplace.common.model.IWorkspaceStore;
import miworkplace.common.model.SourceMember;
import miworkplace.common.model.StreamFile;
import miworkplace.connection.api.IConnectionManager;
import miworkplace.i18n.Messages;
import miworkplace.notifications.Notifier;
import miworkplace.services.api.ICompileSettingsProvider;
import miworkplace.services.api.IContentTypeRegistry;
import miworkplace.services.api.ITextAttributeService;
import miworkplace.ui.api.ICompileResultService;
import miworkplace.ui.api.WorkspaceUtil;
import miworkplace.ui.compile.CompileResult;
import miworkplace.ui.explorer.IfsContentProvider;
import miworkplace.ui.explorer.IfsViewer;
import miworkplace.ui.explorer.QsysViewer;
import miworkplace.ui.explorer.RemoteExplorerContentProvider;
import miworkplace.ui.explorer.RemoteExplorerLabelProvider;
import miworkplace.ui.explorer.filter.FilterManager;
import miworkplace.ui.explorer.filter.FilterMatcher;
import miworkplace.ui.handler.WindowCloseHandler;
import miworkplace.ui.network.NetworkPreferencesObserver;
import miworkplace.ui.util.RefreshWorkbench;
import miworkplace.ui.util.VersionChecker;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.commands.EHandlerService;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.di.extensions.Preference;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.di.PersistState;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.model.application.ui.menu.MHandledToolItem;
import org.eclipse.e4.ui.services.EContextService;
import org.eclipse.e4.ui.services.EMenuService;
import org.eclipse.e4.ui.services.IStylingEngine;
import org.eclipse.e4.ui.services.help.EHelpService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.e4.ui.workbench.modeling.IWindowCloseHandler;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.osgi.service.event.Event;
import org.osgi.service.prefs.BackingStoreException;

public class RemoteExplorer {
    private static final String MIWORKPLACE_NOTIFICATIONS_POSITION = "miworkplace.notifications.position";
    private static final String MIWORKPLACE_UI_GENERAL_VERSIONCHECK = "miworkplace.ui.general.versioncheck";
    private static final String MIWORKPLACE_REMOTEEXPLORER_QSYS = "miworkplace-remoteexplorer-qsys";
    private static final String MIWORKPLACE_REMOTEEXPLORER_IFS = "miworkplace-remoteexplorer-ifs";
    private static final String SEP = "/";
    private static final String MIWORKPLACE_UI_EXPLORER_VIEWER_PARENT = "miworkplace.ui.explorer.viewer.parent";
    private static final String MIWORKPLACE_UI_SOURCE_ID = "miworkplace.ui.source.id";
    private static final String PROP_REVEAL = "reveal";
    private static final String BINDING_CTX_EXPLORER = "miworkplace.ui.bindingcontext.explorer";
    private static final String BINDING_CTX_IFS = "miworkplace.ui.bindingcontext.explorer.ifs";
    public static final String PART_ID = "miworkplace.ui.explorer";
    private static final String POPUPMENU_QSYS_ID = "miworkplace.ui.menu.popup.explorer";
    private static final String TOGGLE_ID = "miworkplace.ui.handledtoolitem.uiremoteexplorerfstoggle";
    public static final int LIBRARY_SEGMENT_COUNT = 4;
    public static final int OBJECT_SEGMENT_COUNT = 5;
    public static final int MEMBER_SEGMENT_COUNT = 6;
    Debug debug = Debug.getInstance();
    @Inject
    private MApplication application;
    @Inject
    private IEclipseContext context;
    @Inject
    private ECommandService commandService;
    @Inject
    private EHandlerService handlerService;
    @Inject
    private IConnectionManager connectionManager;
    @Inject
    private IWorkspace workspace;
    @Inject
    private IWorkspaceStore workspaceStore;
    @Inject
    private IEventBroker fEventBroker;
    @Inject
    EHelpService fHelpService;
    @Inject
    private FilterManager fFilterManager;
    @Inject
    private IContentTypeRegistry contentTypeRegistry;
    @Inject
    @Preference(nodePath="miworkplace.application")
    private IEclipsePreferences applicationPreferences;
    @Inject
    @Preference(nodePath="miworkplace.application/contenttypes")
    private IEclipsePreferences contentTypePreferences;
    @Inject
    private ITextAttributeService textAttributeService;
    @Inject
    @Preference(nodePath="miworkplace.application/appearance")
    private IEclipsePreferences appearancePreferences;
    @Inject
    private ICompileSettingsProvider compileSettingsProvider;
    @Inject
    private ICompileResultService fCompileResultService;
    @Inject
    @Preference(nodePath="miworkplace.application/compilers")
    private IEclipsePreferences compileSettingsPreferences;
    @Inject
    @Preference(nodePath="miworkplace.application/explorer")
    private IEclipsePreferences uiPreferences;
    @Inject
    private EContextService contextService;
    @Inject
    private IStylingEngine engine;
    private Composite parent;
    private TreeViewer qsysViewer;
    private TreeViewer ifsViewer;
    private LabelProvider labelProvider;
    private RemoteExplorerContentProvider contentProvider;
    private StackLayout mainLayout;
    private Composite noConnectionPanel;
    private ViewerFilter[] filterViewers = null;
    private boolean qsysViewerShowing = true;
    private final Long sourceId = System.currentTimeMillis();
    private PropertyChangeListener fCompileResultListener;

    @PostConstruct
    public void postConstruct(Composite parent, EMenuService menuService, ESelectionService selectionService, MPart part) {
        WorkspaceUtil.setWorkspace(this.workspace);
        WorkspaceUtil.setWorkspaceStore(this.workspaceStore);
        WorkspaceUtil.setEclipseContext(this.context);
        this.workspaceStore.setWorkspace(this.workspace);
        this.parent = parent;
        IEclipseContext additionalContext = EclipseContextFactory.create();
        additionalContext.set(MIWORKPLACE_UI_SOURCE_ID, (Object)this.sourceId);
        this.contentProvider = (RemoteExplorerContentProvider)ContextInjectionFactory.make(RemoteExplorerContentProvider.class, (IEclipseContext)this.context, (IEclipseContext)additionalContext);
        this.labelProvider = (LabelProvider)ContextInjectionFactory.make(RemoteExplorerLabelProvider.class, (IEclipseContext)this.context, (IEclipseContext)additionalContext);
        this.mainLayout = new StackLayout();
        parent.setLayout((Layout)this.mainLayout);
        this.filterViewers = this.buildViewerFilter();
        this.buildNoConnectionLabel(parent);
        this.buildQsysViewer(parent);
        this.ifsViewer = this.buildIfsViewer(parent);
        this.updateViewerFilters();
        this.engine.setId((Object)this.qsysViewer.getControl(), MIWORKPLACE_REMOTEEXPLORER_QSYS);
        this.engine.setId((Object)this.ifsViewer.getControl(), MIWORKPLACE_REMOTEEXPLORER_IFS);
        menuService.registerContextMenu((Object)this.qsysViewer.getControl(), POPUPMENU_QSYS_ID);
        this.doUnrelatedWork();
        this.updateViewerFilters();
        this.qsysViewerShowing = this.uiPreferences.get("miworkplace.ui.explorer.viewer.showing", "qsys").equals("qsys");
        this.fHelpService.setHelp((Object)parent, "miworkplace.help.MIW: Remote Explorer");
        this.showComponents(part);
        this.fEventBroker.post("miworkplace/ui/explorer/loaded", (Object)part);
    }

    private void doUnrelatedWork() {
        new NetworkPreferencesObserver().setPreferences(this.applicationPreferences);
        if (this.applicationPreferences.getBoolean(MIWORKPLACE_UI_GENERAL_VERSIONCHECK, true)) {
            VersionChecker versionChecker = (VersionChecker)((Object)ContextInjectionFactory.make(VersionChecker.class, (IEclipseContext)this.context));
            versionChecker.schedule();
            RefreshWorkbench refresh = (RefreshWorkbench)((Object)ContextInjectionFactory.make(RefreshWorkbench.class, (IEclipseContext)this.context));
            refresh.schedule();
        }
        this.contentTypeRegistry.setPreferences(this.contentTypePreferences);
        this.textAttributeService.setPreferences(this.appearancePreferences);
        this.compileSettingsProvider.setPreferences(this.compileSettingsPreferences);
        this.fCompileResultService.addCompileResultListener(this.getCompileResultListener());
        WindowCloseHandler handler = (WindowCloseHandler)ContextInjectionFactory.make(WindowCloseHandler.class, (IEclipseContext)this.context);
        MWindow window = (MWindow)this.application.getChildren().get(0);
        window.getContext().set(IWindowCloseHandler.class, (Object)handler);
        this.applicationPreferences.addPreferenceChangeListener(new IEclipsePreferences.IPreferenceChangeListener(){

            public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
                if (event.getKey().equals(RemoteExplorer.MIWORKPLACE_NOTIFICATIONS_POSITION)) {
                    Notifier.Placement placement = Notifier.Placement.valueOf((String)event.getNewValue().toString());
                    Notifier.setPlacement((Notifier.Placement)placement);
                }
            }
        });
        String notificationPlacement = this.applicationPreferences.get(MIWORKPLACE_NOTIFICATIONS_POSITION, Notifier.Placement.WINDOW_BOTTOM.name());
        try {
            Notifier.Placement placement = Notifier.Placement.valueOf((String)notificationPlacement);
            Notifier.setPlacement((Notifier.Placement)placement);
        }
        catch (Exception e) {
            this.debug.error(MessageFormat.format("Could not set notification placement. Placement: {0}", notificationPlacement), (Throwable)e);
            Notifier.setPlacement((Notifier.Placement)Notifier.Placement.WINDOW_BOTTOM);
        }
    }

    private PropertyChangeListener getCompileResultListener() {
        if (this.fCompileResultListener == null) {
            this.fCompileResultListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent pEvent) {
                    CompileResult oldValue = (CompileResult)pEvent.getOldValue();
                    CompileResult newValue = (CompileResult)pEvent.getNewValue();
                    if (oldValue == null && newValue != null && newValue.hasErrors() || oldValue != null && newValue != null && oldValue.hasErrors() != newValue.hasErrors()) {
                        IRemoteObject remoteObject = RemoteExplorer.this.workspaceStore.get(newValue.getSource().getConnection(), newValue.getSource().getPath());
                        if (remoteObject instanceof SourceMember) {
                            RemoteExplorer.this.qsysViewer.refresh((Object)remoteObject, true);
                        }
                        if (remoteObject instanceof StreamFile) {
                            RemoteExplorer.this.ifsViewer.refresh((Object)remoteObject, true);
                        }
                    } else if (oldValue != null) {
                        IRemoteObject remoteObject = RemoteExplorer.this.workspaceStore.get(oldValue.getSource().getConnection(), oldValue.getSource().getPath());
                        if (remoteObject instanceof SourceMember) {
                            RemoteExplorer.this.qsysViewer.refresh((Object)remoteObject, true);
                        }
                        if (remoteObject instanceof StreamFile) {
                            RemoteExplorer.this.ifsViewer.refresh((Object)remoteObject, true);
                        }
                    }
                }
            };
        }
        return this.fCompileResultListener;
    }

    private void showComponents(MPart pPart) {
        if (this.connectionManager.list().isEmpty()) {
            this.mainLayout.topControl = this.noConnectionPanel;
        } else {
            if (this.qsysViewerShowing) {
                this.mainLayout.topControl = this.qsysViewer.getControl();
                this.contextService.deactivateContext(BINDING_CTX_IFS);
                this.contextService.activateContext(BINDING_CTX_EXPLORER);
            } else {
                this.mainLayout.topControl = this.ifsViewer.getControl();
                this.contextService.deactivateContext(BINDING_CTX_EXPLORER);
                this.contextService.activateContext(BINDING_CTX_IFS);
            }
            this.saveActiveViewer();
            this.filtersChanged();
        }
        this.setToggleIcon(pPart);
        this.parent.requestLayout();
    }

    private void setToggleIcon(MPart pPart) {
        MHandledToolItem item = (MHandledToolItem)pPart.getToolbar().getChildren().stream().filter(i -> TOGGLE_ID.equals(i.getElementId())).collect(Collectors.toList()).get(0);
        if (this.qsysViewerShowing) {
            item.setIconURI("platform:/plugin/miworkplace.images/icons/ifs.png");
        } else {
            item.setIconURI("platform:/plugin/miworkplace.images/icons/qsys.png");
        }
    }

    @Focus
    public void onFocus(EPartService partService) {
        this.qsysViewer.getControl().setFocus();
    }

    @PersistState
    public void persist(MPart part) {
        this.saveActiveViewer();
    }

    private void saveActiveViewer() {
        String currentViewer = this.qsysViewerShowing ? "qsys" : "ifs";
        this.uiPreferences.put("miworkplace.ui.explorer.viewer.showing", currentViewer);
        try {
            this.uiPreferences.flush();
        }
        catch (BackingStoreException e) {
            this.debug.error("Error saving UI Remote Explorer preferences. " + e.getMessage(), (Throwable)e);
        }
    }

    @Inject
    @Optional
    public void notifiedViewerInputChange(@UIEventTopic(value="miworkplace/ui/explorer/input/change") Event event) {
        this.setViewerInput(event.getProperty("org.eclipse.e4.data"));
    }

    @Inject
    @Optional
    public void notifiedViewerFilterChange(@UIEventTopic(value="miworkplace/ui/filter/changed") Event event) {
        this.filtersChanged();
    }

    private void filtersChanged() {
        this.filterViewers = this.buildViewerFilter();
        this.updateViewerFilters();
        this.updateConnectionLabels();
    }

    private void updateConnectionLabels() {
        for (IConnection connection : this.connectionManager.list()) {
            this.ifsViewer.update((Object)connection, null);
            this.qsysViewer.update((Object)connection, null);
        }
    }

    @Inject
    @Optional
    public void notifiedViewerInputMoveUp(@UIEventTopic(value="miworkplace/ui/explorer/input/up") Event event) {
        if (this.isQsysViewShowing()) {
            if (this.qsysViewer.getInput() instanceof IConnection) {
                this.setViewerInput(this.connectionManager);
            } else if (this.qsysViewer.getInput() instanceof IRemoteObject) {
                IRemoteObject object = (IRemoteObject)this.qsysViewer.getInput();
                if (object.getType() == IRemoteObject.Type.library) {
                    this.setViewerInput(object.getConnection());
                } else if (object.getType() == IRemoteObject.Type.file) {
                    this.setViewerInput(this.workspaceStore.getLibrary(object));
                }
            }
        } else if (!(this.ifsViewer.getInput() instanceof IConnectionManager)) {
            if (this.ifsViewer.getInput() instanceof IConnection) {
                this.setViewerInput(this.connectionManager);
            } else {
                IRemoteObject object = (IRemoteObject)this.ifsViewer.getInput();
                if (object.getType() == IRemoteObject.Type.streamfile) {
                    if (SEP.equals(object.getPath())) {
                        this.setViewerInput(object.getConnection());
                    } else if (this.workspaceStore.getParentFile(object) == null) {
                        this.setViewerInput(object.getConnection());
                    } else {
                        this.setViewerInput(this.workspaceStore.getParentFile(object));
                    }
                }
            }
        }
    }

    @Inject
    @Optional
    public void notifiedShowIfsViewer(@UIEventTopic(value="miworkplace/ui/explorer/toplevel/ifs") Event event, MPart part) {
        if (this.qsysViewerShowing) {
            this.doSwitchTopLevelView(part);
        }
        if (this.qsysViewerShowing) {
            this.doSwitchTopLevelView(part);
        }
    }

    @Inject
    @Optional
    public void notifiedShowQsysViewer(@UIEventTopic(value="miworkplace/ui/explorer/toplevel/qsys") Event event, MPart part) {
        if (!this.qsysViewerShowing) {
            this.doSwitchTopLevelView(part);
        }
    }

    @Inject
    @Optional
    public void notifiedSwitchTopLevelView(@UIEventTopic(value="miworkplace/ui/explorer/toplevel/switch") Event event, MPart part) {
        this.doSwitchTopLevelView(part);
    }

    private void doSwitchTopLevelView(MPart part) {
        this.qsysViewerShowing = !this.qsysViewerShowing;
        this.showComponents(part);
    }

    @Inject
    @Optional
    public void notifiedExpandPath(@UIEventTopic(value="miworkplace/ui/explorer/ifs/expand") Event event, MPart part) {
        boolean reveal;
        boolean bl = reveal = event.containsProperty(PROP_REVEAL) ? Boolean.parseBoolean(event.getProperty(PROP_REVEAL).toString()) : false;
        if (reveal) {
            this.showIfsViewer(part);
        }
    }

    private void showIfsViewer(MPart pPart) {
        this.qsysViewerShowing = false;
        this.showComponents(pPart);
    }

    public boolean isQsysViewShowing() {
        return this.qsysViewerShowing;
    }

    private void setViewerInput(Object input) {
        this.debug.traceEntry((Option)miworkplace.ui.debug.Option.loading, new Object[]{MessageFormat.format("Set new input for RemoteExplorer: {0} - {1}", input.getClass().getName(), input.toString()), input});
        TreeViewer viewer = this.isQsysViewShowing() ? this.qsysViewer : this.ifsViewer;
        Object oldViewerInput = viewer.getInput();
        Object[] expandedElements = viewer.getExpandedElements();
        Object selectedObject = null;
        if (viewer.getSelection() != null) {
            IStructuredSelection selection = (IStructuredSelection)viewer.getSelection();
            selectedObject = selection.getFirstElement();
        }
        viewer.setInput(input);
        viewer.refresh();
        viewer.expandToLevel(oldViewerInput, 1);
        int i = 0;
        while (i < expandedElements.length) {
            viewer.expandToLevel(expandedElements[i], 1);
            ++i;
        }
        if (selectedObject != null) {
            viewer.reveal(selectedObject);
        }
        this.debug.traceExit((Option)miworkplace.ui.debug.Option.loading, null);
    }

    @Inject
    @Optional
    public void notifiedConnection(@UIEventTopic(value="miworkplace/connection/*") Event event, MPart pPart) {
        try {
            if (event.getTopic().equals("miworkplace/connection/connected")) {
                this.qsysViewer.refresh();
            } else if (event.getTopic().equals("miworkplace/connection/changed")) {
                this.qsysViewer.refresh();
            } else if (event.getTopic().equals("miworkplace/connection/created")) {
                if (this.connectionManager.list().size() == 1) {
                    this.showComponents(pPart);
                }
                this.qsysViewer.refresh();
            } else if (event.getTopic().equals("miworkplace/connection/deleted")) {
                if (this.connectionManager.list().isEmpty()) {
                    this.showComponents(pPart);
                }
                this.qsysViewer.refresh();
            } else if (event.getTopic().equals("miworkplace/connection/disconnected")) {
                this.qsysViewer.refresh();
            }
        }
        catch (SWTException sWTException) {}
    }

    @Inject
    @Optional
    public void notifiedFilterEnablementChanged(@UIEventTopic(value="miworkplace/ui/filter/enablement/changed") Event event) {
        this.updateViewerFilters();
    }

    private void buildNoConnectionLabel(Composite parent) {
        FormToolkit toolkit = new FormToolkit(parent.getDisplay());
        Form form = toolkit.createForm(parent);
        RowLayout layout = new RowLayout();
        form.getBody().setLayout((Layout)layout);
        toolkit.createLabel(form.getBody(), Messages.ui_explorer_noconns_1);
        Hyperlink link = toolkit.createHyperlink(form.getBody(), Messages.ui_explorer_noconns_2, 64);
        link.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                ParameterizedCommand command = RemoteExplorer.this.commandService.createCommand("miworkplace.ui.command.newConnection", null);
                RemoteExplorer.this.handlerService.executeHandler(command);
            }
        });
        toolkit.createLabel(form.getBody(), Messages.ui_explorer_noconns_3, 64);
        this.noConnectionPanel = form;
    }

    private void buildQsysViewer(Composite parent) {
        IEclipseContext additionalContext = EclipseContextFactory.create();
        additionalContext.set(MIWORKPLACE_UI_EXPLORER_VIEWER_PARENT, (Object)parent);
        additionalContext.set(MIWORKPLACE_UI_SOURCE_ID, (Object)this.sourceId);
        this.qsysViewer = (TreeViewer)ContextInjectionFactory.make(QsysViewer.class, (IEclipseContext)this.context, (IEclipseContext)additionalContext);
        this.qsysViewer.setContentProvider((IContentProvider)this.contentProvider);
        this.qsysViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.qsysViewer.setUseHashlookup(true);
        this.qsysViewer.setInput((Object)this.connectionManager);
    }

    private TreeViewer buildIfsViewer(Composite parent) {
        IEclipseContext additionalContext = EclipseContextFactory.create();
        additionalContext.set(MIWORKPLACE_UI_EXPLORER_VIEWER_PARENT, (Object)parent);
        additionalContext.set(MIWORKPLACE_UI_SOURCE_ID, (Object)this.sourceId);
        TreeViewer viewer = (TreeViewer)ContextInjectionFactory.make(IfsViewer.class, (IEclipseContext)this.context, (IEclipseContext)additionalContext);
        viewer.setContentProvider((IContentProvider)ContextInjectionFactory.make(IfsContentProvider.class, (IEclipseContext)this.context, (IEclipseContext)additionalContext));
        viewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        viewer.setUseHashlookup(true);
        viewer.setInput((Object)this.connectionManager);
        return viewer;
    }

    private void updateViewerFilters() {
        Object[] expandedElements = this.qsysViewer.getExpandedElements();
        Object selectedObject = null;
        if (this.qsysViewer.getSelection() != null) {
            IStructuredSelection selection = (IStructuredSelection)this.qsysViewer.getSelection();
            selectedObject = selection.getFirstElement();
        }
        this.qsysViewer.setFilters(this.filterViewers);
        this.ifsViewer.setFilters(this.filterViewers);
        int i = 0;
        while (i < expandedElements.length) {
            this.qsysViewer.expandToLevel(expandedElements[i], 1);
            ++i;
        }
        if (selectedObject != null) {
            this.qsysViewer.reveal(selectedObject);
        }
    }

    private ViewerFilter[] buildViewerFilter() {
        LinkedList<4> viewFilters = new LinkedList<4>();
        final FilterMatcher m = new FilterMatcher(this.fFilterManager, !this.qsysViewerShowing);
        viewFilters.add(new ViewerFilter(){

            public boolean select(Viewer pViewer, Object pParentElement, Object pElement) {
                return m.select(pElement);
            }
        });
        return viewFilters.toArray(new ViewerFilter[0]);
    }

    public Long getSourceId() {
        return this.sourceId;
    }

    Object getViewerInput() {
        return this.qsysViewer.getInput();
    }

    public void viewerRefresh() {
        this.qsysViewer.refresh();
    }
}

