/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.dialog;

import com.ibm.as400.access.QSYSObjectPathName;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import miworkplace.common.model.IRemoteObject;
import miworkplace.i18n.Messages;
import miworkplace.ui.dialog.BoundModule;
import miworkplace.ui.dialog.BoundServiceProgram;
import miworkplace.ui.dialog.ServiceProgramInfo;
import miworkplace.ui.dialog.ServiceProgramInfoRetriever;
import miworkplace.ui.dialog.StructuredContentProvider;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.util.Geometry;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.osgi.service.log.LogService;

public class ServiceProgramInfoDialog
extends TitleAreaDialog {
    private LogService logger;
    private IRemoteObject serviceProgram;
    private StackLayout mainLayout;
    private Label noInfoPanel;
    private Composite parent;

    @Inject
    public ServiceProgramInfoDialog(@Named(value="activeShell") Shell shell, IRemoteObject serviceProgram, LogService logger) {
        super(shell);
        this.serviceProgram = serviceProgram;
        this.logger = logger;
    }

    public boolean isHelpAvailable() {
        return false;
    }

    protected Control createDialogArea(Composite parent) {
        QSYSObjectPathName path = new QSYSObjectPathName(this.serviceProgram.getPath());
        this.setTitle(Messages.ui_dialog_srvpgm_title);
        this.setMessage(String.format(Messages.ui_dialog_srvpgm_desc, path.getLibraryName(), path.getObjectName()));
        this.setTitleImage(new Image((Device)parent.getShell().getDisplay(), ((Object)((Object)this)).getClass().getResourceAsStream("/icons/serviceprogram-dialogtitle.png")));
        parent.getShell().setText(Messages.ui_dialog_srvpgm_title);
        parent.setLayout((Layout)new GridLayout());
        this.parent = (Composite)super.createDialogArea(parent);
        this.mainLayout = new StackLayout();
        this.mainLayout.marginHeight = 10;
        this.mainLayout.marginWidth = 10;
        this.parent.setLayout((Layout)this.mainLayout);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.heightHint = 400;
        gridData.widthHint = 400;
        this.parent.setLayoutData((Object)gridData);
        this.noInfoPanel = this.buildNoInfoLabel(this.parent);
        this.mainLayout.topControl = this.noInfoPanel;
        ServiceProgramInfo info = new ServiceProgramInfo();
        new ServiceProgramInfoRetriever(this.serviceProgram.getConnection(), info, this.serviceProgram.getPath(), this.logger).run();
        Composite tabs = this.buildInfoTabs(this.parent, info);
        this.mainLayout.topControl = tabs;
        return this.parent;
    }

    private Label buildNoInfoLabel(Composite parent) {
        Label l = new Label(parent, 0);
        l.setText(Messages.ui_dialog_srvpgm_noinfo);
        return l;
    }

    protected boolean isResizable() {
        return true;
    }

    protected Point getInitialLocation(Point initialSize) {
        Composite parent = this.getShell().getParent();
        Monitor monitor = this.getShell().getDisplay().getPrimaryMonitor();
        if (parent != null) {
            monitor = parent.getMonitor();
        }
        Rectangle monitorBounds = monitor.getClientArea();
        Point centerPoint = parent != null ? Geometry.centerPoint((Rectangle)parent.getBounds()) : Geometry.centerPoint((Rectangle)monitorBounds);
        return new Point(centerPoint.x - initialSize.x / 2, Math.max(monitorBounds.y, Math.min(centerPoint.y - initialSize.y * 2 / 3, monitorBounds.y + monitorBounds.height - initialSize.y)));
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
    }

    private Composite buildInfoTabs(Composite parent, ServiceProgramInfo info) {
        TabFolder tabs = new TabFolder(parent, 0);
        TabItem tab = new TabItem(tabs, 0);
        tab.setText(Messages.ui_dialog_srvpgm_crtinfo);
        tab.setControl(this.buildTabCreationInfo((Composite)tabs, info));
        tab = new TabItem(tabs, 0);
        tab.setText(Messages.ui_dialog_srvpgm_stats);
        tab.setControl(this.buildTabStatistics((Composite)tabs, info));
        tab = new TabItem(tabs, 0);
        tab.setText(Messages.ui_dialog_srvpgm_size);
        tab.setControl(this.buildTabSize((Composite)tabs, info));
        tab = new TabItem(tabs, 0);
        tab.setText(Messages.ui_dialog_srvpgm_mods);
        tab.setControl(this.buildTabModules((Composite)tabs, info));
        tab = new TabItem(tabs, 0);
        tab.setText(Messages.ui_dialog_srvpgm_bound);
        tab.setControl(this.buildTabBoundServicePrograms((Composite)tabs, info));
        tab = new TabItem(tabs, 0);
        tab.setText(Messages.ui_dialog_srvpgm_procexp);
        tab.setControl(this.buildTabProcedureExports((Composite)tabs, info));
        tab = new TabItem(tabs, 0);
        tab.setText(Messages.ui_dialog_srvpgm_dataexp);
        tab.setControl(this.buildTabDataExports((Composite)tabs, info));
        tab = new TabItem(tabs, 0);
        tab.setText(Messages.ui_dialog_srvpgm_sigs);
        tab.setControl(this.buildTabSignatures((Composite)tabs, info));
        tab = new TabItem(tabs, 0);
        tab.setText(Messages.ui_dialog_srvpgm_copy);
        tab.setControl(this.buildTabCopyrights((Composite)tabs, info));
        return tabs;
    }

    private Control buildTabSize(Composite parent, ServiceProgramInfo info) {
        Table table = new Table(parent, 768);
        table.setHeaderVisible(false);
        TableColumn nameColumn = new TableColumn(table, 0);
        TableColumn valueColumn = new TableColumn(table, 0);
        TableItem item = new TableItem(table, 0);
        item.setText(new String[]{Messages.ui_dialog_srvpgm_size_numberdata, String.valueOf(info.dataExports.size())});
        item = new TableItem(table, 0);
        item.setText(new String[]{Messages.ui_dialog_srvpgm_size_numbermods, String.valueOf(info.modules.size())});
        item = new TableItem(table, 0);
        item.setText(new String[]{Messages.ui_dialog_srvpgm_size_numbersrvpgm, String.valueOf(info.bounded.size())});
        item = new TableItem(table, 0);
        item.setText(new String[]{Messages.ui_dialog_srvpgm_size_numbersigs, String.valueOf(info.signatures.size())});
        item = new TableItem(table, 0);
        item.setText(new String[]{Messages.ui_dialog_srvpgm_size_numberprocs, String.valueOf(info.procedures.size())});
        item = new TableItem(table, 0);
        item.setText(new String[]{Messages.ui_dialog_srvpgm_size_kb, info.size.toString()});
        item = new TableItem(table, 0);
        item.setText(new String[]{Messages.ui_dialog_srvpgm_size_static, info.staticStorageSize.toString()});
        nameColumn.setWidth(300);
        valueColumn.setWidth(200);
        return table;
    }

    private Control buildTabModules(Composite parent, ServiceProgramInfo info) {
        TableViewer viewer = new TableViewer(parent, 768);
        viewer.setContentProvider((IContentProvider)new StructuredContentProvider(){

            @Override
            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof ServiceProgramInfo) {
                    List<BoundModule> modules = ((ServiceProgramInfo)inputElement).modules;
                    Collections.sort(modules, new Comparator<BoundModule>(){

                        @Override
                        public int compare(BoundModule m1, BoundModule m2) {
                            return m1.toString().compareTo(m2.toString());
                        }
                    });
                    return ((ServiceProgramInfo)inputElement).modules.toArray();
                }
                return super.getElements(inputElement);
            }
        });
        viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        viewer.setInput((Object)info);
        return viewer.getTable();
    }

    private Control buildTabBoundServicePrograms(Composite parent, ServiceProgramInfo info) {
        Collections.sort(info.bounded, new Comparator<BoundServiceProgram>(){

            @Override
            public int compare(BoundServiceProgram sp1, BoundServiceProgram sp2) {
                return sp1.toString().compareTo(sp2.toString());
            }
        });
        Table table = new Table(parent, 768);
        table.setHeaderVisible(true);
        TableColumn libraryColumn = new TableColumn(table, 0);
        libraryColumn.setText(Messages.ui_dialog_srvpgm_bound_col_lib);
        TableColumn nameColumn = new TableColumn(table, 0);
        nameColumn.setText(Messages.ui_dialog_srvpgm_bound_col_name);
        TableColumn signatureColumn = new TableColumn(table, 0);
        signatureColumn.setText(Messages.ui_dialog_srvpgm_bound_col_sig);
        TableColumn activationColumn = new TableColumn(table, 0);
        activationColumn.setText(Messages.ui_dialog_srvpgm_bound_col_act);
        for (BoundServiceProgram sp : info.bounded) {
            TableItem item = new TableItem(table, 0);
            item.setText(new String[]{sp.library, sp.serviceProgram, sp.signature, sp.activation});
        }
        libraryColumn.setWidth(100);
        nameColumn.setWidth(100);
        signatureColumn.setWidth(250);
        activationColumn.setWidth(100);
        return table;
    }

    private Control buildTabDataExports(Composite parent, ServiceProgramInfo info) {
        TableViewer viewer = new TableViewer(parent, 768);
        viewer.setContentProvider((IContentProvider)new StructuredContentProvider(){

            @Override
            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof ServiceProgramInfo) {
                    List<String> dataExports = ((ServiceProgramInfo)inputElement).dataExports;
                    Collections.sort(dataExports);
                    return dataExports.toArray();
                }
                return super.getElements(inputElement);
            }
        });
        viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        viewer.setInput((Object)info);
        return viewer.getTable();
    }

    private Control buildTabProcedureExports(Composite parent, ServiceProgramInfo info) {
        TableViewer viewer = new TableViewer(parent, 768);
        viewer.setContentProvider((IContentProvider)new StructuredContentProvider(){

            @Override
            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof ServiceProgramInfo) {
                    List<String> procedures = ((ServiceProgramInfo)inputElement).procedures;
                    Collections.sort(procedures);
                    return procedures.toArray();
                }
                return super.getElements(inputElement);
            }
        });
        viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        viewer.setInput((Object)info);
        return viewer.getTable();
    }

    private Control buildTabCopyrights(Composite parent, ServiceProgramInfo info) {
        TableViewer viewer = new TableViewer(parent, 768);
        viewer.setContentProvider((IContentProvider)new StructuredContentProvider(){

            @Override
            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof ServiceProgramInfo) {
                    return ((ServiceProgramInfo)inputElement).copyrights.toArray();
                }
                return super.getElements(inputElement);
            }
        });
        viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        viewer.setInput((Object)info);
        return viewer.getTable();
    }

    private Control buildTabSignatures(Composite parent, ServiceProgramInfo info) {
        TableViewer viewer = new TableViewer(parent, 768);
        viewer.setContentProvider((IContentProvider)new StructuredContentProvider(){

            @Override
            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof ServiceProgramInfo) {
                    return ((ServiceProgramInfo)inputElement).signatures.toArray();
                }
                return super.getElements(inputElement);
            }
        });
        viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        viewer.setInput((Object)info);
        return viewer.getTable();
    }

    private Control buildTabStatistics(Composite parent, ServiceProgramInfo info) {
        Table table = new Table(parent, 768);
        table.setHeaderVisible(false);
        TableColumn nameColumn = new TableColumn(table, 0);
        TableColumn valueColumn = new TableColumn(table, 0);
        TableItem item = new TableItem(table, 0);
        item.setText(new String[]{Messages.ui_dialog_srvpgm_stats_reinz, info.allowStaticStorageInitialization != false ? Messages.common_yes : Messages.common_no});
        item = new TableItem(table, 0);
        item.setText(new String[]{Messages.ui_dialog_srvpgm_stats_assspace, String.valueOf(info.associatedSpaceSize)});
        item = new TableItem(table, 0);
        item.setText(new String[]{Messages.ui_dialog_srvpgm_stats_earliest, info.releaseEarliestRun});
        item = new TableItem(table, 0);
        item.setText(new String[]{Messages.ui_dialog_srvpgm_stats_createdfor, info.releaseCreatedFor});
        item = new TableItem(table, 0);
        item.setText(new String[]{Messages.ui_dialog_srvpgm_stats_createdon, info.releaseCreated});
        item = new TableItem(table, 0);
        item.setText(new String[]{Messages.ui_dialog_srvpgm_stats_domain, info.domain});
        item = new TableItem(table, 0);
        item.setText(new String[]{Messages.ui_dialog_srvpgm_stats_size, info.size.toString()});
        item = new TableItem(table, 0);
        item.setText(new String[]{Messages.ui_dialog_srvpgm_stats_state, info.state});
        item = new TableItem(table, 0);
        item.setText(new String[]{Messages.ui_dialog_srvpgm_stats_static, info.staticStorageSize.toString()});
        nameColumn.setWidth(300);
        valueColumn.setWidth(200);
        return table;
    }

    private Control buildTabCreationInfo(Composite parent, ServiceProgramInfo info) {
        Table table = new Table(parent, 768);
        table.setHeaderVisible(false);
        TableColumn nameColumn = new TableColumn(table, 0);
        TableColumn valueColumn = new TableColumn(table, 0);
        TableItem item = new TableItem(table, 0);
        item.setText(new String[]{Messages.ui_dialog_srvpgm_crtinfo_act, info.activationGroup});
        item = new TableItem(table, 0);
        item.setText(new String[]{Messages.ui_dialog_srvpgm_crtinfo_bound, info.allowBoundServiceProgramLibraryUpdate != false ? Messages.common_yes : Messages.common_no});
        item = new TableItem(table, 0);
        item.setText(new String[]{Messages.ui_dialog_srvpgm_crtinfo_update, info.allowUpdate != false ? Messages.common_yes : Messages.common_no});
        item = new TableItem(table, 0);
        item.setText(new String[]{Messages.ui_dialog_srvpgm_crtinfo_ccsid, info.ccsid.toString()});
        item = new TableItem(table, 0);
        item.setText(new String[]{Messages.ui_dialog_srvpgm_crtinfo_export, this.buildExportSourceInfo(info)});
        item = new TableItem(table, 0);
        item.setText(new String[]{Messages.ui_dialog_srvpgm_crtinfo_shared, info.sharedActivationGroup != false ? Messages.common_yes : Messages.common_no});
        item = new TableItem(table, 0);
        item.setText(new String[]{Messages.ui_dialog_srvpgm_crtinfo_storage, info.storageModel});
        item = new TableItem(table, 0);
        item.setText(new String[]{Messages.ui_dialog_srvpgm_crtinfo_adopt, info.useAdoptedAuthority != false ? Messages.common_yes : Messages.common_no});
        item = new TableItem(table, 0);
        item.setText(new String[]{Messages.ui_dialog_srvpgm_crtinfo_user, info.userProfile});
        nameColumn.setWidth(300);
        valueColumn.setWidth(200);
        return table;
    }

    private String buildExportSourceInfo(ServiceProgramInfo info) {
        if (StringUtils.isNotBlank((CharSequence)info.exportSourceMember)) {
            StringBuffer buffer = new StringBuffer();
            if (info.exportSourceLibrary == null) {
                buffer.append("*LIBL/");
            } else {
                buffer.append(info.exportSourceLibrary + "/");
            }
            buffer.append(info.exportSourceName);
            buffer.append(",");
            buffer.append(info.exportSourceMember);
            return buffer.toString();
        }
        return "";
    }
}

