/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.dialog;

import com.ibm.as400.access.QSYSObjectPathName;
import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import miworkplace.common.model.IConnection;
import miworkplace.common.model.IRemoteObject;
import miworkplace.common.model.IWorkspaceStore;
import miworkplace.common.model.SourceMember;
import miworkplace.i18n.Messages;
import miworkplace.notifications.Notifier;
import miworkplace.services.api.IActiveConnectionService;
import miworkplace.ui.api.WorkspaceUtil;
import miworkplace.ui.dialog.ExportContentProvider;
import miworkplace.ui.dialog.PathLabelProvider;
import miworkplace.ui.dialog.SourceContentLoader;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.e4.ui.di.UISynchronize;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.util.Geometry;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.osgi.service.log.LogService;

public class ExportDialog
extends TitleAreaDialog {
    @Inject
    private IActiveConnectionService activeConnService;
    @Inject
    private IWorkspaceStore workspaceStore;
    @Inject
    @Named(value="org.eclipse.ui.selection")
    private TreeSelection selection;
    @Inject
    private UISynchronize uiSync;
    private LogService logger;
    private IConnection connection;
    private List<SourceMember> selectedElements;
    private CheckboxTableViewer viewer;
    private Text txtExportPath = null;
    private Button saveInDirectory = null;
    private Button saveInArchive = null;
    private Button createDirectoryStructure = null;
    private Button overrideFiles = null;
    private Button lowercaseNames = null;

    @Inject
    public ExportDialog(@Named(value="activeShell") Shell shell, LogService logger) {
        super(shell);
        this.logger = logger;
    }

    @PostConstruct
    public void postConstruct() {
        this.connection = this.activeConnService.getLastUsedActiveConnection();
        this.selectedElements = this.resolveSelectedObjectsToMembers();
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(Messages.ui_dialog_export_title);
        this.setMessage(String.format(Messages.ui_dialog_export_desc, this.connection.getName()));
        this.setTitleImage(new Image((Device)parent.getShell().getDisplay(), ((Object)((Object)this)).getClass().getResourceAsStream("/icons/export-wizard.png")));
        parent.getShell().setText(Messages.ui_dialog_export_title);
        Composite controls = this.buildControls(parent);
        this.initializeControls();
        return controls;
    }

    private void initializeControls() {
    }

    private Composite buildControls(Composite parent) {
        Composite p = (Composite)super.createDialogArea(parent);
        p.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite controls = new Composite(p, 0);
        controls.setLayoutData((Object)new GridData(4, 4, true, true));
        FormLayout parentLayout = new FormLayout();
        parentLayout.marginHeight = 15;
        parentLayout.marginWidth = 15;
        controls.setLayout((Layout)parentLayout);
        FormData formData = new FormData();
        formData.top = new FormAttachment();
        formData.left = new FormAttachment();
        formData.right = new FormAttachment(100);
        formData.bottom = new FormAttachment(50);
        Table table = this.buildTable(controls);
        this.viewer = new CheckboxTableViewer(table);
        this.viewer.setContentProvider((IContentProvider)new ExportContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new PathLabelProvider());
        this.viewer.setInput(this.selectedElements);
        this.viewer.getControl().setLayoutData((Object)formData);
        formData = new FormData();
        formData.top = new FormAttachment(this.viewer.getControl(), 25);
        Label lblExportPath = new Label(controls, 0);
        lblExportPath.setText(Messages.ui_dialog_export_path);
        lblExportPath.setLayoutData((Object)formData);
        formData = new FormData();
        formData.bottom = new FormAttachment((Control)lblExportPath, 0, 0x1000000);
        formData.right = new FormAttachment(this.viewer.getControl(), 0, 131072);
        Button browse = new Button(controls, 8);
        browse.setText(Messages.ui_dialog_export_browse);
        browse.setLayoutData((Object)formData);
        browse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ExportDialog.this.saveInDirectory.getSelection()) {
                    DirectoryDialog dialog = new DirectoryDialog(ExportDialog.this.getShell(), 4096);
                    String path = dialog.open();
                    if (path != null) {
                        ExportDialog.this.txtExportPath.setText(path);
                    }
                } else if (ExportDialog.this.saveInArchive.getSelection()) {
                    FileDialog dialog = new FileDialog(ExportDialog.this.getShell(), 4096);
                    dialog.setFilterExtensions(new String[]{"*.zip"});
                    String path = dialog.open();
                    if (path != null) {
                        ExportDialog.this.txtExportPath.setText(path);
                    }
                }
            }
        });
        formData = new FormData();
        formData.bottom = new FormAttachment((Control)lblExportPath, 0, 0x1000000);
        formData.left = new FormAttachment((Control)lblExportPath, 15, 131072);
        formData.right = new FormAttachment((Control)browse, -15, 16384);
        this.txtExportPath = new Text(controls, 2048);
        this.txtExportPath.setLayoutData((Object)formData);
        formData = new FormData();
        formData.top = new FormAttachment((Control)lblExportPath, 25);
        formData.left = new FormAttachment((Control)lblExportPath, 0, 16384);
        formData.right = new FormAttachment(100);
        formData.bottom = new FormAttachment(100);
        Group optionsGroup = new Group(controls, 32);
        optionsGroup.setLayoutData((Object)formData);
        optionsGroup.setLayout((Layout)new GridLayout(1, true));
        optionsGroup.setText(Messages.ui_dialog_export_options);
        this.saveInDirectory = new Button((Composite)optionsGroup, 16);
        this.saveInDirectory.setText(Messages.ui_dialog_export_dir);
        this.saveInDirectory.setSelection(true);
        this.saveInArchive = new Button((Composite)optionsGroup, 16);
        this.saveInArchive.setText(Messages.ui_dialog_export_zip);
        this.saveInArchive.setSelection(false);
        this.createDirectoryStructure = new Button((Composite)optionsGroup, 32);
        this.createDirectoryStructure.setText(Messages.ui_dialog_export_create_dir);
        this.createDirectoryStructure.setSelection(false);
        this.overrideFiles = new Button((Composite)optionsGroup, 32);
        this.overrideFiles.setText(Messages.ui_dialog_export_override);
        this.overrideFiles.setSelection(false);
        this.lowercaseNames = new Button((Composite)optionsGroup, 32);
        this.lowercaseNames.setText(Messages.ui_dialog_export_convnames);
        this.lowercaseNames.setSelection(false);
        this.viewer.setAllChecked(true);
        return controls;
    }

    private Table buildTable(Composite parent) {
        Table table = new Table(parent, 804);
        table.setHeaderVisible(false);
        table.setLinesVisible(false);
        TableColumn column = new TableColumn(table, 16384);
        column.setWidth(400);
        return table;
    }

    protected void okPressed() {
        if (this.isValid()) {
            try {
                new ProgressMonitorDialog(this.getShell()).run(true, true, (IRunnableWithProgress)new ExportRunner(this.viewer.getCheckedElements(), this.createDirectoryStructure.getSelection(), this.lowercaseNames.getSelection(), this.saveInDirectory.getSelection(), this.txtExportPath.getText(), this.overrideFiles.getSelection()));
            }
            catch (InvocationTargetException e) {
                if (e.getMessage() == null) {
                    Notifier.error((String)Messages.ui_dialog_export_notify_title_failed, (String)Messages.ui_dialog_export_notify_failed);
                } else {
                    this.logger.log(1, "Export failed.", (Throwable)e);
                    Notifier.error((String)Messages.ui_dialog_export_notify_title_failed, (String)Messages.ui_dialog_export_notify_failed_msg);
                }
            }
            catch (InterruptedException e) {
                Notifier.info((String)Messages.ui_dialog_export_notify_title_cancelled, (String)e.getLocalizedMessage());
            }
            super.okPressed();
        }
    }

    private void export(IProgressMonitor monitor, Object[] checkedMembers, boolean createDirectoryStructure, boolean lowercaseNames, boolean saveInDirectory, String exportPath, boolean override) {
        HashMap<SourceMember, Boolean> result = null;
        LinkedList<SourceMember> selectedMembers = new LinkedList<SourceMember>();
        Object[] objectArray = checkedMembers;
        int n = checkedMembers.length;
        int n2 = 0;
        while (n2 < n) {
            Object so = objectArray[n2];
            selectedMembers.add((SourceMember)so);
            ++n2;
        }
        result = saveInDirectory ? this.saveMembersToDirectory(selectedMembers, monitor, createDirectoryStructure, lowercaseNames, exportPath, override) : this.saveMembersToArchive(selectedMembers, monitor, createDirectoryStructure, lowercaseNames, exportPath, override);
        final int numberExportedMembers = this.getNumberExportedMembers(result);
        final int size = result.size();
        this.uiSync.asyncExec(new Runnable(){

            @Override
            public void run() {
                Notifier.info((String)Messages.ui_dialog_export_title, (String)String.format(Messages.ui_dialog_export_success, numberExportedMembers, size));
            }
        });
    }

    private boolean isValid() {
        if (this.viewer.getCheckedElements().length == 0) {
            return false;
        }
        return this.txtExportPath.getText() != null && this.txtExportPath.getText().length() != 0;
    }

    private boolean addFileToJar(SourceMember member, ZipOutputStream zipOut, boolean createDirectoryStructure, boolean toLowerCase) {
        boolean retVal = false;
        try {
            String content = new SourceContentLoader(member).load();
            QSYSObjectPathName path = new QSYSObjectPathName(member.getPath());
            StringReader in = new StringReader(content);
            ZipEntry entry = null;
            entry = createDirectoryStructure ? (toLowerCase ? new ZipEntry(path.getLibraryName().toLowerCase() + "/" + path.getObjectName().toLowerCase() + "/" + member.getName().toLowerCase() + "." + member.getSourceType().toLowerCase()) : new ZipEntry(path.getLibraryName() + "/" + path.getObjectName() + "/" + member.getName() + "." + member.getSourceType())) : (toLowerCase ? new ZipEntry(member.getName().toLowerCase() + "." + member.getSourceType().toLowerCase()) : new ZipEntry(member.getName() + "." + member.getSourceType()));
            zipOut.putNextEntry(entry);
            int len = 0;
            char[] buffer = new char[16384];
            while ((len = in.read(buffer)) > 0) {
                zipOut.write(new String(buffer).getBytes(), 0, len);
            }
            retVal = true;
        }
        catch (Exception e) {
            this.logger.log(1, "Could not add member " + member.getName() + " to jar. Cause: " + e.getMessage());
        }
        return retVal;
    }

    private int getNumberExportedMembers(HashMap<SourceMember, Boolean> exportResults) {
        int successfulExportCount = 0;
        for (SourceMember member : exportResults.keySet()) {
            if (!exportResults.get(member).booleanValue()) continue;
            ++successfulExportCount;
        }
        return successfulExportCount;
    }

    private List<SourceMember> resolveSelectedObjectsToMembers() {
        ArrayList<SourceMember> members = new ArrayList<SourceMember>();
        TreePath[] paths = this.selection.getPaths();
        int i = 0;
        while (i < paths.length) {
            Object object = paths[i].getLastSegment();
            if (object instanceof SourceMember) {
                members.add((SourceMember)object);
            } else if (object instanceof IRemoteObject && ((IRemoteObject)object).getAttribute() == IRemoteObject.Attribute.sourcefile) {
                IRemoteObject file = (IRemoteObject)object;
                if (!file.areChildrenLoaded()) {
                    WorkspaceUtil.load(this.connection, file.getPath());
                }
                List tmpMembers = this.workspaceStore.getMembers(file);
                for (IRemoteObject member : tmpMembers) {
                    if (members.contains(member)) continue;
                    members.add((SourceMember)member);
                }
            }
            ++i;
        }
        return members;
    }

    private HashMap<SourceMember, Boolean> saveMembersToDirectory(List<SourceMember> selectedMembers, IProgressMonitor monitor, boolean createDirectoryStructure, boolean toLowerCase, String exportPath, boolean override) {
        HashMap<SourceMember, Boolean> exportResults = new HashMap<SourceMember, Boolean>();
        monitor.beginTask(String.format(Messages.ui_dialog_export_task_title, selectedMembers.size()), selectedMembers.size());
        int counter = 0;
        for (SourceMember member : selectedMembers) {
            if (monitor.isCanceled()) break;
            monitor.subTask(String.format(Messages.ui_dialog_export_subtask_title, member.getName(), ++counter, selectedMembers.size()));
            String baseDirPath = exportPath;
            File sourceFile = null;
            QSYSObjectPathName path = new QSYSObjectPathName(member.getPath());
            if (createDirectoryStructure) {
                File dir = null;
                if (toLowerCase) {
                    dir = new File(baseDirPath + File.separator + path.getLibraryName().toLowerCase() + File.separator + path.getObjectName().toLowerCase());
                    dir.mkdirs();
                    sourceFile = new File(dir.getAbsolutePath() + File.separator + path.getMemberName().toLowerCase() + "." + member.getSourceType().toLowerCase());
                } else {
                    dir = new File(baseDirPath + File.separator + path.getLibraryName() + File.separator + path.getObjectName());
                    dir.mkdirs();
                    sourceFile = new File(dir.getAbsolutePath() + File.separator + member.getName() + "." + member.getSourceType());
                }
            } else {
                sourceFile = toLowerCase ? new File(baseDirPath + File.separator + member.getName().toLowerCase() + "." + member.getSourceType().toLowerCase()) : new File(baseDirPath + File.separator + member.getName() + "." + member.getSourceType());
            }
            try {
                if (override && sourceFile.exists()) {
                    sourceFile.delete();
                }
                sourceFile.createNewFile();
                String content = new SourceContentLoader(member).load();
                FileWriter out = new FileWriter(sourceFile);
                out.write(content);
                out.flush();
                out.close();
                exportResults.put(member, Boolean.TRUE);
            }
            catch (IOException ioe) {
                this.logger.log(1, "Could not export source " + member.getName() + ". Cause: " + ioe.getMessage());
                exportResults.put(member, Boolean.FALSE);
            }
            catch (Exception e) {
                this.logger.log(1, "Could not get content from server for source " + member.getName() + ".", (Throwable)e);
                exportResults.put(member, Boolean.FALSE);
            }
            monitor.worked(1);
        }
        monitor.done();
        return exportResults;
    }

    private HashMap<SourceMember, Boolean> saveMembersToArchive(List<SourceMember> selectedMembers, IProgressMonitor monitor, boolean createDirectoryStructure, boolean toLowerCase, String exportPath, boolean override) {
        HashMap<SourceMember, Boolean> exportResults = new HashMap<SourceMember, Boolean>();
        monitor.beginTask(String.format(Messages.ui_dialog_export_task_title, selectedMembers.size()), selectedMembers.size());
        int counter = 0;
        File zipFile = new File(exportPath);
        if (zipFile.exists() && override) {
            zipFile.delete();
        } else if (zipFile.exists()) {
            throw new RuntimeException(Messages.ui_dialog_export_error_zip_exists);
        }
        try {
            zipFile.createNewFile();
        }
        catch (IOException e) {
            this.logger.log(1, "Could not create source zip file " + zipFile.getPath() + ".", (Throwable)e);
            throw new RuntimeException(Messages.ui_dialog_export_error_zip_create);
        }
        ZipOutputStream zipOut = null;
        try {
            FileOutputStream fileOut = new FileOutputStream(zipFile);
            zipOut = new ZipOutputStream(fileOut);
            for (SourceMember member : selectedMembers) {
                monitor.subTask(String.format(Messages.ui_dialog_export_subtask_title, member.getName(), ++counter, selectedMembers.size()));
                if (monitor.isCanceled()) break;
                if (this.addFileToJar(member, zipOut, createDirectoryStructure, toLowerCase)) {
                    exportResults.put(member, Boolean.TRUE);
                } else {
                    exportResults.put(member, Boolean.FALSE);
                }
                monitor.worked(1);
            }
            zipOut.flush();
            zipOut.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.logger.log(1, "Zip archive file " + zipFile.getAbsolutePath() + " not found.");
            Notifier.error((String)Messages.ui_dialog_export_title, (String)Messages.ui_dialog_export_error_zip_notfound);
        }
        catch (IOException ioe) {
            this.logger.log(1, "Input/Output error during source member export to zip file.", (Throwable)ioe);
            Notifier.error((String)Messages.ui_dialog_export_title, (String)Messages.ui_dialog_export_error_member);
        }
        monitor.done();
        return exportResults;
    }

    protected Control createContents(Composite parent) {
        Control content = super.createContents(parent);
        parent.pack();
        return content;
    }

    protected void initializeBounds() {
        super.initializeBounds();
        Rectangle bounds = this.getShell().getBounds();
        Point location = this.getInitialLocation(new Point(bounds.width, bounds.height));
        this.getShell().setBounds(location.x, location.y, bounds.width, bounds.height);
    }

    protected Point getInitialLocation(Point initialSize) {
        Composite parent = this.getShell().getParent();
        Monitor monitor = this.getShell().getDisplay().getPrimaryMonitor();
        if (parent != null) {
            monitor = parent.getMonitor();
        }
        Rectangle monitorBounds = monitor.getClientArea();
        Point centerPoint = parent != null ? Geometry.centerPoint((Rectangle)parent.getBounds()) : Geometry.centerPoint((Rectangle)monitorBounds);
        return new Point(centerPoint.x - initialSize.x / 2, Math.max(monitorBounds.y, Math.min(centerPoint.y - initialSize.y * 2 / 3, monitorBounds.y + monitorBounds.height - initialSize.y)));
    }

    protected boolean isResizable() {
        return true;
    }

    class ExportRunner
    implements IRunnableWithProgress {
        private Object[] checkedMembers;
        private boolean createDirStructure;
        private boolean lowercaseNames;
        private boolean saveInDirectory;
        private String exportPath;
        private boolean override;

        public ExportRunner(Object[] checkedMembers, boolean createDirStructure, boolean lowercaseNames, boolean saveInDirectory, String exportPath, boolean override) {
            this.checkedMembers = checkedMembers;
            this.createDirStructure = createDirStructure;
            this.lowercaseNames = lowercaseNames;
            this.saveInDirectory = saveInDirectory;
            this.exportPath = exportPath;
            this.override = override;
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            ExportDialog.this.export(monitor, this.checkedMembers, this.createDirStructure, this.lowercaseNames, this.saveInDirectory, this.exportPath, this.override);
        }
    }
}

