/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.console;

import jakarta.inject.Inject;
import java.util.List;
import miworkplace.i18n.Messages;
import miworkplace.ui.console.ConsoleView;
import org.eclipse.e4.ui.di.AboutToShow;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.commands.MCommand;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.menu.MDirectMenuItem;
import org.eclipse.e4.ui.model.application.ui.menu.MHandledMenuItem;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuElement;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuFactory;
import org.eclipse.e4.ui.workbench.modeling.EModelService;

public class ConsoleInputContributionHandler {
    private final String CONSOLE_SWITCH_DOCUMENT = "miworkplace.ui.command.console.switch";
    @Inject
    private EModelService modelService;
    @Inject
    private MApplication application;

    @AboutToShow
    public void aboutToShow(MPart part, List<MMenuElement> items) {
        Object object = part.getObject();
        if (object == null) {
            return;
        }
        List<String> processes = ((ConsoleView)part.getObject()).getProcesses();
        if (processes.isEmpty()) {
            MDirectMenuItem item = this.createEmptyMenuItem();
            items.add((MMenuElement)item);
        } else {
            MCommand command = this.getCommandInstance("miworkplace.ui.command.console.switch");
            for (String process : processes) {
                MHandledMenuItem dynamicItem = (MHandledMenuItem)this.modelService.createModelElement(MHandledMenuItem.class);
                dynamicItem.setLabel(process);
                dynamicItem.setCommand(command);
                dynamicItem.getTransientData().put("process", process);
                items.add((MMenuElement)dynamicItem);
            }
        }
    }

    private MCommand getCommandInstance(String commandId) {
        List commands = this.application.getCommands();
        for (MCommand command : commands) {
            if (!command.getElementId().equals(commandId)) continue;
            return command;
        }
        return null;
    }

    private MDirectMenuItem createEmptyMenuItem() {
        MDirectMenuItem item = MMenuFactory.INSTANCE.createDirectMenuItem();
        item.setLabel(Messages.ui_console_noprocess);
        item.setEnabled(false);
        item.setVisible(true);
        return item;
    }
}

