/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.connection.wizard;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import miworkplace.i18n.Messages;
import miworkplace.ui.widgets.LibraryList;
import org.eclipse.e4.tools.services.IResourcePool;
import org.eclipse.e4.ui.services.help.EHelpService;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ConnectionCustomLibraryListWizardPage
extends WizardPage {
    private List<String> libraries = new LinkedList<String>();
    private Button replaceLibraries;
    private LibraryList viewer;
    private Text txtJobDescription;
    private IResourcePool imagePool;
    private Button showLibraryList;
    private EHelpService fHelpService;

    public ConnectionCustomLibraryListWizardPage(IResourcePool imagePool, EHelpService pHelpService) {
        super(Messages.ui_conn_wiz_custom_page);
        this.imagePool = imagePool;
        this.fHelpService = pHelpService;
        this.setTitle(Messages.ui_conn_wiz_custom_title);
        this.setDescription(Messages.ui_conn_wiz_custom_desc);
    }

    public void createControl(Composite parent) {
        Composite controls = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.horizontalSpacing = 18;
        controls.setLayout((Layout)gridLayout);
        Label labelJobDescription = new Label(controls, 0);
        labelJobDescription.setText(Messages.ui_conn_wiz_custom_jobd);
        this.txtJobDescription = new Text(controls, 2048);
        this.txtJobDescription.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        String text = Messages.ui_conn_wiz_custom_jobd_ttt;
        this.decorateField((Control)this.txtJobDescription, text);
        Label labelCustomLibraries = new Label(controls, 0);
        labelCustomLibraries.setText(Messages.ui_conn_wiz_custom_userlist);
        labelCustomLibraries.setLayoutData((Object)GridDataFactory.defaultsFor((Control)labelCustomLibraries).align(1, 1).create());
        this.viewer = new LibraryList(controls, 0);
        this.viewer.setLayoutData(new GridData(4, 4, true, true, 1, 1));
        this.viewer.setInput(this.libraries.toArray(new String[0]));
        text = Messages.ui_conn_wiz_custom_col_lib_ttt;
        this.decorateField((Control)this.viewer, text);
        Label labelReplaceLibrares = new Label(controls, 0);
        labelReplaceLibrares.setText(Messages.ui_conn_wiz_custom_replace);
        this.replaceLibraries = new Button(controls, 32);
        this.replaceLibraries.setSelection(false);
        this.replaceLibraries.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        Label labelLibraryList = new Label(controls, 0);
        labelLibraryList.setText(Messages.ui_conn_wiz_libs_show_libl);
        this.showLibraryList = new Button(controls, 32);
        this.showLibraryList.setSelection(false);
        this.showLibraryList.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        this.decorateField((Control)this.showLibraryList, Messages.ui_conn_wiz_showlibl_libs);
        this.setControl((Control)controls);
    }

    public void performHelp() {
        this.fHelpService.displayHelp("miworkplace.help.MIW: Connections");
    }

    public boolean showLibraryList() {
        return this.showLibraryList.getSelection();
    }

    private void decorateField(Control control, String text) {
        ControlDecoration deco = new ControlDecoration(control, 16512);
        Image image = this.imagePool.getImageUnchecked("IMAGE_INFORMATION");
        deco.setImage(image);
        deco.setDescriptionText(text);
        deco.setShowOnlyOnFocus(false);
    }

    public boolean replaceLibraries() {
        return this.replaceLibraries.getSelection();
    }

    public List<String> getCustomLibraries() {
        return Arrays.asList(this.viewer.getElements());
    }

    public String getJobDescription() {
        return this.txtJobDescription.getText().toUpperCase();
    }
}

