/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.connection.handler;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import miworkplace.common.model.IConnection;
import miworkplace.connection.job.CloseConnectionJob;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.jface.viewers.ITreeSelection;

public class CloseConnectionHandler {
    @Inject
    private IEclipseContext context;

    @CanExecute
    public boolean canExecute(@Named(value="org.eclipse.ui.selection") ITreeSelection selection) {
        Object firstElement;
        boolean canExecute = false;
        if (selection.size() == 1 && (firstElement = selection.getFirstElement()) instanceof IConnection) {
            return ((IConnection)firstElement).isConnected();
        }
        return canExecute;
    }

    @Execute
    public void run(@Named(value="org.eclipse.ui.selection") ITreeSelection selection) {
        ITreeSelection ss = selection;
        Object element = ss.getFirstElement();
        if (element != null && element instanceof IConnection) {
            IConnection conn = (IConnection)element;
            IEclipseContext additionalContext = EclipseContextFactory.create();
            additionalContext.set(IConnection.class, (Object)conn);
            CloseConnectionJob job = (CloseConnectionJob)ContextInjectionFactory.make(CloseConnectionJob.class, (IEclipseContext)this.context, (IEclipseContext)additionalContext);
            job.schedule();
        }
    }
}

