/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.connection;

import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import miworkplace.common.model.IConnection;
import miworkplace.connection.api.IConnectionManager;
import miworkplace.i18n.Messages;
import miworkplace.ui.connection.wizard.ConnectionWizard;
import miworkplace.ui.widgets.LibraryList;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.e4.tools.services.IResourcePool;
import org.eclipse.e4.ui.services.help.EHelpService;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ConnectionDialog
extends TitleAreaDialog {
    @Inject
    private IConnection connection;
    @Inject
    private IConnectionManager connectionManager;
    @Inject
    private IResourcePool imagePool;
    @Inject
    EHelpService fHelpService;
    private Text txtServer;
    private Text txtUsername;
    private Button showLibraryList;
    private Button replaceLibraryList;
    private Text txtJobDescription;
    private LibraryList viewerListedLibraries;
    private LibraryList viewerCustomLibraries;
    private Text objectLibrary;
    private List<String> listedLibraries = new LinkedList<String>();
    private List<String> customLibraries = new LinkedList<String>();
    private Button fSecureBtn;

    @Inject
    public ConnectionDialog(@Named(value="activeShell") Shell shell) {
        super(shell);
    }

    @PostConstruct
    public void postConstruct() {
        this.listedLibraries.addAll(this.connection.getListedLibraries());
        this.customLibraries.addAll(this.connection.getCustomUserLibraries());
    }

    protected Point getInitialSize() {
        return new Point(550, 648);
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(Messages.ui_conn_dialog_title);
        this.setMessage(String.format(Messages.ui_conn_dialog_subtitle, this.connection.getName()));
        Image newTitleImage = new Image((Device)parent.getShell().getDisplay(), ((Object)((Object)this)).getClass().getResourceAsStream("/icons/server-wizard.png"));
        parent.addDisposeListener(e -> newTitleImage.dispose());
        this.setTitleImage(newTitleImage);
        parent.getShell().setText(Messages.ui_conn_dialog_title);
        Composite controls = this.buildControls(parent);
        this.initializeControls();
        this.txtServer.selectAll();
        this.fHelpService.setHelp((Object)controls, "miworkplace.help.MIW: Connections");
        return controls;
    }

    private void initializeControls() {
        this.txtServer.setText(this.connection.getSystemName());
        if (Boolean.TRUE.toString().equals(System.getProperties().getProperty("miworkplace.pub400", Boolean.FALSE.toString()))) {
            this.txtServer.setEnabled(false);
        }
        this.fSecureBtn.setSelection(this.connection.isSecure());
        this.txtUsername.setText(StringUtils.defaultString((String)this.connection.getUsername()));
        this.showLibraryList.setSelection(this.connection.showLibraryList());
        this.replaceLibraryList.setSelection(this.connection.isReplaceUserLibraryList());
        this.txtJobDescription.setText(StringUtils.defaultString((String)this.connection.getJobDescription()));
        this.objectLibrary.setText(StringUtils.defaultString((String)this.connection.getObjectLibrary()));
    }

    private Composite buildControls(Composite parent) {
        Composite p = (Composite)super.createDialogArea(parent);
        Composite controls = new Composite(p, 0);
        controls.setLayoutData((Object)new GridData(1808));
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 5;
        gridLayout.marginHeight = 5;
        gridLayout.verticalSpacing = 5;
        gridLayout.horizontalSpacing = 18;
        controls.setLayout((Layout)gridLayout);
        Label lblServer = new Label(controls, 0);
        lblServer.setText(Messages.ui_conn_dialog_server);
        this.txtServer = new Text(controls, 2048);
        this.txtServer.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        Label lblSecure = new Label(controls, 0);
        lblSecure.setText(Messages.ui_conn_dialog_secure);
        this.fSecureBtn = new Button(controls, 32);
        this.fSecureBtn.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        Label lblUsername = new Label(controls, 0);
        lblUsername.setText(Messages.ui_conn_dialog_user);
        this.txtUsername = new Text(controls, 2048);
        this.txtUsername.setLayoutData((Object)GridDataFactory.fillDefaults().create());
        new Label(controls, 0);
        new Label(controls, 0);
        Label labelListedLibraries = new Label(controls, 0);
        labelListedLibraries.setText(Messages.ui_conn_dialog_listed);
        labelListedLibraries.setLayoutData((Object)GridDataFactory.defaultsFor((Control)labelListedLibraries).align(1, 1).create());
        this.viewerListedLibraries = this.composeViewerListedLibraries(controls);
        GridDataFactory.fillDefaults().grab(true, true).minSize(-1, 100).applyTo((Control)this.viewerListedLibraries);
        Label labelObjectLibrary = new Label(controls, 0);
        labelObjectLibrary.setText(Messages.common_objlib + ":");
        this.objectLibrary = new Text(controls, 2048);
        this.objectLibrary.setLayoutData((Object)GridDataFactory.fillDefaults().create());
        ConnectionWizard.addDecorator((Control)this.objectLibrary, Messages.ui_conn_wiz_custom_objectlibrary);
        new Label(controls, 0);
        new Label(controls, 0);
        Label labelJobDescription = new Label(controls, 0);
        labelJobDescription.setText(Messages.ui_conn_dialog_jobd);
        this.txtJobDescription = new Text(controls, 2048);
        this.txtJobDescription.setLayoutData((Object)GridDataFactory.fillDefaults().create());
        String text = Messages.ui_conn_dialog_jobd_ttt;
        this.decorateField((Control)this.txtJobDescription, text);
        Label labelCustomLibraries = new Label(controls, 0);
        labelCustomLibraries.setText(Messages.ui_conn_dialog_userlibl);
        labelCustomLibraries.setLayoutData((Object)GridDataFactory.defaultsFor((Control)labelCustomLibraries).align(1, 1).create());
        this.viewerCustomLibraries = this.composeViewerCustomLibraries(controls);
        GridDataFactory.fillDefaults().grab(true, true).minSize(-1, 100).applyTo((Control)this.viewerCustomLibraries);
        Label labelReplaceLibraryList = new Label(controls, 0);
        labelReplaceLibraryList.setText(Messages.ui_conn_dialog_replace);
        this.replaceLibraryList = new Button(controls, 32);
        this.replaceLibraryList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
            }
        });
        this.replaceLibraryList.setSelection(true);
        this.replaceLibraryList.setLayoutData((Object)GridDataFactory.fillDefaults().create());
        Label labelLibraryList = new Label(controls, 0);
        labelLibraryList.setText(Messages.ui_conn_dialog_libl);
        this.showLibraryList = new Button(controls, 32);
        this.showLibraryList.setSelection(true);
        this.showLibraryList.setLayoutData((Object)GridDataFactory.fillDefaults().create());
        ConnectionWizard.addDecorator((Control)this.showLibraryList, Messages.ui_conn_wiz_showlibl_libs);
        return controls;
    }

    private LibraryList composeViewerListedLibraries(Composite controls) {
        LibraryList viewer = new LibraryList(controls, 2048);
        viewer.setInput(this.listedLibraries.toArray(new String[0]));
        String text = Messages.ui_conn_dialog_col_lib_ttt;
        this.decorateField((Control)viewer, text);
        return viewer;
    }

    private LibraryList composeViewerCustomLibraries(Composite controls) {
        LibraryList viewer = new LibraryList(controls, 2048);
        viewer.setInput(this.customLibraries.toArray(new String[0]));
        String text = Messages.ui_conn_dialog_col_lib_ttt;
        this.decorateField((Control)viewer, text);
        return viewer;
    }

    protected void okPressed() {
        if (this.isValid()) {
            this.applyValues();
            this.connectionManager.update(this.connection);
            super.okPressed();
        }
    }

    private void applyValues() {
        this.connection.setSystemName(this.txtServer.getText().trim());
        this.connection.setSecure(this.fSecureBtn.getSelection());
        this.connection.setUsername(this.txtUsername.getText().trim());
        this.connection.setShowLibraryList(this.showLibraryList.getSelection());
        this.connection.setListedLibraries(new HashSet<String>(Arrays.asList(this.viewerListedLibraries.getElements())));
        this.connection.setShowAllLibraries(false);
        this.connection.setReplaceUserLibraryList(this.replaceLibraryList.getSelection());
        this.connection.setCustomUserLibraries(new LinkedList<String>(Arrays.asList(this.viewerCustomLibraries.getElements())));
        this.connection.setJobDescription(this.txtJobDescription.getText().trim().toUpperCase());
        this.connection.setObjectLibrary(StringUtils.substring((String)this.objectLibrary.getText(), (int)0, (int)10));
    }

    private boolean isValid() {
        if (this.txtServer.getText().trim().isEmpty()) {
            this.setErrorMessage(Messages.ui_conn_dialog_server_invalid);
            return false;
        }
        return true;
    }

    private void decorateField(Control control, String text) {
        ControlDecoration deco = new ControlDecoration(control, 16512);
        Image image = this.imagePool.getImageUnchecked("IMAGE_INFORMATION");
        deco.setImage(image);
        deco.setDescriptionText(text);
        deco.setShowOnlyOnFocus(false);
    }

    protected boolean isResizable() {
        return true;
    }
}

