/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.compile;

import java.util.ArrayList;
import java.util.List;
import miworkplace.common.model.IRemoteObject;
import miworkplace.i18n.Messages;
import miworkplace.ui.api.EventFile;
import miworkplace.ui.api.EventFileEntry;

public class CompileResult {
    private EventFile eventFile = null;
    private IRemoteObject source = null;
    private List<EventFileEntry> fAdditionalEntries = new ArrayList<EventFileEntry>();

    public CompileResult() {
    }

    public CompileResult(EventFile eventFile) {
        this.eventFile = eventFile;
    }

    public EventFile getEventFile() {
        return this.eventFile;
    }

    public void setEventFile(EventFile eventFile) {
        this.eventFile = eventFile;
    }

    public IRemoteObject getSource() {
        return this.source;
    }

    public void setMember(IRemoteObject source) {
        this.source = source;
    }

    public EventFileEntry[] getEntries() {
        if (this.eventFile != null) {
            EventFileEntry[] entries = this.eventFile.getEntries();
            ArrayList<EventFileEntry> result = new ArrayList<EventFileEntry>();
            result.addAll(this.fAdditionalEntries);
            EventFileEntry[] eventFileEntryArray = entries;
            int n = entries.length;
            int n2 = 0;
            while (n2 < n) {
                EventFileEntry eventFileEntry = eventFileEntryArray[n2];
                result.add(eventFileEntry);
                ++n2;
            }
            return result.toArray(new EventFileEntry[0]);
        }
        return null;
    }

    public String getFile(int id) {
        String result = this.eventFile.getFile(id);
        if (result != null && result.toUpperCase().contains("QTEMP.LIB")) {
            this.eventFile.removeFile(id);
            this.eventFile.addFile(id, this.source.getPath());
        }
        return this.eventFile.getFile(id);
    }

    public boolean hasErrors() {
        if (this.eventFile == null) {
            throw new RuntimeException(Messages.ui_compile_result_nodata);
        }
        EventFileEntry[] eventFileEntryArray = this.getEntries();
        int n = eventFileEntryArray.length;
        int n2 = 0;
        while (n2 < n) {
            EventFileEntry entry = eventFileEntryArray[n2];
            if (entry.getSeverityCode().equals("E")) {
                return true;
            }
            if (entry.getSeverityCode().equals("S")) {
                return true;
            }
            if (entry.getSeverityCode().equals("T")) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void addEntry(EventFileEntry pNewEntry) {
        this.fAdditionalEntries.add(pNewEntry);
    }
}

