/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.compile;

import java.text.MessageFormat;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import miworkplace.common.debug.Debug;
import miworkplace.common.debug.Option;
import miworkplace.common.model.IRemoteObject;
import miworkplace.common.model.SourceMember;
import miworkplace.common.model.StreamFile;
import miworkplace.i18n.Messages;
import miworkplace.services.api.ICompileSettings;
import miworkplace.services.api.ICompileSettingsProvider;
import miworkplace.ui.api.ICompileArgumentResolver;
import miworkplace.ui.api.ICompileCommandBuilder;
import miworkplace.ui.compile.CompileSettingsProvider;
import miworkplace.ui.compile.UnresolvedPlaceholderException;
import org.apache.commons.lang3.StringUtils;

public class CompileCommandBuilder
implements ICompileCommandBuilder {
    private List<ICompileArgumentResolver> resolvers = new LinkedList<ICompileArgumentResolver>();
    private Debug logger = Debug.getInstance();
    private ICompileSettingsProvider compileSettingsProvider;
    private CompileSettingsProvider persistedCompileSettingsProvider;

    public void bindResolver(ICompileArgumentResolver resolver) {
        if (!this.resolvers.contains(resolver)) {
            this.resolvers.add(resolver);
        }
    }

    public void unbindResolver(ICompileArgumentResolver resolver) {
        this.resolvers.remove(resolver);
    }

    public void bindDefaultCompileSettingsProvider(CompileSettingsProvider provider) {
        this.persistedCompileSettingsProvider = provider;
    }

    public void unbindDefaultCompileSettingsProvider(CompileSettingsProvider provider) {
        this.persistedCompileSettingsProvider = null;
    }

    public void bindCompileSettingsProvider(ICompileSettingsProvider provider) {
        this.compileSettingsProvider = provider;
    }

    public void unbindCompileSettingsProvider(ICompileSettingsProvider provider) {
        this.compileSettingsProvider = null;
    }

    @Override
    public String buildCommand(IRemoteObject sourceObject) {
        if (sourceObject instanceof SourceMember || sourceObject instanceof StreamFile) {
            return this.buildCommandString(sourceObject);
        }
        throw new RuntimeException(String.format(Messages.ui_compile_builder_nosupport, sourceObject.getPath()));
    }

    private String buildCommandString(IRemoteObject sourceObject) {
        Properties properties = this.persistedCompileSettingsProvider.get(sourceObject);
        ICompileSettings compileSettings = properties != null && properties.containsKey("command.id") ? this.compileSettingsProvider.get(properties.getProperty("command.id")) : this.compileSettingsProvider.getDefault(sourceObject);
        StringBuilder sb = new StringBuilder();
        sb.append(compileSettings.getCompileCommand());
        String memberArguments = properties.getProperty("compile.options", "");
        String arguments = memberArguments.isEmpty() ? compileSettings.getCompileArguments() : memberArguments;
        arguments = this.resolveArguments(sourceObject, arguments);
        Set<String> ura = this.getUnresolvedArguments(arguments);
        if (!ura.isEmpty()) {
            arguments = this.resolveArguments(sourceObject, arguments);
        }
        sb.append(" " + arguments);
        if (!ura.isEmpty()) {
            String joinedUnresolvedArgumentsList = StringUtils.join(ura, (String)", ");
            throw new UnresolvedPlaceholderException(String.format(Messages.ui_compile_builder_unresolved, joinedUnresolvedArgumentsList));
        }
        return sb.toString();
    }

    private String resolveArguments(IRemoteObject sourceObject, String arguments) {
        Set<String> unresolvedArguments = this.getUnresolvedArguments(arguments);
        this.logger.debug((Option)miworkplace.ui.debug.Option.compile, MessageFormat.format("Placeholders in compile command: {0}", StringUtils.join(unresolvedArguments, (String)", ")));
        String escapedConnectionName = sourceObject.getConnection().getName().replaceAll(" ", "_");
        HashSet<String> tmpArguments = new HashSet<String>(unresolvedArguments);
        for (ICompileArgumentResolver resolver : this.resolvers) {
            for (String argument : tmpArguments) {
                String resolvedString = resolver.resolve(sourceObject, escapedConnectionName + "_" + argument);
                if (resolvedString == null) {
                    resolvedString = resolver.resolve(sourceObject, argument);
                }
                if (resolvedString == null) continue;
                unresolvedArguments.remove(argument);
                while (arguments.contains("${" + argument + "}")) {
                    arguments = arguments.replace("${" + argument + "}", resolvedString);
                }
            }
            tmpArguments = new HashSet<String>(unresolvedArguments);
        }
        return arguments;
    }

    private Set<String> getUnresolvedArguments(String arguments) {
        HashSet<String> unresolvedArguments = new HashSet<String>();
        int x1 = arguments.indexOf("${");
        while (x1 >= 0) {
            int x2 = arguments.indexOf("}", x1);
            if (x2 < 0) break;
            String argument = arguments.substring(x1 + 2, x2);
            unresolvedArguments.add(argument);
            x1 = arguments.indexOf("${", x2);
        }
        return unresolvedArguments;
    }
}

